/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.solr.SearchDAO;
import org.alfresco.repo.search.impl.DisabledFeatureException;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryLanguage;
import org.alfresco.repo.search.impl.lucene.LuceneQueryLanguageSPI;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.solr.SolrJSONResultSet;
import org.alfresco.repo.search.results.ChildAssocRefResultSet;
import org.alfresco.repo.solr.NodeParameters;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.QueryConsistency;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StopWatch;

public class DbOrIndexSwitchingQueryLanguage
extends AbstractLuceneQueryLanguage {
    protected static final Log logger = LogFactory.getLog(DbOrIndexSwitchingQueryLanguage.class);
    LuceneQueryLanguageSPI dbQueryLanguage;
    LuceneQueryLanguageSPI indexQueryLanguage;
    QueryConsistency queryConsistency = QueryConsistency.DEFAULT;
    QueryConsistency solrQueryConsistency = null;
    private NodeService nodeService;
    private SearchDAO searchDao;
    private Boolean hybridEnabled;
    private Boolean solrHybridEnabled;
    private String subsystemName;

    public void setDbQueryLanguage(LuceneQueryLanguageSPI dbQueryLanguage) {
        this.dbQueryLanguage = dbQueryLanguage;
    }

    public void setIndexQueryLanguage(LuceneQueryLanguageSPI indexQueryLanguage) {
        this.indexQueryLanguage = indexQueryLanguage;
    }

    public void setQueryConsistency(QueryConsistency queryConsistency) {
        this.queryConsistency = queryConsistency;
    }

    public void setSolrQueryConsistency(QueryConsistency solrQueryConsistency) {
        this.solrQueryConsistency = solrQueryConsistency;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchDao(SearchDAO searchDao) {
        this.searchDao = searchDao;
    }

    public void setHybridEnabled(Boolean hybridEnabled) {
        this.hybridEnabled = hybridEnabled;
    }

    public void setSolrHybridEnabled(Boolean solrHybridEnabled) {
        this.solrHybridEnabled = solrHybridEnabled;
    }

    public void setSubsystemName(String subsystemName) {
        this.subsystemName = subsystemName;
    }

    @Override
    public ResultSet executeQuery(SearchParameters searchParameters) {
        QueryConsistency consistency = searchParameters.getQueryConsistency();
        if (consistency == QueryConsistency.DEFAULT) {
            consistency = this.solrQueryConsistency != null ? this.solrQueryConsistency : this.queryConsistency;
        }
        switch (consistency) {
            case EVENTUAL: {
                if (this.indexQueryLanguage != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Using " + this.subsystemName + " query: " + this.dbQueryLanguage.getName() + " for " + searchParameters));
                    }
                    StopWatch stopWatch = new StopWatch("index only");
                    stopWatch.start();
                    ResultSet results = this.indexQueryLanguage.executeQuery(searchParameters);
                    stopWatch.stop();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(String.valueOf(this.subsystemName) + " returned " + results.length() + " results in " + stopWatch.getLastTaskTimeMillis() + "ms"));
                    }
                    return results;
                }
                throw new QueryModelException("No query language available");
            }
            case TRANSACTIONAL: {
                if (this.dbQueryLanguage != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Trying db query for " + this.dbQueryLanguage.getName() + " for " + searchParameters));
                    }
                    StopWatch stopWatch = new StopWatch("database only");
                    stopWatch.start();
                    ResultSet results = this.dbQueryLanguage.executeQuery(this.flattenDBQuery(searchParameters));
                    stopWatch.stop();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("DB returned " + results.length() + " results in " + stopWatch.getLastTaskTimeMillis() + "ms"));
                    }
                    return results;
                }
                throw new QueryModelException("No query language available");
            }
            case HYBRID: {
                if (this.solrHybridEnabled != null && !this.solrHybridEnabled.booleanValue() || this.hybridEnabled == null || !this.hybridEnabled.booleanValue()) {
                    throw new DisabledFeatureException("Hybrid query is disabled.");
                }
                return this.executeHybridQuery(searchParameters);
            }
        }
        StopWatch stopWatch = new StopWatch("DB if possible");
        if (this.dbQueryLanguage != null && !searchParameters.hasFaceting()) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Trying db query for " + this.dbQueryLanguage.getName() + " for " + searchParameters));
                }
                stopWatch.start();
                ResultSet results = this.dbQueryLanguage.executeQuery(this.flattenDBQuery(searchParameters));
                stopWatch.stop();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("DB returned " + results.length() + " results in " + stopWatch.getLastTaskTimeMillis() + "ms"));
                }
                return results;
            }
            catch (QueryModelException qme) {
                if (stopWatch.isRunning()) {
                    stopWatch.stop();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("DB query failed for " + this.dbQueryLanguage.getName() + " for " + searchParameters), (Throwable)qme);
                }
                if (this.indexQueryLanguage != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Using " + this.subsystemName + " query: " + this.dbQueryLanguage.getName() + " for " + searchParameters));
                    }
                    stopWatch.start();
                    ResultSet results = this.indexQueryLanguage.executeQuery(searchParameters);
                    stopWatch.stop();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(String.valueOf(this.subsystemName) + " returned " + results.length() + " results in " + stopWatch.getLastTaskTimeMillis() + "ms"));
                    }
                    return results;
                }
            }
        } else if (this.indexQueryLanguage != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("(No DB QL) Using " + this.subsystemName + " query: " + "dbQueryLanguage==null" + " for " + searchParameters));
            }
            stopWatch.start();
            ResultSet results = this.indexQueryLanguage.executeQuery(searchParameters);
            stopWatch.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(String.valueOf(this.subsystemName) + " returned " + results.length() + " results in " + stopWatch.getLastTaskTimeMillis() + "ms"));
            }
            return results;
        }
        throw new QueryModelException("No query language available");
    }

    private SearchParameters flattenDBQuery(SearchParameters sp) {
        if (sp.getFilterQueries().size() == 0) {
            return sp;
        }
        SearchParameters flatten = sp.copy();
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("( ").append(sp.getQuery()).append(" )");
        for (String filter : sp.getFilterQueries()) {
            Matcher matcher = LuceneQueryLanguageSPI.AFTS_QUERY.matcher(filter);
            if (matcher.find()) {
                queryBuilder.append("AND ( ").append(matcher.group(2)).append(" )");
                continue;
            }
            queryBuilder.append("AND ( ").append(filter).append(" )");
        }
        flatten.setQuery(queryBuilder.toString());
        return flatten;
    }

    private ResultSet executeHybridQuery(SearchParameters searchParameters) {
        if (this.indexQueryLanguage == null || this.dbQueryLanguage == null) {
            throw new QueryModelException("Both " + this.subsystemName + " and DB query language required for hybrid search [index=" + this.indexQueryLanguage + ", DB=" + this.dbQueryLanguage + "]");
        }
        StopWatch stopWatch = new StopWatch("hybrid search");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Hybrid search, using " + this.subsystemName + " query: " + this.dbQueryLanguage.getName() + " for " + searchParameters));
        }
        stopWatch.start("index query");
        ResultSet indexResults = this.indexQueryLanguage.executeQuery(searchParameters);
        stopWatch.stop();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(this.subsystemName) + " query returned " + indexResults.length() + " results in " + stopWatch.getLastTaskTimeMillis() + "ms"));
        }
        if (!(indexResults instanceof SolrJSONResultSet)) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Hybrid search can only use database when " + this.subsystemName + " is also in use. " + "Skipping DB search, returning results from index."));
            }
            return indexResults;
        }
        long lastTxId = ((SolrJSONResultSet)indexResults).getLastIndexedTxId();
        searchParameters.setSinceTxId(Long.valueOf(lastTxId));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Hybrid search, using DB query: " + this.dbQueryLanguage.getName() + " for " + searchParameters));
        }
        stopWatch.start("database query");
        ResultSet dbResults = this.dbQueryLanguage.executeQuery(searchParameters);
        stopWatch.stop();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DB query returned " + dbResults.length() + " results in " + stopWatch.getLastTaskTimeMillis() + "ms"));
        }
        ArrayList<ChildAssociationRef> childAssocs = new ArrayList<ChildAssociationRef>();
        NodeParameters nodeParameters = new NodeParameters();
        nodeParameters.setFromTxnId(lastTxId + 1L);
        nodeParameters.setToTxnId(Long.MAX_VALUE);
        stopWatch.start("get changed nodes");
        List<Node> changedNodeList = this.searchDao.getNodes(nodeParameters, null, null);
        stopWatch.stop();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Nodes changed since last indexed transaction (ID " + lastTxId + ") = " + changedNodeList.size() + " (took " + stopWatch.getLastTaskTimeMillis() + "ms)"));
        }
        stopWatch.start("merge result sets");
        HashSet<NodeRef> nodeRefs = new HashSet<NodeRef>(changedNodeList.size());
        for (Node n : changedNodeList) {
            nodeRefs.add(n.getNodeRef());
        }
        for (ChildAssociationRef car : indexResults.getChildAssocRefs()) {
            if (nodeRefs.contains(car.getChildRef())) continue;
            childAssocs.add(car);
        }
        childAssocs.addAll(dbResults.getChildAssocRefs());
        ChildAssocRefResultSet results = new ChildAssocRefResultSet(this.nodeService, childAssocs);
        stopWatch.stop();
        if (logger.isDebugEnabled()) {
            String stats = String.format(String.valueOf(this.subsystemName) + "=%d, DB=%d, total=%d", indexResults.length(), dbResults.length(), results.length());
            logger.debug((Object)("Hybrid search returning combined results with counts: " + stats));
            logger.debug((Object)stopWatch.prettyPrint());
        }
        return results;
    }
}

