/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.util.LinkedHashSet;
import org.alfresco.service.cmr.repository.StoreRef;
import org.springframework.beans.factory.BeanNameAware;

public class SolrStoreMapping
implements BeanNameAware {
    StoreRef storeRef;
    String httpClientFactory;
    String baseUrl;
    String protocol;
    String identifier;
    private String beanName;
    private String[] nodes = new String[0];
    private int numShards = 1;
    private int replicationFactor = 1;

    public StoreRef getStoreRef() {
        return this.storeRef;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
        this.setStoreRef();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
        this.setStoreRef();
    }

    public String getHttpClientFactory() {
        return this.httpClientFactory;
    }

    public void setHttpClientFactory(String httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    private void setStoreRef() {
        if (this.protocol != null && this.identifier != null) {
            this.storeRef = new StoreRef(this.protocol, this.identifier);
        }
    }

    public String getNodeString() {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = this.nodes;
        int n = this.nodes.length;
        int n2 = 0;
        while (n2 < n) {
            String node = stringArray[n2];
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(node);
            ++n2;
        }
        return builder.toString();
    }

    public String[] getNodes() {
        return this.nodes;
    }

    public void setNodeString(String nodes) {
        LinkedHashSet<String> unique = new LinkedHashSet<String>();
        String[] stringArray = nodes.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String split = stringArray[n2];
            unique.add(split.trim());
            ++n2;
        }
        this.nodes = unique.toArray(new String[0]);
    }

    public int getNumShards() {
        return this.numShards;
    }

    public void setNumShards(int numShards) {
        this.numShards = numShards;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(int replicationFactor) {
        this.replicationFactor = replicationFactor;
    }
}

