/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tagging;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.action.ActionModel;
import org.alfresco.repo.action.AsynchronousActionExecutionQueuePolicies;
import org.alfresco.repo.audit.AuditComponent;
import org.alfresco.repo.audit.AuditServiceImpl;
import org.alfresco.repo.audit.UserAuditFilter;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.node.NodeRefPropertyMethodInterceptor;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tagging.NonExistentTagException;
import org.alfresco.repo.tagging.TagExistsException;
import org.alfresco.repo.tagging.TagScopePropertyMethodInterceptor;
import org.alfresco.repo.tagging.TaggingException;
import org.alfresco.repo.tagging.TaggingServiceImpl;
import org.alfresco.repo.tagging.UpdateTagScopesActionExecuter;
import org.alfresco.repo.tagging.UpdateTagScopesQuartzJob;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ActionTrackingService;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.ScriptLocation;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.tagging.TagDetails;
import org.alfresco.service.cmr.tagging.TagScope;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.RedundantTests;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TaggingServiceImplTest
extends BaseSpringTest {
    private static final Log logger = LogFactory.getLog(TaggingServiceImplTest.class);
    private TaggingServiceImpl taggingService;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private CopyService copyService;
    private CheckOutCheckInService checkOutCheckInService;
    private ScriptService scriptService;
    private AuditService auditService;
    private ActionService actionService;
    private ActionTrackingService actionTrackingService;
    private TransactionService transactionService;
    private AuthenticationComponent authenticationComponent;
    private PersonService personService;
    private PermissionService permissionService;
    private MutableAuthenticationService authenticationService;
    private AsyncOccurs asyncOccurs;
    private SiteService siteService;
    private NodeRefPropertyMethodInterceptor nodeRefPropInterceptor;
    private static StoreRef storeRef;
    private static NodeRef rootNode;
    private NodeRef folder;
    private NodeRef subFolder;
    private NodeRef document;
    private NodeRef subDocument;
    private static final String TEST_SITE_PRESET = "testSitePreset";
    private static final String TEST_TITLE = "TitleTest This is my title";
    private static final String TEST_DESCRIPTION = "DescriptionTest This is my description";
    private static final String TAG_1 = "tag one";
    private static final String TAG_2 = "tag two";
    private static final String TAG_3 = "Tag Three";
    private static final String TAG_4 = "tag four";
    private static final String TAG_5 = "tag five";
    private static final String TAG_I18N = "\u00e0\u00e2\u00e6\u00e7\u00e9\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u0153\u00f9\u00fb\u00fc\u00ff\u00f1";
    private static final String BAD_TAG = "bad \n tag";
    private static final String BAD_TAG2 = "Broken|2";
    private static final String UPPER_TAG = "House";
    private static final String LOWER_TAG = "house";
    private static boolean init;

    static {
        init = false;
    }

    @Before
    public void setUp() throws Exception {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            throw new IllegalStateException("There should not be any transactions when starting test: " + AlfrescoTransactionSupport.getTransactionId() + " started at " + new Date(AlfrescoTransactionSupport.getTransactionStartTime()));
        }
        this.taggingService = (TaggingServiceImpl)this.applicationContext.getBean("taggingService");
        this.nodeService = (NodeService)this.applicationContext.getBean("NodeService");
        this.fileFolderService = (FileFolderService)this.applicationContext.getBean("FileFolderService");
        this.copyService = (CopyService)this.applicationContext.getBean("CopyService");
        this.checkOutCheckInService = (CheckOutCheckInService)this.applicationContext.getBean("CheckoutCheckinService");
        this.actionService = (ActionService)this.applicationContext.getBean("ActionService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.siteService = (SiteService)this.applicationContext.getBean("SiteService", SiteService.class);
        UserAuditFilter userAuditFilter = new UserAuditFilter();
        userAuditFilter.setUserFilterPattern("System;.*");
        userAuditFilter.afterPropertiesSet();
        AuditComponent auditComponent = (AuditComponent)this.applicationContext.getBean("auditComponent");
        auditComponent.setUserAuditFilter(userAuditFilter);
        AuditServiceImpl auditServiceImpl = (AuditServiceImpl)this.applicationContext.getBean("auditService");
        auditServiceImpl.setAuditComponent(auditComponent);
        this.auditService = (AuditService)this.applicationContext.getBean("auditService");
        this.scriptService = (ScriptService)this.applicationContext.getBean("scriptService");
        this.actionTrackingService = (ActionTrackingService)this.applicationContext.getBean("actionTrackingService");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.personService = (PersonService)this.applicationContext.getBean("PersonService");
        this.permissionService = (PermissionService)this.applicationContext.getBean("PermissionService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.nodeRefPropInterceptor = (NodeRefPropertyMethodInterceptor)this.applicationContext.getBean("nodeRefPropertyInterceptor");
        if (!init) {
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    TaggingServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                    TaggingServiceImplTest.storeRef = TaggingServiceImplTest.this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
                    rootNode = TaggingServiceImplTest.this.nodeService.getRootNode(storeRef);
                    NodeRef catContainer = TaggingServiceImplTest.this.nodeService.createNode(rootNode, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"categoryContainer"), ContentModel.TYPE_CONTAINER).getChildRef();
                    NodeRef catRoot = TaggingServiceImplTest.this.nodeService.createNode(catContainer, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"categoryRoot"), ContentModel.TYPE_CATEGORYROOT).getChildRef();
                    TaggingServiceImplTest.this.nodeService.createNode(catRoot, ContentModel.ASSOC_CATEGORIES, ContentModel.ASPECT_TAGGABLE, ContentModel.TYPE_CATEGORY).getChildRef();
                    init = true;
                    return null;
                }
            });
        }
        this.asyncOccurs = new AsyncOccurs();
        ((PolicyComponent)this.applicationContext.getBean("policyComponent")).bindClassBehaviour(AsynchronousActionExecutionQueuePolicies.OnAsyncActionExecute.QNAME, ActionModel.TYPE_ACTION, (Behaviour)new JavaBehaviour((Object)this.asyncOccurs, "onAsyncActionExecute", Behaviour.NotificationFrequency.EVERY_EVENT));
        UpdateTagScopesActionExecuter updateTagsAction = (UpdateTagScopesActionExecuter)this.applicationContext.getBean("update-tagscope");
        updateTagsAction.setTrackStatus(true);
        this.createTestDocumentsAndFolders();
    }

    @After
    public void tearDown() throws Exception {
        this.removeTestDocumentsAndFolders();
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            TaggingServiceImplTest.fail((String)"Test is not transaction-safe.  Fix up transaction handling and re-test.");
        }
    }

    private void createTestDocumentsAndFolders() throws Exception {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                String guid = GUID.generate();
                HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
                folderProps.put(ContentModel.PROP_NAME, "testFolder" + guid);
                TaggingServiceImplTest.this.folder = TaggingServiceImplTest.this.nodeService.createNode(rootNode, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("testFolder" + guid)), ContentModel.TYPE_FOLDER, folderProps).getChildRef();
                HashMap<QName, String> docProps = new HashMap<QName, String>(1);
                docProps.put(ContentModel.PROP_NAME, "testDocument" + guid + ".txt");
                TaggingServiceImplTest.this.document = TaggingServiceImplTest.this.nodeService.createNode(TaggingServiceImplTest.this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("testDocument" + guid + ".txt")), ContentModel.TYPE_CONTENT, docProps).getChildRef();
                HashMap<QName, String> props = new HashMap<QName, String>(1);
                props.put(ContentModel.PROP_NAME, "subFolder" + guid);
                TaggingServiceImplTest.this.subFolder = TaggingServiceImplTest.this.nodeService.createNode(TaggingServiceImplTest.this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("subFolder" + guid)), ContentModel.TYPE_FOLDER, props).getChildRef();
                props = new HashMap(1);
                props.put(ContentModel.PROP_NAME, "subDocument" + guid + ".txt");
                TaggingServiceImplTest.this.subDocument = TaggingServiceImplTest.this.nodeService.createNode(TaggingServiceImplTest.this.subFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("subDocument" + guid + ".txt")), ContentModel.TYPE_CONTENT, props).getChildRef();
                return null;
            }
        });
    }

    private void removeTestDocumentsAndFolders() throws Exception {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef nodeRef;
                NodeRef[] nodes;
                TaggingServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                NodeRef[] nodeRefArray = nodes = new NodeRef[]{TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.this.document, TaggingServiceImplTest.this.folder};
                int n = nodes.length;
                int n2 = 0;
                while (n2 < n) {
                    nodeRef = nodeRefArray[n2];
                    if (TaggingServiceImplTest.this.taggingService.isTagScope(nodeRef)) {
                        TaggingServiceImplTest.this.taggingService.removeTagScope(nodeRef);
                    }
                    ++n2;
                }
                nodeRefArray = nodes;
                n = nodes.length;
                n2 = 0;
                while (n2 < n) {
                    nodeRef = nodeRefArray[n2];
                    TaggingServiceImplTest.this.nodeService.deleteNode(nodeRef);
                    ++n2;
                }
                TaggingServiceImplTest.this.auditService.clearAudit("Alfresco Tagging Service", Long.valueOf(0L), Long.valueOf(System.currentTimeMillis() + 1L));
                return null;
            }
        });
    }

    @Test
    @Category(value={RedundantTests.class, LuceneTests.class})
    public void test1TagCRUD() throws Exception {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List tags = TaggingServiceImplTest.this.taggingService.getTags(storeRef);
                TaggingServiceImplTest.assertNotNull((Object)tags);
                TaggingServiceImplTest.assertEquals((int)0, (int)tags.size());
                TaggingServiceImplTest.this.taggingService.createTag(storeRef, TaggingServiceImplTest.TAG_1);
                TaggingServiceImplTest.this.taggingService.createTag(storeRef, TaggingServiceImplTest.UPPER_TAG);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List tags = TaggingServiceImplTest.this.taggingService.getTags(storeRef);
                TaggingServiceImplTest.assertNotNull((Object)tags);
                TaggingServiceImplTest.assertEquals((int)2, (int)tags.size());
                TaggingServiceImplTest.assertTrue((boolean)tags.contains(TaggingServiceImplTest.TAG_1));
                TaggingServiceImplTest.assertTrue((boolean)tags.contains(TaggingServiceImplTest.LOWER_TAG));
                Pair pagedTags = TaggingServiceImplTest.this.taggingService.getPagedTags(storeRef, "one", 0, 10);
                TaggingServiceImplTest.assertNotNull((Object)pagedTags);
                List tagPage = (List)pagedTags.getFirst();
                int allFilteredTagsCount = (Integer)pagedTags.getSecond();
                TaggingServiceImplTest.assertEquals((int)1, (int)allFilteredTagsCount);
                TaggingServiceImplTest.assertEquals((int)1, (int)tagPage.size());
                TaggingServiceImplTest.assertTrue((boolean)((String)tagPage.get(0)).contains("one"));
                tagPage = TaggingServiceImplTest.this.taggingService.getTags(storeRef, "one");
                TaggingServiceImplTest.assertNotNull((Object)pagedTags);
                tagPage = (List)pagedTags.getFirst();
                allFilteredTagsCount = (Integer)pagedTags.getSecond();
                TaggingServiceImplTest.assertEquals((int)1, (int)allFilteredTagsCount);
                TaggingServiceImplTest.assertEquals((int)1, (int)tagPage.size());
                TaggingServiceImplTest.assertTrue((boolean)((String)tagPage.get(0)).contains("one"));
                TaggingServiceImplTest.assertFalse((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.TAG_2));
                TaggingServiceImplTest.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.TAG_1));
                TaggingServiceImplTest.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.UPPER_TAG));
                TaggingServiceImplTest.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.LOWER_TAG));
                TaggingServiceImplTest.this.taggingService.deleteTag(storeRef, TaggingServiceImplTest.UPPER_TAG);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List tags = TaggingServiceImplTest.this.taggingService.getTags(storeRef);
                TaggingServiceImplTest.assertNotNull((Object)tags);
                TaggingServiceImplTest.assertEquals((int)1, (int)tags.size());
                TaggingServiceImplTest.assertTrue((boolean)tags.contains(TaggingServiceImplTest.TAG_1));
                TaggingServiceImplTest.assertFalse((boolean)tags.contains(TaggingServiceImplTest.LOWER_TAG));
                TaggingServiceImplTest.assertFalse((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.TAG_2));
                TaggingServiceImplTest.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.TAG_1));
                TaggingServiceImplTest.assertFalse((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.UPPER_TAG));
                TaggingServiceImplTest.assertFalse((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.LOWER_TAG));
                return null;
            }
        });
    }

    @Test
    @Category(value={RedundantTests.class, LuceneTests.class})
    public void test2AddRemoveTag() throws Exception {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List tags = TaggingServiceImplTest.this.taggingService.getTags(TaggingServiceImplTest.this.document);
                TaggingServiceImplTest.assertNotNull((Object)tags);
                TaggingServiceImplTest.assertTrue((boolean)tags.isEmpty());
                TaggingServiceImplTest.assertFalse((boolean)TaggingServiceImplTest.this.taggingService.hasTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_1));
                TaggingServiceImplTest.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.TAG_1));
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_1);
                tags = TaggingServiceImplTest.this.taggingService.getTags(TaggingServiceImplTest.this.document);
                TaggingServiceImplTest.assertNotNull((Object)tags);
                TaggingServiceImplTest.assertEquals((int)1, (int)tags.size());
                TaggingServiceImplTest.assertTrue((boolean)tags.contains(TaggingServiceImplTest.TAG_1));
                TaggingServiceImplTest.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.hasTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_1));
                TaggingServiceImplTest.assertFalse((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.TAG_2));
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_2);
                TaggingServiceImplTest.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.isTag(storeRef, TaggingServiceImplTest.TAG_2));
                tags = TaggingServiceImplTest.this.taggingService.getTags(TaggingServiceImplTest.this.document);
                TaggingServiceImplTest.assertNotNull((Object)tags);
                TaggingServiceImplTest.assertEquals((int)2, (int)tags.size());
                TaggingServiceImplTest.assertTrue((boolean)tags.contains(TaggingServiceImplTest.TAG_1));
                TaggingServiceImplTest.assertTrue((boolean)tags.contains(TaggingServiceImplTest.TAG_2));
                TaggingServiceImplTest.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.hasTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_1));
                TaggingServiceImplTest.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.hasTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_2));
                TaggingServiceImplTest.this.taggingService.removeTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_1);
                tags = TaggingServiceImplTest.this.taggingService.getTags(TaggingServiceImplTest.this.document);
                TaggingServiceImplTest.assertNotNull((Object)tags);
                TaggingServiceImplTest.assertEquals((int)1, (int)tags.size());
                TaggingServiceImplTest.assertFalse((boolean)tags.contains(TaggingServiceImplTest.TAG_1));
                TaggingServiceImplTest.assertFalse((boolean)TaggingServiceImplTest.this.taggingService.hasTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_1));
                TaggingServiceImplTest.assertTrue((boolean)tags.contains(TaggingServiceImplTest.TAG_2));
                TaggingServiceImplTest.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.hasTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_2));
                ArrayList<String> setTags = new ArrayList<String>(2);
                setTags.add(TaggingServiceImplTest.TAG_3);
                setTags.add(TaggingServiceImplTest.TAG_1);
                TaggingServiceImplTest.this.taggingService.setTags(TaggingServiceImplTest.this.document, setTags);
                tags = TaggingServiceImplTest.this.taggingService.getTags(TaggingServiceImplTest.this.document);
                TaggingServiceImplTest.assertNotNull((Object)tags);
                TaggingServiceImplTest.assertEquals((int)2, (int)tags.size());
                TaggingServiceImplTest.assertTrue((boolean)tags.contains(TaggingServiceImplTest.TAG_1));
                TaggingServiceImplTest.assertFalse((boolean)tags.contains(TaggingServiceImplTest.TAG_2));
                TaggingServiceImplTest.assertTrue((boolean)tags.contains(TaggingServiceImplTest.TAG_3.toLowerCase()));
                TaggingServiceImplTest.this.taggingService.clearTags(TaggingServiceImplTest.this.document);
                tags = TaggingServiceImplTest.this.taggingService.getTags(TaggingServiceImplTest.this.document);
                TaggingServiceImplTest.assertNotNull((Object)tags);
                TaggingServiceImplTest.assertTrue((boolean)tags.isEmpty());
                return null;
            }
        });
    }

    @Test
    public void test3TagScopeFindAddRemove() throws Exception {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TagScope tagScope = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.subDocument);
                TaggingServiceImplTest.assertNull((Object)tagScope);
                List tagScopes = TaggingServiceImplTest.this.taggingService.findAllTagScopes(TaggingServiceImplTest.this.subDocument);
                TaggingServiceImplTest.assertNotNull((Object)tagScopes);
                TaggingServiceImplTest.assertEquals((int)0, (int)tagScopes.size());
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.subFolder);
                tagScope = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.subDocument);
                TaggingServiceImplTest.assertNotNull((Object)tagScope);
                tagScopes = TaggingServiceImplTest.this.taggingService.findAllTagScopes(TaggingServiceImplTest.this.subDocument);
                TaggingServiceImplTest.assertNotNull((Object)tagScopes);
                TaggingServiceImplTest.assertEquals((int)2, (int)tagScopes.size());
                tagScope = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.subFolder);
                TaggingServiceImplTest.assertNotNull((Object)tagScope);
                tagScopes = TaggingServiceImplTest.this.taggingService.findAllTagScopes(TaggingServiceImplTest.this.subFolder);
                TaggingServiceImplTest.assertNotNull((Object)tagScopes);
                TaggingServiceImplTest.assertEquals((int)2, (int)tagScopes.size());
                tagScope = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.assertNotNull((Object)tagScope);
                tagScopes = TaggingServiceImplTest.this.taggingService.findAllTagScopes(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.assertNotNull((Object)tagScopes);
                TaggingServiceImplTest.assertEquals((int)1, (int)tagScopes.size());
                TaggingServiceImplTest.this.taggingService.removeTagScope(TaggingServiceImplTest.this.folder);
                tagScope = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.subDocument);
                TaggingServiceImplTest.assertNotNull((Object)tagScope);
                tagScopes = TaggingServiceImplTest.this.taggingService.findAllTagScopes(TaggingServiceImplTest.this.subDocument);
                TaggingServiceImplTest.assertNotNull((Object)tagScopes);
                TaggingServiceImplTest.assertEquals((int)1, (int)tagScopes.size());
                tagScope = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.subFolder);
                TaggingServiceImplTest.assertNotNull((Object)tagScope);
                tagScopes = TaggingServiceImplTest.this.taggingService.findAllTagScopes(TaggingServiceImplTest.this.subFolder);
                TaggingServiceImplTest.assertNotNull((Object)tagScopes);
                TaggingServiceImplTest.assertEquals((int)1, (int)tagScopes.size());
                tagScope = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.assertNull((Object)tagScope);
                tagScopes = TaggingServiceImplTest.this.taggingService.findAllTagScopes(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.assertNotNull((Object)tagScopes);
                TaggingServiceImplTest.assertEquals((int)0, (int)tagScopes.size());
                return null;
            }
        });
    }

    @Test
    public void test4TagScope() throws Exception {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.subFolder);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_3);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TagScope ts1 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.subDocument);
                TagScope ts2 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.assertEquals((String)("Wrong tags on sub folder: " + ts1.getTags()), (int)3, (int)ts1.getTags().size());
                TaggingServiceImplTest.assertEquals((String)("Wrong tags on main folder: " + ts2.getTags()), (int)3, (int)ts2.getTags().size());
                TaggingServiceImplTest.assertEquals((int)2, (int)((TagDetails)ts1.getTags().get(0)).getCount());
                TaggingServiceImplTest.assertEquals((int)2, (int)((TagDetails)ts1.getTags().get(1)).getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)((TagDetails)ts1.getTags().get(2)).getCount());
                TaggingServiceImplTest.assertEquals((String)TaggingServiceImplTest.TAG_1, (String)((TagDetails)ts1.getTags().get(0)).getName());
                TaggingServiceImplTest.assertEquals((String)TaggingServiceImplTest.TAG_2, (String)((TagDetails)ts1.getTags().get(1)).getName());
                TaggingServiceImplTest.assertEquals((String)TaggingServiceImplTest.TAG_3.toLowerCase(), (String)((TagDetails)ts1.getTags().get(2)).getName());
                TaggingServiceImplTest.assertEquals((int)3, (int)((TagDetails)ts2.getTags().get(0)).getCount());
                TaggingServiceImplTest.assertEquals((int)2, (int)((TagDetails)ts2.getTags().get(1)).getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)((TagDetails)ts2.getTags().get(2)).getCount());
                TaggingServiceImplTest.assertEquals((String)TaggingServiceImplTest.TAG_2, (String)((TagDetails)ts2.getTags().get(0)).getName());
                TaggingServiceImplTest.assertEquals((String)TaggingServiceImplTest.TAG_1, (String)((TagDetails)ts2.getTags().get(1)).getName());
                TaggingServiceImplTest.assertEquals((String)TaggingServiceImplTest.TAG_3.toLowerCase(), (String)((TagDetails)ts2.getTags().get(2)).getName());
                TaggingServiceImplTest.this.taggingService.removeTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.removeTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.removeTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.removeTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_3);
                return null;
            }
        });
    }

    @Test
    public void test5TagScopeSummary() throws Exception {
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.subFolder);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_3);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TagScopePropertyMethodInterceptor.setEnabled((Boolean)Boolean.TRUE);
                Serializable summaryObj = TaggingServiceImplTest.this.nodeService.getProperty(TaggingServiceImplTest.this.folder, ContentModel.PROP_TAGSCOPE_SUMMARY);
                TaggingServiceImplTest.assertTrue((String)("TagScopeSummary value on main folder is not of correct class: " + summaryObj.getClass().getName()), (boolean)List.class.isAssignableFrom(summaryObj.getClass()));
                TaggingServiceImplTest.assertEquals((int)3, (int)((List)((Object)summaryObj)).size());
                Serializable summaryObj2 = TaggingServiceImplTest.this.nodeService.getProperty(TaggingServiceImplTest.this.folder, ContentModel.PROP_TAGSCOPE_SUMMARY);
                TaggingServiceImplTest.assertTrue((String)"TagScopeSummary value on main folder did not come from the cache", (summaryObj == summaryObj2 ? 1 : 0) != 0);
                Map props = TaggingServiceImplTest.this.nodeService.getProperties(TaggingServiceImplTest.this.subFolder);
                TaggingServiceImplTest.assertTrue((String)"Properties of subfolder do not include tagScopeSummary", (boolean)props.containsKey(ContentModel.PROP_TAGSCOPE_SUMMARY));
                summaryObj = (Serializable)props.get(ContentModel.PROP_TAGSCOPE_SUMMARY);
                TaggingServiceImplTest.assertTrue((String)("TagScopeSummary value on subfolder is not of correct class: " + summaryObj.getClass().getName()), (boolean)List.class.isAssignableFrom(summaryObj.getClass()));
                TaggingServiceImplTest.assertEquals((int)3, (int)((List)((Object)summaryObj)).size());
                TagScopePropertyMethodInterceptor.setEnabled((Boolean)Boolean.FALSE);
                summaryObj = TaggingServiceImplTest.this.nodeService.getProperty(TaggingServiceImplTest.this.folder, ContentModel.PROP_TAGSCOPE_SUMMARY);
                TaggingServiceImplTest.assertNull((String)("TagScopeSummary value on main folder should be null: " + summaryObj), (Object)summaryObj);
                props = TaggingServiceImplTest.this.nodeService.getProperties(TaggingServiceImplTest.this.subFolder);
                TaggingServiceImplTest.assertFalse((String)"Properties of subfolder should not contain tagScopeProperty", (boolean)props.containsKey(ContentModel.PROP_TAGSCOPE_SUMMARY));
                return null;
            }
        });
    }

    @Test
    @Category(value={RedundantTests.class, LuceneTests.class})
    public void test6TagScopeRefresh() throws Exception {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_1);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_2);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_3);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_1);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_2);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.folder);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TagScope tagScope = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.assertNotNull((Object)tagScope);
                TaggingServiceImplTest.assertEquals((int)3, (int)tagScope.getTags().size());
                TaggingServiceImplTest.assertEquals((int)3, (int)tagScope.getTag(TaggingServiceImplTest.TAG_2).getCount());
                TaggingServiceImplTest.assertEquals((int)2, (int)tagScope.getTag(TaggingServiceImplTest.TAG_1).getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)tagScope.getTag(TaggingServiceImplTest.TAG_3.toLowerCase()).getCount());
                return null;
            }
        });
    }

    @Test
    public void test7TagScopeSetUpdate() throws Exception {
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_3);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TagScope ts1 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.assertEquals((String)("Wrong tags on folder tagscope: " + ts1.getTags()), (int)3, (int)ts1.getTags().size());
                TaggingServiceImplTest.assertEquals((int)4, (int)ts1.getTag(TaggingServiceImplTest.TAG_1).getCount());
                TaggingServiceImplTest.assertEquals((int)2, (int)ts1.getTag(TaggingServiceImplTest.TAG_2).getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)ts1.getTag(TaggingServiceImplTest.TAG_3.toLowerCase()).getCount());
                ArrayList<String> tags = new ArrayList<String>(3);
                tags.add(TaggingServiceImplTest.TAG_2);
                tags.add(TaggingServiceImplTest.TAG_3);
                tags.add(TaggingServiceImplTest.TAG_4);
                TaggingServiceImplTest.this.taggingService.setTags(TaggingServiceImplTest.this.subDocument, tags);
                return null;
            }
        });
    }

    @Test
    @Category(value={RedundantTests.class, LuceneTests.class})
    public void test8ETHREEOH_220() throws Exception {
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_I18N);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List tags = TaggingServiceImplTest.this.taggingService.getTags(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.assertNotNull((Object)tags);
                TaggingServiceImplTest.assertEquals((int)1, (int)tags.size());
                TaggingServiceImplTest.assertEquals((String)TaggingServiceImplTest.TAG_I18N, (String)((String)tags.get(0)));
                TagScope tagScope = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.assertNotNull((Object)tagScope);
                TaggingServiceImplTest.assertEquals((int)1, (int)tagScope.getTags().size());
                TagDetails tagDetails = tagScope.getTag(TaggingServiceImplTest.TAG_I18N);
                TaggingServiceImplTest.assertNotNull((Object)tagDetails);
                TaggingServiceImplTest.assertEquals((String)TaggingServiceImplTest.TAG_I18N, (String)tagDetails.getName());
                TaggingServiceImplTest.assertEquals((int)1, (int)tagDetails.getCount());
                return null;
            }
        });
    }

    @Test
    @Category(value={RedundantTests.class, LuceneTests.class})
    public void test9TagScopeUpdateViaNodePolicies() throws Exception {
        class TestData {
            public NodeRef tagFoo1;
            public NodeRef tagFoo2;
            public NodeRef tagFoo3;
            public NodeRef tagBar;
            public NodeRef container1;
            public NodeRef container2;
            public NodeRef taggedFolder;
            public NodeRef taggedFolder2;
            public NodeRef taggedDoc;
            public NodeRef taggedDoc2;
            public NodeRef checkedOutDoc;

            TestData() {
            }
        }
        final TestData testData = new TestData();
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testData.tagFoo1 = TaggingServiceImplTest.this.taggingService.createTag(TaggingServiceImplTest.this.folder.getStoreRef(), "Foo1");
                testData.tagFoo2 = TaggingServiceImplTest.this.taggingService.createTag(TaggingServiceImplTest.this.folder.getStoreRef(), "Foo2");
                testData.tagFoo3 = TaggingServiceImplTest.this.taggingService.createTag(TaggingServiceImplTest.this.folder.getStoreRef(), "Foo3");
                testData.tagBar = TaggingServiceImplTest.this.taggingService.createTag(TaggingServiceImplTest.this.folder.getStoreRef(), "Bar");
                new ArrayList();
                HashMap<QName, String> container1Props = new HashMap<QName, String>(1);
                container1Props.put(ContentModel.PROP_NAME, "Container1");
                testData.container1 = TaggingServiceImplTest.this.nodeService.createNode(TaggingServiceImplTest.this.folder, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, container1Props).getChildRef();
                TaggingServiceImplTest.assertEquals((int)0, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container1).size());
                HashMap container2Props = new HashMap(1);
                container1Props.put(ContentModel.PROP_NAME, "Container2");
                testData.container2 = TaggingServiceImplTest.this.nodeService.createNode(TaggingServiceImplTest.this.folder, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, container2Props).getChildRef();
                TaggingServiceImplTest.assertEquals((int)0, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container2).size());
                TaggingServiceImplTest.this.taggingService.addTagScope(testData.container1);
                TaggingServiceImplTest.this.taggingService.addTagScope(testData.container2);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TaggingServiceImplTest.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.isTagScope(testData.container1));
                TaggingServiceImplTest.assertTrue((boolean)TaggingServiceImplTest.this.taggingService.isTagScope(testData.container2));
                TaggingServiceImplTest.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                TaggingServiceImplTest.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                HashMap<QName, String> taggedFolderProps = new HashMap<QName, String>(1);
                taggedFolderProps.put(ContentModel.PROP_NAME, "Folder");
                testData.taggedFolder = TaggingServiceImplTest.this.nodeService.createNode(testData.container1, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, taggedFolderProps).getChildRef();
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TaggingServiceImplTest.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                TaggingServiceImplTest.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container1).size());
                HashMap<QName, Serializable> taggedFolderProps = new HashMap<QName, Serializable>(1);
                ArrayList<NodeRef> tagsList = new ArrayList<NodeRef>();
                tagsList.add(testData.tagFoo1);
                tagsList.add(testData.tagFoo3);
                taggedFolderProps.put(ContentModel.ASPECT_TAGGABLE, tagsList);
                TaggingServiceImplTest.this.nodeService.addProperties(testData.taggedFolder, taggedFolderProps);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TaggingServiceImplTest.assertEquals((String)("Unexpected tags " + TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags()), (int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                TaggingServiceImplTest.assertEquals((String)("Unexpected tags " + TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags()), (int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo1").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo3").getCount());
                ArrayList<NodeRef> tagsList = new ArrayList<NodeRef>();
                tagsList.add(testData.tagFoo1);
                tagsList.add(testData.tagFoo2);
                HashMap<QName, Object> taggedDocProps = new HashMap<QName, Object>(1);
                taggedDocProps.put(ContentModel.PROP_NAME, "Document");
                taggedDocProps.put(ContentModel.ASPECT_TAGGABLE, tagsList);
                testData.taggedDoc = TaggingServiceImplTest.this.nodeService.createNode(testData.taggedFolder, ContentModel.ASSOC_CONTAINS, ContentModel.ASPECT_TAGGABLE, ContentModel.TYPE_CONTENT, taggedDocProps).getChildRef();
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TaggingServiceImplTest.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                TaggingServiceImplTest.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                TaggingServiceImplTest.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo1").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo2").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo3").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container1).size());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.taggedFolder).size());
                testData.checkedOutDoc = TaggingServiceImplTest.this.checkOutCheckInService.checkout(testData.taggedDoc);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TaggingServiceImplTest.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                TaggingServiceImplTest.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                TaggingServiceImplTest.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo1").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo2").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo3").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container1).size());
                TaggingServiceImplTest.assertEquals((int)2, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.taggedFolder).size());
                TaggingServiceImplTest.this.checkOutCheckInService.checkin(testData.checkedOutDoc, null);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TaggingServiceImplTest.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                TaggingServiceImplTest.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                TaggingServiceImplTest.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo1").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo2").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo3").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container1).size());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.taggedFolder).size());
                HashMap<QName, String> taggedDocProps = new HashMap<QName, String>(1);
                taggedDocProps.put(ContentModel.PROP_NAME, "CopyDoc");
                TaggingServiceImplTest.assertEquals((int)0, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container2).size());
                testData.taggedDoc2 = TaggingServiceImplTest.this.nodeService.createNode(testData.container2, ContentModel.ASSOC_CONTAINS, ContentModel.ASPECT_TAGGABLE, ContentModel.TYPE_CONTENT, taggedDocProps).getChildRef();
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TaggingServiceImplTest.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                TaggingServiceImplTest.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container2).size());
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.copyService.copy(testData.taggedDoc, testData.taggedDoc2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TaggingServiceImplTest.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                TaggingServiceImplTest.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                TaggingServiceImplTest.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo1").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo2").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo3").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo1").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo2").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container2).size());
                TaggingServiceImplTest.assertEquals((Object)testData.container2, (Object)TaggingServiceImplTest.this.nodeService.getPrimaryParent(testData.taggedDoc2).getParentRef());
                TaggingServiceImplTest.assertEquals((Object)testData.container2, (Object)TaggingServiceImplTest.this.taggingService.findTagScope(testData.taggedDoc2).getNodeRef());
                testData.taggedFolder2 = TaggingServiceImplTest.this.copyService.copy(testData.taggedFolder, testData.container2, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CHILDREN, true);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TaggingServiceImplTest.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                TaggingServiceImplTest.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                TaggingServiceImplTest.assertEquals((int)2, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container2).size());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.taggedFolder2).size());
                TaggingServiceImplTest.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo1").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo2").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo3").getCount());
                TaggingServiceImplTest.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo1").getCount());
                TaggingServiceImplTest.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo2").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo3").getCount());
                ArrayList<NodeRef> tagsList = new ArrayList<NodeRef>();
                tagsList.add(testData.tagBar);
                HashMap<QName, Object> taggedDocProps = new HashMap<QName, Object>(1);
                taggedDocProps.put(ContentModel.ASPECT_TAGGABLE, tagsList);
                taggedDocProps.put(ContentModel.PROP_NAME, "UpdatedDocument");
                TaggingServiceImplTest.this.nodeService.addProperties(testData.taggedDoc, taggedDocProps);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TaggingServiceImplTest.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                TaggingServiceImplTest.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo1").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo3").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("bar").getCount());
                TaggingServiceImplTest.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo1").getCount());
                TaggingServiceImplTest.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo2").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo3").getCount());
                testData.taggedDoc = TaggingServiceImplTest.this.nodeService.moveNode(testData.taggedDoc, testData.container2, ContentModel.ASSOC_CONTAINS, ContentModel.ASPECT_TAGGABLE).getChildRef();
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TaggingServiceImplTest.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                TaggingServiceImplTest.assertEquals((int)4, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo1").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo3").getCount());
                TaggingServiceImplTest.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo1").getCount());
                TaggingServiceImplTest.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo2").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo3").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("bar").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container1).size());
                TaggingServiceImplTest.assertEquals((int)3, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container2).size());
                TaggingServiceImplTest.assertEquals((Object)testData.container2, (Object)TaggingServiceImplTest.this.nodeService.getPrimaryParent(testData.taggedDoc).getParentRef());
                TaggingServiceImplTest.assertEquals((Object)testData.container2, (Object)TaggingServiceImplTest.this.taggingService.findTagScope(testData.taggedDoc).getNodeRef());
                TaggingServiceImplTest.assertEquals((Object)testData.container2, (Object)TaggingServiceImplTest.this.nodeService.getPrimaryParent(testData.taggedDoc2).getParentRef());
                TaggingServiceImplTest.assertEquals((Object)testData.container2, (Object)TaggingServiceImplTest.this.taggingService.findTagScope(testData.taggedDoc2).getNodeRef());
                TaggingServiceImplTest.this.nodeService.deleteNode(testData.taggedDoc);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TaggingServiceImplTest.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                TaggingServiceImplTest.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container1).size());
                TaggingServiceImplTest.assertEquals((int)2, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container2).size());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo1").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo3").getCount());
                TaggingServiceImplTest.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo1").getCount());
                TaggingServiceImplTest.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo2").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo3").getCount());
                TaggingServiceImplTest.assertEquals(null, (Object)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("bar"));
                TaggingServiceImplTest.this.nodeService.deleteNode(testData.taggedDoc2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TaggingServiceImplTest.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                TaggingServiceImplTest.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container1).size());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container2).size());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo1").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTag("foo3").getCount());
                TaggingServiceImplTest.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo1").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo2").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo3").getCount());
                TaggingServiceImplTest.assertEquals(null, (Object)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("bar"));
                TaggingServiceImplTest.this.nodeService.deleteNode(testData.taggedFolder);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TaggingServiceImplTest.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                TaggingServiceImplTest.assertEquals((int)3, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                TaggingServiceImplTest.assertEquals((int)0, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container1).size());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container2).size());
                TaggingServiceImplTest.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo1").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo2").getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTag("foo3").getCount());
                TaggingServiceImplTest.this.nodeService.deleteNode(testData.taggedFolder2);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TaggingServiceImplTest.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container1).getTags().size());
                TaggingServiceImplTest.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.findTagScope(testData.container2).getTags().size());
                TaggingServiceImplTest.assertEquals((int)0, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container1).size());
                TaggingServiceImplTest.assertEquals((int)0, (int)TaggingServiceImplTest.this.nodeService.getChildAssocs(testData.container2).size());
                return null;
            }
        });
    }

    @Test
    @Category(value={RedundantTests.class, LuceneTests.class})
    public void test91PermissionsAndPolicies() throws Exception {
        class TestData {
            public NodeRef taggedNode;
            public NodeRef auditableFolder;
            public Date origModified;

            TestData() {
            }
        }
        final TestData testData = new TestData();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                if (TaggingServiceImplTest.this.authenticationService.authenticationExists("User1")) {
                    TaggingServiceImplTest.this.authenticationService.deleteAuthentication("User1");
                }
                if (TaggingServiceImplTest.this.personService.personExists("User1")) {
                    TaggingServiceImplTest.this.personService.deletePerson("User1");
                }
                TaggingServiceImplTest.this.authenticationService.createAuthentication("User1", "PWD".toCharArray());
                PropertyMap personProperties = new PropertyMap();
                personProperties.put((Object)ContentModel.PROP_USERNAME, (Object)"User1");
                personProperties.put((Object)ContentModel.PROP_AUTHORITY_DISPLAY_NAME, (Object)"titleUser1");
                personProperties.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
                personProperties.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
                personProperties.put((Object)ContentModel.PROP_EMAIL, (Object)"User1@example.com");
                personProperties.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
                TaggingServiceImplTest.this.personService.createPerson((Map)personProperties);
                NodeRef tn = TaggingServiceImplTest.this.taggingService.createTag(TaggingServiceImplTest.this.folder.getStoreRef(), "Testing");
                NodeRef tr = TaggingServiceImplTest.this.nodeService.getPrimaryParent(tn).getParentRef();
                TaggingServiceImplTest.this.permissionService.setPermission(tr, "User1", "Editor", true);
                TaggingServiceImplTest.this.permissionService.setPermission(tr, "User1", "Contributor", true);
                TaggingServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                testData.auditableFolder = TaggingServiceImplTest.this.nodeService.createNode(TaggingServiceImplTest.this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Folder"), ContentModel.TYPE_FOLDER).getChildRef();
                TaggingServiceImplTest.this.nodeService.addAspect(testData.auditableFolder, ContentModel.ASPECT_AUDITABLE, null);
                TaggingServiceImplTest.this.taggingService.addTagScope(testData.auditableFolder);
                TaggingServiceImplTest.this.permissionService.setPermission(testData.auditableFolder, "User1", "Consumer", true);
                TaggingServiceImplTest.assertEquals((Object)"System", (Object)TaggingServiceImplTest.this.nodeService.getProperty(testData.auditableFolder, ContentModel.PROP_CREATOR));
                TaggingServiceImplTest.assertEquals((Object)"System", (Object)TaggingServiceImplTest.this.nodeService.getProperty(testData.auditableFolder, ContentModel.PROP_MODIFIER));
                testData.taggedNode = TaggingServiceImplTest.this.nodeService.createNode(testData.auditableFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Tagged"), ContentModel.TYPE_CONTENT).getChildRef();
                TaggingServiceImplTest.this.permissionService.setPermission(testData.taggedNode, "User1", "Editor", true);
                TaggingServiceImplTest.this.authenticationComponent.setCurrentUser("User1");
                TaggingServiceImplTest.assertEquals((int)0, (int)TaggingServiceImplTest.this.taggingService.getTags(testData.taggedNode).size());
                TaggingServiceImplTest.this.nodeService.setProperty(testData.taggedNode, ContentModel.PROP_TITLE, (Serializable)((Object)"To ensure we're allowed to write"));
                TaggingServiceImplTest.this.taggingService.addTag(testData.taggedNode, TaggingServiceImplTest.TAG_1);
                TaggingServiceImplTest.this.taggingService.addTag(testData.taggedNode, TaggingServiceImplTest.TAG_2);
                TaggingServiceImplTest.assertEquals((int)2, (int)TaggingServiceImplTest.this.taggingService.getTags(testData.taggedNode).size());
                TagScope ts = TaggingServiceImplTest.this.taggingService.findTagScope(testData.taggedNode);
                TaggingServiceImplTest.assertEquals((Object)testData.auditableFolder, (Object)ts.getNodeRef());
                TaggingServiceImplTest.assertEquals((int)0, (int)ts.getTags().size());
                TaggingServiceImplTest.assertEquals((Object)"System", (Object)TaggingServiceImplTest.this.nodeService.getProperty(testData.auditableFolder, ContentModel.PROP_CREATOR));
                TaggingServiceImplTest.assertEquals((Object)"System", (Object)TaggingServiceImplTest.this.nodeService.getProperty(ts.getNodeRef(), ContentModel.PROP_MODIFIER));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testData.origModified = (Date)TaggingServiceImplTest.this.nodeService.getProperty(testData.auditableFolder, ContentModel.PROP_MODIFIED);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TagScope ts = TaggingServiceImplTest.this.taggingService.findTagScope(testData.taggedNode);
                TaggingServiceImplTest.assertEquals((Object)testData.auditableFolder, (Object)ts.getNodeRef());
                TaggingServiceImplTest.assertEquals((int)2, (int)ts.getTags().size());
                TaggingServiceImplTest.assertEquals((int)1, (int)ts.getTag(TaggingServiceImplTest.TAG_1).getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)ts.getTag(TaggingServiceImplTest.TAG_2).getCount());
                TaggingServiceImplTest.assertEquals((Object)"System", (Object)TaggingServiceImplTest.this.nodeService.getProperty(testData.auditableFolder, ContentModel.PROP_CREATOR));
                TaggingServiceImplTest.assertEquals((Object)"System", (Object)TaggingServiceImplTest.this.nodeService.getProperty(ts.getNodeRef(), ContentModel.PROP_MODIFIER));
                TaggingServiceImplTest.assertEquals((long)testData.origModified.getTime(), (long)((Date)TaggingServiceImplTest.this.nodeService.getProperty(testData.auditableFolder, ContentModel.PROP_MODIFIED)).getTime());
                TaggingServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                TaggingServiceImplTest.this.authenticationService.deleteAuthentication("User1");
                TaggingServiceImplTest.this.personService.deletePerson("User1");
                return null;
            }
        });
    }

    @Test
    @Category(value={RedundantTests.class, LuceneTests.class})
    public void test92JSAPI() throws Exception {
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                HashMap<String, Object> model = new HashMap<String, Object>(0);
                model.put("folder", TaggingServiceImplTest.this.folder);
                model.put("subFolder", TaggingServiceImplTest.this.subFolder);
                model.put("document", TaggingServiceImplTest.this.document);
                model.put("subDocument", TaggingServiceImplTest.this.subDocument);
                model.put("tagScopeTest", false);
                ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/tagging/script/test_taggingService.js");
                TaggingServiceImplTest.this.scriptService.executeScript((ScriptLocation)location, model);
                return null;
            }
        });
    }

    @Test
    @Category(value={RedundantTests.class, LuceneTests.class})
    public void test93JSTagScope() throws Exception {
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.createTag(storeRef, "alpha");
                TaggingServiceImplTest.this.taggingService.createTag(storeRef, "alpha double");
                TaggingServiceImplTest.this.taggingService.createTag(storeRef, "beta");
                TaggingServiceImplTest.this.taggingService.createTag(storeRef, "gamma");
                TaggingServiceImplTest.this.taggingService.createTag(storeRef, "delta");
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.subFolder);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_3);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_2);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                HashMap<String, Object> model = new HashMap<String, Object>(0);
                model.put("folder", TaggingServiceImplTest.this.folder);
                model.put("subFolder", TaggingServiceImplTest.this.subFolder);
                model.put("document", TaggingServiceImplTest.this.document);
                model.put("subDocument", TaggingServiceImplTest.this.subDocument);
                model.put("tagScopeTest", true);
                model.put("store", storeRef.toString());
                ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/tagging/script/test_taggingService.js");
                TaggingServiceImplTest.this.scriptService.executeScript((ScriptLocation)location, model);
                return null;
            }
        });
    }

    @Test
    public void test93OnStartupJob() throws Exception {
        final UpdateTagScopesActionExecuter updateTagsAction = (UpdateTagScopesActionExecuter)this.applicationContext.getBean("update-tagscope");
        class TestData {
            public String lockF;
            public String lockSF;

            TestData() {
            }
        }
        final TestData testData = new TestData();
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TaggingServiceImplTest.assertEquals((int)0, (int)updateTagsAction.searchForTagScopesPendingUpdates().size());
                testData.lockF = updateTagsAction.lockTagScope(TaggingServiceImplTest.this.folder);
                testData.lockSF = updateTagsAction.lockTagScope(TaggingServiceImplTest.this.subFolder);
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.subFolder);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_1);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_2);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, TaggingServiceImplTest.TAG_1);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.document, TaggingServiceImplTest.TAG_1);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_1);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_3);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TagScope ts1 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                TagScope ts2 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.subFolder);
                TaggingServiceImplTest.assertEquals((String)("Wrong tags on folder tagscope: " + ts1.getTags()), (int)0, (int)ts1.getTags().size());
                TaggingServiceImplTest.assertEquals((String)("Wrong tags on folder tagscope: " + ts1.getTags()), (int)0, (int)ts2.getTags().size());
                TaggingServiceImplTest.assertEquals((int)2, (int)updateTagsAction.searchForTagScopesPendingUpdates().size());
                List pendingScopes = updateTagsAction.searchForTagScopesPendingUpdates();
                TaggingServiceImplTest.assertTrue((String)("Not found in " + pendingScopes), (boolean)pendingScopes.contains(TaggingServiceImplTest.this.folder));
                TaggingServiceImplTest.assertTrue((String)("Not found in " + pendingScopes), (boolean)pendingScopes.contains(TaggingServiceImplTest.this.subFolder));
                updateTagsAction.updateTagScopeLock(TaggingServiceImplTest.this.folder, testData.lockF);
                updateTagsAction.updateTagScopeLock(TaggingServiceImplTest.this.subFolder, testData.lockSF);
                UpdateTagScopesQuartzJob job = new UpdateTagScopesQuartzJob();
                job.execute(TaggingServiceImplTest.this.actionService, updateTagsAction);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.assertEquals((int)2, (int)updateTagsAction.searchForTagScopesPendingUpdates().size());
                List pendingScopes = updateTagsAction.searchForTagScopesPendingUpdates();
                TaggingServiceImplTest.assertTrue((String)("Not found in " + pendingScopes), (boolean)pendingScopes.contains(TaggingServiceImplTest.this.folder));
                TaggingServiceImplTest.assertTrue((String)("Not found in " + pendingScopes), (boolean)pendingScopes.contains(TaggingServiceImplTest.this.subFolder));
                return null;
            }
        });
        updateTagsAction.unlockTagScope(this.folder, testData.lockF);
        updateTagsAction.unlockTagScope(this.subFolder, testData.lockSF);
        UpdateTagScopesQuartzJob job = new UpdateTagScopesQuartzJob();
        job.execute(this.actionService, updateTagsAction);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.assertEquals((int)0, (int)updateTagsAction.searchForTagScopesPendingUpdates().size());
                TagScope ts1 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                TagScope ts2 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.subFolder);
                TaggingServiceImplTest.assertEquals((String)("Wrong tags on folder tagscope: " + ts1.getTags()), (int)3, (int)ts1.getTags().size());
                TaggingServiceImplTest.assertEquals((String)("Wrong tags on folder tagscope: " + ts1.getTags()), (int)2, (int)ts2.getTags().size());
                TaggingServiceImplTest.assertEquals((int)4, (int)ts1.getTag(TaggingServiceImplTest.TAG_1).getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)ts1.getTag(TaggingServiceImplTest.TAG_2).getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)ts1.getTag(TaggingServiceImplTest.TAG_3.toLowerCase()).getCount());
                TaggingServiceImplTest.assertEquals((int)2, (int)ts2.getTag(TaggingServiceImplTest.TAG_1).getCount());
                TaggingServiceImplTest.assertEquals((int)1, (int)ts2.getTag(TaggingServiceImplTest.TAG_2).getCount());
                return null;
            }
        });
    }

    @Test
    public void test94MultiThreaded() throws Exception {
        String[] tags;
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.subFolder);
                return null;
            }
        });
        this.asyncOccurs.wantedActionsCount = 0;
        ArrayList<Thread> threads = new ArrayList<Thread>();
        String[] stringArray = tags = new String[]{TAG_1, TAG_2, TAG_3, TAG_4, TAG_5, "testTag06", "testTag07", "testTag08", "testTag09", "testTag10", "testTag11", "testTag12", "testTag13", "testTag14", "testTag15", "testTag16", "testTag17", "testTag18", "testTag19", "testTag20"};
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tmpTag;
            final String tag = tmpTag = stringArray[n2];
            Thread t = new Thread(new Runnable(){

                @Override
                public synchronized void run() {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    logger.debug((Object)(Thread.currentThread() + " - About to start tagging for " + tag));
                    AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                    RetryingTransactionHelper.RetryingTransactionCallback<Void> txnCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        public Void execute() throws Throwable {
                            TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, tag);
                            TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, tag);
                            TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, tag);
                            logger.debug((Object)(Thread.currentThread() + " - Tagging for " + tag));
                            return null;
                        }
                    };
                    try {
                        TaggingServiceImplTest.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)txnCallback);
                    }
                    catch (Throwable e) {
                        logger.error((Object)("Tagging failed: " + e));
                    }
                    logger.debug((Object)(Thread.currentThread() + " - Done tagging for " + tag));
                    try {
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
            threads.add(t);
            t.start();
            ++n2;
        }
        logger.info((Object)"Releasing tagging threads");
        for (Thread t : threads) {
            t.interrupt();
        }
        for (Thread t : threads) {
            t.join();
        }
        logger.info((Object)"All threads should have finished");
        Thread.sleep(150L);
        int i = 0;
        while (i < 600) {
            try {
                if (this.asyncOccurs.wantedActionsCount < tags.length) {
                    if (i % 50 == 0) {
                        logger.info((Object)("Done " + this.asyncOccurs.wantedActionsCount + " of " + tags.length));
                    }
                    Thread.sleep(100L);
                } else {
                    if (this.actionTrackingService.getAllExecutingActions().size() <= 0) break;
                    if (i % 50 == 0) {
                        List actions = this.actionTrackingService.getAllExecutingActions();
                        logger.info((Object)("Waiting on " + actions.size() + " actions: " + actions));
                    }
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        Thread.sleep(175L);
        System.out.println("Done waiting for tagging, now checking");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TagScope ts1 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                TagScope ts2 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.subFolder);
                TaggingServiceImplTest.assertEquals((String)("Wrong tags on folder tagscope: " + ts1.getTags()), (int)tags.length, (int)ts1.getTags().size());
                TaggingServiceImplTest.assertEquals((String)("Wrong tags on subfolder tagscope: " + ts2.getTags()), (int)tags.length, (int)ts2.getTags().size());
                String[] stringArray = tags;
                int n = tags.length;
                int n2 = 0;
                while (n2 < n) {
                    String tag = stringArray[n2];
                    TaggingServiceImplTest.assertEquals((int)3, (int)ts1.getTag(tag.toLowerCase()).getCount());
                    TaggingServiceImplTest.assertEquals((int)2, (int)ts2.getTag(tag.toLowerCase()).getCount());
                    ++n2;
                }
                return null;
            }
        });
    }

    @Test
    public void testALF_17260() throws Exception {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.folder);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                int j = 0;
                while (j < 10) {
                    final int k = j++;
                    RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createFoldersAndTags = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                        public NodeRef execute() throws Throwable {
                            NodeRef folder1 = TaggingServiceImplTest.this.fileFolderService.create(TaggingServiceImplTest.this.folder, "Test1", ContentModel.TYPE_FOLDER).getNodeRef();
                            NodeRef folder2 = TaggingServiceImplTest.this.fileFolderService.create(TaggingServiceImplTest.this.folder, "Test2", ContentModel.TYPE_FOLDER).getNodeRef();
                            int i = 0;
                            while (i < 102) {
                                NodeRef file = TaggingServiceImplTest.this.fileFolderService.create(folder1, String.valueOf(k) + "_test_" + i + ".text", ContentModel.TYPE_CONTENT).getNodeRef();
                                TaggingServiceImplTest.this.taggingService.addTag(file, String.valueOf(k) + "testTag" + i);
                                ++i;
                            }
                            List childRefs = TaggingServiceImplTest.this.nodeService.getChildAssocs(folder1);
                            for (ChildAssociationRef childRef : childRefs) {
                                TaggingServiceImplTest.this.taggingService.clearTags(childRef.getChildRef());
                            }
                            QName assocQName = TaggingServiceImplTest.this.nodeService.getPrimaryParent(folder1).getTypeQName();
                            TaggingServiceImplTest.this.nodeService.moveNode(folder1, folder2, ContentModel.ASSOC_CONTAINS, assocQName);
                            return folder2;
                        }
                    };
                    NodeRef folder2 = (NodeRef)TaggingServiceImplTest.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFoldersAndTags);
                    TaggingServiceImplTest.this.nodeService.deleteNode(folder2);
                }
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TagScope ts1 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.assertEquals((String)("Wrong tags on sub folder: " + ts1.getTags()), (int)0, (int)ts1.getTags().size());
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, TaggingServiceImplTest.TAG_1);
                return null;
            }
        });
        this.asyncOccurs.awaitExecution(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TagScope ts1 = TaggingServiceImplTest.this.taggingService.findTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.assertEquals((String)("Wrong tags on folder: " + ts1.getTags()), (int)1, (int)ts1.getTags().size());
                TaggingServiceImplTest.assertEquals((String)"Wrong tag name", (String)TaggingServiceImplTest.TAG_1, (String)((TagDetails)ts1.getTags().get(0)).getName());
                TaggingServiceImplTest.assertEquals((String)"Wrong number of documents", (int)1, (int)((TagDetails)ts1.getTags().get(0)).getCount());
                return null;
            }
        });
    }

    @Test
    public void testTagFileRead() throws UnsupportedEncodingException {
        List tags = TaggingServiceImpl.readTagDetails((InputStream)new ByteArrayInputStream("Tag1|10\nTag2|20\nInvalid\nInvalid2|\nInvalid3|One\nTooMany|1|2\n\n".getBytes("UTF-8")));
        TaggingServiceImplTest.assertEquals((int)3, (int)tags.size());
        TaggingServiceImplTest.assertEquals((String)((TagDetails)tags.get(0)).getName(), (String)"Tag1");
        TaggingServiceImplTest.assertEquals((String)((TagDetails)tags.get(1)).getName(), (String)"Tag2");
        TaggingServiceImplTest.assertEquals((String)((TagDetails)tags.get(2)).getName(), (String)"TooMany");
        TaggingServiceImplTest.assertEquals((int)((TagDetails)tags.get(0)).getCount(), (int)10);
        TaggingServiceImplTest.assertEquals((int)((TagDetails)tags.get(1)).getCount(), (int)20);
        TaggingServiceImplTest.assertEquals((int)((TagDetails)tags.get(2)).getCount(), (int)1);
    }

    @Test
    @Category(value={RedundantTests.class, LuceneTests.class})
    public void testPagedTags() throws UnsupportedEncodingException {
        this.authenticationComponent.setSystemUserAsCurrentUser();
        Pair tags = this.taggingService.getPagedTags(storeRef, 1, 10);
        TaggingServiceImplTest.assertNotNull((Object)tags);
        PagingResults res = this.taggingService.getTags(storeRef, new PagingRequest(10));
        TaggingServiceImplTest.assertNotNull((Object)res);
        String guid = GUID.generate();
        HashMap<QName, String> docProps = new HashMap<QName, String>(1);
        String docName = "testDocument" + guid + ".txt";
        docProps.put(ContentModel.PROP_NAME, docName);
        NodeRef myDoc = this.nodeService.createNode(this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)docName), ContentModel.TYPE_CONTENT, docProps).getChildRef();
        this.taggingService.addTag(myDoc, "dog");
        res = this.taggingService.getTags(myDoc, new PagingRequest(10));
        TaggingServiceImplTest.assertNotNull((Object)res);
        TaggingServiceImplTest.assertTrue(((Integer)res.getTotalResultCount().getFirst() == 1 ? 1 : 0) != 0);
    }

    @Test
    @Category(value={RedundantTests.class, LuceneTests.class})
    public void testChangeTags() throws UnsupportedEncodingException {
        try {
            this.taggingService.changeTag(storeRef, null, null);
            TaggingServiceImplTest.fail((String)"Should throw exception");
        }
        catch (TaggingException tae) {
            tae.getMessage().contains("Existing tag cannot be null");
        }
        try {
            this.taggingService.changeTag(storeRef, "bob", null);
            TaggingServiceImplTest.fail((String)"Should throw exception");
        }
        catch (TaggingException tae) {
            tae.getMessage().contains("New tag cannot be null");
        }
        try {
            this.taggingService.changeTag(storeRef, "bob", "bob");
            TaggingServiceImplTest.fail((String)"Should throw exception");
        }
        catch (TaggingException tae) {
            tae.getMessage().contains("New and existing tags are the same");
        }
        try {
            this.taggingService.changeTag(storeRef, "bob", "hope");
            TaggingServiceImplTest.fail((String)"Should throw exception");
        }
        catch (NonExistentTagException net) {
            net.getMessage().contains("not found");
        }
        try {
            List storeTags = this.taggingService.getTags(storeRef);
            TaggingServiceImplTest.assertNotNull((Object)storeTags);
            TaggingServiceImplTest.assertTrue((storeTags.size() > 1 ? 1 : 0) != 0);
            this.taggingService.changeTag(storeRef, (String)storeTags.get(0), (String)storeTags.get(1));
            TaggingServiceImplTest.fail((String)"Should throw exception");
        }
        catch (TagExistsException tee) {
            tee.getMessage().contains("already exists");
        }
    }

    @Test
    public void testBadTags() {
        this.testTag(BAD_TAG);
        this.testTag(BAD_TAG2);
    }

    private void testTag(final String tag) {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                try {
                    TaggingServiceImplTest.this.taggingService.createTag(storeRef, tag);
                    TaggingServiceImplTest.fail();
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                try {
                    TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.document, tag);
                    TaggingServiceImplTest.fail();
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                try {
                    ArrayList<String> setTags = new ArrayList<String>(2);
                    setTags.add(tag);
                    TaggingServiceImplTest.this.taggingService.setTags(TaggingServiceImplTest.this.document, setTags);
                    TaggingServiceImplTest.fail();
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                return null;
            }
        });
    }

    @Test
    @Category(value={RedundantTests.class, LuceneTests.class})
    public void testDeleteTag() throws Exception {
        try {
            this.nodeRefPropInterceptor.setFilterOnGet(false);
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    TaggingServiceImplTest.this.taggingService.clearTags(TaggingServiceImplTest.this.folder);
                    TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_1);
                    List taggableProperty = (List)((Object)TaggingServiceImplTest.this.nodeService.getProperty(TaggingServiceImplTest.this.folder, ContentModel.PROP_TAGS));
                    TaggingServiceImplTest.assertTrue((String)"Our folder should have a reference on one tag.", (taggableProperty.size() == 1 ? 1 : 0) != 0);
                    TaggingServiceImplTest.this.taggingService.deleteTag(storeRef, TaggingServiceImplTest.TAG_1);
                    taggableProperty = (List)((Object)TaggingServiceImplTest.this.nodeService.getProperty(TaggingServiceImplTest.this.folder, ContentModel.PROP_TAGS));
                    TaggingServiceImplTest.assertTrue((String)"Our folder shouldn't have any references left to deleted tags.", (taggableProperty.size() == 0 ? 1 : 0) != 0);
                    return null;
                }
            });
        }
        finally {
            this.nodeRefPropInterceptor.setFilterOnGet(true);
        }
    }

    @Test
    public void testTagScopeIfUrlNull() {
        TagScopePropertyMethodInterceptor.setEnabled((Boolean)Boolean.TRUE);
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        final String siteName = GUID.generate();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SiteInfo siteInfo = TaggingServiceImplTest.this.createSite(siteName, "doclib", SiteVisibility.PUBLIC);
                NodeRef documentLibraryOfSite = TaggingServiceImplTest.this.siteService.getContainer(siteInfo.getShortName(), "doclib");
                NodeRef containerTagScope = TaggingServiceImplTest.this.fileFolderService.create(documentLibraryOfSite, "containerTagScope" + GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                String tagName = GUID.generate();
                TaggingServiceImplTest.this.taggingService.createTag(storeRef, tagName);
                TaggingServiceImplTest.this.taggingService.addTagScope(containerTagScope);
                NodeRef file = TaggingServiceImplTest.this.fileFolderService.create(containerTagScope, "_test_" + GUID.generate() + ".text", ContentModel.TYPE_CONTENT).getNodeRef();
                TaggingServiceImplTest.this.taggingService.addTag(file, tagName);
                TaggingServiceImplTest.this.fileFolderService.delete(file);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                UpdateTagScopesActionExecuter updateTagsAction = (UpdateTagScopesActionExecuter)TaggingServiceImplTest.this.applicationContext.getBean("update-tagscope");
                UpdateTagScopesQuartzJob job = new UpdateTagScopesQuartzJob();
                job.execute(TaggingServiceImplTest.this.actionService, updateTagsAction);
                return null;
            }
        });
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("customSiteName", siteName);
        ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/site/script/test_tagScopeALF_21875.js");
        this.scriptService.executeScript((ScriptLocation)location, model);
        TagScopePropertyMethodInterceptor.setEnabled((Boolean)Boolean.FALSE);
    }

    private SiteInfo createSite(String siteShortName, String componentId, SiteVisibility visibility) {
        SiteInfo siteInfo = this.siteService.createSite(TEST_SITE_PRESET, siteShortName, TEST_TITLE, TEST_DESCRIPTION, visibility);
        this.siteService.createContainer(siteShortName, componentId, ContentModel.TYPE_FOLDER, null);
        return siteInfo;
    }

    public class AsyncOccurs
    implements AsynchronousActionExecutionQueuePolicies.OnAsyncActionExecute {
        private Object waitForExecutionLock = new Object();
        private static final long waitTime = 3500L;
        private static final String ACTION_TYPE = "update-tagscope";
        private int wantedActionsCount = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAsyncActionExecute(Action action, NodeRef actionedUponNodeRef) {
            if (action.getActionDefinitionName().equals(ACTION_TYPE)) {
                ++this.wantedActionsCount;
                Object object = this.waitForExecutionLock;
                synchronized (object) {
                    try {
                        this.waitForExecutionLock.notify();
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {}
                }
            }
            System.out.println("Ignoring unexpected async action:" + action);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T awaitExecution(RetryingTransactionHelper.RetryingTransactionCallback<T> callback) throws Exception {
            Object returnVal = TaggingServiceImplTest.this.transactionService.getRetryingTransactionHelper().doInTransaction(callback);
            Object object = this.waitForExecutionLock;
            synchronized (object) {
                this.waitForExecutionLock.wait(100L);
                if (TaggingServiceImplTest.this.actionTrackingService.getExecutingActions(ACTION_TYPE).size() > 0) {
                    long now = System.currentTimeMillis();
                    this.waitForExecutionLock.wait(3500L);
                    if (System.currentTimeMillis() - now >= 3500L) {
                        System.err.println("Warning - trigger wasn't received");
                    }
                }
            }
            int i = 0;
            while (i < 100) {
                if (TaggingServiceImplTest.this.actionTrackingService.getExecutingActions(ACTION_TYPE).size() == 0) break;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
            if (TaggingServiceImplTest.this.actionTrackingService.getExecutingActions(ACTION_TYPE).size() > 0) {
                System.err.println("Warning - not all actions finished");
            }
            return (T)returnVal;
        }
    }
}

