/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.CacheStatistics;
import org.alfresco.repo.cache.LockingCache;
import org.alfresco.repo.cache.NullCache;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.TransactionStats;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionalCache<K extends Serializable, V>
implements LockingCache<K, V>,
TransactionListener,
InitializingBean {
    private static final String RESOURCE_KEY_TXN_DATA = "TransactionalCache.TxnData";
    private Log logger = LogFactory.getLog(TransactionalCache.class);
    private boolean isDebugEnabled = this.logger.isDebugEnabled();
    private String name;
    private boolean disableSharedCache = false;
    private SimpleCache<Serializable, ValueHolder<V>> sharedCache;
    private boolean isMutable = true;
    private boolean allowEqualsChecks = false;
    private int maxCacheSize = 500;
    private String resourceKeyTxnData;
    private CacheStatistics cacheStats;
    private boolean cacheStatsEnabled = false;
    private boolean isTenantAware = true;

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactionalCache)) {
            return false;
        }
        TransactionalCache that = (TransactionalCache)obj;
        return EqualsHelper.nullSafeEquals((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void setSharedCache(SimpleCache<Serializable, ValueHolder<V>> sharedCache) {
        this.sharedCache = sharedCache;
    }

    public void setDisableSharedCache(boolean disableSharedCache) {
        this.disableSharedCache = disableSharedCache;
    }

    public void setMutable(boolean isMutable) {
        this.isMutable = isMutable;
    }

    public void setAllowEqualsChecks(boolean allowEqualsChecks) {
        this.allowEqualsChecks = allowEqualsChecks;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTenantAware(boolean isTenantAware) {
        this.isTenantAware = isTenantAware;
    }

    public void setCacheStats(CacheStatistics cacheStats) {
        this.cacheStats = cacheStats;
    }

    public void setCacheStatsEnabled(boolean cacheStatsEnabled) {
        this.cacheStatsEnabled = cacheStatsEnabled;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"name", (Object)this.name);
        PropertyCheck.mandatory((Object)this, (String)"sharedCache", this.sharedCache);
        this.resourceKeyTxnData = "TransactionalCache.TxnData." + this.name;
        this.logger = LogFactory.getLog((String)(String.valueOf(TransactionalCache.class.getName()) + "." + this.name));
        this.isDebugEnabled = this.logger.isDebugEnabled();
        if (this.disableSharedCache) {
            this.sharedCache = NullCache.getInstance();
        }
    }

    private TransactionData getTransactionData() {
        TransactionData data = (TransactionData)AlfrescoTransactionSupport.getResource((Object)this.resourceKeyTxnData);
        if (data == null) {
            data = new TransactionData();
            data.updatedItemsCache = new LRULinkedHashMap(23);
            data.removedItemsCache = new HashSet(13);
            data.lockedItemsCache = new HashSet(13);
            data.isReadOnly = AlfrescoTransactionSupport.getTransactionReadState() == AlfrescoTransactionSupport.TxnReadState.TXN_READ_ONLY;
            data.stats = new TransactionStats();
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                AlfrescoTransactionSupport.bindListener(this);
            }
            AlfrescoTransactionSupport.bindResource((Object)this.resourceKeyTxnData, (Object)data);
        }
        return data;
    }

    public boolean getDisableSharedCacheReadForTransaction() {
        if (AlfrescoTransactionSupport.getTransactionId() != null) {
            TransactionData txnData = this.getTransactionData();
            return txnData.noSharedCacheRead;
        }
        return false;
    }

    public void setDisableSharedCacheReadForTransaction(boolean noSharedCacheRead) {
        TransactionData txnData = this.getTransactionData();
        if (noSharedCacheRead && !txnData.noSharedCacheRead) {
            txnData.noSharedCacheRead = noSharedCacheRead;
            String currentCacheRegion = TenantUtil.getCurrentDomain();
            for (Map.Entry entry : new ArrayList(txnData.updatedItemsCache.entrySet())) {
                Serializable cacheKey = (Serializable)entry.getKey();
                Serializable key = null;
                if (cacheKey instanceof CacheRegionKey) {
                    CacheRegionKey cacheRegionKey = (CacheRegionKey)cacheKey;
                    if (currentCacheRegion.equals(cacheRegionKey.getCacheRegion())) {
                        key = cacheRegionKey.getCacheKey();
                    }
                } else {
                    key = cacheKey;
                }
                if (key == null) continue;
                CacheBucket bucket = (CacheBucket)entry.getValue();
                if (bucket instanceof ReadCacheBucket) {
                    txnData.updatedItemsCache.remove(cacheKey);
                    continue;
                }
                if (!(bucket instanceof UpdateCacheBucket)) continue;
                this.remove(key);
            }
        }
    }

    public boolean contains(K key) {
        V value = this.get(key);
        return value != null;
    }

    public Collection<K> getKeys() {
        HashSet<Object> keys = null;
        if (AlfrescoTransactionSupport.getTransactionId() != null) {
            keys = new HashSet<Object>(23);
            TransactionData txnData = this.getTransactionData();
            if (!txnData.isClearOn) {
                Collection backingKeys = this.sharedCache.getKeys();
                HashSet<Serializable> hashSet = new HashSet<Serializable>(backingKeys.size());
                for (Serializable backingKey : backingKeys) {
                    hashSet.add(this.getTenantAwareCacheKey(backingKey));
                }
                keys.addAll(hashSet);
            }
            keys.addAll(txnData.updatedItemsCache.keySet());
            keys.removeAll(txnData.removedItemsCache);
        } else {
            keys = this.sharedCache.getKeys();
        }
        HashSet<Serializable> cacheKeys = new HashSet<Serializable>(keys.size());
        String currentCacheRegion = TenantUtil.getCurrentDomain();
        for (Serializable serializable : keys) {
            if (serializable instanceof CacheRegionKey) {
                CacheRegionKey cacheRegionKey = (CacheRegionKey)serializable;
                if (!currentCacheRegion.equals(cacheRegionKey.getCacheRegion())) continue;
                cacheKeys.add(cacheRegionKey.getCacheKey());
                continue;
            }
            cacheKeys.add(serializable);
        }
        return cacheKeys;
    }

    public static <KEY extends Serializable, VAL> VAL getSharedCacheValue(SimpleCache<KEY, ValueHolder<VAL>> sharedCache, KEY key) {
        return TransactionalCache.getSharedCacheValue(sharedCache, key, null);
    }

    public static <KEY extends Serializable, VAL> VAL getSharedCacheValue(SimpleCache<KEY, ValueHolder<VAL>> sharedCache, KEY key, TransactionStats stats) {
        long endNanos;
        long startNanos = stats != null ? System.nanoTime() : 0L;
        Object possibleWrapper = sharedCache.get(key);
        long l = endNanos = stats != null ? System.nanoTime() : 0L;
        if (possibleWrapper == null) {
            if (stats != null) {
                stats.record(startNanos, endNanos, TransactionStats.OpType.GET_MISS);
            }
            return null;
        }
        if (possibleWrapper instanceof ValueHolder) {
            if (stats != null) {
                stats.record(startNanos, endNanos, TransactionStats.OpType.GET_HIT);
            }
            ValueHolder wrapper = (ValueHolder)possibleWrapper;
            return (VAL)wrapper.getValue();
        }
        if (stats != null) {
            stats.record(startNanos, endNanos, TransactionStats.OpType.GET_MISS);
        }
        throw new IllegalStateException("All entries for TransactionalCache must be put using TransactionalCache.putSharedCacheValue.");
    }

    public static <KEY extends Serializable, VAL> void putSharedCacheValue(SimpleCache<KEY, ValueHolder<VAL>> sharedCache, KEY key, VAL value, TransactionStats stats) {
        ValueHolder wrapper = new ValueHolder(value);
        long startNanos = System.nanoTime();
        sharedCache.put(key, wrapper);
        long endNanos = System.nanoTime();
        if (stats != null) {
            stats.record(startNanos, endNanos, TransactionStats.OpType.PUT);
        }
    }

    private final boolean isValueLocked(TransactionData txnData, Serializable key) {
        return txnData.lockedItemsCache.size() > 0 && txnData.lockedItemsCache.contains(key);
    }

    public boolean isValueLocked(K keyIn) {
        if (AlfrescoTransactionSupport.getTransactionId() != null) {
            Serializable key = this.getTenantAwareCacheKey(keyIn);
            TransactionData txnData = this.getTransactionData();
            return txnData.lockedItemsCache.contains(key);
        }
        return false;
    }

    public void lockValue(K keyIn) {
        if (AlfrescoTransactionSupport.getTransactionId() != null) {
            Serializable key = this.getTenantAwareCacheKey(keyIn);
            TransactionData txnData = this.getTransactionData();
            txnData.lockedItemsCache.add(key);
            return;
        }
    }

    public void unlockValue(K keyIn) {
        if (AlfrescoTransactionSupport.getTransactionId() != null) {
            Serializable key = this.getTenantAwareCacheKey(keyIn);
            TransactionData txnData = this.getTransactionData();
            txnData.lockedItemsCache.remove(key);
            return;
        }
    }

    public V get(K keyIn) {
        TransactionData txnData;
        Serializable key = this.getTenantAwareCacheKey(keyIn);
        boolean ignoreSharedCache = false;
        if (AlfrescoTransactionSupport.getTransactionId() != null && !(txnData = this.getTransactionData()).isClosed) {
            if (!txnData.isClearOn && txnData.removedItemsCache.contains(key)) {
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("get returning null - item has been removed from transactional cache: \n   cache: " + this + "\n" + "   key: " + key));
                }
                return null;
            }
            ReadCacheBucket<Object> bucket = (ReadCacheBucket<Object>)txnData.updatedItemsCache.get(key);
            if (bucket != null) {
                Object value = bucket.getValue();
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("Found item in transactional cache: \n   cache: " + this + "\n" + "   key: " + key + "\n" + "   value: " + value));
                }
                return (V)value;
            }
            if (txnData.isClearOn) {
                ignoreSharedCache = true;
            } else if (txnData.noSharedCacheRead) {
                ignoreSharedCache = true;
            } else {
                V value = null;
                value = this.cacheStatsEnabled ? (V)TransactionalCache.getSharedCacheValue(this.sharedCache, key, txnData.stats) : (V)TransactionalCache.getSharedCacheValue(this.sharedCache, key, null);
                bucket = new ReadCacheBucket<Object>(value);
                txnData.updatedItemsCache.put(key, bucket);
                return value;
            }
        }
        if (!ignoreSharedCache) {
            V value = TransactionalCache.getSharedCacheValue(this.sharedCache, key, null);
            if (this.isDebugEnabled) {
                this.logger.debug((Object)("No value found in transaction - fetching instance from shared cache: \n   cache: " + this + "\n" + "   key: " + key + "\n" + "   value: " + value));
            }
            return value;
        }
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("No value found in transaction and ignoring shared cache: \n   cache: " + this + "\n" + "   key: " + key));
        }
        return null;
    }

    public void put(K keyIn, V value) {
        Serializable key = this.getTenantAwareCacheKey(keyIn);
        if (AlfrescoTransactionSupport.getTransactionId() == null) {
            TransactionalCache.putSharedCacheValue(this.sharedCache, key, value, null);
            if (this.isDebugEnabled) {
                this.logger.debug((Object)("No transaction - adding item direct to shared cache: \n   cache: " + this + "\n" + "   key: " + key + "\n" + "   value: " + value));
            }
        } else {
            TransactionData txnData = this.getTransactionData();
            if (txnData.isClosed) {
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("In post-commit add: \n   cache: " + this + "\n" + "   key: " + key + "\n" + "   value: " + value));
                }
            } else if (this.isValueLocked(txnData, key)) {
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("Ignoring put after detecting locked key: \n   cache: " + this + "\n" + "   key: " + key + "\n" + "   value: " + value));
                }
            } else {
                if (txnData.updatedItemsCache.hasHitSize()) {
                    txnData.isClearOn = true;
                    if (!txnData.haveIssuedFullWarning) {
                        if (this.logger.isInfoEnabled()) {
                            Exception e = new Exception("Stack: ");
                            this.logger.info((Object)("Transactional update cache '" + this.name + "' is full (" + this.maxCacheSize + ")."), (Throwable)e);
                        } else if (this.logger.isWarnEnabled()) {
                            this.logger.warn((Object)("Transactional update cache '" + this.name + "' is full (" + this.maxCacheSize + ")."));
                        }
                        txnData.haveIssuedFullWarning = true;
                    }
                }
                ValueHolder existingValueHolder = txnData.noSharedCacheRead ? null : (ValueHolder)this.sharedCache.get(key);
                CacheBucket<V> bucket = null;
                bucket = existingValueHolder == null ? new NewCacheBucket<V>(value) : new UpdateCacheBucket<V>(existingValueHolder, value);
                txnData.updatedItemsCache.put(key, bucket);
                txnData.removedItemsCache.remove(key);
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("In transaction - adding item direct to transactional update cache: \n   cache: " + this + "\n" + "   key: " + key + "\n" + "   value: " + value));
                }
            }
        }
    }

    public void remove(K keyIn) {
        Serializable key = this.getTenantAwareCacheKey(keyIn);
        if (AlfrescoTransactionSupport.getTransactionId() == null) {
            this.sharedCache.remove(key);
            if (this.isDebugEnabled) {
                this.logger.debug((Object)("No transaction - removing item from shared cache: \n   cache: " + this + "\n" + "   key: " + key));
            }
        } else {
            TransactionData txnData = this.getTransactionData();
            if (txnData.isClosed) {
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("In post-commit remove: \n   cache: " + this + "\n" + "   key: " + key));
                }
            } else if (this.isValueLocked(txnData, key)) {
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("Ignoring remove after detecting locked key: \n   cache: " + this + "\n" + "   key: " + key));
                }
            } else {
                if (!txnData.isClearOn) {
                    if (txnData.removedItemsCache.size() >= this.maxCacheSize) {
                        txnData.isClearOn = true;
                        if (!txnData.haveIssuedFullWarning) {
                            if (this.logger.isInfoEnabled()) {
                                Exception e = new Exception("Stack: ");
                                this.logger.info((Object)("Transactional removal cache '" + this.name + "' is full (" + this.maxCacheSize + ")."), (Throwable)e);
                            } else if (this.logger.isWarnEnabled()) {
                                this.logger.warn((Object)("Transactional removal cache '" + this.name + "' is full (" + this.maxCacheSize + ")."));
                            }
                            txnData.haveIssuedFullWarning = true;
                        }
                    } else {
                        txnData.removedItemsCache.add(key);
                    }
                }
                txnData.updatedItemsCache.remove(key);
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("In transaction - adding item direct to transactional removed cache: \n   cache: " + this + "\n" + "   key: " + key));
                }
            }
        }
    }

    public void clear() {
        if (AlfrescoTransactionSupport.getTransactionId() != null) {
            TransactionData txnData;
            if (this.isDebugEnabled) {
                this.logger.debug((Object)("In transaction clearing cache: \n   cache: " + this + "\n" + "   txn: " + AlfrescoTransactionSupport.getTransactionId()));
            }
            if ((txnData = this.getTransactionData()).isClosed) {
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("In post-commit clear: \n   cache: " + this));
                }
            } else {
                txnData.isClearOn = true;
                txnData.updatedItemsCache.clear();
                txnData.removedItemsCache.clear();
            }
        } else {
            if (this.isDebugEnabled) {
                this.logger.debug((Object)"No transaction - clearing shared cache");
            }
            this.sharedCache.clear();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void beforeCompletion() {
    }

    @Override
    public void beforeCommit(boolean readOnly) {
        if (this.isDebugEnabled) {
            this.logger.debug((Object)"Processing before-commit");
        }
        TransactionData txnData = this.getTransactionData();
        try {
            try {
                if (txnData.isClearOn) {
                    long endNanos;
                    long startNanos = this.cacheStatsEnabled ? System.nanoTime() : 0L;
                    this.sharedCache.clear();
                    long l = endNanos = this.cacheStatsEnabled ? System.nanoTime() : 0L;
                    if (this.cacheStatsEnabled) {
                        TransactionStats stats = txnData.stats;
                        stats.record(startNanos, endNanos, TransactionStats.OpType.CLEAR);
                    }
                    if (this.isDebugEnabled) {
                        this.logger.debug((Object)"Clear notification recieved in commit - clearing shared cache");
                    }
                } else {
                    for (Serializable key : txnData.removedItemsCache) {
                        long startNanos = System.nanoTime();
                        this.sharedCache.remove(key);
                        long endNanos = System.nanoTime();
                        TransactionStats stats = txnData.stats;
                        stats.record(startNanos, endNanos, TransactionStats.OpType.REMOVE);
                    }
                    if (this.isDebugEnabled) {
                        this.logger.debug((Object)("Removed " + txnData.removedItemsCache.size() + " values from shared cache in commit"));
                    }
                }
                Set keys = txnData.updatedItemsCache.keySet();
                for (Map.Entry entry : txnData.updatedItemsCache.entrySet()) {
                    Serializable key = (Serializable)entry.getKey();
                    CacheBucket bucket = (CacheBucket)entry.getValue();
                    bucket.doPreCommit(this.sharedCache, key, this.isMutable, this.allowEqualsChecks, txnData.isReadOnly);
                }
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("Pre-commit called for " + keys.size() + " values."));
                }
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException("Failed to transfer updates to shared cache", e);
            }
        }
        finally {
            txnData.isClosed = true;
        }
    }

    @Override
    public void afterCommit() {
        if (this.isDebugEnabled) {
            this.logger.debug((Object)"Processing after-commit");
        }
        TransactionData txnData = this.getTransactionData();
        try {
            try {
                if (txnData.isClearOn) {
                    long endNanos;
                    long startNanos = this.cacheStatsEnabled ? System.nanoTime() : 0L;
                    this.sharedCache.clear();
                    long l = endNanos = this.cacheStatsEnabled ? System.nanoTime() : 0L;
                    if (this.cacheStatsEnabled) {
                        TransactionStats stats = txnData.stats;
                        stats.record(startNanos, endNanos, TransactionStats.OpType.CLEAR);
                    }
                    if (this.isDebugEnabled) {
                        this.logger.debug((Object)"Clear notification recieved in commit - clearing shared cache");
                    }
                } else {
                    for (Serializable key : txnData.removedItemsCache) {
                        long startNanos = System.nanoTime();
                        this.sharedCache.remove(key);
                        long endNanos = System.nanoTime();
                        TransactionStats stats = txnData.stats;
                        stats.record(startNanos, endNanos, TransactionStats.OpType.REMOVE);
                    }
                    if (this.isDebugEnabled) {
                        this.logger.debug((Object)("Removed " + txnData.removedItemsCache.size() + " values from shared cache in commit"));
                    }
                }
                Set keys = txnData.updatedItemsCache.keySet();
                for (Map.Entry entry : txnData.updatedItemsCache.entrySet()) {
                    Serializable key = (Serializable)entry.getKey();
                    CacheBucket bucket = (CacheBucket)entry.getValue();
                    try {
                        bucket.doPostCommit(this.sharedCache, key, this.isMutable, this.allowEqualsChecks, txnData.isReadOnly, txnData.stats);
                    }
                    catch (Exception e) {
                        throw new AlfrescoRuntimeException("CacheBucket postCommit transfer to shared cache failed: \n   Cache:      " + this.sharedCache + "\n" + "   Key:        " + key + "\n" + "   New Value:  " + bucket.getValue() + "\n" + "   Cache Value:" + this.sharedCache.get(key), (Throwable)e);
                    }
                }
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("Post-commit called for " + keys.size() + " values."));
                }
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException("Failed to transfer updates to shared cache", e);
            }
        }
        finally {
            this.removeCaches(txnData);
            if (this.cacheStatsEnabled) {
                this.cacheStats.add(this.name, txnData.stats);
            }
        }
    }

    @Override
    public void afterRollback() {
        TransactionData txnData = this.getTransactionData();
        try {
            try {
                if (txnData.isClearOn) {
                    long endNanos;
                    long startNanos = this.cacheStatsEnabled ? System.nanoTime() : 0L;
                    this.sharedCache.clear();
                    long l = endNanos = this.cacheStatsEnabled ? System.nanoTime() : 0L;
                    if (this.cacheStatsEnabled) {
                        TransactionStats stats = txnData.stats;
                        stats.record(startNanos, endNanos, TransactionStats.OpType.CLEAR);
                    }
                    if (this.isDebugEnabled) {
                        this.logger.debug((Object)"Clear notification recieved in rollback - clearing shared cache");
                    }
                } else {
                    for (Serializable key : txnData.removedItemsCache) {
                        long startNanos = System.nanoTime();
                        this.sharedCache.remove(key);
                        long endNanos = System.nanoTime();
                        TransactionStats stats = txnData.stats;
                        stats.record(startNanos, endNanos, TransactionStats.OpType.REMOVE);
                    }
                    if (this.isDebugEnabled) {
                        this.logger.debug((Object)("Removed " + txnData.removedItemsCache.size() + " values from shared cache in rollback"));
                    }
                }
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException("Failed to transfer updates to shared cache", e);
            }
        }
        finally {
            this.removeCaches(txnData);
            if (this.cacheStatsEnabled) {
                this.cacheStats.add(this.name, txnData.stats);
            }
        }
    }

    private void removeCaches(TransactionData txnData) {
        txnData.isClosed = true;
    }

    private Serializable getTenantAwareCacheKey(K key) {
        String tenantDomain;
        if (this.isTenantAware && !(tenantDomain = TenantUtil.getCurrentDomain()).equals("")) {
            return new CacheRegionKey(tenantDomain, (Serializable)key);
        }
        return key;
    }

    private static interface CacheBucket<BV>
    extends Serializable {
        public BV getValue();

        public void doPreCommit(SimpleCache<Serializable, ValueHolder<BV>> var1, Serializable var2, boolean var3, boolean var4, boolean var5);

        public void doPostCommit(SimpleCache<Serializable, ValueHolder<BV>> var1, Serializable var2, boolean var3, boolean var4, boolean var5, TransactionStats var6);
    }

    public static class CacheRegionKey
    implements Serializable {
        private static final long serialVersionUID = -213050301938804468L;
        private final String cacheRegion;
        private final Serializable cacheKey;
        private final int hashCode;

        public CacheRegionKey(String cacheRegion, Serializable cacheKey) {
            this.cacheRegion = cacheRegion;
            this.cacheKey = cacheKey;
            this.hashCode = cacheRegion.hashCode() + cacheKey.hashCode();
        }

        public Serializable getCacheKey() {
            return this.cacheKey;
        }

        public String getCacheRegion() {
            return this.cacheRegion;
        }

        public String toString() {
            return String.valueOf(this.cacheRegion) + (this.cacheRegion != "" ? "." : "") + this.cacheKey.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheRegionKey)) {
                return false;
            }
            CacheRegionKey that = (CacheRegionKey)obj;
            return this.cacheRegion.equals(that.cacheRegion) && this.cacheKey.equals(that.cacheKey);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private class LRULinkedHashMap<K1, V1>
    extends LinkedHashMap<K1, V1> {
        private static final long serialVersionUID = -4874684348174271106L;

        private LRULinkedHashMap(int initialSize) {
            super(initialSize);
        }

        private boolean hasHitSize() {
            return this.size() >= TransactionalCache.this.maxCacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K1, V1> eldest) {
            return this.size() > TransactionalCache.this.maxCacheSize;
        }
    }

    private static class NewCacheBucket<BV>
    implements CacheBucket<BV> {
        private static final long serialVersionUID = -8536386687213957425L;
        private final BV value;

        public NewCacheBucket(BV value) {
            this.value = value;
        }

        @Override
        public BV getValue() {
            return this.value;
        }

        @Override
        public void doPreCommit(SimpleCache<Serializable, ValueHolder<BV>> sharedCache, Serializable key, boolean mutable, boolean allowEqualsCheck, boolean readOnly) {
        }

        @Override
        public void doPostCommit(SimpleCache<Serializable, ValueHolder<BV>> sharedCache, Serializable key, boolean mutable, boolean allowEqualsCheck, boolean readOnly, TransactionStats stats) {
            ValueHolder sharedObjValueHolder = (ValueHolder)sharedCache.get(key);
            if (sharedObjValueHolder == null) {
                TransactionalCache.putSharedCacheValue(sharedCache, key, this.value, stats);
            } else if (!(!mutable || allowEqualsCheck && EqualsHelper.nullSafeEquals(this.value, sharedObjValueHolder.getValue()))) {
                sharedCache.remove(key);
            }
        }
    }

    private static class ReadCacheBucket<BV>
    implements CacheBucket<BV> {
        private static final long serialVersionUID = 7885689778259779578L;
        private final BV value;

        public ReadCacheBucket(BV value) {
            this.value = value;
        }

        @Override
        public BV getValue() {
            return this.value;
        }

        @Override
        public void doPreCommit(SimpleCache<Serializable, ValueHolder<BV>> sharedCache, Serializable key, boolean mutable, boolean allowEqualsCheck, boolean readOnly) {
        }

        @Override
        public void doPostCommit(SimpleCache<Serializable, ValueHolder<BV>> sharedCache, Serializable key, boolean mutable, boolean allowEqualsCheck, boolean readOnly, TransactionStats stats) {
        }
    }

    private class TransactionData {
        private LRULinkedHashMap<Serializable, CacheBucket<V>> updatedItemsCache;
        private Set<Serializable> removedItemsCache;
        private Set<Serializable> lockedItemsCache;
        private boolean haveIssuedFullWarning;
        private boolean isClearOn;
        private boolean isClosed;
        private boolean isReadOnly;
        private boolean noSharedCacheRead;
        private TransactionStats stats;

        private TransactionData() {
        }
    }

    private static class UpdateCacheBucket<BV>
    implements CacheBucket<BV> {
        private static final long serialVersionUID = 7885689778259779578L;
        private final BV value;
        private final ValueHolder<BV> originalValueHolder;

        public UpdateCacheBucket(ValueHolder<BV> originalValueHolder, BV value) {
            this.originalValueHolder = originalValueHolder;
            this.value = value;
        }

        @Override
        public BV getValue() {
            return this.value;
        }

        @Override
        public void doPreCommit(SimpleCache<Serializable, ValueHolder<BV>> sharedCache, Serializable key, boolean mutable, boolean allowEqualsCheck, boolean readOnly) {
        }

        @Override
        public void doPostCommit(SimpleCache<Serializable, ValueHolder<BV>> sharedCache, Serializable key, boolean mutable, boolean allowEqualsCheck, boolean readOnly, TransactionStats stats) {
            ValueHolder sharedObjValueHolder = (ValueHolder)sharedCache.get(key);
            if (sharedObjValueHolder == null) {
                if (!mutable) {
                    TransactionalCache.putSharedCacheValue(sharedCache, key, this.value, stats);
                }
            } else if (!(!mutable || allowEqualsCheck && EqualsHelper.nullSafeEquals(this.value, sharedObjValueHolder.getValue()))) {
                if (EqualsHelper.nullSafeEquals(this.originalValueHolder, (Object)sharedObjValueHolder)) {
                    TransactionalCache.putSharedCacheValue(sharedCache, key, this.value, stats);
                } else {
                    sharedCache.remove(key);
                }
            }
        }
    }

    public static final class ValueHolder<V2>
    implements Serializable {
        private static final long serialVersionUID = -3462098329153772713L;
        private final int rand = (int)(Math.random() * 2.147483647E9);
        private final V2 value;

        private ValueHolder(V2 value) {
            this.value = value;
        }

        public final V2 getValue() {
            return this.value;
        }

        public final int hashCode() {
            return this.rand;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValueHolder other = (ValueHolder)obj;
            return this.rand == other.rand;
        }

        public final String toString() {
            return "ValueHolder [value=" + this.value + "]";
        }
    }
}

