/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.directurl;

import org.alfresco.repo.content.directurl.DirectUrlConfig;
import org.alfresco.repo.content.directurl.InvalidDirectAccessUrlConfigException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SystemWideDirectUrlConfig
implements DirectUrlConfig {
    private static final Log logger = LogFactory.getLog(SystemWideDirectUrlConfig.class);
    private Boolean enabled;
    private Long defaultExpiryTimeInSec;
    private Long maxExpiryTimeInSec;

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setDefaultExpiryTimeInSec(Long defaultExpiryTimeInSec) {
        this.defaultExpiryTimeInSec = defaultExpiryTimeInSec;
    }

    public void setMaxExpiryTimeInSec(Long maxExpiryTimeInSec) {
        this.maxExpiryTimeInSec = maxExpiryTimeInSec;
    }

    @Override
    public Boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Long getDefaultExpiryTimeInSec() {
        return this.defaultExpiryTimeInSec;
    }

    public Long getMaxExpiryTimeInSec() {
        return this.maxExpiryTimeInSec;
    }

    public void init() {
        this.validate();
    }

    @Override
    public void validate() {
        try {
            this.validateSystemDirectAccessUrlConfig();
        }
        catch (InvalidDirectAccessUrlConfigException ex) {
            logger.error((Object)("Disabling system-wide direct access URLs due to configuration error: " + ex.getMessage()));
            this.setEnabled(false);
        }
        logger.info((Object)("System-wide direct access URLs are " + (this.isEnabled() != false ? "enabled" : "disabled")));
    }

    private void validateSystemDirectAccessUrlConfig() throws InvalidDirectAccessUrlConfigException {
        if (this.isEnabled().booleanValue()) {
            if (this.getDefaultExpiryTimeInSec() == null || this.getDefaultExpiryTimeInSec() < 1L) {
                throw new InvalidDirectAccessUrlConfigException("System-wide direct access URL default expiry time is missing or invalid.");
            }
            if (this.getMaxExpiryTimeInSec() == null || this.getMaxExpiryTimeInSec() < 1L) {
                throw new InvalidDirectAccessUrlConfigException("System-wide direct access URL maximum expiry time is missing or invalid.");
            }
            if (this.getDefaultExpiryTimeInSec() > this.getMaxExpiryTimeInSec()) {
                String errorMsg = String.format("System-wide direct access URL default expiry time [%s] exceeds maximum expiry time [%s].", this.getDefaultExpiryTimeInSec(), this.getMaxExpiryTimeInSec());
                throw new InvalidDirectAccessUrlConfigException(errorMsg);
            }
        }
    }
}

