/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr.facet.facetsresponse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.GenericBucket;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.GenericFacetResponse;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.Metric;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.SimpleMetric;
import org.alfresco.service.cmr.search.RangeParameters;

public class RangeResultMapper {
    public static List<GenericFacetResponse> getGenericFacetsForRanges(Map<String, List<Map<String, String>>> facetFields, List<RangeParameters> ranges) {
        ArrayList<GenericFacetResponse> ffcs = new ArrayList<GenericFacetResponse>(facetFields.size());
        if (facetFields != null && !facetFields.isEmpty() && ranges != null) {
            for (Map.Entry<String, List<Map<String, String>>> facet : facetFields.entrySet()) {
                ArrayList<GenericBucket> buckets = new ArrayList<GenericBucket>();
                facet.getValue().forEach(action -> {
                    boolean bl = buckets.add(RangeResultMapper.buildGenericBucketFromRange((String)facet.getKey(), action, ranges));
                });
                ffcs.add(new GenericFacetResponse(GenericFacetResponse.FACET_TYPE.range, facet.getKey(), buckets));
            }
        }
        return ffcs;
    }

    public static GenericBucket buildGenericBucketFromRange(String facetField, Map<String, String> facet, List<RangeParameters> ranges) {
        String start = facet.get("start");
        String end = facet.get("end");
        boolean startInclusive = true;
        boolean endInclusive = false;
        String startFilterQuery = "[";
        String endFilterQuery = ">";
        StringBuilder filterQ = new StringBuilder();
        switch (facet.get("bucketPosition")) {
            case "head": {
                for (RangeParameters range : ranges) {
                    if (!range.getField().equalsIgnoreCase(facetField)) continue;
                    startFilterQuery = range.getRangeFirstBucketStartInclusive();
                    endFilterQuery = range.getRangeFirstBucketEndInclusive();
                    startInclusive = RangeResultMapper.checkInclusive(startFilterQuery);
                    endInclusive = RangeResultMapper.checkInclusive(endFilterQuery);
                }
                break;
            }
            case "tail": {
                for (RangeParameters range : ranges) {
                    if (!range.getField().equalsIgnoreCase(facetField)) continue;
                    startFilterQuery = range.getRangeBucketStartInclusive();
                    endFilterQuery = range.getRangeLastBucketEndInclusive();
                    startInclusive = RangeResultMapper.checkInclusive(startFilterQuery);
                    endInclusive = RangeResultMapper.checkInclusive(endFilterQuery);
                }
                break;
            }
            default: {
                for (RangeParameters range : ranges) {
                    List includes;
                    if (!range.getField().equalsIgnoreCase(facetField) || (includes = range.getInclude()) == null || includes.isEmpty()) continue;
                    startFilterQuery = range.getRangeBucketStartInclusive();
                    endFilterQuery = range.getRangeBucketEndInclusive();
                    startInclusive = RangeResultMapper.checkInclusive(startFilterQuery);
                    endInclusive = RangeResultMapper.checkInclusive(endFilterQuery);
                }
            }
        }
        facet.put("startInclusive".toString(), Boolean.toString(startInclusive));
        facet.put("endInclusive".toString(), Boolean.toString(endInclusive));
        facet.remove("label");
        filterQ.append(facetField).append(":").append(startFilterQuery).append("\"").append(start).append("\"").append(" TO ").append("\"").append(end).append("\"").append(endFilterQuery);
        HashSet<Metric> metrics = new HashSet<Metric>(Arrays.asList(new SimpleMetric(Metric.METRIC_TYPE.count, facet.get("count"))));
        facet.remove("count");
        StringBuilder label = new StringBuilder();
        label.append(startInclusive ? "[" : "(").append(start).append(" - ").append(end).append(endInclusive ? "]" : ")");
        facet.remove("bucketPosition");
        return new GenericBucket(label.toString(), filterQ.toString(), null, metrics, null, facet);
    }

    private static boolean checkInclusive(String input) {
        return input.equalsIgnoreCase("[") || input.equalsIgnoreCase("]");
    }
}

