/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice.authentication;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.alfresco.util.PropertyCheck;

public class AdditionalHeadersHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private final Map<String, String> additionalHeaders;
    private final HttpServletRequest wrappedRequest;

    public AdditionalHeadersHttpServletRequestWrapper(Map<String, String> additionalHeaders, HttpServletRequest request) {
        super(request);
        PropertyCheck.mandatory((Object)((Object)this), (String)"additionalHeaders", additionalHeaders);
        this.additionalHeaders = additionalHeaders;
        this.wrappedRequest = request;
    }

    public Enumeration<String> getHeaderNames() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration originalHeaders = this.wrappedRequest.getHeaderNames();
        if (originalHeaders != null) {
            while (originalHeaders.hasMoreElements()) {
                String header = (String)originalHeaders.nextElement();
                if (this.additionalHeaders.containsKey(header)) continue;
                result.add(header);
            }
        }
        result.addAll(this.additionalHeaders.keySet());
        return Collections.enumeration(result);
    }

    public String getHeader(String name) {
        return this.additionalHeaders.getOrDefault(name, super.getHeader(name));
    }

    public Enumeration<String> getHeaders(String name) {
        return Collections.enumeration(Arrays.asList(this.additionalHeaders.getOrDefault(name, super.getHeader(name))));
    }
}

