/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.util;

import java.util.Objects;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.transaction.TransactionListener;
import org.alfresco.util.transaction.TransactionListenerAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PostTxnCallbackScheduler {
    private static Log logger = LogFactory.getLog(PostTxnCallbackScheduler.class);
    private TransactionService transactionService;

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void scheduleRendition(RetryingTransactionHelper.RetryingTransactionCallback callback, String uniqueId) {
        AlfrescoTransactionSupport.bindListener((TransactionListener)new PostTxTransactionListener(callback, uniqueId));
    }

    private class PostTxTransactionListener
    extends TransactionListenerAdapter {
        private final RetryingTransactionHelper.RetryingTransactionCallback callback;
        private final String id;

        PostTxTransactionListener(RetryingTransactionHelper.RetryingTransactionCallback callback, String uniqueId) {
            this.callback = callback;
            this.id = uniqueId;
            logger.debug((Object)("Created lister with id = " + this.id));
        }

        public void afterCommit() {
            try {
                PostTxnCallbackScheduler.this.transactionService.getRetryingTransactionHelper().doInTransaction(this.callback);
            }
            catch (Exception e) {
                logger.debug((Object)("The after commit callback " + this.id + " failed to execute: " + e.getMessage()));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            PostTxTransactionListener that = (PostTxTransactionListener)((Object)o);
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

