/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.traitextender;

import org.alfresco.traitextender.ExtensionPoint;
import org.alfresco.traitextender.InvalidExtension;
import org.alfresco.traitextender.RegistryExtensionBundle;
import org.alfresco.traitextender.SingletonExtensionFactory;
import org.alfresco.traitextender.SpringBeanExtension;
import org.alfresco.traitextender.Trait;

public class SpringExtensionPoint {
    private String trait;
    private String extension;

    public void setTrait(String trait) {
        this.trait = trait;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void register(RegistryExtensionBundle bundle, SpringBeanExtension<?, ?> extensionBean) throws InvalidExtension {
        try {
            Class<?> extensionAPI = Class.forName(this.extension);
            Class<?> traitAPI = Class.forName(this.trait);
            if (!Trait.class.isAssignableFrom(traitAPI)) {
                throw new InvalidExtension("Non " + Trait.class + " spring extension point : " + traitAPI);
            }
            if (!extensionBean.acceptsTraitClass(traitAPI)) {
                throw new InvalidExtension("Unsupported trait class : " + traitAPI + " in extension point targeting " + extensionBean);
            }
            bundle.register(new ExtensionPoint(extensionAPI, traitAPI), new SingletonExtensionFactory(extensionBean, extensionAPI));
        }
        catch (InvalidExtension error) {
            throw error;
        }
        catch (ClassNotFoundException error) {
            throw new InvalidExtension("Extension point definition class not found.", error);
        }
    }
}

