/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr.facet.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.repo.search.impl.solr.facet.FacetQueryProvider;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetConfigException;
import org.alfresco.repo.search.impl.solr.facet.handler.AbstractFacetLabelDisplayHandler;
import org.alfresco.repo.search.impl.solr.facet.handler.FacetLabel;
import org.springframework.extensions.surf.util.ParameterCheck;

public class DateBucketsDisplayHandler
extends AbstractFacetLabelDisplayHandler
implements FacetQueryProvider {
    private static final Pattern DATE_RANGE_PATTERN = Pattern.compile("(\\[\\w+\\S+\\sTO\\s(\\w+\\S+)\\])");
    private final Map<String, FacetLabel> facetLabelMap;
    private final Map<String, List<String>> facetQueriesMap;

    public DateBucketsDisplayHandler(Set<String> facetQueryFields, Map<String, String> dateBucketsMap) {
        ParameterCheck.mandatory((String)"facetQueryFields", facetQueryFields);
        ParameterCheck.mandatory((String)"dateBucketsMap", dateBucketsMap);
        this.supportedFieldFacets = facetQueryFields;
        this.facetLabelMap = new HashMap<String, FacetLabel>(dateBucketsMap.size());
        LinkedHashMap facetQueries = new LinkedHashMap(facetQueryFields.size());
        for (String facetQueryField : facetQueryFields) {
            ArrayList<String> queries = new ArrayList<String>();
            int index = 0;
            for (Map.Entry<String, String> bucket : dateBucketsMap.entrySet()) {
                String dateRange = bucket.getKey().trim();
                Matcher matcher = DATE_RANGE_PATTERN.matcher(dateRange);
                if (!matcher.find()) {
                    throw new SolrFacetConfigException("Invalid date range. Example of a valid date range is: '[NOW/DAY-1DAY TO NOW/DAY+1DAY]'");
                }
                String facetQuery = String.valueOf(facetQueryField) + ':' + dateRange;
                queries.add(facetQuery);
                String dateRangeQuery = dateRange.substring(1, dateRange.length() - 1);
                dateRangeQuery = dateRangeQuery.replaceFirst("\\sTO\\s", "\"..\"");
                this.facetLabelMap.put(facetQuery, new FacetLabel(dateRangeQuery, bucket.getValue(), index++));
            }
            facetQueries.put(facetQueryField, queries);
        }
        this.facetQueriesMap = Collections.unmodifiableMap(facetQueries);
    }

    @Override
    public FacetLabel getDisplayLabel(String value) {
        FacetLabel facetLabel = this.facetLabelMap.get(value);
        return facetLabel == null ? new FacetLabel(value, value, -1) : facetLabel;
    }

    @Override
    public Map<String, List<String>> getFacetQueries() {
        return this.facetQueriesMap;
    }
}

