/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions;

import java.util.Collection;
import org.alfresco.repo.security.permissions.ProxyFactoryUtils;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.support.DefaultIntroductionAdvisor;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;

public interface PermissionCheckCollection<T> {
    public int getTargetResultCount();

    public long getCutOffAfterTimeMs();

    public int getCutOffAfterCount();

    public static class PermissionCheckCollectionMixin<T>
    extends DelegatingIntroductionInterceptor
    implements PermissionCheckCollection<T> {
        private final int targetResultCount;
        private final long cutOffAfterTimeMs;
        private final int cutOffAfterCount;

        private PermissionCheckCollectionMixin(int targetResultCount, long cutOffAfterTimeMs, int cutOffAfterCount) {
            this.targetResultCount = targetResultCount;
            this.cutOffAfterTimeMs = cutOffAfterTimeMs;
            this.cutOffAfterCount = cutOffAfterCount;
            if (cutOffAfterTimeMs <= 0L) {
                cutOffAfterTimeMs = 0L;
            }
            if (cutOffAfterCount <= 0) {
                cutOffAfterCount = 0;
            }
        }

        @Override
        public int getTargetResultCount() {
            return this.targetResultCount;
        }

        @Override
        public long getCutOffAfterTimeMs() {
            return this.cutOffAfterTimeMs;
        }

        @Override
        public int getCutOffAfterCount() {
            return this.cutOffAfterCount;
        }

        public static <TT> Collection<TT> create(Collection<TT> collection, int targetResultCount, long cutOffAfterTimeMs, int cutOffAfterCount) {
            if (targetResultCount <= 0) {
                targetResultCount = collection.size();
            }
            PermissionCheckCollectionMixin mixin = new PermissionCheckCollectionMixin(targetResultCount, cutOffAfterTimeMs, cutOffAfterCount);
            DefaultIntroductionAdvisor advisor = new DefaultIntroductionAdvisor(mixin, PermissionCheckCollection.class);
            return (Collection)ProxyFactoryUtils.createProxy(collection, (IntroductionAdvisor)advisor);
        }
    }
}

