/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.ParameterizedItemDefinitionImpl;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.namespace.QName;

public abstract class BaseParameterizedItemDefinitionImplTest
extends TestCase {
    protected static final String NAME = "name";
    protected static final String TITLE = "title";
    protected static final String DESCRIPTION = "description";
    protected List<ParameterDefinition> paramDefs = new ArrayList<ParameterDefinition>();
    protected List<ParameterDefinition> duplicateParamDefs = new ArrayList<ParameterDefinition>();
    private static final String PARAM1_DISPLAYNAME = "param1-displayname";
    private static final String PARAM1_NAME = "param1-name";
    private static final QName PARAM1_TYPE = DataTypeDefinition.TEXT;
    private static final QName PARAM2_TYPE = DataTypeDefinition.TEXT;
    private static final String PARAM2_DISPLAYNAME = "param2-displaname";
    private static final String PARAM2_NAME = "param2-name";

    protected void setUp() throws Exception {
        this.paramDefs.add((ParameterDefinition)new ParameterDefinitionImpl(PARAM1_NAME, PARAM1_TYPE, false, PARAM1_DISPLAYNAME));
        this.paramDefs.add((ParameterDefinition)new ParameterDefinitionImpl(PARAM2_NAME, PARAM2_TYPE, false, PARAM2_DISPLAYNAME));
        this.duplicateParamDefs.add((ParameterDefinition)new ParameterDefinitionImpl(PARAM1_NAME, PARAM1_TYPE, false, PARAM1_DISPLAYNAME));
        this.duplicateParamDefs.add((ParameterDefinition)new ParameterDefinitionImpl(PARAM1_NAME, PARAM1_TYPE, false, PARAM1_DISPLAYNAME));
    }

    public void testConstructor() {
        this.create();
    }

    protected abstract ParameterizedItemDefinitionImpl create();

    public void testGetName() {
        ParameterizedItemDefinitionImpl temp = this.create();
        BaseParameterizedItemDefinitionImplTest.assertEquals((String)NAME, (String)temp.getName());
    }

    public void testGetParameterDefintions() {
        ParameterizedItemDefinitionImpl temp = this.create();
        List params = temp.getParameterDefinitions();
        BaseParameterizedItemDefinitionImplTest.assertNotNull((Object)params);
        BaseParameterizedItemDefinitionImplTest.assertEquals((int)2, (int)params.size());
        int i = 0;
        for (ParameterDefinition definition : params) {
            if (i == 0) {
                BaseParameterizedItemDefinitionImplTest.assertEquals((String)PARAM1_NAME, (String)definition.getName());
                BaseParameterizedItemDefinitionImplTest.assertEquals((Object)PARAM1_TYPE, (Object)definition.getType());
                BaseParameterizedItemDefinitionImplTest.assertEquals((String)PARAM1_DISPLAYNAME, (String)definition.getDisplayLabel());
            } else {
                BaseParameterizedItemDefinitionImplTest.assertEquals((String)PARAM2_NAME, (String)definition.getName());
                BaseParameterizedItemDefinitionImplTest.assertEquals((Object)PARAM2_TYPE, (Object)definition.getType());
                BaseParameterizedItemDefinitionImplTest.assertEquals((String)PARAM2_DISPLAYNAME, (String)definition.getDisplayLabel());
            }
            ++i;
        }
    }

    public void testGetParameterDefinition() {
        ParameterizedItemDefinitionImpl temp = this.create();
        ParameterDefinition definition = temp.getParameterDefintion(PARAM1_NAME);
        BaseParameterizedItemDefinitionImplTest.assertNotNull((Object)definition);
        BaseParameterizedItemDefinitionImplTest.assertEquals((String)PARAM1_NAME, (String)definition.getName());
        BaseParameterizedItemDefinitionImplTest.assertEquals((Object)PARAM1_TYPE, (Object)definition.getType());
        BaseParameterizedItemDefinitionImplTest.assertEquals((String)PARAM1_DISPLAYNAME, (String)definition.getDisplayLabel());
        ParameterDefinition nullDef = temp.getParameterDefintion("bobbins");
        BaseParameterizedItemDefinitionImplTest.assertNull((Object)nullDef);
    }
}

