/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.domain.dialect.MySQLInnoDBDialect;
import org.alfresco.util.schemacomp.ComparisonUtils;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.RedundantDbObject;
import org.alfresco.util.schemacomp.ValidatingVisitor;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.Index;
import org.alfresco.util.schemacomp.model.Schema;
import org.alfresco.util.schemacomp.model.Table;
import org.alfresco.util.schemacomp.validator.DbValidator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ValidatingVisitorTest {
    private DiffContext ctx;
    private ValidatingVisitor visitor;
    private Table refTable;
    private Table targetTable;
    private Schema refSchema;
    private Schema targetSchema;
    private Index refIndex;
    private Index targetIndex1;
    private Index targetIndex2;
    private Index targetIndex3;
    private List<DbValidator> validators;
    private ComparisonUtils comparisonUtils;

    @Before
    public void setUp() throws Exception {
        this.refTable = new Table("reference_table");
        this.refIndex = new Index(this.refTable, "index_name", Arrays.asList("a", "b", "c"));
        this.ctx = new DiffContext((Dialect)new MySQLInnoDBDialect(), this.refSchema, this.targetSchema);
        this.visitor = new ValidatingVisitor(this.ctx);
        this.validators = new ArrayList<DbValidator>();
        this.validators.add((DbValidator)Mockito.mock(DbValidator.class));
        this.validators.add((DbValidator)Mockito.mock(DbValidator.class));
        this.refIndex.setValidators(this.validators);
        this.targetTable = new Table("target_table");
        this.targetIndex1 = new Index(this.targetTable, "index_name", Arrays.asList("a", "b", "c"));
        this.targetIndex2 = new Index(this.targetTable, "another_index", Arrays.asList("a", "b", "c"));
        this.targetIndex3 = new Index(this.targetTable, "index_name", Arrays.asList("e", "f"));
        this.comparisonUtils = (ComparisonUtils)Mockito.mock(ComparisonUtils.class);
        this.visitor.setComparisonUtils(this.comparisonUtils);
    }

    @Test
    public void canValidate() {
        Mockito.when((Object)this.comparisonUtils.findEquivalentObjects((DbObject)this.refSchema, (DbObject)this.refIndex)).thenReturn(Arrays.asList(this.targetIndex1, this.targetIndex2, this.targetIndex3));
        this.visitor.visit((DbObject)this.refIndex);
        ((DbValidator)Mockito.verify((Object)this.validators.get(0))).validate((DbObject)this.refIndex, (DbObject)this.targetIndex1, this.ctx);
        ((DbValidator)Mockito.verify((Object)this.validators.get(0))).validate((DbObject)this.refIndex, (DbObject)this.targetIndex2, this.ctx);
        ((DbValidator)Mockito.verify((Object)this.validators.get(0))).validate((DbObject)this.refIndex, (DbObject)this.targetIndex3, this.ctx);
        ((DbValidator)Mockito.verify((Object)this.validators.get(1))).validate((DbObject)this.refIndex, (DbObject)this.targetIndex1, this.ctx);
        ((DbValidator)Mockito.verify((Object)this.validators.get(1))).validate((DbObject)this.refIndex, (DbObject)this.targetIndex2, this.ctx);
        ((DbValidator)Mockito.verify((Object)this.validators.get(1))).validate((DbObject)this.refIndex, (DbObject)this.targetIndex3, this.ctx);
    }

    @Test
    public void redundantDbObjectsAreNoticed() {
        Mockito.when((Object)this.comparisonUtils.findEquivalentObjects((DbObject)this.refSchema, (DbObject)this.refIndex)).thenReturn(Arrays.asList(this.targetIndex1, this.targetIndex2, this.targetIndex3));
        this.visitor.visit((DbObject)this.refIndex);
        Assert.assertEquals((long)1L, (long)this.ctx.getComparisonResults().size());
        Assert.assertEquals(RedundantDbObject.class, this.ctx.getComparisonResults().get(0).getClass());
    }

    @Test
    public void nonRedundantDbObjectsAreNoticed() {
        Mockito.when((Object)this.comparisonUtils.findEquivalentObjects((DbObject)this.refSchema, (DbObject)this.refIndex)).thenReturn(Arrays.asList(this.targetIndex1));
        this.visitor.visit((DbObject)this.refIndex);
        Assert.assertEquals((long)0L, (long)this.ctx.getComparisonResults().size());
    }
}

