/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.server.handler;

import org.alfresco.email.server.handler.AbstractForumEmailMessageHandler;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ForumModel;
import org.alfresco.service.cmr.email.EmailMessage;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class TopicEmailMessageHandler
extends AbstractForumEmailMessageHandler {
    @Override
    public void processMessage(NodeRef nodeRef, EmailMessage message) {
        QName nodeTypeQName = this.getNodeService().getType(nodeRef);
        NodeRef topicNode = null;
        if (this.getDictionaryService().isSubClass(nodeTypeQName, ForumModel.TYPE_TOPIC)) {
            topicNode = nodeRef;
        } else if (this.getDictionaryService().isSubClass(nodeTypeQName, ForumModel.TYPE_POST)) {
            topicNode = this.getNodeService().getPrimaryParent(nodeRef).getParentRef();
            if (topicNode == null) {
                throw new AlfrescoRuntimeException("A POST node has no primary parent: " + nodeRef);
            }
        } else {
            throw new AlfrescoRuntimeException("\nMessage handler " + this.getClass().getName() + " cannot handle type " + nodeTypeQName + ".\n" + "Check the message handler mappings.");
        }
        this.addPostNode(topicNode, message);
    }
}

