/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.contentdata;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.alfresco.repo.domain.contentdata.EncryptedKey;
import org.alfresco.service.cmr.repository.ContentUrlKey;
import org.apache.commons.codec.DecoderException;

public class ContentUrlKeyEntity
implements Serializable {
    private static final long serialVersionUID = -6594309522849585169L;
    private Long id;
    private Long contentUrlId;
    private byte[] encryptedKeyAsBytes;
    private Integer keySize;
    private String algorithm;
    private String masterKeystoreId;
    private String masterKeyAlias;
    private Long unencryptedFileSize;

    public ContentUrlKey getContentUrlKey() throws DecoderException {
        ContentUrlKey contentUrlKey = new ContentUrlKey();
        contentUrlKey.setAlgorithm(this.algorithm);
        contentUrlKey.setKeySize(this.keySize);
        contentUrlKey.setEncryptedKeyBytes(ByteBuffer.wrap(this.encryptedKeyAsBytes));
        contentUrlKey.setMasterKeyAlias(this.masterKeyAlias);
        contentUrlKey.setMasterKeystoreId(this.masterKeystoreId);
        contentUrlKey.setUnencryptedFileSize(this.unencryptedFileSize);
        return contentUrlKey;
    }

    public Long getContentUrlId() {
        return this.contentUrlId;
    }

    public void setContentUrlId(Long contentUrlId) {
        this.contentUrlId = contentUrlId;
    }

    public void setEncryptedKeyAsBytes(byte[] encryptedKeyAsBytes) {
        this.encryptedKeyAsBytes = encryptedKeyAsBytes;
    }

    public byte[] getEncryptedKeyAsBytes() {
        return this.encryptedKeyAsBytes;
    }

    public void setEncryptedKey(EncryptedKey encryptedKey) {
        byte[] encryptedKeyAsBytes = new byte[encryptedKey.getByteBuffer().remaining()];
        encryptedKey.getByteBuffer().get(encryptedKeyAsBytes);
        this.encryptedKeyAsBytes = encryptedKeyAsBytes;
        this.keySize = encryptedKeyAsBytes.length * 8;
        this.algorithm = encryptedKey.getAlgorithm();
        this.masterKeyAlias = encryptedKey.getMasterKeyAlias();
        this.masterKeystoreId = encryptedKey.getMasterKeystoreId();
    }

    public static ContentUrlKeyEntity setEncryptedKey(ContentUrlKeyEntity existing, EncryptedKey encryptedKey) {
        ContentUrlKeyEntity newContentUrlKeyEntity = new ContentUrlKeyEntity();
        byte[] encryptedKeyAsBytes = new byte[encryptedKey.getByteBuffer().remaining()];
        encryptedKey.getByteBuffer().get(encryptedKeyAsBytes);
        newContentUrlKeyEntity.setEncryptedKeyAsBytes(encryptedKeyAsBytes);
        newContentUrlKeyEntity.setKeySize(encryptedKeyAsBytes.length * 8);
        newContentUrlKeyEntity.setAlgorithm(encryptedKey.getAlgorithm());
        newContentUrlKeyEntity.setMasterKeyAlias(encryptedKey.getMasterKeyAlias());
        newContentUrlKeyEntity.setMasterKeystoreId(encryptedKey.getMasterKeystoreId());
        newContentUrlKeyEntity.setContentUrlId(existing.getContentUrlId());
        newContentUrlKeyEntity.setUnencryptedFileSize(existing.getUnencryptedFileSize());
        newContentUrlKeyEntity.setId(existing.getId());
        return newContentUrlKeyEntity;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EncryptedKey getEncryptedKey() throws DecoderException {
        EncryptedKey encryptedKey = new EncryptedKey(this.getMasterKeystoreId(), this.getMasterKeyAlias(), this.getAlgorithm(), ByteBuffer.wrap(this.encryptedKeyAsBytes));
        return encryptedKey;
    }

    public Long getUnencryptedFileSize() {
        return this.unencryptedFileSize;
    }

    public void setUnencryptedFileSize(Long unencryptedFileSize) {
        this.unencryptedFileSize = unencryptedFileSize;
    }

    public void setKeySize(Integer keySize) {
        this.keySize = keySize;
    }

    public Integer getKeySize() {
        return this.keySize;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getMasterKeystoreId() {
        return this.masterKeystoreId;
    }

    public void setMasterKeystoreId(String masterKeystoreId) {
        this.masterKeystoreId = masterKeystoreId;
    }

    public String getMasterKeyAlias() {
        return this.masterKeyAlias;
    }

    public void setMasterKeyAlias(String masterKeyAlias) {
        this.masterKeyAlias = masterKeyAlias;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.masterKeyAlias == null ? 0 : this.masterKeyAlias.hashCode());
        result = 31 * result + (this.masterKeystoreId == null ? 0 : this.masterKeystoreId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentUrlKeyEntity other = (ContentUrlKeyEntity)obj;
        if (this.algorithm == null ? other.algorithm != null : !this.algorithm.equals(other.algorithm)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.masterKeyAlias == null ? other.masterKeyAlias != null : !this.masterKeyAlias.equals(other.masterKeyAlias)) {
            return false;
        }
        return !(this.masterKeystoreId == null ? other.masterKeystoreId != null : !this.masterKeystoreId.equals(other.masterKeystoreId));
    }

    public String toString() {
        return "ContentUrlKeyEntity [id=" + this.id + ", encryptedKeyAsBytes=" + this.encryptedKeyAsBytes + ", keySize=" + this.keySize + ", algorithm=" + this.algorithm + ", masterKeystoreId=" + this.masterKeystoreId + ", masterKeyAlias=" + this.masterKeyAlias + ", unencryptedFileSize=" + this.unencryptedFileSize + "]";
    }
}

