/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import org.alfresco.repo.audit.PropertyAuditFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PropertyAuditFilterTest {
    private PropertyAuditFilter filter;
    private Properties properties;
    private String rootPath;
    private Map<String, Serializable> auditMap;

    @Before
    public void setUp() throws Exception {
        this.filter = new PropertyAuditFilter();
        this.properties = new Properties();
        this.filter.setProperties(this.properties);
        this.rootPath = "root/action";
        this.auditMap = new HashMap<String, Serializable>();
        this.auditMap.put("name", (Serializable)((Object)"value"));
    }

    @Test
    public void testNoFilterIfNoProperties() {
        boolean actual = this.filter.accept(this.rootPath, this.auditMap);
        Assert.assertTrue((String)"Filter should only run if properties are set.", (boolean)actual);
    }

    @Test
    public void testNoRegexOnValue() {
        this.properties.put("audit.filter.root.action.enabled", "true");
        boolean actual = this.filter.accept(this.rootPath, this.auditMap);
        Assert.assertTrue((String)"Value should have been accepted.", (boolean)actual);
    }

    @Test
    public void testRegexOnValue() {
        this.properties.put("audit.filter.root.action.enabled", "true");
        this.properties.put("audit.filter.root.action.name", "value");
        boolean actual = this.filter.accept(this.rootPath, this.auditMap);
        Assert.assertTrue((String)"Value should have been accepted.", (boolean)actual);
    }

    @Test
    public void testRegexOnBadValue() {
        this.properties.put("audit.filter.root.action.enabled", "true");
        this.properties.put("audit.filter.root.action.name", "~value");
        boolean actual = this.filter.accept(this.rootPath, this.auditMap);
        Assert.assertFalse((String)"Value should have been rejected.", (boolean)actual);
    }

    @Test
    public void testNullValue() {
        this.auditMap.put("name", null);
        this.properties.put("audit.filter.root.action.enabled", "true");
        this.properties.put("audit.filter.root.action.name", "null");
        boolean actual = this.filter.accept(this.rootPath, this.auditMap);
        Assert.assertTrue((String)"A null value should match null", (boolean)actual);
    }

    @Test
    public void testNullStringValue() {
        this.auditMap.put("name", (Serializable)((Object)"null"));
        this.properties.put("audit.filter.root.action.enabled", "true");
        this.properties.put("audit.filter.root.action.name", "null");
        boolean actual = this.filter.accept(this.rootPath, this.auditMap);
        Assert.assertTrue((String)"A null value should match null", (boolean)actual);
    }

    @Test
    public void testNonStringValue() {
        LinkedHashSet<Integer> value = new LinkedHashSet<Integer>();
        value.add(1);
        value.add(2);
        value.add(3);
        this.auditMap.put("name", value);
        this.properties.put("audit.filter.root.action.enabled", "true");
        this.properties.put("audit.filter.root.action.name", "\\[1, 2, 3\\]");
        boolean actual = this.filter.accept(this.rootPath, this.auditMap);
        Assert.assertTrue((String)"The check should have worked on the value.toString().", (boolean)actual);
    }

    @Test
    public void testZeroLengthRegex() {
        this.properties.put("audit.filter.root.action.enabled", "true");
        this.properties.put("audit.filter.root.action.name", "");
        boolean actual = this.filter.accept(this.rootPath, this.auditMap);
        Assert.assertTrue((String)"Should match any values just like having no property", (boolean)actual);
    }

    @Test
    public void testDefaultActionUsedAsFallback() {
        this.properties.put("audit.filter.root.default.enabled", "true");
        this.properties.put("audit.filter.root.default.name", "~value");
        boolean actual = this.filter.accept(this.rootPath, this.auditMap);
        Assert.assertFalse((String)"The 'default' fallback action should have been used to enable the filter and reject the value.", (boolean)actual);
    }

    @Test
    public void testRedirect() {
        this.properties.put("audit.filter.root.action.enabled", "true");
        this.properties.put("audit.filter.root.action.name", "$anotherProperty");
        this.properties.put("anotherProperty", "$theFinalProperty");
        this.properties.put("theFinalProperty", "~value");
        boolean actual = this.filter.accept(this.rootPath, this.auditMap);
        Assert.assertFalse((String)"Redirected properties should have rejected the value.", (boolean)actual);
    }

    @Test
    public void testMultipleRegExp() {
        this.properties.put("audit.filter.root.action.enabled", "true");
        this.properties.put("audit.filter.root.action.name", "beGood;~b.*;.*");
        this.auditMap.put("name", (Serializable)((Object)"beGood"));
        Assert.assertTrue((String)"Should match 1st regex", (boolean)this.filter.accept(this.rootPath, this.auditMap));
        this.auditMap.put("name", (Serializable)((Object)"bad"));
        Assert.assertFalse((String)"Should match 2nd regex", (boolean)this.filter.accept(this.rootPath, this.auditMap));
        this.auditMap.put("name", (Serializable)((Object)"value"));
        Assert.assertTrue((String)"Should match 3rd regex", (boolean)this.filter.accept(this.rootPath, this.auditMap));
    }

    @Test
    public void testMultipleRegExpWithNoCatchAll() {
        this.properties.put("audit.filter.root.action.enabled", "true");
        this.properties.put("audit.filter.root.action.name", "beGood;~b.*");
        this.auditMap.put("name", (Serializable)((Object)"value"));
        Assert.assertFalse((String)"Should match nothing", (boolean)this.filter.accept(this.rootPath, this.auditMap));
    }

    @Test
    public void testEscapedSemicolon() {
        this.properties.put("audit.filter.root.action.enabled", "true");
        this.properties.put("audit.filter.root.action.name", "value\\\\;value");
        this.auditMap.put("name", (Serializable)((Object)"value\\;value"));
        Assert.assertTrue((String)"Should match 1st regex", (boolean)this.filter.accept(this.rootPath, this.auditMap));
    }

    @Test
    public void testEscapedRedirect() {
        this.properties.put("audit.filter.root.action.enabled", "true");
        this.properties.put("audit.filter.root.action.name", "\\$");
        this.auditMap.put("name", (Serializable)((Object)""));
        Assert.assertTrue((String)"Should match only zero length values", (boolean)this.filter.accept(this.rootPath, this.auditMap));
    }

    @Test
    public void testEscapedNot() {
        this.properties.put("audit.filter.root.action.enabled", "true");
        this.properties.put("audit.filter.root.action.name", "\\~.*");
        this.auditMap.put("name", (Serializable)((Object)"~good"));
        Assert.assertTrue((String)"Should match any value starting with '~'.", (boolean)this.filter.accept(this.rootPath, this.auditMap));
    }
}

