/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.util.Locale;
import junit.framework.TestCase;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.springframework.extensions.surf.util.I18NUtil;

public class ContentDataTest
extends TestCase {
    public ContentDataTest(String name) {
        super(name);
    }

    public void testToAndFromString() throws Exception {
        Locale locale = I18NUtil.getLocale();
        String localeStr = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)locale);
        ContentData property = new ContentData(null, null, 0L, null, null);
        String propertyStr = property.toString();
        ContentDataTest.assertEquals((String)"Null values not converted correctly", (String)("contentUrl=|mimetype=|size=0|encoding=|locale=" + localeStr), (String)propertyStr);
        ContentData checkProperty = ContentData.createContentProperty((String)propertyStr);
        ContentDataTest.assertEquals((String)"Conversion from string failed", (Object)property, (Object)checkProperty);
        property = new ContentData("test://uuu", "mmm", 123L, "eee", I18NUtil.getLocale());
        propertyStr = property.toString();
        ContentDataTest.assertEquals((String)"Incorrect property string representation", (String)("contentUrl=test://uuu|mimetype=mmm|size=123|encoding=eee|locale=" + localeStr), (String)propertyStr);
        checkProperty = ContentData.createContentProperty((String)propertyStr);
        ContentDataTest.assertEquals((String)"Conversion from string failed", (Object)property, (Object)checkProperty);
    }

    public void testEquals() {
        ContentData contentData1 = new ContentData("abc://xxx", "application/octet-stream", 600L, "UTF-8", Locale.ENGLISH);
        ContentData contentData2 = new ContentData("abc://xxx", "application/octet-stream", 600L, "UTF-8", Locale.ENGLISH);
        ContentData contentData3 = new ContentData("abc://XXX", "application/octet-stream", 600L, "UTF-8", Locale.ENGLISH);
        ContentData contentData4 = new ContentData("abc://xxx", "text/plain", 600L, "UTF-8", Locale.ENGLISH);
        ContentData contentData5 = new ContentData("abc://xxx", "application/octet-stream", 500L, "UTF-8", Locale.ENGLISH);
        ContentData contentData6 = new ContentData("abc://xxx", "application/octet-stream", 600L, "UTF-16", Locale.ENGLISH);
        ContentData contentData7 = new ContentData("abc://xxx", "application/octet-stream", 600L, "UTF-8", Locale.CHINESE);
        ContentDataTest.assertEquals((Object)contentData1, (Object)contentData2);
        ContentDataTest.assertNotSame((Object)contentData1, (Object)contentData3);
        ContentDataTest.assertNotSame((Object)contentData1, (Object)contentData4);
        ContentDataTest.assertNotSame((Object)contentData1, (Object)contentData5);
        ContentDataTest.assertNotSame((Object)contentData1, (Object)contentData6);
        ContentDataTest.assertNotSame((Object)contentData1, (Object)contentData7);
    }
}

