/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.version.Version2Model;
import org.alfresco.repo.version.Version2ServiceImpl$AjcClosure1;
import org.alfresco.repo.version.Version2ServiceImpl$AjcClosure11;
import org.alfresco.repo.version.Version2ServiceImpl$AjcClosure13;
import org.alfresco.repo.version.Version2ServiceImpl$AjcClosure15;
import org.alfresco.repo.version.Version2ServiceImpl$AjcClosure17;
import org.alfresco.repo.version.Version2ServiceImpl$AjcClosure19;
import org.alfresco.repo.version.Version2ServiceImpl$AjcClosure21;
import org.alfresco.repo.version.Version2ServiceImpl$AjcClosure23;
import org.alfresco.repo.version.Version2ServiceImpl$AjcClosure25;
import org.alfresco.repo.version.Version2ServiceImpl$AjcClosure27;
import org.alfresco.repo.version.Version2ServiceImpl$AjcClosure29;
import org.alfresco.repo.version.Version2ServiceImpl$AjcClosure3;
import org.alfresco.repo.version.Version2ServiceImpl$AjcClosure5;
import org.alfresco.repo.version.Version2ServiceImpl$AjcClosure7;
import org.alfresco.repo.version.Version2ServiceImpl$AjcClosure9;
import org.alfresco.repo.version.VersionRevertCallback;
import org.alfresco.repo.version.VersionRevertDetailsImpl;
import org.alfresco.repo.version.VersionServiceImpl;
import org.alfresco.repo.version.common.VersionHistoryImpl;
import org.alfresco.repo.version.common.VersionImpl;
import org.alfresco.repo.version.common.VersionUtil;
import org.alfresco.repo.version.common.versionlabel.SerialVersionLabelPolicy;
import org.alfresco.repo.version.traitextender.VersionServiceExtension;
import org.alfresco.repo.version.traitextender.VersionServiceTrait;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.AspectMissingException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.version.ReservedVersionNameException;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionServiceException;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.traitextender.AJProxyTrait;
import org.alfresco.traitextender.Extend;
import org.alfresco.traitextender.ExtendedTrait;
import org.alfresco.traitextender.Extensible;
import org.alfresco.traitextender.RouteExtensions;
import org.alfresco.traitextender.Trait;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.extensions.surf.util.ParameterCheck;

public class Version2ServiceImpl
extends VersionServiceImpl
implements VersionService,
Version2Model,
Extensible {
    private static Log logger;
    private PermissionService permissionService;
    private boolean useVersionAssocIndex = false;
    private ExtendedTrait<VersionServiceTrait> versionServiceTrait = new ExtendedTrait<VersionServiceTrait>(AJProxyTrait.create(this, VersionServiceTrait.class));
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ Annotation ajc$anno$8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ Annotation ajc$anno$9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ Annotation ajc$anno$10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ Annotation ajc$anno$11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ Annotation ajc$anno$12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ Annotation ajc$anno$13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ Annotation ajc$anno$14;

    static {
        Version2ServiceImpl.ajc$preClinit();
        logger = LogFactory.getLog(Version2ServiceImpl.class);
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setUseVersionAssocIndex(boolean useVersionAssocIndex) {
        this.useVersionAssocIndex = useVersionAssocIndex;
    }

    public boolean isUseVersionAssocIndex() {
        return this.useVersionAssocIndex;
    }

    @Override
    public void initialise() {
        super.initialise();
    }

    @Override
    @Extend(extensionAPI=VersionServiceExtension.class, traitAPI=VersionServiceTrait.class)
    public StoreRef getVersionStoreReference() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, joinPoint};
        Version2ServiceImpl$AjcClosure1 version2ServiceImpl$AjcClosure1 = new Version2ServiceImpl$AjcClosure1(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = version2ServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = Version2ServiceImpl.class.getDeclaredMethod("getVersionStoreReference", new Class[0]).getAnnotation(Extend.class);
        }
        return (StoreRef)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(extensionAPI=VersionServiceExtension.class, traitAPI=VersionServiceTrait.class)
    public Version createVersion(NodeRef nodeRef, Map<String, Serializable> versionProperties) throws ReservedVersionNameException, AspectMissingException {
        NodeRef nodeRef2 = nodeRef;
        Map<String, Serializable> map = versionProperties;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)nodeRef2, map);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, map, joinPoint};
        Version2ServiceImpl$AjcClosure3 version2ServiceImpl$AjcClosure3 = new Version2ServiceImpl$AjcClosure3(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = version2ServiceImpl$AjcClosure3.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = Version2ServiceImpl.class.getDeclaredMethod("createVersion", NodeRef.class, Map.class).getAnnotation(Extend.class);
        }
        return (Version)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(extensionAPI=VersionServiceExtension.class, traitAPI=VersionServiceTrait.class)
    public Collection<Version> createVersion(Collection<NodeRef> nodeRefs, Map<String, Serializable> versionProperties) throws ReservedVersionNameException, AspectMissingException {
        Collection<NodeRef> collection = nodeRefs;
        Map<String, Serializable> map = versionProperties;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, collection, map);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, collection, map, joinPoint};
        Version2ServiceImpl$AjcClosure5 version2ServiceImpl$AjcClosure5 = new Version2ServiceImpl$AjcClosure5(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = version2ServiceImpl$AjcClosure5.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = Version2ServiceImpl.class.getDeclaredMethod("createVersion", Collection.class, Map.class).getAnnotation(Extend.class);
        }
        return (Collection)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    protected Version createVersion(NodeRef nodeRef, Map<String, Serializable> origVersionProperties, int versionNumber) throws ReservedVersionNameException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Run as user " + AuthenticationUtil.getRunAsUser()));
            logger.debug((Object)("Fully authenticated " + AuthenticationUtil.getFullyAuthenticatedUser()));
        }
        long startTime = System.currentTimeMillis();
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
        if (origVersionProperties != null) {
            versionProperties.putAll(origVersionProperties);
        }
        this.policyBehaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        }
        this.invokeBeforeCreateVersion(nodeRef);
        String versionDescription = (String)versionProperties.get("description");
        versionProperties.remove("description");
        versionProperties.remove(ContentModel.PROP_VERSION_LABEL);
        VersionUtil.checkVersionPropertyNames(versionProperties.keySet());
        NodeRef versionHistoryRef = this.getVersionHistoryNodeRef(nodeRef);
        Object currentVersionRef = null;
        Version currentVersion = null;
        if (versionHistoryRef == null) {
            versionHistoryRef = this.createVersionHistory(nodeRef);
        } else {
            this.checkForCorruptedVersions(versionHistoryRef, nodeRef);
            Pair<Boolean, Version> result = this.getCurrentVersionImpl(versionHistoryRef, nodeRef);
            boolean headVersion = false;
            if (result != null) {
                currentVersion = (Version)result.getSecond();
                headVersion = (Boolean)result.getFirst();
            }
            if (currentVersion == null) {
                throw new VersionServiceException("version_service.err_not_found");
            }
            if (!headVersion) {
                VersionHistory versionHistory = this.buildVersionHistory(versionHistoryRef, nodeRef);
                if (versionHistory.getSuccessors(currentVersion).size() == 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Belt-and-braces: current version does seem to be head version [" + versionHistoryRef + ", " + nodeRef + "]"));
                    }
                } else {
                    throw new VersionServiceException("version_service.err_unsupported");
                }
            }
        }
        QName classRef = this.nodeService.getType(nodeRef);
        PolicyScope nodeDetails = new PolicyScope(classRef);
        this.invokeOnCreateVersion(nodeRef, versionProperties, nodeDetails);
        String versionLabel = this.invokeCalculateVersionLabel(classRef, currentVersion, versionNumber, versionProperties);
        QName sourceTypeRef = this.nodeService.getType(nodeRef);
        long nodeDbId = (Long)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NODE_DBID);
        Set nodeAspects = this.nodeService.getAspects(nodeRef);
        NodeRef newVersionRef = this.createNewVersion(sourceTypeRef, versionHistoryRef, this.getStandardVersionProperties(nodeRef, nodeDbId, nodeAspects, versionNumber, versionLabel, versionDescription), versionProperties, versionNumber, nodeDetails);
        if (currentVersionRef == null) {
            this.dbNodeService.createAssociation(versionHistoryRef, newVersionRef, Version2Model.ASSOC_ROOT_VERSION);
        }
        Version version = this.getVersion(newVersionRef);
        this.policyBehaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_LOCKABLE);
        try {
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_VERSION_LABEL, (Serializable)((Object)version.getVersionLabel()));
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_VERSION_TYPE, (Serializable)((Object)version.getVersionType()));
        }
        finally {
            this.policyBehaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_LOCKABLE);
        }
        this.policyBehaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
        this.invokeAfterCreateVersion(nodeRef, version);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("created version (" + this.getVersionStoreReference() + ") " + newVersionRef + " " + (System.currentTimeMillis() - startTime) + " ms"));
        }
        return version;
    }

    protected NodeRef createVersionHistory(NodeRef nodeRef) {
        long start = System.currentTimeMillis();
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, nodeRef.getId());
        props.put(Version2Model.PROP_QNAME_VERSIONED_NODE_ID, nodeRef.getId());
        ChildAssociationRef childAssocRef = this.dbNodeService.createNode(this.getRootNode(), Version2Model.CHILD_QNAME_VERSION_HISTORIES, QName.createQName((String)"http://www.alfresco.org/model/versionstore/2.0", (String)nodeRef.getId()), Version2Model.TYPE_QNAME_VERSION_HISTORY, props);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("created version history nodeRef: " + childAssocRef.getChildRef() + " for " + nodeRef + " in " + (System.currentTimeMillis() - start) + " ms"));
        }
        return childAssocRef.getChildRef();
    }

    @Override
    @Extend(extensionAPI=VersionServiceExtension.class, traitAPI=VersionServiceTrait.class)
    public VersionHistory getVersionHistory(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        Version2ServiceImpl$AjcClosure7 version2ServiceImpl$AjcClosure7 = new Version2ServiceImpl$AjcClosure7(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = version2ServiceImpl$AjcClosure7.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = Version2ServiceImpl.class.getDeclaredMethod("getVersionHistory", NodeRef.class).getAnnotation(Extend.class);
        }
        return (VersionHistory)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(extensionAPI=VersionServiceExtension.class, traitAPI=VersionServiceTrait.class)
    public Version getCurrentVersion(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        Version2ServiceImpl$AjcClosure9 version2ServiceImpl$AjcClosure9 = new Version2ServiceImpl$AjcClosure9(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = version2ServiceImpl$AjcClosure9.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = Version2ServiceImpl.class.getDeclaredMethod("getCurrentVersion", NodeRef.class).getAnnotation(Extend.class);
        }
        return (Version)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    protected Map<QName, Serializable> getStandardVersionProperties(NodeRef nodeRef, long nodeDbId, Set<QName> nodeAspects, int versionNumber, String versionLabel, String versionDescription) {
        HashMap<QName, Serializable> result = new HashMap<QName, Serializable>(10);
        result.put(Version2Model.PROP_QNAME_VERSION_LABEL, (Serializable)((Object)versionLabel));
        result.put(Version2Model.PROP_QNAME_VERSION_DESCRIPTION, (Serializable)((Object)versionDescription));
        result.put(Version2Model.PROP_QNAME_FROZEN_NODE_REF, (Serializable)nodeRef);
        result.put(Version2Model.PROP_QNAME_FROZEN_NODE_DBID, Long.valueOf(nodeDbId));
        return result;
    }

    protected NodeRef createNewVersion(QName sourceTypeRef, NodeRef versionHistoryRef, Map<QName, Serializable> standardVersionProperties, Map<String, Serializable> versionProperties, int versionNumber, PolicyScope nodeDetails) {
        ChildAssociationRef childAssocRef = null;
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_MULTILINGUAL_DOCUMENT);
        this.policyBehaviourFilter.disableBehaviour(ContentModel.TYPE_MULTILINGUAL_CONTAINER);
        NodeRef versionNodeRef = null;
        try {
            childAssocRef = this.dbNodeService.createNode(versionHistoryRef, Version2Model.CHILD_QNAME_VERSIONS, QName.createQName((String)"http://www.alfresco.org/model/versionstore/2.0", (String)("version-" + versionNumber)), sourceTypeRef, nodeDetails.getProperties());
            if (this.isUseVersionAssocIndex()) {
                this.nodeService.setChildAssociationIndex(childAssocRef, this.getAllVersions(versionHistoryRef).size());
            }
            versionNodeRef = childAssocRef.getChildRef();
            if (sourceTypeRef.equals((Object)ContentModel.TYPE_MULTILINGUAL_CONTAINER)) {
                this.permissionService.setPermission(versionNodeRef, "GROUP_EVERYONE", "All", true);
                this.permissionService.setPermission(versionNodeRef, AuthenticationUtil.getGuestUserName(), "All", true);
            }
            this.nodeService.addAspect(versionNodeRef, Version2Model.ASPECT_VERSION, standardVersionProperties);
            this.storeVersionMetaData(versionNodeRef, versionProperties);
            this.freezeChildAssociations(versionNodeRef, nodeDetails.getChildAssociations());
            this.freezeAssociations(versionNodeRef, nodeDetails.getAssociations());
            this.freezeAspects(nodeDetails, versionNodeRef, nodeDetails.getAspects());
        }
        finally {
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_VERSIONABLE);
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_MULTILINGUAL_DOCUMENT);
            this.policyBehaviourFilter.enableBehaviour(ContentModel.TYPE_MULTILINGUAL_CONTAINER);
        }
        if (!this.dbNodeService.hasAspect(versionNodeRef, ContentModel.ASPECT_AUDITABLE)) {
            this.dbNodeService.addAspect(versionNodeRef, ContentModel.ASPECT_AUDITABLE, null);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("newVersion created (" + versionNumber + ") " + versionNodeRef));
        }
        return versionNodeRef;
    }

    private void storeVersionMetaData(NodeRef versionNodeRef, Map<String, Serializable> versionProperties) {
        for (Map.Entry<String, Serializable> entry : versionProperties.entrySet()) {
            this.dbNodeService.setProperty(versionNodeRef, QName.createQName((String)"http://www.alfresco.org/model/versionstore/2.0", (String)("metadata-" + entry.getKey())), entry.getValue());
        }
    }

    private void freezeAspects(PolicyScope nodeDetails, NodeRef versionNodeRef, Set<QName> aspects) {
        for (QName aspect : aspects) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("freezeAspect: " + versionNodeRef + " " + aspect));
            }
            if (aspect.equals((Object)ContentModel.ASPECT_AUDITABLE)) {
                for (Map.Entry<QName, Serializable> entry : nodeDetails.getProperties(aspect).entrySet()) {
                    if (entry.getKey().equals((Object)ContentModel.PROP_CREATOR)) {
                        this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_FROZEN_CREATOR, entry.getValue());
                        continue;
                    }
                    if (entry.getKey().equals((Object)ContentModel.PROP_CREATED)) {
                        this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_FROZEN_CREATED, entry.getValue());
                        continue;
                    }
                    if (entry.getKey().equals((Object)ContentModel.PROP_MODIFIER)) {
                        this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_FROZEN_MODIFIER, entry.getValue());
                        continue;
                    }
                    if (entry.getKey().equals((Object)ContentModel.PROP_MODIFIED)) {
                        this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_FROZEN_MODIFIED, entry.getValue());
                        continue;
                    }
                    if (entry.getKey().equals((Object)ContentModel.PROP_ACCESSED)) {
                        this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_FROZEN_ACCESSED, entry.getValue());
                        continue;
                    }
                    throw new AlfrescoRuntimeException("Unexpected auditable property: " + entry.getKey());
                }
            } else {
                this.dbNodeService.addAspect(versionNodeRef, aspect, nodeDetails.getProperties(aspect));
            }
            this.freezeChildAssociations(versionNodeRef, nodeDetails.getChildAssociations(aspect));
            this.freezeAssociations(versionNodeRef, nodeDetails.getAssociations(aspect));
        }
    }

    private void freezeChildAssociations(NodeRef versionNodeRef, List<ChildAssociationRef> childAssociations) {
        for (ChildAssociationRef childAssocRef : childAssociations) {
            HashMap<QName, NodeRef> properties = new HashMap<QName, NodeRef>();
            NodeRef childRef = childAssocRef.getChildRef();
            QName sourceTypeRef = this.nodeService.getType(childRef);
            properties.put(ContentModel.PROP_REFERENCE, childRef);
            this.dbNodeService.createNode(versionNodeRef, childAssocRef.getTypeQName(), childAssocRef.getQName(), sourceTypeRef, properties);
        }
    }

    private void freezeAssociations(NodeRef versionNodeRef, List<AssociationRef> associations) {
        for (AssociationRef targetAssocRef : associations) {
            HashMap<QName, Object> properties = new HashMap<QName, Object>();
            QName sourceTypeRef = this.nodeService.getType(targetAssocRef.getSourceRef());
            NodeRef targetRef = targetAssocRef.getTargetRef();
            properties.put(ContentModel.PROP_REFERENCE, targetRef);
            properties.put(Version2Model.PROP_QNAME_ASSOC_DBID, targetAssocRef.getId());
            this.dbNodeService.createNode(versionNodeRef, Version2Model.CHILD_QNAME_VERSIONED_ASSOCS, targetAssocRef.getTypeQName(), sourceTypeRef, properties);
        }
    }

    protected List<Version> getAllVersions(NodeRef versionHistoryRef) {
        List<ChildAssociationRef> versionAssocs = this.getVersionAssocs(versionHistoryRef, true);
        ArrayList<Version> versions = new ArrayList<Version>(versionAssocs.size());
        for (ChildAssociationRef versionAssoc : versionAssocs) {
            versions.add(this.getVersion(versionAssoc.getChildRef()));
        }
        return versions;
    }

    private List<ChildAssociationRef> getVersionAssocs(NodeRef versionHistoryRef, boolean preLoad) {
        return this.dbNodeService.getChildAssocs(versionHistoryRef, (QNamePattern)Version2Model.CHILD_QNAME_VERSIONS, RegexQNamePattern.MATCH_ALL, preLoad);
    }

    @Override
    protected VersionHistory buildVersionHistory(NodeRef versionHistoryRef, NodeRef nodeRef) {
        VersionHistoryImpl versionHistory = null;
        List<Version> versions = this.getAllVersions(versionHistoryRef);
        if (this.versionComparatorDesc != null) {
            Collections.sort(versions, Collections.reverseOrder(this.versionComparatorDesc));
        }
        boolean isRoot = true;
        Version preceeding = null;
        for (Version version : versions) {
            if (isRoot) {
                versionHistory = new VersionHistoryImpl(version, this.versionComparatorDesc);
                isRoot = false;
            } else {
                ((VersionHistoryImpl)versionHistory).addVersion(version, preceeding);
            }
            preceeding = version;
        }
        return versionHistory;
    }

    @Override
    protected Version getVersion(NodeRef versionRef) {
        if (versionRef == null) {
            return null;
        }
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
        Map nodeProperties = this.dbNodeService.getProperties(versionRef);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getVersion: " + versionRef + " nodeProperties=\n" + nodeProperties.keySet()));
        }
        for (QName key : nodeProperties.keySet()) {
            Serializable value = (Serializable)nodeProperties.get(key);
            String keyName = key.getLocalName();
            int idx = keyName.indexOf("metadata-");
            if (idx == 0) {
                versionProperties.put(keyName.substring("metadata-".length()), value);
                continue;
            }
            if (key.equals((Object)Version2Model.PROP_QNAME_VERSION_DESCRIPTION)) {
                versionProperties.put("description", (Serializable)((Object)((String)((Object)value))));
                continue;
            }
            if (key.equals((Object)Version2Model.PROP_QNAME_VERSION_LABEL)) {
                versionProperties.put("versionLabel", (Serializable)((Object)((String)((Object)value))));
                continue;
            }
            if (keyName.equals("description") || keyName.equals("versionLabel")) continue;
            versionProperties.put(keyName, value);
        }
        NodeRef newNodeRef = new NodeRef(new StoreRef("versionStore", "version2Store"), versionRef.getId());
        VersionImpl result = new VersionImpl(versionProperties, newNodeRef);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getVersion: " + versionRef + " versionProperties=\n" + versionProperties.keySet()));
        }
        return result;
    }

    @Override
    protected NodeRef getVersionHistoryNodeRef(NodeRef nodeRef) {
        NodeRef vhNodeRef = this.dbNodeService.getChildByName(this.getRootNode(), Version2Model.CHILD_QNAME_VERSION_HISTORIES, nodeRef.getId());
        if (vhNodeRef == null && this.nodeService.exists(nodeRef)) {
            vhNodeRef = this.dbNodeService.getChildByName(this.getRootNode(), Version2Model.CHILD_QNAME_VERSION_HISTORIES, (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NODE_UUID)));
        }
        return vhNodeRef;
    }

    private Pair<Boolean, Version> getCurrentVersionImpl(NodeRef versionHistoryRef, NodeRef nodeRef) {
        int versionCount;
        if (nodeRef.getStoreRef().getIdentifier().contains("version2Store")) {
            throw new IllegalArgumentException("The node reference " + nodeRef + " is pointing to a version node, when a reference to a live node is expected.");
        }
        Pair result = null;
        String versionLabel = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL));
        List<ChildAssociationRef> versionAssocs = this.getVersionAssocs(versionHistoryRef, false);
        int i = versionCount = versionAssocs.size();
        while (i > 0) {
            ChildAssociationRef versionAssoc = versionAssocs.get(i - 1);
            String tempLabel = (String)((Object)this.dbNodeService.getProperty(versionAssoc.getChildRef(), Version2Model.PROP_QNAME_VERSION_LABEL));
            if (tempLabel != null && tempLabel.equals(versionLabel)) {
                boolean headVersion;
                boolean bl = headVersion = i == versionCount;
                if (!headVersion) {
                    throw new ConcurrencyFailureException("Unexpected: current version does not appear to be 1st version in the list [" + versionHistoryRef + ", " + nodeRef + "]");
                }
                result = new Pair((Object)headVersion, (Object)this.getVersion(versionAssoc.getChildRef()));
                break;
            }
            --i;
        }
        return result;
    }

    private void checkForCorruptedVersions(NodeRef versionHistory, NodeRef nodeRef) {
        String versionLabel = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL));
        if (versionLabel != null && versionLabel.equals("0")) {
            List<Version> versions = this.getAllVersions(versionHistory);
            Collections.sort(versions, new Comparator<Version>(){

                @Override
                public int compare(Version v1, Version v2) {
                    int result = v1.getFrozenModifiedDate().compareTo(v2.getFrozenModifiedDate());
                    if (result == 0) {
                        Long dbid1 = (Long)Version2ServiceImpl.this.nodeService.getProperty(v1.getFrozenStateNodeRef(), ContentModel.PROP_NODE_DBID);
                        Long dbid2 = (Long)Version2ServiceImpl.this.nodeService.getProperty(v2.getFrozenStateNodeRef(), ContentModel.PROP_NODE_DBID);
                        if (dbid1 != null && dbid2 != null) {
                            result = dbid1.compareTo(dbid2);
                        } else {
                            result = 0;
                            if (logger.isWarnEnabled()) {
                                logger.warn((Object)("node-dbid property is missing for versions: " + v1.toString() + " or " + v2.toString()));
                            }
                        }
                    }
                    return result;
                }
            });
            SerialVersionLabelPolicy serialVersionLabelPolicy = new SerialVersionLabelPolicy();
            QName classRef = this.nodeService.getType(nodeRef);
            Version preceedingVersion = null;
            for (Version version : versions) {
                versionLabel = serialVersionLabelPolicy.calculateVersionLabel(classRef, preceedingVersion, 0, version.getVersionProperties());
                NodeRef versionNodeRef = new NodeRef("workspace", version.getFrozenStateNodeRef().getStoreRef().getIdentifier(), version.getFrozenStateNodeRef().getId());
                this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_VERSION_LABEL, (Serializable)((Object)versionLabel));
                version.getVersionProperties().put("versionLabel", (Serializable)((Object)versionLabel));
                preceedingVersion = version;
            }
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_VERSION_LABEL, (Serializable)((Object)versionLabel));
        }
    }

    @Override
    @Extend(extensionAPI=VersionServiceExtension.class, traitAPI=VersionServiceTrait.class)
    public void revert(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        Version2ServiceImpl$AjcClosure11 version2ServiceImpl$AjcClosure11 = new Version2ServiceImpl$AjcClosure11(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = version2ServiceImpl$AjcClosure11.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = Version2ServiceImpl.class.getDeclaredMethod("revert", NodeRef.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(extensionAPI=VersionServiceExtension.class, traitAPI=VersionServiceTrait.class)
    public void revert(NodeRef nodeRef, boolean deep) {
        NodeRef nodeRef2 = nodeRef;
        boolean bl = deep;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)nodeRef2, (Object)Conversions.booleanObject((boolean)bl));
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, Conversions.booleanObject((boolean)bl), joinPoint};
        Version2ServiceImpl$AjcClosure13 version2ServiceImpl$AjcClosure13 = new Version2ServiceImpl$AjcClosure13(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = version2ServiceImpl$AjcClosure13.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = Version2ServiceImpl.class.getDeclaredMethod("revert", NodeRef.class, Boolean.TYPE).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(extensionAPI=VersionServiceExtension.class, traitAPI=VersionServiceTrait.class)
    public void revert(NodeRef nodeRef, Version version) {
        NodeRef nodeRef2 = nodeRef;
        Version version2 = version;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)nodeRef2, (Object)version2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, version2, joinPoint};
        Version2ServiceImpl$AjcClosure15 version2ServiceImpl$AjcClosure15 = new Version2ServiceImpl$AjcClosure15(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = version2ServiceImpl$AjcClosure15.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = Version2ServiceImpl.class.getDeclaredMethod("revert", NodeRef.class, Version.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(extensionAPI=VersionServiceExtension.class, traitAPI=VersionServiceTrait.class)
    public void revert(NodeRef nodeRef, Version version, boolean deep) {
        NodeRef nodeRef2 = nodeRef;
        Version version2 = version;
        boolean bl = deep;
        Object[] objectArray = new Object[]{nodeRef2, version2, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef2, version2, Conversions.booleanObject((boolean)bl), joinPoint};
        Version2ServiceImpl$AjcClosure17 version2ServiceImpl$AjcClosure17 = new Version2ServiceImpl$AjcClosure17(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = version2ServiceImpl$AjcClosure17.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = Version2ServiceImpl.class.getDeclaredMethod("revert", NodeRef.class, Version.class, Boolean.TYPE).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(extensionAPI=VersionServiceExtension.class, traitAPI=VersionServiceTrait.class)
    public NodeRef restore(NodeRef nodeRef, NodeRef parentNodeRef, QName assocTypeQName, QName assocQName) {
        NodeRef nodeRef2 = nodeRef;
        NodeRef nodeRef3 = parentNodeRef;
        QName qName = assocTypeQName;
        QName qName2 = assocQName;
        Object[] objectArray = new Object[]{nodeRef2, nodeRef3, qName, qName2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef2, nodeRef3, qName, qName2, joinPoint};
        Version2ServiceImpl$AjcClosure19 version2ServiceImpl$AjcClosure19 = new Version2ServiceImpl$AjcClosure19(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = version2ServiceImpl$AjcClosure19.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$9;
        if (annotation == null) {
            annotation = ajc$anno$9 = Version2ServiceImpl.class.getDeclaredMethod("restore", NodeRef.class, NodeRef.class, QName.class, QName.class).getAnnotation(Extend.class);
        }
        return (NodeRef)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(extensionAPI=VersionServiceExtension.class, traitAPI=VersionServiceTrait.class)
    public NodeRef restore(NodeRef nodeRef, NodeRef parentNodeRef, QName assocTypeQName, QName assocQName, boolean deep) {
        NodeRef nodeRef2 = nodeRef;
        NodeRef nodeRef3 = parentNodeRef;
        QName qName = assocTypeQName;
        QName qName2 = assocQName;
        boolean bl = deep;
        Object[] objectArray = new Object[]{nodeRef2, nodeRef3, qName, qName2, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef2, nodeRef3, qName, qName2, Conversions.booleanObject((boolean)bl), joinPoint};
        Version2ServiceImpl$AjcClosure21 version2ServiceImpl$AjcClosure21 = new Version2ServiceImpl$AjcClosure21(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = version2ServiceImpl$AjcClosure21.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$10;
        if (annotation == null) {
            annotation = ajc$anno$10 = Version2ServiceImpl.class.getDeclaredMethod("restore", NodeRef.class, NodeRef.class, QName.class, QName.class, Boolean.TYPE).getAnnotation(Extend.class);
        }
        return (NodeRef)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    private Version getHeadVersion(NodeRef nodeRef) {
        VersionHistory versionHistory;
        NodeRef versionHistoryNodeRef = this.getVersionHistoryNodeRef(nodeRef);
        Version headVersion = null;
        if (versionHistoryNodeRef != null && (versionHistory = this.buildVersionHistory(versionHistoryNodeRef, nodeRef)) != null) {
            headVersion = versionHistory.getHeadVersion();
        }
        return headVersion;
    }

    @Override
    @Extend(extensionAPI=VersionServiceExtension.class, traitAPI=VersionServiceTrait.class)
    public void deleteVersionHistory(NodeRef nodeRef) throws AspectMissingException {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        Version2ServiceImpl$AjcClosure23 version2ServiceImpl$AjcClosure23 = new Version2ServiceImpl$AjcClosure23(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = version2ServiceImpl$AjcClosure23.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$11;
        if (annotation == null) {
            annotation = ajc$anno$11 = Version2ServiceImpl.class.getDeclaredMethod("deleteVersionHistory", NodeRef.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(extensionAPI=VersionServiceExtension.class, traitAPI=VersionServiceTrait.class)
    public void deleteVersion(NodeRef nodeRef, Version version) {
        NodeRef nodeRef2 = nodeRef;
        Version version2 = version;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)nodeRef2, (Object)version2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, version2, joinPoint};
        Version2ServiceImpl$AjcClosure25 version2ServiceImpl$AjcClosure25 = new Version2ServiceImpl$AjcClosure25(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = version2ServiceImpl$AjcClosure25.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$12;
        if (annotation == null) {
            annotation = ajc$anno$12 = Version2ServiceImpl.class.getDeclaredMethod("deleteVersion", NodeRef.class, Version.class).getAnnotation(Extend.class);
        }
        routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(extensionAPI=VersionServiceExtension.class, traitAPI=VersionServiceTrait.class)
    public boolean isAVersion(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        Version2ServiceImpl$AjcClosure27 version2ServiceImpl$AjcClosure27 = new Version2ServiceImpl$AjcClosure27(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = version2ServiceImpl$AjcClosure27.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$13;
        if (annotation == null) {
            annotation = ajc$anno$13 = Version2ServiceImpl.class.getDeclaredMethod("isAVersion", NodeRef.class).getAnnotation(Extend.class);
        }
        return Conversions.booleanValue((Object)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation));
    }

    @Override
    @Extend(extensionAPI=VersionServiceExtension.class, traitAPI=VersionServiceTrait.class)
    public boolean isVersioned(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        Version2ServiceImpl$AjcClosure29 version2ServiceImpl$AjcClosure29 = new Version2ServiceImpl$AjcClosure29(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = version2ServiceImpl$AjcClosure29.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$14;
        if (annotation == null) {
            annotation = ajc$anno$14 = Version2ServiceImpl.class.getDeclaredMethod("isVersioned", NodeRef.class).getAnnotation(Extend.class);
        }
        return Conversions.booleanValue((Object)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation));
    }

    @Override
    public <T extends Trait> ExtendedTrait<T> getTrait(Class<? extends T> traitAPI) {
        return this.versionServiceTrait;
    }

    static final /* synthetic */ StoreRef getVersionStoreReference_aroundBody0(Version2ServiceImpl ajc$this, JoinPoint joinPoint) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Run as user " + AuthenticationUtil.getRunAsUser()));
            logger.debug((Object)("Fully authenticated " + AuthenticationUtil.getFullyAuthenticatedUser()));
        }
        return new StoreRef("workspace", "version2Store");
    }

    static final /* synthetic */ Version createVersion_aroundBody2(Version2ServiceImpl ajc$this, NodeRef nodeRef, Map versionProperties, JoinPoint joinPoint) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Run as user " + AuthenticationUtil.getRunAsUser()));
            logger.debug((Object)("Fully authenticated " + AuthenticationUtil.getFullyAuthenticatedUser()));
        }
        long startTime = System.currentTimeMillis();
        int versionNumber = 0;
        Version version = ajc$this.createVersion(nodeRef, (Map<String, Serializable>)versionProperties, versionNumber);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("created version (" + VersionUtil.convertNodeRef(version.getFrozenStateNodeRef()) + ") in " + (System.currentTimeMillis() - startTime) + " ms"));
        }
        return version;
    }

    static final /* synthetic */ Collection createVersion_aroundBody4(Version2ServiceImpl ajc$this, Collection nodeRefs, Map versionProperties, JoinPoint joinPoint) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Run as user " + AuthenticationUtil.getRunAsUser()));
            logger.debug((Object)("Fully authenticated " + AuthenticationUtil.getFullyAuthenticatedUser()));
        }
        long startTime = System.currentTimeMillis();
        ArrayList<Version> result = new ArrayList<Version>(nodeRefs.size());
        int versionNumber = 0;
        for (NodeRef nodeRef : nodeRefs) {
            result.add(ajc$this.createVersion(nodeRef, (Map<String, Serializable>)versionProperties, versionNumber));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("created version list (" + ajc$this.getVersionStoreReference() + ") in " + (System.currentTimeMillis() - startTime) + " ms (with " + nodeRefs.size() + " nodes)"));
        }
        return result;
    }

    static final /* synthetic */ VersionHistory getVersionHistory_aroundBody6(Version2ServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Run as user " + AuthenticationUtil.getRunAsUser()));
            logger.debug((Object)("Fully authenticated " + AuthenticationUtil.getFullyAuthenticatedUser()));
        }
        VersionHistory versionHistory = null;
        NodeRef versionHistoryRef = ajc$this.getVersionHistoryNodeRef(nodeRef);
        if (versionHistoryRef != null) {
            versionHistory = ajc$this.buildVersionHistory(versionHistoryRef, nodeRef);
        }
        return versionHistory;
    }

    static final /* synthetic */ Version getCurrentVersion_aroundBody8(Version2ServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        Pair<Boolean, Version> result;
        NodeRef versionHistoryRef;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Run as user " + AuthenticationUtil.getRunAsUser()));
            logger.debug((Object)("Fully authenticated " + AuthenticationUtil.getFullyAuthenticatedUser()));
        }
        Version version = null;
        if (ajc$this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE) && (versionHistoryRef = ajc$this.getVersionHistoryNodeRef(nodeRef)) != null && (result = ajc$this.getCurrentVersionImpl(versionHistoryRef, nodeRef)) != null) {
            version = (Version)result.getSecond();
        }
        return version;
    }

    static final /* synthetic */ void revert_aroundBody10(Version2ServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Run as user " + AuthenticationUtil.getRunAsUser()));
            logger.debug((Object)("Fully authenticated " + AuthenticationUtil.getFullyAuthenticatedUser()));
        }
        ajc$this.revert(nodeRef, ajc$this.getCurrentVersion(nodeRef), true);
    }

    static final /* synthetic */ void revert_aroundBody12(Version2ServiceImpl ajc$this, NodeRef nodeRef, boolean deep, JoinPoint joinPoint) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Run as user " + AuthenticationUtil.getRunAsUser()));
            logger.debug((Object)("Fully authenticated " + AuthenticationUtil.getFullyAuthenticatedUser()));
        }
        ajc$this.revert(nodeRef, ajc$this.getCurrentVersion(nodeRef), deep);
    }

    static final /* synthetic */ void revert_aroundBody14(Version2ServiceImpl ajc$this, NodeRef nodeRef, Version version, JoinPoint joinPoint) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Run as user " + AuthenticationUtil.getRunAsUser()));
            logger.debug((Object)("Fully authenticated " + AuthenticationUtil.getFullyAuthenticatedUser()));
        }
        ajc$this.revert(nodeRef, version, true);
    }

    static final /* synthetic */ void revert_aroundBody16(Version2ServiceImpl ajc$this, NodeRef nodeRef, Version version, boolean deep, JoinPoint joinPoint) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Run as user " + AuthenticationUtil.getRunAsUser()));
            logger.debug((Object)("Fully authenticated " + AuthenticationUtil.getFullyAuthenticatedUser()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("revert nodeRef:" + nodeRef));
        }
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"version", (Object)version);
        if (!nodeRef.getId().equals(((NodeRef)version.getVersionProperty("frozenNodeRef")).getId())) {
            throw new VersionServiceException("version_service.err_revert_mismatch");
        }
        ajc$this.policyBehaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
        try {
            TypeDefinition typeDef;
            Map oldProps = ajc$this.nodeService.getProperties(nodeRef);
            Set oldAspectQNames = ajc$this.nodeService.getAspects(nodeRef);
            QName oldNodeTypeQName = ajc$this.nodeService.getType(nodeRef);
            String currentVersionLabel = (String)((Object)ajc$this.nodeService.getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL));
            NodeRef versionNodeRef = version.getFrozenStateNodeRef();
            boolean needToRestoreDiscussion = !ajc$this.nodeService.hasAspect(versionNodeRef, ForumModel.ASPECT_DISCUSSABLE) && ajc$this.nodeService.hasAspect(nodeRef, ForumModel.ASPECT_DISCUSSABLE);
            HashMap<QName, Serializable> forumProps = null;
            Map currentVersionProp = ajc$this.nodeService.getProperties(nodeRef);
            forumProps = new HashMap<QName, Serializable>();
            for (QName key : currentVersionProp.keySet()) {
                if (!key.getNamespaceURI().equals("http://www.alfresco.org/model/forum/1.0")) continue;
                forumProps.put(key, (Serializable)currentVersionProp.get(key));
            }
            Map newProps = ajc$this.nodeService.getProperties(versionNodeRef);
            VersionUtil.convertFrozenToOriginalProps(newProps);
            Set newAspectQNames = ajc$this.nodeService.getAspects(versionNodeRef);
            QName newNodeTypeQName = ajc$this.nodeService.getType(versionNodeRef);
            VersionRevertDetailsImpl revertDetails = new VersionRevertDetailsImpl();
            revertDetails.setNodeRef(nodeRef);
            revertDetails.setNodeType(newNodeTypeQName);
            ArrayList propsToLeaveAlone = new ArrayList();
            ArrayList<Object> assocsToLeaveAlone = new ArrayList<Object>();
            if (newNodeTypeQName.equals((Object)oldNodeTypeQName) && (typeDef = ajc$this.dictionaryService.getType(oldNodeTypeQName)) != null) {
                for (QName assocName : typeDef.getAssociations().keySet()) {
                    if (ajc$this.getRevertAssocAction(oldNodeTypeQName, assocName, revertDetails) != VersionRevertCallback.RevertAssocAction.IGNORE) continue;
                    assocsToLeaveAlone.add(assocName);
                }
            }
            for (QName aspect : oldAspectQNames) {
                AspectDefinition aspectDef = ajc$this.dictionaryService.getAspect(aspect);
                if (aspectDef == null) continue;
                if (ajc$this.getRevertAspectAction(aspect, revertDetails) == VersionRevertCallback.RevertAspectAction.IGNORE) {
                    propsToLeaveAlone.addAll(aspectDef.getProperties().keySet());
                }
                for (Object assocName : aspectDef.getAssociations().keySet()) {
                    if (ajc$this.getRevertAssocAction(aspect, (QName)assocName, revertDetails) != VersionRevertCallback.RevertAssocAction.IGNORE) continue;
                    assocsToLeaveAlone.addAll(aspectDef.getAssociations().keySet());
                }
            }
            for (QName prop : propsToLeaveAlone) {
                if (!oldProps.containsKey(prop)) continue;
                newProps.put(prop, (Serializable)oldProps.get(prop));
            }
            ajc$this.nodeService.setProperties(nodeRef, newProps);
            ajc$this.nodeService.addProperties(nodeRef, forumProps);
            ajc$this.nodeService.setType(nodeRef, newNodeTypeQName);
            HashSet aspectsToRemove = new HashSet(oldAspectQNames);
            aspectsToRemove.removeAll(newAspectQNames);
            HashSet aspectsToAdd = new HashSet(newAspectQNames);
            aspectsToAdd.removeAll(oldAspectQNames);
            for (QName aspect : aspectsToAdd) {
                if (ajc$this.getRevertAspectAction(aspect, revertDetails) == VersionRevertCallback.RevertAspectAction.IGNORE) continue;
                ajc$this.nodeService.addAspect(nodeRef, aspect, null);
            }
            if (needToRestoreDiscussion) {
                HashSet<QName> ignoredAspects = new HashSet<QName>();
                for (QName aspectForCheck : aspectsToRemove) {
                    if (!aspectForCheck.getNamespaceURI().equals("http://www.alfresco.org/model/forum/1.0")) continue;
                    ignoredAspects.add(aspectForCheck);
                }
                aspectsToRemove.removeAll(ignoredAspects);
            }
            for (QName aspect : aspectsToRemove) {
                if (ajc$this.getRevertAspectAction(aspect, revertDetails) == VersionRevertCallback.RevertAspectAction.IGNORE) continue;
                ajc$this.nodeService.removeAspect(nodeRef, aspect);
            }
            if (!ajc$this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
                ajc$this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
            }
            ajc$this.nodeService.setProperty(nodeRef, ContentModel.PROP_VERSION_LABEL, (Serializable)((Object)currentVersionLabel));
            ArrayList children = new ArrayList(ajc$this.nodeService.getChildAssocs(nodeRef));
            List versionedChildren = ajc$this.nodeService.getChildAssocs(versionNodeRef);
            for (ChildAssociationRef versionedChild : versionedChildren) {
                if (!children.contains(versionedChild)) {
                    NodeRef childRef = null;
                    ChildAssociationRef assocToKeep = null;
                    if (ajc$this.nodeService.exists(versionedChild.getChildRef())) {
                        String childRefName = (String)((Object)ajc$this.nodeService.getProperty(versionedChild.getChildRef(), ContentModel.PROP_NAME));
                        childRef = ajc$this.nodeService.getChildByName(nodeRef, versionedChild.getTypeQName(), childRefName);
                        if (childRef == null) {
                            List allAssocs = ajc$this.nodeService.getParentAssocs(versionedChild.getChildRef(), (QNamePattern)versionedChild.getTypeQName(), RegexQNamePattern.MATCH_ALL);
                            for (ChildAssociationRef assocToCheck : allAssocs) {
                                if (!children.contains(assocToCheck)) continue;
                                childRef = assocToCheck.getChildRef();
                                assocToKeep = assocToCheck;
                                break;
                            }
                        }
                        if (childRef == null) {
                            childRef = ajc$this.nodeService.addChild(nodeRef, versionedChild.getChildRef(), versionedChild.getTypeQName(), versionedChild.getQName()).getChildRef();
                        }
                    } else if (versionedChild.isPrimary() && deep && ajc$this.getVersionHistoryNodeRef(versionedChild.getChildRef()) != null) {
                        childRef = ajc$this.restore(versionedChild.getChildRef(), nodeRef, versionedChild.getTypeQName(), versionedChild.getQName());
                    }
                    if (childRef == null) continue;
                    if (assocToKeep != null) {
                        children.remove(assocToKeep);
                        continue;
                    }
                    children.remove(ajc$this.nodeService.getPrimaryParent(childRef));
                    continue;
                }
                children.remove(versionedChild);
            }
            if (needToRestoreDiscussion) {
                ArrayList<ChildAssociationRef> ignoredChildren = new ArrayList<ChildAssociationRef>();
                for (ChildAssociationRef childForCheck : children) {
                    if (!childForCheck.getTypeQName().getNamespaceURI().equals("http://www.alfresco.org/model/forum/1.0")) continue;
                    ignoredChildren.add(childForCheck);
                }
                children.removeAll(ignoredChildren);
            }
            for (ChildAssociationRef ref : children) {
                if (assocsToLeaveAlone.contains(ref.getTypeQName())) continue;
                ajc$this.nodeService.removeChild(nodeRef, ref.getChildRef());
            }
            for (AssociationRef assocRef : ajc$this.nodeService.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL)) {
                if (assocsToLeaveAlone.contains(assocRef.getTypeQName())) continue;
                ajc$this.nodeService.removeAssociation(assocRef.getSourceRef(), assocRef.getTargetRef(), assocRef.getTypeQName());
            }
            for (AssociationRef versionedAssoc : ajc$this.nodeService.getTargetAssocs(versionNodeRef, RegexQNamePattern.MATCH_ALL)) {
                if (assocsToLeaveAlone.contains(versionedAssoc.getTypeQName()) || !ajc$this.nodeService.exists(versionedAssoc.getTargetRef())) continue;
                ajc$this.nodeService.createAssociation(nodeRef, versionedAssoc.getTargetRef(), versionedAssoc.getTypeQName());
            }
        }
        finally {
            ajc$this.policyBehaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
        }
        ajc$this.invokeAfterVersionRevert(nodeRef, version);
    }

    static final /* synthetic */ NodeRef restore_aroundBody18(Version2ServiceImpl ajc$this, NodeRef nodeRef, NodeRef parentNodeRef, QName assocTypeQName, QName assocQName, JoinPoint joinPoint) {
        return ajc$this.restore(nodeRef, parentNodeRef, assocTypeQName, assocQName, true);
    }

    static final /* synthetic */ NodeRef restore_aroundBody20(Version2ServiceImpl ajc$this, NodeRef nodeRef, NodeRef parentNodeRef, QName assocTypeQName, QName assocQName, boolean deep, JoinPoint joinPoint) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Run as user " + AuthenticationUtil.getRunAsUser()));
            logger.debug((Object)("Fully authenticated " + AuthenticationUtil.getFullyAuthenticatedUser()));
        }
        NodeRef restoredNodeRef = null;
        if (ajc$this.nodeService.exists(nodeRef)) {
            throw new VersionServiceException("version_service.err_restore_exists", new Object[]{nodeRef.toString()});
        }
        Version version = ajc$this.getHeadVersion(nodeRef);
        if (version == null) {
            throw new VersionServiceException("version_service.err_restore_no_version", new Object[]{nodeRef.toString()});
        }
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NODE_UUID, ((NodeRef)version.getVersionProperty("frozenNodeRef")).getId());
        props.put(ContentModel.PROP_VERSION_LABEL, version.getVersionLabel());
        QName type = ajc$this.dbNodeService.getType(VersionUtil.convertNodeRef(version.getFrozenStateNodeRef()));
        ajc$this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        try {
            restoredNodeRef = ajc$this.nodeService.createNode(parentNodeRef, assocTypeQName, assocQName, type, props).getChildRef();
        }
        finally {
            ajc$this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        }
        ajc$this.revert(restoredNodeRef, version, deep);
        return restoredNodeRef;
    }

    static final /* synthetic */ void deleteVersionHistory_aroundBody22(Version2ServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        NodeRef versionHistoryNodeRef;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Run as user " + AuthenticationUtil.getRunAsUser()));
            logger.debug((Object)("Fully authenticated " + AuthenticationUtil.getFullyAuthenticatedUser()));
        }
        if ((versionHistoryNodeRef = ajc$this.getVersionHistoryNodeRef(nodeRef)) != null) {
            try {
                ajc$this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
                ajc$this.dbNodeService.deleteNode(versionHistoryNodeRef);
                if (ajc$this.nodeService.exists(nodeRef) && ajc$this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
                    ajc$this.nodeService.setProperty(nodeRef, ContentModel.PROP_VERSION_LABEL, null);
                }
            }
            finally {
                ajc$this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_VERSIONABLE);
            }
        }
    }

    static final /* synthetic */ void deleteVersion_aroundBody24(Version2ServiceImpl ajc$this, NodeRef nodeRef, Version version, JoinPoint joinPoint) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Run as user " + AuthenticationUtil.getRunAsUser()));
            logger.debug((Object)("Fully authenticated " + AuthenticationUtil.getFullyAuthenticatedUser()));
        }
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"version", (Object)version);
        Version currentVersion = ajc$this.getCurrentVersion(nodeRef);
        ajc$this.dbNodeService.deleteNode(VersionUtil.convertNodeRef(version.getFrozenStateNodeRef()));
        if (currentVersion.getVersionLabel().equals(version.getVersionLabel())) {
            Version headVersion = ajc$this.getHeadVersion(nodeRef);
            if (headVersion != null) {
                ajc$this.policyBehaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
                try {
                    ajc$this.nodeService.setProperty(nodeRef, ContentModel.PROP_VERSION_LABEL, (Serializable)((Object)headVersion.getVersionLabel()));
                    ajc$this.revert(nodeRef, headVersion);
                }
                finally {
                    ajc$this.policyBehaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
                }
            } else {
                ajc$this.deleteVersionHistory(nodeRef);
            }
        }
    }

    static final /* synthetic */ boolean isAVersion_aroundBody26(Version2ServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Run as user " + AuthenticationUtil.getRunAsUser()));
            logger.debug((Object)("Fully authenticated " + AuthenticationUtil.getFullyAuthenticatedUser()));
        }
        NodeRef realNodeRef = nodeRef;
        if (nodeRef.getStoreRef().getProtocol().equals("versionStore")) {
            realNodeRef = VersionUtil.convertNodeRef(nodeRef);
        }
        return ajc$this.dbNodeService.hasAspect(realNodeRef, Version2Model.ASPECT_VERSION);
    }

    static final /* synthetic */ boolean isVersioned_aroundBody28(Version2ServiceImpl ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Run as user " + AuthenticationUtil.getRunAsUser()));
            logger.debug((Object)("Fully authenticated " + AuthenticationUtil.getFullyAuthenticatedUser()));
        }
        NodeRef realNodeRef = nodeRef;
        if (nodeRef.getStoreRef().getProtocol().equals("versionStore")) {
            realNodeRef = VersionUtil.convertNodeRef(nodeRef);
        }
        return ajc$this.dbNodeService.hasAspect(realNodeRef, ContentModel.ASPECT_VERSIONABLE);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Version2ServiceImpl.java", Version2ServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getVersionStoreReference", "org.alfresco.repo.version.Version2ServiceImpl", "", "", "", "org.alfresco.service.cmr.repository.StoreRef"), 129);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createVersion", "org.alfresco.repo.version.Version2ServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:java.util.Map", "nodeRef:versionProperties", "org.alfresco.service.cmr.version.ReservedVersionNameException:org.alfresco.service.cmr.repository.AspectMissingException", "org.alfresco.service.cmr.version.Version"), 142);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "restore", "org.alfresco.repo.version.Version2ServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:org.alfresco.service.cmr.repository.NodeRef:org.alfresco.service.namespace.QName:org.alfresco.service.namespace.QName:boolean", "nodeRef:parentNodeRef:assocTypeQName:assocQName:deep", "", "org.alfresco.service.cmr.repository.NodeRef"), 1352);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteVersionHistory", "org.alfresco.repo.version.Version2ServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "org.alfresco.service.cmr.repository.AspectMissingException", "void"), 1438);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteVersion", "org.alfresco.repo.version.Version2ServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:org.alfresco.service.cmr.version.Version", "nodeRef:version", "", "void"), 1477);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isAVersion", "org.alfresco.repo.version.Version2ServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "boolean"), 1524);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isVersioned", "org.alfresco.repo.version.Version2ServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "boolean"), 1542);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createVersion", "org.alfresco.repo.version.Version2ServiceImpl", "java.util.Collection:java.util.Map", "nodeRefs:versionProperties", "org.alfresco.service.cmr.version.ReservedVersionNameException:org.alfresco.service.cmr.repository.AspectMissingException", "java.util.Collection"), 170);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getVersionHistory", "org.alfresco.repo.version.Version2ServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "org.alfresco.service.cmr.version.VersionHistory"), 412);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCurrentVersion", "org.alfresco.repo.version.Version2ServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "org.alfresco.service.cmr.version.Version"), 433);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "revert", "org.alfresco.repo.version.Version2ServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "void"), 1002);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "revert", "org.alfresco.repo.version.Version2ServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:boolean", "nodeRef:deep", "", "void"), 1015);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "revert", "org.alfresco.repo.version.Version2ServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:org.alfresco.service.cmr.version.Version", "nodeRef:version", "", "void"), 1028);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "revert", "org.alfresco.repo.version.Version2ServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:org.alfresco.service.cmr.version.Version:boolean", "nodeRef:version:deep", "", "void"), 1041);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "restore", "org.alfresco.repo.version.Version2ServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:org.alfresco.service.cmr.repository.NodeRef:org.alfresco.service.namespace.QName:org.alfresco.service.namespace.QName", "nodeRef:parentNodeRef:assocTypeQName:assocQName", "", "org.alfresco.service.cmr.repository.NodeRef"), 1341);
    }
}

