/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation.site;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.SysAdminParamsImpl;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.invitation.site.InviteModeratedSender;
import org.alfresco.repo.model.Repository;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.apache.commons.lang3.StringUtils;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class InviteModeratedSenderTest
extends TestCase {
    private static final StoreRef testStore = new StoreRef("test", "test");
    private static final String requesterFirstName = "FirstName";
    private static final String requesterLastName = "LastName";
    private static final String requesterUserName = "JustAUserName";
    private static final String requesterRole = "SiteConsumer";
    private static final String requesterMail = "req@mail.alf";
    private static final NodeRef requesterNodeRef = new NodeRef(testStore, "JustAUserName");
    private static final String SiteManagerGroup = "Group_site_manager";
    private static final NodeRef emailTemplateNodeRef = new NodeRef(testStore, "emailTemplate");
    private static final String fullSiteName = "Full Site Name";
    private static final String shortSiteName = "site-name";
    private static final String packageId = testStore + "/Package";
    private final MessageService messageService = (MessageService)Mockito.mock(MessageService.class);
    private Action mailAction;
    private SiteInfo siteInfo = (SiteInfo)Mockito.mock(SiteInfo.class);
    private InviteModeratedSender inviteModeratedSender;

    public void testSendModeratedEmail() throws Exception {
        Map<String, String> properties = this.buildDefaultProperties();
        this.inviteModeratedSender.sendMail("app:company_home/app:dictionary/app:email_templates/cm:invite/cm:invite-email-moderated.html.ftl", "invitation.moderated.email.subject", properties);
        ((Action)Mockito.verify((Object)this.mailAction)).setParameterValue((String)ArgumentMatchers.eq((Object)"from"), (Serializable)ArgumentMatchers.eq((Object)requesterMail));
        ((Action)Mockito.verify((Object)this.mailAction)).setParameterValue((String)ArgumentMatchers.eq((Object)"to_many"), (Serializable)ArgumentMatchers.eq((Object)SiteManagerGroup));
        ((Action)Mockito.verify((Object)this.mailAction)).setParameterValue((String)ArgumentMatchers.eq((Object)"subject"), (Serializable)ArgumentMatchers.eq((Object)"invitation.moderated.email.subject"));
        ((Action)Mockito.verify((Object)this.mailAction)).setParameterValue((String)ArgumentMatchers.eq((Object)"subjectParams"), (Serializable)ArgumentMatchers.eq((Object)new Object[]{fullSiteName}));
        ((Action)Mockito.verify((Object)this.mailAction)).setParameterValue((String)ArgumentMatchers.eq((Object)"template"), (Serializable)ArgumentMatchers.eq((Object)emailTemplateNodeRef));
        ArgumentCaptor modelC = ArgumentCaptor.forClass(Map.class);
        ((Action)Mockito.verify((Object)this.mailAction)).setParameterValue((String)ArgumentMatchers.eq((Object)"template_model"), (Serializable)modelC.capture());
        String pendingInvitesLink = StringUtils.stripStart((String)MessageFormat.format("{0}/page/site/{1}/pending-invites", "", shortSiteName), (String)"/");
        Map model = (Map)modelC.getValue();
        InviteModeratedSenderTest.assertNotNull((Object)model);
        InviteModeratedSenderTest.assertEquals((boolean)false, (boolean)model.isEmpty());
        InviteModeratedSenderTest.assertNotNull(model.get("productName"));
        InviteModeratedSenderTest.assertEquals(model.get("inviteeName"), (Object)"FirstName LastName");
        InviteModeratedSenderTest.assertEquals(model.get("siteName"), (Object)fullSiteName);
        InviteModeratedSenderTest.assertEquals(model.get("sharePendingInvitesLink"), (Object)pendingInvitesLink);
    }

    private Map<String, String> buildDefaultProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("imwf_inviteeUserName", requesterUserName);
        properties.put("imwf_inviteeRole", requesterRole);
        properties.put("imwf_resourceName", shortSiteName);
        properties.put("bpm_groupAssignee", SiteManagerGroup);
        properties.put("imwf_resourceType", "website");
        properties.put("wf_package", packageId);
        return properties;
    }

    protected void setUp() throws Exception {
        super.setUp();
        ServiceRegistry services = this.mockServices();
        Repository repository = this.mockRepository();
        this.inviteModeratedSender = new InviteModeratedSender(services, repository, this.messageService);
    }

    private Repository mockRepository() {
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)repository.getPerson()).thenReturn((Object)requesterNodeRef);
        return repository;
    }

    private ServiceRegistry mockServices() {
        ActionService mockActionService = this.mockActionService();
        NodeService mockNodeService = this.mockNodeService();
        PersonService mockPersonService = this.mockPersonService();
        SearchService mockSearchService = this.mockSearchService();
        SiteService mockSiteService = this.mockSiteService();
        FileFolderService mockFileFolderService = this.mockFileFolderService();
        SysAdminParamsImpl sysAdminParams = new SysAdminParamsImpl();
        ServiceRegistry services = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        Mockito.when((Object)services.getActionService()).thenReturn((Object)mockActionService);
        Mockito.when((Object)services.getNodeService()).thenReturn((Object)mockNodeService);
        Mockito.when((Object)services.getPersonService()).thenReturn((Object)mockPersonService);
        Mockito.when((Object)services.getSearchService()).thenReturn((Object)mockSearchService);
        Mockito.when((Object)services.getSiteService()).thenReturn((Object)mockSiteService);
        Mockito.when((Object)services.getFileFolderService()).thenReturn((Object)mockFileFolderService);
        Mockito.when((Object)services.getSysAdminParams()).thenReturn((Object)sysAdminParams);
        return services;
    }

    private FileFolderService mockFileFolderService() {
        FileFolderService fileFolderService = (FileFolderService)Mockito.mock(FileFolderService.class);
        Mockito.when((Object)fileFolderService.getLocalizedSibling(emailTemplateNodeRef)).thenReturn((Object)emailTemplateNodeRef);
        return fileFolderService;
    }

    private SiteService mockSiteService() {
        SiteService siteService = (SiteService)Mockito.mock(SiteService.class);
        Mockito.when((Object)this.siteInfo.getTitle()).thenReturn((Object)fullSiteName);
        Mockito.when((Object)siteService.getSite(shortSiteName)).thenReturn((Object)this.siteInfo);
        return siteService;
    }

    private SearchService mockSearchService() {
        SearchService searchService = (SearchService)Mockito.mock(SearchService.class);
        ResultSet results = (ResultSet)Mockito.mock(ResultSet.class);
        List<NodeRef> nodeRefs = Arrays.asList(emailTemplateNodeRef);
        Mockito.when((Object)results.getNodeRefs()).thenReturn(nodeRefs);
        Mockito.when((Object)searchService.query((SearchParameters)ArgumentMatchers.any())).thenReturn((Object)results);
        Mockito.when((Object)searchService.selectNodes((NodeRef)ArgumentMatchers.any(), (String)ArgumentMatchers.any(String.class), (QueryParameterDefinition[])ArgumentMatchers.any(), (NamespacePrefixResolver)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false))).thenReturn(nodeRefs);
        return searchService;
    }

    private PersonService mockPersonService() {
        PersonService personService = (PersonService)Mockito.mock(PersonService.class);
        Mockito.when((Object)personService.getPerson(requesterUserName)).thenReturn((Object)requesterNodeRef);
        Mockito.when((Object)personService.getPerson(requesterNodeRef)).thenReturn((Object)new PersonService.PersonInfo(requesterNodeRef, requesterUserName, requesterFirstName, requesterLastName));
        return personService;
    }

    private NodeService mockNodeService() {
        NodeService nodeService = (NodeService)Mockito.mock(NodeService.class);
        Mockito.when((Object)nodeService.getProperty(requesterNodeRef, ContentModel.PROP_EMAIL)).thenReturn((Object)requesterMail);
        return nodeService;
    }

    private ActionService mockActionService() {
        this.mailAction = (Action)Mockito.mock(Action.class);
        ActionService actionService = (ActionService)Mockito.mock(ActionService.class);
        Mockito.when((Object)actionService.createAction("mail")).thenReturn((Object)this.mailAction);
        return actionService;
    }
}

