/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.activities.ActivityPostDAO;
import org.alfresco.repo.domain.activities.ActivityPostEntity;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.test.junitrules.AbstractPersonRule;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.GUID;

public class TemporarySites
extends AbstractPersonRule {
    private static final Log log = LogFactory.getLog(TemporarySites.class);
    private List<SiteInfo> temporarySites = new ArrayList<SiteInfo>();
    private List<String> temporarySiteUsers = new ArrayList<String>();

    public TemporarySites(ApplicationContextInit appContextRule) {
        super(appContextRule);
    }

    protected void before() throws Throwable {
    }

    protected void after() {
        final RetryingTransactionHelper transactionHelper = (RetryingTransactionHelper)this.appContextRule.getApplicationContext().getBean("retryingTransactionHelper");
        final SiteService siteService = (SiteService)this.appContextRule.getApplicationContext().getBean("siteService", SiteService.class);
        final ActivityPostDAO postDAO = (ActivityPostDAO)this.appContextRule.getApplicationContext().getBean("postDAO", ActivityPostDAO.class);
        final NodeArchiveService nodeArchiveService = (NodeArchiveService)this.appContextRule.getApplicationContext().getBean("nodeArchiveService");
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() throws Throwable {
                        for (SiteInfo site : TemporarySites.this.temporarySites) {
                            String shortName = site.getShortName();
                            if (siteService.getSite(shortName) == null) continue;
                            log.debug((Object)("Deleting temporary site " + shortName));
                            siteService.deleteSite(shortName);
                        }
                        for (String username : TemporarySites.this.temporarySiteUsers) {
                            log.debug((Object)("Deleting temporary site user " + username));
                            TemporarySites.this.deletePerson(username);
                        }
                        int deletedCnt = 0;
                        Date keepDate = new Date(System.currentTimeMillis() + 120000L);
                        ActivityPostEntity.STATUS[] sTATUSArray = ActivityPostEntity.STATUS.values();
                        int n = sTATUSArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ActivityPostEntity.STATUS status = sTATUSArray[n2];
                            deletedCnt += postDAO.deletePosts(keepDate, status);
                            ++n2;
                        }
                        log.debug((Object)("Deleted " + deletedCnt + " post feeds."));
                        return null;
                    }
                });
                transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() throws Throwable {
                        for (SiteInfo site : TemporarySites.this.temporarySites) {
                            log.debug((Object)("Purging temporary site from trashcan: " + site.getShortName()));
                            nodeArchiveService.purgeArchivedNode(nodeArchiveService.getArchivedNode(site.getNodeRef()));
                        }
                        return null;
                    }
                });
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
    }

    public void addSite(SiteInfo temporarySite) {
        this.temporarySites.add(temporarySite);
    }

    public SiteInfo createSite(String sitePreset, String siteShortName, String siteTitle, String siteDescription, SiteVisibility visibility, String siteCreator) {
        return this.createSite(sitePreset, siteShortName, siteTitle, siteDescription, visibility, SiteModel.TYPE_SITE, siteCreator);
    }

    public SiteInfo createSite(final String sitePreset, final String siteShortName, final String siteTitle, final String siteDescription, final SiteVisibility visibility, final QName siteType, String siteCreator) {
        RetryingTransactionHelper transactionHelper = (RetryingTransactionHelper)this.appContextRule.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)siteCreator);
        SiteInfo newSite = (SiteInfo)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<SiteInfo>(){

            public SiteInfo execute() throws Throwable {
                SiteService siteService = (SiteService)TemporarySites.this.appContextRule.getApplicationContext().getBean("siteService", SiteService.class);
                SiteInfo newSite = siteService.createSite(sitePreset, siteShortName, siteTitle, siteDescription, visibility, siteType);
                NodeRef docLibFolder = siteService.getContainer(siteShortName, "documentLibrary");
                if (docLibFolder == null) {
                    docLibFolder = siteService.createContainer(siteShortName, "documentLibrary", ContentModel.TYPE_FOLDER, null);
                }
                return newSite;
            }
        });
        AuthenticationUtil.popAuthentication();
        this.temporarySites.add(newSite);
        return newSite;
    }

    public TestSiteAndMemberInfo createTestSiteWithUserPerRole(final String siteShortName, String sitePreset, SiteVisibility visibility, String siteCreator) {
        SiteInfo result = this.createSite(sitePreset, siteShortName, null, null, visibility, siteCreator);
        RetryingTransactionHelper transactionHelper = (RetryingTransactionHelper)this.appContextRule.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        final SiteService siteService = (SiteService)this.appContextRule.getApplicationContext().getBean("siteService", SiteService.class);
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)siteCreator);
        List userNames = (List)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<List<String>>(){

            public List<String> execute() throws Throwable {
                ArrayList<String> users = new ArrayList<String>(4);
                for (String shareRole : SiteModel.STANDARD_PERMISSIONS) {
                    String userName = String.valueOf(siteShortName) + "_" + shareRole + "_" + GUID.generate();
                    log.debug((Object)("Creating temporary site user " + userName));
                    TemporarySites.this.createPerson(userName);
                    siteService.setMembership(siteShortName, userName, shareRole);
                    users.add(userName);
                    TemporarySites.this.temporarySiteUsers.add(userName);
                }
                return users;
            }
        });
        NodeRef doclibFolder = (NodeRef)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                return siteService.getContainer(siteShortName, "documentLibrary");
            }
        });
        AuthenticationUtil.popAuthentication();
        return new TestSiteAndMemberInfo(result, doclibFolder, (String)userNames.get(0), (String)userNames.get(1), (String)userNames.get(2), (String)userNames.get(3));
    }

    public List<String> createTestSiteWithGroups(final String siteShortName, String sitePreset, SiteVisibility visibility, String siteCreator, final int noOfGroups) {
        this.createSite(sitePreset, siteShortName, null, null, visibility, siteCreator);
        RetryingTransactionHelper transactionHelper = (RetryingTransactionHelper)this.appContextRule.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        final SiteService siteService = (SiteService)this.appContextRule.getApplicationContext().getBean("siteService", SiteService.class);
        final AuthorityService authorityService = (AuthorityService)this.appContextRule.getApplicationContext().getBean("authorityService", AuthorityService.class);
        final PersonService personService = (PersonService)this.appContextRule.getApplicationContext().getBean("personService", PersonService.class);
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)siteCreator);
        List groupIds = (List)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<List<String>>(){

            public List<String> execute() throws Throwable {
                ArrayList<String> groups = new ArrayList<String>(noOfGroups);
                int i = 0;
                while (i < noOfGroups) {
                    String shareRole = (String)SiteModel.STANDARD_PERMISSIONS.get(i % 4);
                    String groupName = "Test_Group_" + GUID.generate();
                    String userName = "Test_User_" + GUID.generate();
                    log.debug((Object)("Creating temporary site user " + userName));
                    HashMap<QName, String> properties = new HashMap<QName, String>();
                    properties.put(ContentModel.PROP_USERNAME, userName);
                    properties.put(ContentModel.PROP_FIRSTNAME, GUID.generate());
                    properties.put(ContentModel.PROP_LASTNAME, GUID.generate());
                    properties.put(ContentModel.PROP_EMAIL, String.valueOf(GUID.generate()) + "@test.com");
                    personService.createPerson(properties);
                    log.debug((Object)("Creating temporary site group " + groupName));
                    String groupId = authorityService.createAuthority(AuthorityType.GROUP, groupName);
                    authorityService.setAuthorityDisplayName(groupId, GUID.generate());
                    authorityService.addAuthority(groupId, userName);
                    siteService.setMembership(siteShortName, groupId, shareRole);
                    groups.add(userName);
                    ++i;
                }
                return groups;
            }
        });
        return groupIds;
    }

    public static class TestSiteAndMemberInfo {
        public final SiteInfo siteInfo;
        public final NodeRef doclib;
        public final String siteManager;
        public final String siteCollaborator;
        public final String siteContributor;
        public final String siteConsumer;

        public TestSiteAndMemberInfo(SiteInfo siteInfo, NodeRef siteDocLib, String siteManager, String siteCollaborator, String siteContributor, String siteConsumer) {
            this.siteInfo = siteInfo;
            this.doclib = siteDocLib;
            this.siteManager = siteManager;
            this.siteCollaborator = siteCollaborator;
            this.siteContributor = siteContributor;
            this.siteConsumer = siteConsumer;
        }
    }
}

