/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remoteticket;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.remotecredentials.PasswordCredentialsInfoImpl;
import org.alfresco.repo.remoteticket.AlfTicketRemoteAlfrescoTicketImpl;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.remoteconnector.RemoteConnectorRequest;
import org.alfresco.service.cmr.remoteconnector.RemoteConnectorService;
import org.alfresco.service.cmr.remotecredentials.BaseCredentialsInfo;
import org.alfresco.service.cmr.remotecredentials.PasswordCredentialsInfo;
import org.alfresco.service.cmr.remotecredentials.RemoteCredentialsService;
import org.alfresco.service.cmr.remoteticket.NoCredentialsFoundException;
import org.alfresco.service.cmr.remoteticket.NoSuchSystemException;
import org.alfresco.service.cmr.remoteticket.RemoteAlfrescoTicketInfo;
import org.alfresco.service.cmr.remoteticket.RemoteAlfrescoTicketService;
import org.alfresco.service.cmr.remoteticket.RemoteSystemUnavailableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class RemoteAlfrescoTicketServiceImpl
implements RemoteAlfrescoTicketService {
    private static Log logger = LogFactory.getLog(RemoteAlfrescoTicketServiceImpl.class);
    private RetryingTransactionHelper retryingTransactionHelper;
    private RemoteCredentialsService remoteCredentialsService;
    private RemoteConnectorService remoteConnectorService;
    private SimpleCache<String, String> ticketsCache;
    private Map<String, String> remoteSystemsUrls = new HashMap<String, String>();
    private Map<String, Map<String, String>> remoteSystemsReqHeaders = new HashMap<String, Map<String, String>>();

    public void setRemoteCredentialsService(RemoteCredentialsService remoteCredentialsService) {
        this.remoteCredentialsService = remoteCredentialsService;
    }

    public void setRemoteConnectorService(RemoteConnectorService remoteConnectorService) {
        this.remoteConnectorService = remoteConnectorService;
    }

    public void setTicketsCache(SimpleCache<String, String> ticketsCache) {
        this.ticketsCache = ticketsCache;
    }

    public void setRetryingTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    @Override
    public synchronized void registerRemoteSystem(String remoteSystemId, String baseUrl, Map<String, String> requestHeaders) {
        this.remoteSystemsUrls.put(remoteSystemId, baseUrl);
        this.remoteSystemsReqHeaders.put(remoteSystemId, requestHeaders);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered System " + remoteSystemId + " as " + baseUrl));
        }
    }

    protected void ensureRemoteSystemKnown(String remoteSystemId) throws NoSuchSystemException {
        String baseUrl = this.remoteSystemsUrls.get(remoteSystemId);
        if (baseUrl == null) {
            throw new NoSuchSystemException(remoteSystemId);
        }
    }

    protected PasswordCredentialsInfo ensureCredentialsFound(String remoteSystemId, BaseCredentialsInfo credentails) {
        if (credentails == null) {
            throw new NoCredentialsFoundException(remoteSystemId);
        }
        if (!(credentails instanceof PasswordCredentialsInfo)) {
            throw new AlfrescoRuntimeException("Credentials found, but of the wrong type, needed PasswordCredentialsInfo but got " + credentails);
        }
        return (PasswordCredentialsInfo)credentails;
    }

    protected String toCacheKey(String remoteSystemId, BaseCredentialsInfo credentials) {
        return String.valueOf(remoteSystemId) + "===" + credentials.getRemoteUsername();
    }

    @Override
    public BaseCredentialsInfo storeRemoteCredentials(String remoteSystemId, String username, String password) throws AuthenticationException, RemoteSystemUnavailableException, NoSuchSystemException {
        this.ensureRemoteSystemKnown(remoteSystemId);
        PasswordCredentialsInfoImpl credentials = new PasswordCredentialsInfoImpl();
        BaseCredentialsInfo existing = this.getRemoteCredentials(remoteSystemId);
        if (existing != null) {
            if (existing instanceof PasswordCredentialsInfoImpl) {
                credentials = (PasswordCredentialsInfoImpl)existing;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Updating existing credentials from " + credentials.getNodeRef()));
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Unable to update existing credentials from " + existing.getNodeRef() + ", replacing"));
                }
                this.remoteCredentialsService.deleteCredentials(existing);
                existing = null;
            }
        }
        credentials.setRemoteUsername(username);
        credentials.setRemotePassword(password);
        this.refreshTicket(remoteSystemId, credentials);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Credentials correct for " + username + " on " + remoteSystemId));
        }
        credentials.setLastAuthenticationSucceeded(true);
        if (credentials.getNodeRef() != null) {
            return this.remoteCredentialsService.updateCredentials(credentials);
        }
        return this.remoteCredentialsService.createPersonCredentials(remoteSystemId, credentials);
    }

    @Override
    public BaseCredentialsInfo getRemoteCredentials(String remoteSystemId) throws NoSuchSystemException {
        this.ensureRemoteSystemKnown(remoteSystemId);
        return this.remoteCredentialsService.getPersonCredentials(remoteSystemId);
    }

    @Override
    public boolean deleteRemoteCredentials(String remoteSystemId) throws NoSuchSystemException {
        BaseCredentialsInfo credentials = this.getRemoteCredentials(remoteSystemId);
        if (credentials == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No credentials found to delete on " + remoteSystemId));
            }
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleting credentials for " + credentials.getRemoteUsername() + " on " + remoteSystemId));
        }
        this.remoteCredentialsService.deleteCredentials(credentials);
        String cacheKey = this.toCacheKey(remoteSystemId, credentials);
        this.ticketsCache.remove((Serializable)((Object)cacheKey));
        return true;
    }

    @Override
    public RemoteAlfrescoTicketInfo getAlfrescoTicket(String remoteSystemId) throws AuthenticationException, NoCredentialsFoundException, NoSuchSystemException, RemoteSystemUnavailableException {
        this.ensureRemoteSystemKnown(remoteSystemId);
        BaseCredentialsInfo creds = this.getRemoteCredentials(remoteSystemId);
        PasswordCredentialsInfo credentials = this.ensureCredentialsFound(remoteSystemId, creds);
        String cacheKey = this.toCacheKey(remoteSystemId, credentials);
        String ticket = (String)this.ticketsCache.get((Serializable)((Object)cacheKey));
        if (ticket == null) {
            return this.refreshTicket(remoteSystemId, credentials);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cached ticket found for " + creds.getRemoteUsername() + " on " + remoteSystemId));
        }
        return new AlfTicketRemoteAlfrescoTicketImpl(ticket);
    }

    @Override
    public RemoteAlfrescoTicketInfo refetchAlfrescoTicket(String remoteSystemId) throws AuthenticationException, NoCredentialsFoundException, NoSuchSystemException, RemoteSystemUnavailableException {
        this.ensureRemoteSystemKnown(remoteSystemId);
        BaseCredentialsInfo creds = this.getRemoteCredentials(remoteSystemId);
        PasswordCredentialsInfo credentials = this.ensureCredentialsFound(remoteSystemId, creds);
        return this.refreshTicket(remoteSystemId, credentials);
    }

    protected RemoteAlfrescoTicketInfo refreshTicket(String remoteSystemId, final PasswordCredentialsInfo credentials) throws AuthenticationException, NoSuchSystemException, RemoteSystemUnavailableException {
        String baseUrl = this.remoteSystemsUrls.get(remoteSystemId);
        if (baseUrl == null) {
            throw new NoSuchSystemException(remoteSystemId);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Fetching new ticket for " + credentials.getRemoteUsername() + " on " + remoteSystemId));
        }
        JSONObject json = new JSONObject();
        json.put((Object)"username", (Object)credentials.getRemoteUsername());
        json.put((Object)"password", (Object)credentials.getRemotePassword());
        String url = String.valueOf(baseUrl) + "api/login";
        RemoteConnectorRequest request = this.remoteConnectorService.buildRequest(url, "POST");
        request.setRequestBody(json.toJSONString());
        Map<String, String> reqHeaders = this.remoteSystemsReqHeaders.get(remoteSystemId);
        if (reqHeaders != null) {
            for (Map.Entry<String, String> reqHeader : reqHeaders.entrySet()) {
                request.addRequestHeader(reqHeader.getKey(), reqHeader.getValue());
            }
        }
        String cacheKey = this.toCacheKey(remoteSystemId, credentials);
        String ticket = null;
        try {
            Object data;
            JSONObject response = this.remoteConnectorService.executeJSONRequest(request);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("JSON Ticket Response Received: " + response));
            }
            if ((data = response.get((Object)"data")) == null) {
                throw new RemoteSystemUnavailableException("Invalid JSON received: " + response);
            }
            if (!(data instanceof JSONObject)) {
                throw new RemoteSystemUnavailableException("Invalid JSON part received: " + data.getClass() + " - from: " + response);
            }
            Object ticketJSON = ((JSONObject)data).get((Object)"ticket");
            if (ticketJSON == null) {
                throw new RemoteSystemUnavailableException("Invalid JSON received, ticket missing: " + response);
            }
            if (!(ticketJSON instanceof String)) {
                throw new RemoteSystemUnavailableException("Invalid JSON part received: " + ticketJSON.getClass() + " from: " + response);
            }
            ticket = (String)ticketJSON;
        }
        catch (IOException ioEx) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Problem communicating with remote Alfresco instance " + remoteSystemId), (Throwable)ioEx);
            }
            throw new RemoteSystemUnavailableException("Error talking to remote system", ioEx);
        }
        catch (ParseException jsonEx) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invalid JSON from remote Alfresco instance " + remoteSystemId), (Throwable)jsonEx);
            }
            throw new RemoteSystemUnavailableException("Invalid JSON response from remote system", jsonEx);
        }
        catch (AuthenticationException authEx) {
            if (credentials.getNodeRef() != null && credentials.getLastAuthenticationSucceeded()) {
                this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    @Override
                    public Void execute() {
                        RemoteAlfrescoTicketServiceImpl.this.remoteCredentialsService.updateCredentialsAuthenticationSucceeded(false, credentials);
                        return null;
                    }
                }, false, true);
            }
            this.ticketsCache.remove((Serializable)((Object)cacheKey));
            throw authEx;
        }
        this.ticketsCache.put((Serializable)((Object)cacheKey), (Object)ticket);
        if (!credentials.getLastAuthenticationSucceeded()) {
            this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() {
                    RemoteAlfrescoTicketServiceImpl.this.remoteCredentialsService.updateCredentialsAuthenticationSucceeded(true, credentials);
                    return null;
                }
            }, false, true);
        }
        return new AlfTicketRemoteAlfrescoTicketImpl(ticket);
    }
}

