/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.bundle;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.alfresco.repo.version.VersionServicePolicies;
import org.alfresco.repo.version.common.VersionImpl;
import org.alfresco.repo.version.traitextender.VersionServiceExtension;
import org.alfresco.repo.version.traitextender.VersionServiceTrait;
import org.alfresco.repo.virtual.ref.GetParentReferenceMethod;
import org.alfresco.repo.virtual.ref.NodeProtocol;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.store.VirtualStore;
import org.alfresco.service.cmr.repository.AspectMissingException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.version.ReservedVersionNameException;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.namespace.QName;
import org.alfresco.traitextender.SpringBeanExtension;

public class VirtualVersionServiceExtension
extends SpringBeanExtension<VersionServiceExtension, VersionServiceTrait>
implements VersionServiceExtension {
    private VirtualStore smartStore;

    public VirtualVersionServiceExtension() {
        super(VersionServiceTrait.class);
    }

    public void setSmartStore(VirtualStore smartStore) {
        this.smartStore = smartStore;
    }

    @Override
    public StoreRef getVersionStoreReference() {
        return ((VersionServiceTrait)this.getTrait()).getVersionStoreReference();
    }

    @Override
    public boolean isAVersion(NodeRef nodeRef) {
        VersionServiceTrait theTrait = (VersionServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference == null) {
            return theTrait.isAVersion(nodeRef);
        }
        NodeRef materialNode = this.smartStore.materialize(reference);
        return theTrait.isAVersion(materialNode);
    }

    @Override
    public boolean isVersioned(NodeRef nodeRef) {
        VersionServiceTrait theTrait = (VersionServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference == null) {
            return theTrait.isVersioned(nodeRef);
        }
        NodeRef materialNode = this.smartStore.materialize(reference);
        return theTrait.isVersioned(materialNode);
    }

    private Version materializeVersionIfReference(Version virtualVersion) {
        NodeRef frozenStateNodeRef = virtualVersion.getFrozenStateNodeRef();
        StoreRef frozenStoreRef = frozenStateNodeRef.getStoreRef();
        NodeRef materialFrozenNodeRef = frozenStateNodeRef;
        Reference frozenReference = Reference.fromNodeRef(frozenStateNodeRef);
        if (frozenReference != null) {
            materialFrozenNodeRef = this.smartStore.materialize(frozenReference);
        }
        Map<String, Serializable> virtualProperties = virtualVersion.getVersionProperties();
        HashMap<String, Serializable> actualProperties = new HashMap<String, Serializable>(virtualProperties);
        if (frozenStoreRef.getIdentifier().equals("version2Store")) {
            NodeRef propFrozenNode;
            NodeRef propActualFrozenNode = propFrozenNode = (NodeRef)virtualProperties.get("frozenNodeRef");
            Reference propFrozenReference = Reference.fromNodeRef(propFrozenNode);
            if (propFrozenReference != null) {
                propActualFrozenNode = this.smartStore.materialize(propFrozenReference);
            }
            actualProperties.put("frozenNodeRef", (Serializable)propActualFrozenNode);
        } else if (frozenStoreRef.getIdentifier().equals("lightWeightVersionStore")) {
            NodeRef propFrozenNode;
            String frozenNodeStoreProtocol = (String)((Object)virtualProperties.get("frozenNodeStoreProtocol"));
            String frozenNodeStoreId = (String)((Object)virtualProperties.get("frozenNodeStoreId"));
            String frozenNodeId = (String)((Object)virtualProperties.get("frozenNodeId"));
            NodeRef propActualFrozenNode = propFrozenNode = new NodeRef(frozenNodeStoreProtocol, frozenNodeStoreId, frozenNodeId);
            Reference propFrozenReference = Reference.fromNodeRef(propFrozenNode);
            if (propFrozenReference != null) {
                propActualFrozenNode = this.smartStore.materialize(propFrozenReference);
            }
            StoreRef propActualStoreRef = propFrozenNode.getStoreRef();
            actualProperties.put("frozenNodeStoreProtocol", (Serializable)((Object)propActualStoreRef.getProtocol()));
            actualProperties.put("frozenNodeStoreId", (Serializable)((Object)propActualStoreRef.getIdentifier()));
            actualProperties.put("frozenNodeId", (Serializable)((Object)propActualFrozenNode.getId()));
        }
        VersionImpl actualVersion = new VersionImpl(actualProperties, materialFrozenNodeRef);
        return actualVersion;
    }

    private Version virtualizeVersion(Reference versionedReference, Version actualVersion) {
        if (actualVersion == null) {
            return null;
        }
        NodeRef frozenStateNodeRef = actualVersion.getFrozenStateNodeRef();
        StoreRef frozenStoreRef = frozenStateNodeRef.getStoreRef();
        Reference parentReference = versionedReference.execute(new GetParentReferenceMethod());
        Reference virtualFrozenReference = NodeProtocol.newReference(frozenStateNodeRef, parentReference);
        Map<String, Serializable> properties = actualVersion.getVersionProperties();
        HashMap<String, Serializable> virtualProperties = new HashMap<String, Serializable>(properties);
        if (frozenStoreRef.getIdentifier().equals("version2Store")) {
            NodeRef propFrozenNodeRef = (NodeRef)virtualProperties.get("frozenNodeRef");
            Reference virtualPropFrozenReference = NodeProtocol.newReference(propFrozenNodeRef, parentReference);
            virtualProperties.put("frozenNodeRef", (Serializable)virtualPropFrozenReference.toNodeRef(propFrozenNodeRef.getStoreRef()));
        } else if (frozenStoreRef.getIdentifier().equals("lightWeightVersionStore")) {
            String frozenNodeStoreProtocol = (String)virtualProperties.get("frozenNodeStoreProtocol");
            String frozenNodeStoreId = (String)virtualProperties.get("frozenNodeStoreId");
            String frozenNodeId = (String)virtualProperties.get("frozenNodeId");
            StoreRef propFrozenStoreRef = new StoreRef(frozenNodeStoreProtocol, frozenNodeStoreId);
            NodeRef propFrozenNode = new NodeRef(propFrozenStoreRef, frozenNodeId);
            Reference virtualPropFrozenReference = NodeProtocol.newReference(propFrozenNode, parentReference);
            NodeRef virtualPropFrozenNodeRef = virtualPropFrozenReference.toNodeRef(propFrozenStoreRef);
            virtualProperties.put("frozenNodeStoreProtocol", (Serializable)((Object)propFrozenStoreRef.getProtocol()));
            virtualProperties.put("frozenNodeStoreId", (Serializable)((Object)propFrozenStoreRef.getIdentifier()));
            virtualProperties.put("frozenNodeId", (Serializable)((Object)virtualPropFrozenNodeRef.getId()));
        }
        return new VersionImpl(virtualProperties, virtualFrozenReference.toNodeRef(frozenStateNodeRef.getStoreRef()));
    }

    private Collection<Version> virtualizeVersions(Reference versionedReference, Collection<Version> actualVersions) {
        LinkedList<Version> virtualizedVersions = new LinkedList<Version>();
        for (Version actualVersion : actualVersions) {
            Version virtualizedVersion = this.virtualizeVersion(versionedReference, actualVersion);
            virtualizedVersions.add(virtualizedVersion);
        }
        return virtualizedVersions;
    }

    @Override
    public Version createVersion(NodeRef nodeRef, Map<String, Serializable> versionProperties) throws ReservedVersionNameException, AspectMissingException {
        VersionServiceTrait theTrait = (VersionServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference == null) {
            return theTrait.createVersion(nodeRef, versionProperties);
        }
        NodeRef materialNode = this.smartStore.materializeIfPossible(nodeRef);
        Version actualVersion = theTrait.createVersion(materialNode, versionProperties);
        return this.virtualizeVersion(reference, actualVersion);
    }

    @Override
    public Collection<Version> createVersion(NodeRef nodeRef, Map<String, Serializable> versionProperties, boolean versionChildren) throws ReservedVersionNameException, AspectMissingException {
        VersionServiceTrait theTrait = (VersionServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference == null) {
            return theTrait.createVersion(nodeRef, versionProperties, versionChildren);
        }
        NodeRef materialNode = this.smartStore.materializeIfPossible(nodeRef);
        Collection<Version> actualVersions = theTrait.createVersion(materialNode, versionProperties, versionChildren);
        return this.virtualizeVersions(reference, actualVersions);
    }

    @Override
    public Collection<Version> createVersion(Collection<NodeRef> nodeRefs, Map<String, Serializable> versionProperties) throws ReservedVersionNameException, AspectMissingException {
        VersionServiceTrait theTrait = (VersionServiceTrait)this.getTrait();
        LinkedList<NodeRef> materialNodeRefs = new LinkedList<NodeRef>();
        HashMap<NodeRef, Reference> materializedNodeRefs = new HashMap<NodeRef, Reference>();
        for (NodeRef nodeRef : nodeRefs) {
            Reference reference = Reference.fromNodeRef(nodeRef);
            if (reference == null) {
                materialNodeRefs.add(nodeRef);
                continue;
            }
            NodeRef materialNode = this.smartStore.materializeIfPossible(nodeRef);
            materialNodeRefs.add(materialNode);
            materializedNodeRefs.put(materialNode, reference);
        }
        Collection<Version> versions = theTrait.createVersion(materialNodeRefs, versionProperties);
        LinkedList<Version> virtualizedVersions = new LinkedList<Version>();
        for (Version version : versions) {
            NodeRef versionedNodeRef = version.getVersionedNodeRef();
            Reference reference = (Reference)materializedNodeRefs.get(versionedNodeRef);
            if (reference != null) {
                Version virtualizedVersion = this.virtualizeVersion(reference, version);
                virtualizedVersions.add(virtualizedVersion);
                continue;
            }
            virtualizedVersions.add(version);
        }
        return virtualizedVersions;
    }

    @Override
    public VersionHistory getVersionHistory(NodeRef nodeRef) throws AspectMissingException {
        VersionServiceTrait theTrait = (VersionServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference == null) {
            return theTrait.getVersionHistory(nodeRef);
        }
        NodeRef materialNode = this.smartStore.materialize(reference);
        VersionHistory actualVersionHistory = theTrait.getVersionHistory(materialNode);
        if (actualVersionHistory == null) {
            return null;
        }
        Reference versionedReference = Reference.fromNodeRef(nodeRef);
        return new VirtualVersionHistory(versionedReference, actualVersionHistory);
    }

    @Override
    public Version getCurrentVersion(NodeRef nodeRef) {
        VersionServiceTrait theTrait = (VersionServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference == null) {
            return theTrait.getCurrentVersion(nodeRef);
        }
        NodeRef materialNode = this.smartStore.materialize(reference);
        Reference versionedReference = Reference.fromNodeRef(nodeRef);
        Version actualVersion = theTrait.getCurrentVersion(materialNode);
        return this.virtualizeVersion(versionedReference, actualVersion);
    }

    @Override
    public void revert(NodeRef nodeRef) {
        VersionServiceTrait theTrait = (VersionServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference == null) {
            theTrait.revert(nodeRef);
        } else {
            NodeRef materialNode = this.smartStore.materialize(reference);
            theTrait.revert(materialNode);
        }
    }

    @Override
    public void revert(NodeRef nodeRef, boolean deep) {
        VersionServiceTrait theTrait = (VersionServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference == null) {
            theTrait.revert(nodeRef, deep);
        } else {
            NodeRef materialNode = this.smartStore.materialize(reference);
            theTrait.revert(materialNode, deep);
        }
    }

    @Override
    public void revert(NodeRef nodeRef, Version version) {
        VersionServiceTrait theTrait = (VersionServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference == null) {
            theTrait.revert(nodeRef, version);
        } else {
            NodeRef materialNode = this.smartStore.materialize(reference);
            Version actualVersion = this.materializeVersionIfReference(version);
            theTrait.revert(materialNode, actualVersion);
        }
    }

    @Override
    public void revert(NodeRef nodeRef, Version version, boolean deep) {
        VersionServiceTrait theTrait = (VersionServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference == null) {
            theTrait.revert(nodeRef, version, deep);
        } else {
            NodeRef materialNode = this.smartStore.materialize(reference);
            Version actualVersion = this.materializeVersionIfReference(version);
            theTrait.revert(materialNode, actualVersion, deep);
        }
    }

    @Override
    public NodeRef restore(NodeRef nodeRef, NodeRef parentNodeRef, QName assocTypeQName, QName assocQName) {
        VersionServiceTrait theTrait = (VersionServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference == null) {
            return theTrait.restore(nodeRef, parentNodeRef, assocTypeQName, assocQName);
        }
        NodeRef materialNode = this.smartStore.materialize(reference);
        return theTrait.restore(materialNode, parentNodeRef, assocTypeQName, assocQName);
    }

    @Override
    public NodeRef restore(NodeRef nodeRef, NodeRef parentNodeRef, QName assocTypeQName, QName assocQName, boolean deep) {
        VersionServiceTrait theTrait = (VersionServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference == null) {
            return theTrait.restore(nodeRef, parentNodeRef, assocTypeQName, assocQName, deep);
        }
        NodeRef materialNode = this.smartStore.materialize(reference);
        return theTrait.restore(materialNode, parentNodeRef, assocTypeQName, assocQName, deep);
    }

    @Override
    public void deleteVersionHistory(NodeRef nodeRef) throws AspectMissingException {
        VersionServiceTrait theTrait = (VersionServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference == null) {
            theTrait.deleteVersionHistory(nodeRef);
        } else {
            NodeRef materialNode = this.smartStore.materialize(reference);
            theTrait.deleteVersionHistory(materialNode);
        }
    }

    @Override
    public void deleteVersion(NodeRef nodeRef, Version version) {
        VersionServiceTrait theTrait = (VersionServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference == null) {
            theTrait.deleteVersion(nodeRef, version);
        } else {
            NodeRef materialNode = this.smartStore.materialize(reference);
            Version actualVersion = this.materializeVersionIfReference(version);
            theTrait.deleteVersion(materialNode, actualVersion);
        }
    }

    @Override
    public void ensureVersioningEnabled(NodeRef nodeRef, Map<QName, Serializable> versionProperties) {
        VersionServiceTrait theTrait = (VersionServiceTrait)this.getTrait();
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference == null) {
            theTrait.ensureVersioningEnabled(nodeRef, versionProperties);
        } else {
            NodeRef materialNode = this.smartStore.materialize(reference);
            theTrait.ensureVersioningEnabled(materialNode, versionProperties);
        }
    }

    @Override
    public void registerVersionLabelPolicy(QName typeQName, VersionServicePolicies.CalculateVersionLabelPolicy policy) {
        ((VersionServiceTrait)this.getTrait()).registerVersionLabelPolicy(typeQName, policy);
    }

    public class VirtualVersionHistory
    implements VersionHistory {
        private static final long serialVersionUID = 2640439550254763191L;
        private Reference versionedReference;
        private VersionHistory actualHistory;

        public VirtualVersionHistory(Reference versionedReference, VersionHistory actualHistory) {
            this.versionedReference = versionedReference;
            this.actualHistory = actualHistory;
        }

        @Override
        public Version getRootVersion() {
            Version actualRootVersion = this.actualHistory.getRootVersion();
            return VirtualVersionServiceExtension.this.virtualizeVersion(this.versionedReference, actualRootVersion);
        }

        @Override
        public Version getHeadVersion() {
            Version actualHeadVersion = this.actualHistory.getRootVersion();
            return VirtualVersionServiceExtension.this.virtualizeVersion(this.versionedReference, actualHeadVersion);
        }

        @Override
        public Collection<Version> getAllVersions() {
            Collection<Version> allActualVersions = this.actualHistory.getAllVersions();
            return VirtualVersionServiceExtension.this.virtualizeVersions(this.versionedReference, allActualVersions);
        }

        @Override
        public Version getPredecessor(Version version) {
            Version actualVersion = VirtualVersionServiceExtension.this.materializeVersionIfReference(version);
            Version actualPredecesor = this.actualHistory.getPredecessor(actualVersion);
            return VirtualVersionServiceExtension.this.virtualizeVersion(this.versionedReference, actualPredecesor);
        }

        @Override
        public Collection<Version> getSuccessors(Version version) {
            Version actualVersion = VirtualVersionServiceExtension.this.materializeVersionIfReference(version);
            Collection<Version> actualSuccessors = this.actualHistory.getSuccessors(actualVersion);
            return VirtualVersionServiceExtension.this.virtualizeVersions(this.versionedReference, actualSuccessors);
        }

        @Override
        public Version getVersion(String versionLabel) {
            Version actualVersion = this.actualHistory.getVersion(versionLabel);
            return VirtualVersionServiceExtension.this.virtualizeVersion(this.versionedReference, actualVersion);
        }
    }
}

