/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.template;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.virtual.ActualEnvironmentException;
import org.alfresco.repo.virtual.VirtualContext;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.RepositoryResource;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.ResourceProcessingError;
import org.alfresco.repo.virtual.ref.ResourceProcessor;
import org.alfresco.repo.virtual.template.FilingRule;
import org.alfresco.repo.virtual.template.NullFilingRule;
import org.alfresco.repo.virtual.template.TemplateFilingRule;
import org.alfresco.repo.virtual.template.VirtualFolderDefinition;
import org.alfresco.repo.virtual.template.VirtualQuery;
import org.alfresco.repo.virtual.template.VirtualQueryImpl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.ParameterCheck;

public class TemplateResourceProcessor
implements ResourceProcessor<VirtualFolderDefinition> {
    private static final String ID_KEY = "id";
    private static final String NAME_KEY = "name";
    private static final String DESCRIPTION_KEY = "description";
    private static final String NODES_KEY = "nodes";
    private static final String SEARCH_KEY = "search";
    private static final String LANGUAGE_KEY = "language";
    private static final String QUERY_KEY = "query";
    private static final String STORE_KEY = "store";
    private static final String FILING_KEY = "filing";
    private static final String CLASSIFICATION_KEY = "classification";
    private static final String TYPE_KEY = "type";
    private static final String ASPECTS_KEY = "aspects";
    private static final String PROPERTIES_KEY = "properties";
    private static final String PATH_KEY = "path";
    private VirtualContext context;

    public TemplateResourceProcessor(VirtualContext context) {
        this.context = context;
    }

    @Override
    public VirtualFolderDefinition process(Resource resource) throws ResourceProcessingError {
        ParameterCheck.mandatory((String)"resource", (Object)resource);
        if (resource instanceof ClasspathResource) {
            return this.process((ClasspathResource)resource);
        }
        if (resource instanceof RepositoryResource) {
            return this.process((RepositoryResource)resource);
        }
        throw new ResourceProcessingError("Unsupported resource class " + resource.getClass());
    }

    @Override
    public VirtualFolderDefinition process(ClasspathResource classpath) throws ResourceProcessingError {
        try {
            Object result = this.context.getActualEnviroment().executeScript(classpath.getClasspath(), this.createScriptParameters(this.context));
            return this.asVirtualStructure(this.context, (Map)result);
        }
        catch (ActualEnvironmentException e) {
            throw new ResourceProcessingError(e);
        }
    }

    @Override
    public VirtualFolderDefinition process(RepositoryResource repositoryResource) throws ResourceProcessingError {
        try {
            NodeRef templateNodeRef = repositoryResource.getLocation().asNodeRef(this.context.getActualEnviroment());
            Object result = this.context.getActualEnviroment().executeScript(templateNodeRef, this.createScriptParameters(this.context));
            return this.asVirtualStructure(this.context, (Map)result);
        }
        catch (ActualEnvironmentException e) {
            throw new ResourceProcessingError(e);
        }
    }

    protected Map<String, Object> createScriptParameters(VirtualContext context) throws ActualEnvironmentException {
        Map<String, Object> parameters = context.getParameters();
        Object scriptContext = context.getActualEnviroment().createScriptVirtualContext(context);
        parameters.put("context", scriptContext);
        return parameters;
    }

    protected FilingRule asFilingRule(VirtualContext context, Object filing) throws ResourceProcessingError {
        Map<String, String> properties;
        if (filing == null) {
            return null;
        }
        Map filingMap = (Map)filing;
        if (filingMap.isEmpty()) {
            return null;
        }
        String path = (String)filingMap.get(PATH_KEY);
        Map classificationMap = (Map)filingMap.get(CLASSIFICATION_KEY);
        String type = null;
        List aspects = null;
        if (classificationMap != null) {
            type = (String)classificationMap.get(TYPE_KEY);
            aspects = (List)classificationMap.get(ASPECTS_KEY);
        }
        if (aspects == null) {
            aspects = Collections.emptyList();
        }
        if ((properties = (Map<String, String>)filingMap.get(PROPERTIES_KEY)) == null) {
            properties = Collections.emptyMap();
        }
        if (path == null && type == null && aspects.isEmpty() && properties.isEmpty()) {
            return new NullFilingRule(context.getActualEnviroment());
        }
        return new TemplateFilingRule(context.getActualEnviroment(), path, type, new HashSet<String>(aspects), properties);
    }

    protected VirtualQuery asVirtualQuery(VirtualContext context, Map<String, Object> search) throws ResourceProcessingError {
        if (search == null) {
            return null;
        }
        Map<String, Object> mapSearch = search;
        String language = (String)mapSearch.get(LANGUAGE_KEY);
        String store = (String)mapSearch.get(STORE_KEY);
        String query = (String)mapSearch.get(QUERY_KEY);
        return new VirtualQueryImpl(store, language, query);
    }

    protected VirtualFolderDefinition asVirtualStructure(VirtualContext context, Map<String, Object> result) throws ResourceProcessingError {
        try {
            Map<String, Object> mapResult = result;
            VirtualFolderDefinition virtualStructure = new VirtualFolderDefinition();
            String id = (String)mapResult.get(ID_KEY);
            virtualStructure.setId(id);
            String name = (String)mapResult.get(NAME_KEY);
            virtualStructure.setName(name);
            String description = (String)mapResult.get(DESCRIPTION_KEY);
            virtualStructure.setDescription(description);
            VirtualQuery virtualQuery = this.asVirtualQuery(context, (Map)mapResult.get(SEARCH_KEY));
            virtualStructure.setQuery(virtualQuery);
            FilingRule filingRule = this.asFilingRule(context, mapResult.get(FILING_KEY));
            if (filingRule == null) {
                filingRule = new NullFilingRule(context.getActualEnviroment());
            }
            virtualStructure.setFilingRule(filingRule);
            Map<String, String> properties = (Map<String, String>)mapResult.get(PROPERTIES_KEY);
            if (properties == null) {
                properties = Collections.emptyMap();
            }
            virtualStructure.setProperties(properties);
            List nodes = (List)mapResult.get(NODES_KEY);
            if (nodes != null) {
                for (Map node : nodes) {
                    VirtualFolderDefinition child = this.asVirtualStructure(context, node);
                    virtualStructure.addChild(child);
                }
            }
            return virtualStructure;
        }
        catch (ClassCastException e) {
            throw new ResourceProcessingError(e);
        }
    }
}

