/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.executer.SpecialiseTypeActionExecuter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.GUID;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.transaction.annotation.Transactional;

@Category(value={BaseSpringTestsCategory.class})
@Transactional
public class SpecialiseTypeActionExecuterTest
extends BaseAlfrescoSpringTest {
    private static final String ID = GUID.generate();
    private SpecialiseTypeActionExecuter executer;
    private NodeRef nodeRef1;
    private NodeRef nodeRef2;
    private NodeRef nodeRef3;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.nodeRef1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeRef2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeRef3 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        this.executer = (SpecialiseTypeActionExecuter)this.applicationContext.getBean("specialise-type");
    }

    @Test
    public void testExecution() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        ActionImpl action = this.checkActionToChangeNodeType(this.nodeRef1);
        this.checkActionAgainAndExpectTypeToChange(action, this.nodeRef1);
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        action = this.checkActionToChangeNodeType(this.nodeRef2);
        this.checkActionAgainAndExpectTypeToChange(action, this.nodeRef2);
        String userName = "bob" + GUID.generate();
        this.createUser(userName);
        PermissionService permissionService = (PermissionService)this.applicationContext.getBean("PermissionService");
        permissionService.setPermission(this.nodeRef3, userName, "Coordinator", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)userName);
        ActionImpl action2 = this.checkActionToChangeNodeType(this.nodeRef3);
        try {
            action2.setParameterValue("type-name", (Serializable)ContentModel.TYPE_DICTIONARY_MODEL);
            this.executer.execute((Action)action2, this.nodeRef3);
            SpecialiseTypeActionExecuterTest.fail((String)"The creation should NOT succeed because the code is not executed but Admin or System user/role");
        }
        catch (InvalidTypeException invalidTypeException) {}
    }

    private void checkActionAgainAndExpectTypeToChange(ActionImpl action, NodeRef nodeRef) {
        action.setParameterValue("type-name", (Serializable)ContentModel.TYPE_DICTIONARY_MODEL);
        this.executer.execute((Action)action, nodeRef);
        SpecialiseTypeActionExecuterTest.assertEquals((Object)ContentModel.TYPE_DICTIONARY_MODEL, (Object)this.nodeService.getType(nodeRef));
    }

    private ActionImpl checkActionToChangeNodeType(NodeRef nodeRef) {
        SpecialiseTypeActionExecuterTest.assertEquals((Object)ContentModel.TYPE_CONTENT, (Object)this.nodeService.getType(nodeRef));
        ActionImpl action = new ActionImpl(null, ID, "specialise-type", null);
        action.setParameterValue("type-name", (Serializable)ContentModel.TYPE_FOLDER);
        this.executer.execute((Action)action, nodeRef);
        SpecialiseTypeActionExecuterTest.assertEquals((Object)ContentModel.TYPE_CONTENT, (Object)this.nodeService.getType(nodeRef));
        return action;
    }
}

