/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.qname;

import junit.framework.TestCase;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.testing.category.DBTests;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class, DBTests.class})
public class QNameDAOTest
extends TestCase {
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private QNameDAO qnameDAO;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.qnameDAO = (QNameDAO)this.ctx.getBean("qnameDAO");
    }

    private Pair<Long, String> getNamespace(final String uri, final boolean autoCreate, boolean expectSuccess) {
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>>(){

            public Pair<Long, String> execute() throws Throwable {
                Pair namespacePair = null;
                namespacePair = autoCreate ? QNameDAOTest.this.qnameDAO.getOrCreateNamespace(uri) : QNameDAOTest.this.qnameDAO.getNamespace(uri);
                return namespacePair;
            }
        };
        try {
            return (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, !autoCreate, false);
        }
        catch (Throwable e) {
            if (expectSuccess) {
                throw new RuntimeException("Expected to get namespace '" + uri + "'.", e);
            }
            return null;
        }
    }

    private Pair<Long, QName> getQName(final QName qname, final boolean autoCreate, boolean expectSuccess) {
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, QName>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, QName>>(){

            public Pair<Long, QName> execute() throws Throwable {
                Pair qnamePair = null;
                qnamePair = autoCreate ? QNameDAOTest.this.qnameDAO.getOrCreateQName(qname) : QNameDAOTest.this.qnameDAO.getQName(qname);
                return qnamePair;
            }
        };
        try {
            return (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, !autoCreate, false);
        }
        catch (Throwable e) {
            if (expectSuccess) {
                throw new RuntimeException("Expected to get qname '" + qname + "'.", e);
            }
            return null;
        }
    }

    public void testCreateNamespace() throws Exception {
        String uri = GUID.generate();
        Pair<Long, String> namespacePair = this.getNamespace(uri, true, true);
        Pair<Long, String> namespacePairCheck = this.getNamespace((String)namespacePair.getSecond(), false, true);
        QNameDAOTest.assertEquals((String)"Namespace ID changed", (Object)namespacePair.getFirst(), (Object)namespacePairCheck.getFirst());
        this.getNamespace(uri, true, false);
    }

    public void testCreateNamespaceEmpty() throws Exception {
        String uri = "";
        Pair<Long, String> namespacePair = this.getNamespace(uri, true, true);
        Pair<Long, String> namespacePairCheck = this.getNamespace((String)namespacePair.getSecond(), false, true);
        QNameDAOTest.assertEquals((String)"Namespace ID changed", (Object)namespacePair.getFirst(), (Object)namespacePairCheck.getFirst());
    }

    public void testUpdateNamespace() throws Exception {
        final String uri = GUID.generate();
        Pair<Long, String> namespacePair = this.getNamespace(uri, true, true);
        QName qnameOld = QName.createQName((String)uri, (String)GUID.generate());
        this.getQName(qnameOld, true, true);
        final String uri2 = GUID.generate();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                QNameDAOTest.this.qnameDAO.updateNamespace(uri, uri2);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        this.getQName(qnameOld, false, false);
        QName qnameNew = QName.createQName((String)uri2, (String)qnameOld.getLocalName());
        this.getQName(qnameNew, false, true);
        Pair<Long, String> namespacePairAgain = this.getNamespace(uri, true, true);
        QNameDAOTest.assertNotSame((String)"Should have a new namespace ID", (Object)namespacePair.getFirst(), (Object)namespacePairAgain.getFirst());
    }

    public void testCreateQName() throws Exception {
        QName qname = QName.createQName((String)this.getName(), (String)GUID.generate());
        Pair<Long, QName> qnamePair = this.getQName(qname, true, true);
        Pair<Long, QName> qnamePairCheck = this.getQName((QName)qnamePair.getSecond(), false, true);
        QNameDAOTest.assertEquals((String)"QName ID changed", (Object)qnamePair.getFirst(), (Object)qnamePairCheck.getFirst());
        this.getQName(qname, true, false);
    }

    public void testUpdateQName() throws Exception {
        final QName qnameOld = QName.createQName((String)GUID.generate(), (String)GUID.generate());
        Pair<Long, QName> qnamePairOld = this.getQName(qnameOld, true, true);
        final QName qnameNew = QName.createQName((String)GUID.generate(), (String)GUID.generate());
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, QName>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, QName>>(){

            public Pair<Long, QName> execute() throws Throwable {
                return QNameDAOTest.this.qnameDAO.updateQName(qnameOld, qnameNew);
            }
        };
        Pair qnamePairNew = (Pair)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        QNameDAOTest.assertEquals((String)"New QName is incorrect", (Object)qnameNew, (Object)qnamePairNew.getSecond());
        QNameDAOTest.assertEquals((String)"ID did not remain the same", (Object)qnamePairOld.getFirst(), (Object)qnamePairNew.getFirst());
        this.getQName(qnameOld, false, false);
        this.getQName(qnameNew, false, true);
    }

    public void testDeleteQName() throws Exception {
        final QName qname = QName.createQName((String)GUID.generate(), (String)GUID.generate());
        this.getQName(qname, true, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                QNameDAOTest.this.qnameDAO.deleteQName(qname);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
        this.getQName(qname, false, false);
    }
}

