/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.locks.ibatis;

import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.domain.locks.AbstractLockDAOImpl;
import org.alfresco.repo.domain.locks.LockEntity;
import org.alfresco.repo.domain.locks.LockResourceEntity;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.dao.ConcurrencyFailureException;

public class LockDAOImpl
extends AbstractLockDAOImpl {
    private static final String SELECT_LOCKRESOURCE_BY_QNAME = "alfresco.lock.select_LockResourceByQName";
    private static final String SELECT_LOCK_BY_ID = "alfresco.lock.select_LockByID";
    private static final String SELECT_LOCK_BY_KEY = "alfresco.lock.select_LockByKey";
    private static final String SELECT_LOCK_BY_SHARED_IDS = "alfresco.lock.select_LockBySharedIds";
    private static final String INSERT_LOCKRESOURCE = "alfresco.lock.insert.insert_LockResource";
    private static final String INSERT_LOCK = "alfresco.lock.insert.insert_Lock";
    private static final String UPDATE_LOCK = "alfresco.lock.update_Lock";
    private static final String UPDATE_EXCLUSIVE_LOCK = "alfresco.lock.update_ExclusiveLock";
    private SqlSessionTemplate template;

    public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.template = sqlSessionTemplate;
    }

    @Override
    protected LockResourceEntity getLockResource(Long qnameNamespaceId, String qnameLocalName) {
        LockResourceEntity lockResource = new LockResourceEntity();
        lockResource.setQnameNamespaceId(qnameNamespaceId);
        lockResource.setQnameLocalName(qnameLocalName == null ? null : qnameLocalName.toLowerCase());
        lockResource = (LockResourceEntity)this.template.selectOne(SELECT_LOCKRESOURCE_BY_QNAME, (Object)lockResource);
        return lockResource;
    }

    @Override
    protected LockResourceEntity createLockResource(Long qnameNamespaceId, String qnameLocalName) {
        LockResourceEntity lockResource = new LockResourceEntity();
        lockResource.setVersion(LockEntity.CONST_LONG_ZERO);
        lockResource.setQnameNamespaceId(qnameNamespaceId);
        lockResource.setQnameLocalName(qnameLocalName == null ? null : qnameLocalName.toLowerCase());
        this.template.insert(INSERT_LOCKRESOURCE, (Object)lockResource);
        return lockResource;
    }

    @Override
    protected List<LockEntity> getLocksBySharedResourceIds(List<Long> sharedLockResourceIds) {
        List locks = this.template.selectList(SELECT_LOCK_BY_SHARED_IDS, sharedLockResourceIds);
        return locks;
    }

    @Override
    protected LockEntity getLock(Long id) {
        LockEntity lock = new LockEntity();
        lock.setId(id);
        lock = (LockEntity)this.template.selectOne(SELECT_LOCK_BY_ID, (Object)lock);
        return lock;
    }

    @Override
    protected LockEntity getLock(Long sharedResourceId, Long exclusiveResourceId) {
        LockEntity lock = new LockEntity();
        lock.setSharedResourceId(sharedResourceId);
        lock.setExclusiveResourceId(exclusiveResourceId);
        lock = (LockEntity)this.template.selectOne(SELECT_LOCK_BY_KEY, (Object)lock);
        return lock;
    }

    @Override
    protected LockEntity createLock(Long sharedResourceId, Long exclusiveResourceId, String lockToken, long timeToLive) {
        LockEntity lock = new LockEntity();
        lock.setVersion(LockEntity.CONST_LONG_ZERO);
        lock.setSharedResourceId(sharedResourceId);
        lock.setExclusiveResourceId(exclusiveResourceId);
        lock.setLockToken(lockToken == null ? null : lockToken.toLowerCase());
        long now = System.currentTimeMillis();
        long exp = now + timeToLive;
        lock.setStartTime(now);
        lock.setExpiryTime(exp);
        this.template.insert(INSERT_LOCK, (Object)lock);
        return lock;
    }

    @Override
    protected LockEntity updateLock(LockEntity lockEntity, String lockToken, long timeToLive) {
        LockEntity updateLockEntity = new LockEntity();
        updateLockEntity.setId(lockEntity.getId());
        updateLockEntity.setVersion(lockEntity.getVersion());
        updateLockEntity.incrementVersion();
        updateLockEntity.setSharedResourceId(lockEntity.getSharedResourceId());
        updateLockEntity.setExclusiveResourceId(lockEntity.getExclusiveResourceId());
        updateLockEntity.setLockToken(lockToken == null ? null : lockToken.toLowerCase());
        long now = timeToLive > 0L ? System.currentTimeMillis() : 0L;
        long exp = timeToLive > 0L ? now + timeToLive : 0L;
        updateLockEntity.setStartTime(now);
        updateLockEntity.setExpiryTime(exp);
        int updated = this.template.update(UPDATE_LOCK, (Object)updateLockEntity);
        if (updated != 1) {
            throw new ConcurrencyFailureException("Incorrect number of rows affected for updateLock: " + updateLockEntity + ": expected 1, actual " + updated);
        }
        return updateLockEntity;
    }

    @Override
    protected int updateLocks(Long exclusiveLockResourceId, String oldLockToken, String newLockToken, long timeToLive) {
        HashMap<String, Object> params = new HashMap<String, Object>(11);
        params.put("exclusiveLockResourceId", exclusiveLockResourceId);
        params.put("oldLockToken", oldLockToken);
        params.put("newLockToken", newLockToken == null ? null : newLockToken.toLowerCase());
        long now = timeToLive > 0L ? System.currentTimeMillis() : 0L;
        long exp = timeToLive > 0L ? now + timeToLive : 0L;
        params.put("newStartTime", now);
        params.put("newExpiryTime", exp);
        int updateCount = this.template.update(UPDATE_EXCLUSIVE_LOCK, params);
        return updateCount;
    }
}

