/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.security.authority.AuthorityInfo;
import org.alfresco.repo.security.authority.AuthorityInfoEntity;
import org.alfresco.repo.security.authority.GetAuthoritiesCannedQueryParams;
import org.alfresco.repo.security.permissions.impl.acegi.AbstractCannedQueryPermissions;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityBean;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetAuthoritiesCannedQuery
extends AbstractCannedQueryPermissions<AuthorityInfo> {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String QUERY_NAMESPACE = "alfresco.query.authorities";
    private static final String QUERY_SELECT_GET_AUTHORITIES = "select_GetAuthoritiesCannedQuery";
    static final String DISPLAY_NAME = "displayName";
    private static final String SHORT_NAME = "shortName";
    private static final String AUTHORITY_NAME = "authorityName";
    private CannedQueryDAO cannedQueryDAO;
    private TenantService tenantService;

    public GetAuthoritiesCannedQuery(CannedQueryDAO cannedQueryDAO, TenantService tenantService, MethodSecurityBean<AuthorityInfo> methodSecurity, CannedQueryParameters params) {
        super(params, methodSecurity);
        this.cannedQueryDAO = cannedQueryDAO;
        this.tenantService = tenantService;
    }

    protected List<AuthorityInfo> queryAndFilter(CannedQueryParameters parameters) {
        Long start = this.logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        GetAuthoritiesCannedQueryParams params = (GetAuthoritiesCannedQueryParams)parameters.getParameterBean();
        final AuthorityType type = params.getType();
        final Pattern nameFilter = this.getPattern(params.getDisplayNameFilter());
        final ArrayList<AuthorityInfo> auths = new ArrayList<AuthorityInfo>(100);
        QueryCallback callback = new QueryCallback(){

            @Override
            public boolean handle(AuthorityInfo auth) {
                if (GetAuthoritiesCannedQuery.this.includeFilter(auth, type, nameFilter)) {
                    auths.add(auth);
                }
                return true;
            }
        };
        ResultHandler resultHandler = new ResultHandler(callback);
        this.cannedQueryDAO.executeQuery(QUERY_NAMESPACE, QUERY_SELECT_GET_AUTHORITIES, params, 0, Integer.MAX_VALUE, resultHandler);
        resultHandler.done();
        if (start != null) {
            this.logger.debug((Object)("Base query: " + auths.size() + " in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        return auths;
    }

    private Pattern getPattern(String searchValue) {
        if (searchValue == null) {
            return null;
        }
        searchValue = "^" + searchValue.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\.", "\\\\.").replaceAll("\\?", ".").replaceAll("\\*", ".*").replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\{", "\\\\{").replaceAll("\\}", "\\\\}").replaceAll("\\^", "\\\\^").replaceAll("\\$", "\\\\\\$").replaceAll("\\:", "\\\\:").replaceAll("\\\"", "\\\\\"").replaceAll("\\<", "\\\\<").replaceAll("\\>", "\\\\>").replaceAll("\\/", "\\\\/").replaceAll("\\|", "\\\\|");
        return Pattern.compile(searchValue, 66);
    }

    protected boolean isApplyPostQuerySorting() {
        return true;
    }

    protected List<AuthorityInfo> applyPostQuerySorting(List<AuthorityInfo> results, CannedQuerySortDetails sortDetails) {
        List sortPairs = sortDetails.getSortPairs();
        if (sortPairs.size() > 0) {
            Collections.sort(results, new AuthComparator((String)((Pair)sortPairs.get(0)).getFirst(), (CannedQuerySortDetails.SortOrder)((Pair)sortPairs.get(0)).getSecond()));
        }
        return results;
    }

    private boolean includeFilter(AuthorityInfo auth, AuthorityType type, Pattern nameFilter) {
        String authName = auth.getAuthorityName();
        AuthorityType authType = AuthorityType.getAuthorityType((String)authName);
        if (authName == null || type != null && !type.equals((Object)authType)) {
            return false;
        }
        if (nameFilter == null) {
            return true;
        }
        String displayName = auth.getAuthorityDisplayName();
        if (displayName != null && nameFilter.matcher(displayName).find()) {
            return true;
        }
        if (authType.isPrefixed()) {
            authName = authName.substring(authType.getPrefixString().length());
        }
        return nameFilter.matcher(authName).find();
    }

    private class AuthComparator
    implements Comparator<AuthorityInfo> {
        private boolean sortByDisplayName;
        private boolean sortByShortName;
        private CannedQuerySortDetails.SortOrder sortOrder;
        private Collator collator;

        public AuthComparator(String fieldName, CannedQuerySortDetails.SortOrder sortOrder) {
            if (GetAuthoritiesCannedQuery.DISPLAY_NAME.equals(fieldName)) {
                this.sortByDisplayName = true;
                this.sortByShortName = false;
            } else if (GetAuthoritiesCannedQuery.SHORT_NAME.equals(fieldName)) {
                this.sortByDisplayName = false;
                this.sortByShortName = true;
            } else if (GetAuthoritiesCannedQuery.AUTHORITY_NAME.equals(fieldName)) {
                this.sortByDisplayName = false;
                this.sortByShortName = false;
            } else {
                throw new IllegalArgumentException("Authorities should be sorted by displayName, authorityName or shortName. Asked use " + fieldName);
            }
            this.sortOrder = sortOrder;
            this.collator = Collator.getInstance();
        }

        @Override
        public int compare(AuthorityInfo auth1In, AuthorityInfo auth2In) {
            AuthorityInfo auth1 = auth1In;
            AuthorityInfo auth2 = auth2In;
            if (this.sortOrder.equals((Object)CannedQuerySortDetails.SortOrder.DESCENDING)) {
                auth1 = auth2In;
                auth2 = auth1In;
            }
            String s1 = null;
            String s2 = null;
            if (this.sortByDisplayName) {
                s1 = auth1.getAuthorityDisplayName();
                s2 = auth2.getAuthorityDisplayName();
            } else if (this.sortByShortName) {
                s1 = auth1.getShortName();
                s2 = auth2.getShortName();
            }
            if (s1 == null) {
                s1 = auth1.getAuthorityName();
            }
            if (s2 == null) {
                s2 = auth2.getAuthorityName();
            }
            if (s1 == null) {
                return s2 == null ? 0 : -1;
            }
            if (s2 == null) {
                return 1;
            }
            return this.collator.compare(s1, s2);
        }
    }

    private static interface QueryCallback {
        public boolean handle(AuthorityInfo var1);
    }

    private class ResultHandler
    implements CannedQueryDAO.ResultHandler<AuthorityInfoEntity> {
        private final QueryCallback resultsCallback;
        private boolean more = true;

        private ResultHandler(QueryCallback resultsCallback) {
            this.resultsCallback = resultsCallback;
        }

        @Override
        public boolean handleResult(AuthorityInfoEntity result) {
            if (!this.more) {
                return false;
            }
            boolean more = this.resultsCallback.handle(new AuthorityInfo(result.getId(), result.getAuthorityDisplayName(), result.getAuthorityName()));
            if (!more) {
                this.more = false;
            }
            return more;
        }

        public void done() {
        }
    }
}

