/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.model;

import org.alfresco.repo.security.permissions.PermissionEntry;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.model.PermissionModel;
import org.alfresco.repo.security.permissions.impl.model.XMLModelInitialisable;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class GlobalPermissionEntry
implements XMLModelInitialisable,
PermissionEntry {
    private static final String AUTHORITY = "authority";
    private static final String PERMISSION = "permission";
    private String authority;
    private PermissionReference permissionReference;

    @Override
    public void initialise(Element element, NamespacePrefixResolver nspr, PermissionModel permissionModel) {
        Attribute permissionAttribute;
        Attribute authorityAttribute = element.attribute(AUTHORITY);
        if (authorityAttribute != null) {
            this.authority = authorityAttribute.getStringValue();
        }
        if ((permissionAttribute = element.attribute(PERMISSION)) != null) {
            this.permissionReference = permissionModel.getPermissionReference(null, permissionAttribute.getStringValue());
        }
    }

    @Override
    public String getAuthority() {
        return this.authority;
    }

    @Override
    public PermissionReference getPermissionReference() {
        return this.permissionReference;
    }

    @Override
    public NodeRef getNodeRef() {
        return null;
    }

    @Override
    public boolean isDenied() {
        return false;
    }

    @Override
    public boolean isAllowed() {
        return true;
    }

    @Override
    public AccessStatus getAccessStatus() {
        return AccessStatus.ALLOWED;
    }

    @Override
    public int getPosition() {
        return 0;
    }

    @Override
    public boolean isInherited() {
        return false;
    }
}

