/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import java.util.Set;
import org.alfresco.repo.cache.TransactionalCache;
import org.alfresco.repo.node.integrity.IntegrityChecker;
import org.alfresco.repo.transaction.DAOAdapter;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.repo.transaction.TransactionalDao;
import org.alfresco.util.transaction.TransactionSupportUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AlfrescoTransactionSupport
extends TransactionSupportUtil {
    private static int COMMIT_ORDER_NORMAL = 0;
    private static int COMMIT_ORDER_INTEGRITY = 1;
    private static int COMMIT_ORDER_LUCENE = 2;
    private static int COMMIT_ORDER_DAO = 3;
    private static int COMMIT_ORDER_CACHE = 4;
    public static final int SESSION_SYNCHRONIZATION_ORDER = 800;
    private static Log logger = LogFactory.getLog(AlfrescoTransactionSupport.class);

    public static TxnReadState getTransactionReadState() {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            return TxnReadState.TXN_NONE;
        }
        if (TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
            return TxnReadState.TXN_READ_ONLY;
        }
        return TxnReadState.TXN_READ_WRITE;
    }

    public static void checkTransactionReadState(boolean requireReadWrite) {
        TxnReadState readState = AlfrescoTransactionSupport.getTransactionReadState();
        switch (readState) {
            case TXN_NONE: {
                throw new IllegalStateException("The current operation requires an active " + (requireReadWrite ? "read-write" : "") + "transaction.");
            }
            case TXN_READ_ONLY: {
                if (!requireReadWrite) break;
                throw new IllegalStateException("The current operation requires an active read-write transaction.");
            }
        }
    }

    public static boolean isDirty() {
        Set allListeners = AlfrescoTransactionSupport.getListeners();
        for (org.alfresco.util.transaction.TransactionListener listener : allListeners) {
            DAOAdapter adapter;
            TransactionalDao service;
            TransactionalDao service2;
            if (!(listener instanceof TransactionalDao ? (service2 = (TransactionalDao)listener).isDirty() : listener instanceof DAOAdapter && (service = (adapter = (DAOAdapter)listener).getService()).isDirty())) continue;
            return true;
        }
        return false;
    }

    public static void bindDaoService(TransactionalDao daoService) {
        DAOAdapter adapter = new DAOAdapter(daoService);
        boolean bound = AlfrescoTransactionSupport.bindListener((org.alfresco.util.transaction.TransactionListener)adapter, (int)COMMIT_ORDER_DAO);
        if (logger.isDebugEnabled()) {
            AlfrescoTransactionSupport.logBoundService(daoService, bound);
        }
    }

    public static void bindIntegrityChecker(IntegrityChecker integrityChecker) {
        boolean bound = AlfrescoTransactionSupport.bindListener((org.alfresco.util.transaction.TransactionListener)integrityChecker, (int)COMMIT_ORDER_INTEGRITY);
        if (logger.isDebugEnabled()) {
            AlfrescoTransactionSupport.logBoundService(integrityChecker, bound);
        }
    }

    public static void bindListener(TransactionListener listener) {
        AlfrescoTransactionSupport.bindListener((org.alfresco.util.transaction.TransactionListener)listener);
    }

    public static void bindListener(org.alfresco.util.transaction.TransactionListener listener) {
        boolean bound = false;
        bound = listener instanceof IntegrityChecker ? AlfrescoTransactionSupport.bindListener((org.alfresco.util.transaction.TransactionListener)listener, (int)COMMIT_ORDER_INTEGRITY) : (listener instanceof TransactionalCache ? AlfrescoTransactionSupport.bindListener((org.alfresco.util.transaction.TransactionListener)listener, (int)COMMIT_ORDER_CACHE) : (listener.getCustomOrder() != null ? AlfrescoTransactionSupport.bindListener((org.alfresco.util.transaction.TransactionListener)listener, (int)listener.getCustomOrder()) : AlfrescoTransactionSupport.bindListener((org.alfresco.util.transaction.TransactionListener)listener, (int)COMMIT_ORDER_NORMAL)));
        if (logger.isDebugEnabled()) {
            AlfrescoTransactionSupport.logBoundService(listener, bound);
        }
    }

    private static void logBoundService(Object service, boolean bound) {
        if (bound) {
            logger.debug((Object)("Bound service: \n   transaction: " + AlfrescoTransactionSupport.getTransactionId() + "\n" + "   service: " + service));
        } else {
            logger.debug((Object)("Service already bound: \n   transaction: " + AlfrescoTransactionSupport.getTransactionId() + "\n" + "   service: " + service));
        }
    }

    public static void flush() {
    }

    public static enum TxnReadState {
        TXN_NONE,
        TXN_READ_ONLY,
        TXN_READ_WRITE;

    }
}

