/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.rules;

import java.util.ArrayList;
import java.util.Date;
import org.alfresco.filesys.repo.ResultCallback;
import org.alfresco.filesys.repo.rules.Command;
import org.alfresco.filesys.repo.rules.Operation;
import org.alfresco.filesys.repo.rules.ScenarioInstance;
import org.alfresco.filesys.repo.rules.commands.CompoundCommand;
import org.alfresco.filesys.repo.rules.commands.CopyContentCommand;
import org.alfresco.filesys.repo.rules.commands.CreateFileCommand;
import org.alfresco.filesys.repo.rules.commands.DeleteFileCommand;
import org.alfresco.filesys.repo.rules.commands.RestoreFileCommand;
import org.alfresco.filesys.repo.rules.operations.RenameFileOperation;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScenarioMultipleRenameShuffleInstance
implements ScenarioInstance {
    private static Log logger = LogFactory.getLog(ScenarioMultipleRenameShuffleInstance.class);
    private NodeRef originalNodeRef;
    InternalState internalState = InternalState.NONE;
    private Date startTime = new Date();
    private String originalName;
    private ScenarioInstance.Ranking ranking;
    private long timeout = 30000L;
    private boolean isComplete;

    @Override
    public Command evaluate(Operation operation) {
        Date now = new Date();
        if (now.getTime() > this.startTime.getTime() + this.getTimeout()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Instance timed out");
            }
            this.isComplete = true;
            return null;
        }
        switch (this.internalState) {
            case NONE: {
                if (operation instanceof RenameFileOperation) {
                    RenameFileOperation r = (RenameFileOperation)operation;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Got first rename - tracking rename: " + operation));
                    }
                    this.originalName = r.getFromPath();
                    ArrayList<Command> commands = new ArrayList<Command>();
                    ArrayList<Command> postCommitCommands = new ArrayList<Command>();
                    ArrayList<Command> postErrorCommands = new ArrayList<Command>();
                    CreateFileCommand c1 = new CreateFileCommand(r.getTo(), r.getRootNodeRef(), r.getToPath(), 0L, true);
                    CopyContentCommand copyContent = new CopyContentCommand(r.getFrom(), r.getTo(), r.getRootNodeRef(), r.getFromPath(), r.getToPath());
                    DeleteFileCommand d1 = new DeleteFileCommand(r.getFrom(), r.getRootNodeRef(), r.getFromPath());
                    postCommitCommands.add(this.deleteFileCallbackCommand());
                    commands.add(c1);
                    commands.add(copyContent);
                    commands.add(d1);
                    this.internalState = InternalState.INITIALISED;
                    return new CompoundCommand(commands, postCommitCommands, postErrorCommands);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"State error, expected a RENAME");
                }
                this.isComplete = true;
            }
            case INITIALISED: {
                RenameFileOperation r;
                if (!(operation instanceof RenameFileOperation)) break;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Tracking rename: " + operation));
                }
                if (!(r = (RenameFileOperation)operation).getToPath().equalsIgnoreCase(this.originalName)) break;
                ArrayList<Command> commands = new ArrayList<Command>();
                RestoreFileCommand r1 = new RestoreFileCommand(r.getTo(), r.getRootNodeRef(), r.getToPath(), 0L, this.originalNodeRef);
                CopyContentCommand copyContent = new CopyContentCommand(r.getFrom(), r1.getName(), r.getRootNodeRef(), r.getFromPath(), r1.getPath());
                DeleteFileCommand d1 = new DeleteFileCommand(r.getFrom(), r.getRootNodeRef(), r.getFromPath());
                commands.add(r1);
                commands.add(copyContent);
                commands.add(d1);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Scenario complete");
                }
                this.isComplete = true;
                return new CompoundCommand(commands);
            }
        }
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public ScenarioInstance.Ranking getRanking() {
        return this.ranking;
    }

    public void setRanking(ScenarioInstance.Ranking ranking) {
        this.ranking = ranking;
    }

    public String toString() {
        return "ScenarioMultipleRenameShuffleInstance: createName:" + this.originalName;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    private ResultCallback deleteFileCallbackCommand() {
        return new ResultCallback(){

            @Override
            public void execute(Object result) {
                if (result instanceof NodeRef) {
                    logger.debug((Object)"got node ref of deleted node");
                    ScenarioMultipleRenameShuffleInstance.this.originalNodeRef = (NodeRef)result;
                }
            }

            @Override
            public AlfrescoTransactionSupport.TxnReadState getTransactionRequired() {
                return AlfrescoTransactionSupport.TxnReadState.TXN_NONE;
            }
        };
    }

    static enum InternalState {
        NONE,
        INITIALISED;

    }
}

