/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import org.alfresco.opencmis.AlfrescoCmisService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.util.FileFilterMode;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlfrescoCmisServiceInterceptor
implements MethodInterceptor {
    private static Log logger = LogFactory.getLog(AlfrescoCmisServiceInterceptor.class);

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        Object[] args = invocation.getArguments();
        boolean debug = logger.isDebugEnabled();
        boolean trace = logger.isTraceEnabled();
        StringBuilder sb = null;
        if (debug || trace) {
            sb = new StringBuilder("\nCMIS invocation:         \n   Method:                 " + methodName + "\n" + "   Arguments:            \n");
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object arg = objectArray[n2];
                sb.append("      ").append(arg).append("\n");
                ++n2;
            }
        }
        Object ret = null;
        AlfrescoCmisService service = (AlfrescoCmisService)invocation.getThis();
        try {
            try {
                if (debug || trace) {
                    sb.append("   Pre-call authentication: \n      Full auth:           " + AuthenticationUtil.getFullyAuthenticatedUser() + "\n" + "      Effective auth:      " + AuthenticationUtil.getRunAsUser() + "\n");
                }
                if (!methodName.equalsIgnoreCase("close")) {
                    service.beforeCall();
                }
                if (debug || trace) {
                    sb.append("   In-call authentication: \n      Full auth:           " + AuthenticationUtil.getFullyAuthenticatedUser() + "\n" + "      Effective auth:      " + AuthenticationUtil.getRunAsUser() + "\n");
                }
                FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.cmis);
                ret = invocation.proceed();
            }
            finally {
                FileFilterMode.clearClient();
                if (!methodName.equalsIgnoreCase("close")) {
                    service.afterCall();
                }
                if (debug || trace) {
                    sb.append("   Post-call authentication: \n      Full auth:           " + AuthenticationUtil.getFullyAuthenticatedUser() + "\n" + "      Effective auth:      " + AuthenticationUtil.getRunAsUser() + "\n");
                }
            }
            if (trace) {
                sb.append("   Returning:              ").append(ret).append("\n");
                logger.debug((Object)sb);
            }
            return ret;
        }
        catch (Throwable e) {
            if (debug) {
                sb.append("   Throwing:             " + e.getMessage());
                logger.debug((Object)sb, e);
            }
            throw e;
        }
    }
}

