/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.search.DocumentNavigator;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.ISO9075;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.BaseXPath;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;
import org.jaxen.SimpleFunctionContext;
import org.jaxen.SimpleVariableContext;
import org.jaxen.function.BooleanFunction;
import org.jaxen.function.CeilingFunction;
import org.jaxen.function.ConcatFunction;
import org.jaxen.function.ContainsFunction;
import org.jaxen.function.CountFunction;
import org.jaxen.function.FalseFunction;
import org.jaxen.function.FloorFunction;
import org.jaxen.function.IdFunction;
import org.jaxen.function.LangFunction;
import org.jaxen.function.LastFunction;
import org.jaxen.function.LocalNameFunction;
import org.jaxen.function.NameFunction;
import org.jaxen.function.NamespaceUriFunction;
import org.jaxen.function.NormalizeSpaceFunction;
import org.jaxen.function.NotFunction;
import org.jaxen.function.NumberFunction;
import org.jaxen.function.PositionFunction;
import org.jaxen.function.RoundFunction;
import org.jaxen.function.StartsWithFunction;
import org.jaxen.function.StringFunction;
import org.jaxen.function.StringLengthFunction;
import org.jaxen.function.SubstringAfterFunction;
import org.jaxen.function.SubstringBeforeFunction;
import org.jaxen.function.SubstringFunction;
import org.jaxen.function.SumFunction;
import org.jaxen.function.TranslateFunction;
import org.jaxen.function.TrueFunction;
import org.jaxen.function.ext.EndsWithFunction;
import org.jaxen.function.ext.EvaluateFunction;
import org.jaxen.function.ext.LowerFunction;
import org.jaxen.function.ext.UpperFunction;
import org.jaxen.function.xslt.DocumentFunction;

public class NodeServiceXPath
extends BaseXPath {
    private static final long serialVersionUID = 3834032441789592882L;
    private static Log logger = LogFactory.getLog(NodeServiceXPath.class);

    public NodeServiceXPath(String xpath, DocumentNavigator documentNavigator, QueryParameterDefinition[] paramDefs) throws JaxenException {
        super(xpath, (Navigator)documentNavigator);
        int i;
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Created XPath: \n").append("   XPath: ").append(xpath).append("\n").append("   Parameters: \n");
            i = 0;
            while (paramDefs != null && i < paramDefs.length) {
                sb.append("      Parameter: \n").append("         name: ").append(paramDefs[i].getQName()).append("\n").append("         value: ").append(paramDefs[i].getDefault()).append("\n");
                ++i;
            }
            logger.debug((Object)sb.toString());
        }
        if (paramDefs != null) {
            SimpleVariableContext svc = (SimpleVariableContext)this.getVariableContext();
            i = 0;
            while (i < paramDefs.length) {
                if (!paramDefs[i].hasDefaultValue()) {
                    throw new AlfrescoRuntimeException("Parameter must have default value");
                }
                Object value = null;
                value = paramDefs[i].getDataTypeDefinition().getName().equals((Object)DataTypeDefinition.BOOLEAN) ? Boolean.valueOf(paramDefs[i].getDefault()) : (paramDefs[i].getDataTypeDefinition().getName().equals((Object)DataTypeDefinition.DOUBLE) ? Double.valueOf(paramDefs[i].getDefault()) : (paramDefs[i].getDataTypeDefinition().getName().equals((Object)DataTypeDefinition.FLOAT) ? Float.valueOf(paramDefs[i].getDefault()) : (paramDefs[i].getDataTypeDefinition().getName().equals((Object)DataTypeDefinition.INT) ? Integer.valueOf(paramDefs[i].getDefault()) : (paramDefs[i].getDataTypeDefinition().getName().equals((Object)DataTypeDefinition.LONG) ? Long.valueOf(paramDefs[i].getDefault()) : paramDefs[i].getDefault()))));
                svc.setVariableValue(paramDefs[i].getQName().getNamespaceURI(), paramDefs[i].getQName().getLocalName(), value);
                ++i;
            }
        }
        for (String prefix : documentNavigator.getNamespacePrefixResolver().getPrefixes()) {
            this.addNamespace(prefix, documentNavigator.getNamespacePrefixResolver().getNamespaceURI(prefix));
        }
    }

    public List selectNodes(Object arg0) throws JaxenException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Selecting using XPath: \n   XPath: " + (Object)((Object)this) + "\n" + "   starting at: " + arg0));
        }
        List resultsWithDuplicates = super.selectNodes(arg0);
        HashSet set = new HashSet(resultsWithDuplicates);
        ArrayList results = new ArrayList();
        results.addAll(set);
        return results;
    }

    protected FunctionContext createFunctionContext() {
        return XPathFunctionContext.getInstance();
    }

    static class Contains
    implements Function {
        Contains() {
        }

        public Object call(Context context, List args) throws FunctionCallException {
            if (args.size() != 1) {
                throw new FunctionCallException("contains() usage: contains('pattern')");
            }
            return this.evaluate(context.getNodeSet(), args.get(0), context.getNavigator());
        }

        public Object evaluate(List nodes, Object pattern, Navigator nav) {
            if (nodes.size() != 1) {
                return false;
            }
            QName qname = null;
            NodeRef nodeRef = null;
            if (nav.isElement(nodes.get(0))) {
                qname = null;
                nodeRef = ((ChildAssociationRef)nodes.get(0)).getChildRef();
            } else if (nav.isAttribute(nodes.get(0))) {
                qname = QName.createQName((String)nav.getAttributeNamespaceUri(nodes.get(0)), (String)ISO9075.decode((String)nav.getAttributeName(nodes.get(0))));
                nodeRef = ((DocumentNavigator.Property)nodes.get((int)0)).parent;
            }
            String patternValue = StringFunction.evaluate((Object)pattern, (Navigator)nav);
            DocumentNavigator dNav = (DocumentNavigator)nav;
            return dNav.contains(nodeRef, qname, patternValue, SearchParameters.OR);
        }
    }

    static class Deref
    implements Function {
        Deref() {
        }

        public Object call(Context context, List args) throws FunctionCallException {
            if (args.size() == 2) {
                return this.evaluate(args.get(0), args.get(1), context.getNavigator());
            }
            throw new FunctionCallException("deref() requires two arguments.");
        }

        public Object evaluate(Object attributeName, Object pattern, Navigator nav) {
            ArrayList<Object> answer = new ArrayList<Object>();
            String attributeValue = StringFunction.evaluate((Object)attributeName, (Navigator)nav);
            String patternValue = StringFunction.evaluate((Object)pattern, (Navigator)nav);
            if (attributeValue != null && attributeValue.length() > 0) {
                DocumentNavigator dNav = (DocumentNavigator)nav;
                NodeRef nodeRef = new NodeRef(attributeValue);
                if (patternValue.equals("*")) {
                    answer.add(dNav.getNode(nodeRef));
                } else {
                    JCRPatternMatch qNamePattern = new JCRPatternMatch(patternValue, dNav.getNamespacePrefixResolver());
                    answer.addAll(dNav.getNode(nodeRef, qNamePattern));
                }
            }
            return answer;
        }
    }

    public static class FirstFunction
    implements Function {
        public Object call(Context context, List args) throws FunctionCallException {
            if (args.size() == 0) {
                return FirstFunction.evaluate(context);
            }
            throw new FunctionCallException("first() requires no arguments.");
        }

        public static Double evaluate(Context context) {
            return 1.0;
        }
    }

    static class HasAspect
    implements Function {
        HasAspect() {
        }

        public Object call(Context context, List args) throws FunctionCallException {
            if (args.size() != 1) {
                throw new FunctionCallException("hasAspect() requires one argument: hasAspect(QName typeQName)");
            }
            return this.evaluate(context.getNodeSet(), args.get(0), context.getNavigator());
        }

        public Object evaluate(List nodes, Object qnameObj, Navigator nav) {
            if (nodes.size() != 1) {
                return false;
            }
            String qnameStr = StringFunction.evaluate((Object)qnameObj, (Navigator)nav);
            if (qnameStr.equals("*")) {
                return true;
            }
            QName typeQName = qnameStr.startsWith("{") ? QName.createQName((String)qnameStr) : QName.createQName((String)qnameStr, (NamespacePrefixResolver)((DocumentNavigator)nav).getNamespacePrefixResolver());
            NodeRef nodeRef = null;
            if (nav.isElement(nodes.get(0))) {
                nodeRef = ((ChildAssociationRef)nodes.get(0)).getChildRef();
            } else if (nav.isAttribute(nodes.get(0))) {
                nodeRef = ((DocumentNavigator.Property)nodes.get((int)0)).parent;
            }
            DocumentNavigator dNav = (DocumentNavigator)nav;
            boolean result = dNav.hasAspect(nodeRef, typeQName);
            return result;
        }
    }

    public static class JCRPatternMatch
    implements QNamePattern {
        private List<String> searches = new ArrayList<String>();
        private NamespacePrefixResolver resolver;

        public JCRPatternMatch(String pattern, NamespacePrefixResolver resolver) {
            String regexPattern = pattern.replaceAll("\\*", ".*");
            StringTokenizer tokenizer = new StringTokenizer(regexPattern, "|", false);
            while (tokenizer.hasMoreTokens()) {
                String disjunct = tokenizer.nextToken().trim();
                this.searches.add(disjunct);
            }
            this.resolver = resolver;
        }

        public boolean isMatch(QName qname) {
            String prefixedName = qname.toPrefixString(this.resolver);
            for (String search : this.searches) {
                if (!prefixedName.matches(search)) continue;
                return true;
            }
            return false;
        }
    }

    static class Like
    implements Function {
        Like() {
        }

        public Object call(Context context, List args) throws FunctionCallException {
            if (args.size() < 2 || args.size() > 3) {
                throw new FunctionCallException("like() usage: like(@attr, 'pattern' [, includeFTS]) \n - includeFTS can be 'true' or 'false' \n - search is case-insensitive");
            }
            return this.evaluate(context.getNodeSet(), args.get(0), args.get(1), args.size() == 2 ? Boolean.toString(true) : args.get(2), context.getNavigator());
        }

        public Object evaluate(List nodes, Object obj, Object patternObj, Object includeFtsObj, Navigator nav) {
            Object attribute = null;
            if (obj instanceof List) {
                List list = (List)obj;
                if (list.isEmpty()) {
                    return false;
                }
                attribute = list.get(0);
            }
            if (attribute == null || !nav.isAttribute(attribute)) {
                return false;
            }
            if (nodes.size() != 1) {
                return false;
            }
            if (!nav.isElement(nodes.get(0))) {
                return false;
            }
            ChildAssociationRef car = (ChildAssociationRef)nodes.get(0);
            String pattern = StringFunction.evaluate((Object)patternObj, (Navigator)nav);
            boolean includeFts = BooleanFunction.evaluate((Object)includeFtsObj, (Navigator)nav);
            QName qname = QName.createQName((String)nav.getAttributeNamespaceUri(attribute), (String)ISO9075.decode((String)nav.getAttributeName(attribute)));
            DocumentNavigator dNav = (DocumentNavigator)nav;
            return dNav.like(car.getChildRef(), qname, pattern, includeFts);
        }
    }

    static class Score
    implements Function {
        private Double one = 1.0;

        Score() {
        }

        public Object call(Context context, List args) throws FunctionCallException {
            return this.evaluate(context.getNodeSet(), context.getNavigator());
        }

        public Object evaluate(List nodes, Navigator nav) {
            return this.one;
        }
    }

    static class SubTypeOf
    implements Function {
        SubTypeOf() {
        }

        public Object call(Context context, List args) throws FunctionCallException {
            if (args.size() != 1) {
                throw new FunctionCallException("subtypeOf() requires one argument: subtypeOf(QName typeQName)");
            }
            return this.evaluate(context.getNodeSet(), args.get(0), context.getNavigator());
        }

        public Object evaluate(List nodes, Object qnameObj, Navigator nav) {
            if (nodes.size() != 1) {
                return false;
            }
            String qnameStr = StringFunction.evaluate((Object)qnameObj, (Navigator)nav);
            if (qnameStr.equals("*")) {
                return true;
            }
            QName typeQName = qnameStr.startsWith("{") ? QName.createQName((String)qnameStr) : QName.createQName((String)qnameStr, (NamespacePrefixResolver)((DocumentNavigator)nav).getNamespacePrefixResolver());
            NodeRef nodeRef = null;
            if (nav.isElement(nodes.get(0))) {
                nodeRef = ((ChildAssociationRef)nodes.get(0)).getChildRef();
            } else if (nav.isAttribute(nodes.get(0))) {
                nodeRef = ((DocumentNavigator.Property)nodes.get((int)0)).parent;
            }
            DocumentNavigator dNav = (DocumentNavigator)nav;
            boolean result = dNav.isSubtypeOf(nodeRef, typeQName);
            return result;
        }
    }

    public static class XPathFunctionContext
    extends SimpleFunctionContext {
        public static FunctionContext getInstance() {
            return Singleton.instance;
        }

        public XPathFunctionContext() {
            this.registerFunction("", "boolean", (Function)new BooleanFunction());
            this.registerFunction("", "ceiling", (Function)new CeilingFunction());
            this.registerFunction("", "concat", (Function)new ConcatFunction());
            this.registerFunction("", "contains", (Function)new ContainsFunction());
            this.registerFunction("", "count", (Function)new CountFunction());
            this.registerFunction("", "document", (Function)new DocumentFunction());
            this.registerFunction("", "ends-with", (Function)new EndsWithFunction());
            this.registerFunction("", "false", (Function)new FalseFunction());
            this.registerFunction("", "floor", (Function)new FloorFunction());
            this.registerFunction("", "id", (Function)new IdFunction());
            this.registerFunction("", "lang", (Function)new LangFunction());
            this.registerFunction("", "last", (Function)new LastFunction());
            this.registerFunction("", "local-name", (Function)new LocalNameFunction());
            this.registerFunction("", "name", (Function)new NameFunction());
            this.registerFunction("", "namespace-uri", (Function)new NamespaceUriFunction());
            this.registerFunction("", "normalize-space", (Function)new NormalizeSpaceFunction());
            this.registerFunction("", "not", (Function)new NotFunction());
            this.registerFunction("", "number", (Function)new NumberFunction());
            this.registerFunction("", "position", (Function)new PositionFunction());
            this.registerFunction("", "round", (Function)new RoundFunction());
            this.registerFunction("", "starts-with", (Function)new StartsWithFunction());
            this.registerFunction("", "string", (Function)new StringFunction());
            this.registerFunction("", "string-length", (Function)new StringLengthFunction());
            this.registerFunction("", "substring-after", (Function)new SubstringAfterFunction());
            this.registerFunction("", "substring-before", (Function)new SubstringBeforeFunction());
            this.registerFunction("", "substring", (Function)new SubstringFunction());
            this.registerFunction("", "sum", (Function)new SumFunction());
            this.registerFunction("", "true", (Function)new TrueFunction());
            this.registerFunction("", "translate", (Function)new TranslateFunction());
            this.registerFunction("", "evaluate", (Function)new EvaluateFunction());
            this.registerFunction("", "lower-case", (Function)new LowerFunction());
            this.registerFunction("", "upper-case", (Function)new UpperFunction());
            this.registerFunction("", "ends-with", (Function)new EndsWithFunction());
            this.registerFunction("", "subtypeOf", new SubTypeOf());
            this.registerFunction("", "hasAspect", new HasAspect());
            this.registerFunction("", "deref", new Deref());
            this.registerFunction("", "like", new Like());
            this.registerFunction("", "contains", new Contains());
            this.registerFunction("", "first", new FirstFunction());
        }

        private static class Singleton {
            private static XPathFunctionContext instance = new XPathFunctionContext();

            private Singleton() {
            }
        }
    }
}

