/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.InputStream;
import org.alfresco.repo.transfer.TransferProgressMonitor;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferProgress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggingTransferProgressMonitorImpl
implements TransferProgressMonitor {
    private static final Log log = LogFactory.getLog(LoggingTransferProgressMonitorImpl.class);
    private TransferProgressMonitor delegate;

    public void setDelegate(TransferProgressMonitor delegate) {
        this.delegate = delegate;
    }

    @Override
    public TransferProgress getProgress(String transferId) throws TransferException {
        return this.delegate.getProgress(transferId);
    }

    @Override
    public void logException(String transferId, Object obj, Throwable ex) throws TransferException {
        this.localLog(transferId, obj, ex);
        this.delegate.logException(transferId, obj, ex);
    }

    @Override
    public void logComment(String transferId, Object obj) throws TransferException {
        this.localLog(transferId, obj, null);
        this.delegate.logComment(transferId, obj);
    }

    @Override
    public void logCreated(String transferId, NodeRef sourceNode, NodeRef destNode, NodeRef parentNode, String parentPath, boolean orphan) {
        this.delegate.logCreated(transferId, sourceNode, destNode, parentNode, parentPath, orphan);
    }

    @Override
    public void logUpdated(String transferId, NodeRef sourceNode, NodeRef destNode, String parentPath) {
        this.delegate.logUpdated(transferId, sourceNode, destNode, parentPath);
    }

    @Override
    public void logMoved(String transferId, NodeRef sourceNode, NodeRef destNode, String oldPath, NodeRef parentNodeRef, String parentPath) {
        this.delegate.logMoved(transferId, sourceNode, destNode, oldPath, parentNodeRef, parentPath);
    }

    @Override
    public void logDeleted(String transferId, NodeRef sourceNode, NodeRef destNode, String parentPath) {
        this.delegate.logDeleted(transferId, sourceNode, destNode, parentPath);
    }

    @Override
    public void updateProgress(String transferId, int currPos, int endPos) throws TransferException {
        if (this.loggingEnabled()) {
            this.localLog(transferId, "Progress update: " + currPos + " out of " + endPos, null);
        }
        this.delegate.updateProgress(transferId, currPos, endPos);
    }

    @Override
    public void updateProgress(String transferId, int currPos) throws TransferException {
        if (this.loggingEnabled()) {
            this.localLog(transferId, "Progress update: current position = " + currPos, null);
        }
        this.delegate.updateProgress(transferId, currPos);
    }

    @Override
    public void updateStatus(String transferId, TransferProgress.Status status) throws TransferException {
        if (this.loggingEnabled()) {
            this.localLog(transferId, "Status update: " + (Object)((Object)status), null);
        }
        this.delegate.updateStatus(transferId, status);
    }

    private boolean loggingEnabled() {
        return log.isInfoEnabled();
    }

    private void localLog(String transferId, Object obj, Throwable ex) {
        if (this.loggingEnabled()) {
            String message = "Transfer Log (" + transferId + "): " + obj.toString();
            if (ex == null) {
                log.info((Object)message);
            } else {
                log.info((Object)message, ex);
            }
        }
    }

    @Override
    public InputStream getLogInputStream(String transferId) throws TransferException {
        return this.delegate.getLogInputStream(transferId);
    }
}

