/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.bundle;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.model.filefolder.traitextender.FileFolderServiceExtension;
import org.alfresco.repo.model.filefolder.traitextender.FileFolderServiceTrait;
import org.alfresco.repo.virtual.ActualEnvironment;
import org.alfresco.repo.virtual.VirtualizationException;
import org.alfresco.repo.virtual.bundle.FileInfoPropsComparator;
import org.alfresco.repo.virtual.bundle.VirtualSpringBeanExtension;
import org.alfresco.repo.virtual.page.PageCollationException;
import org.alfresco.repo.virtual.page.PageCollator;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.ReferenceEncodingException;
import org.alfresco.repo.virtual.store.VirtualStore;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderServiceType;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public class VirtualFileFolderServiceExtension
extends VirtualSpringBeanExtension<FileFolderServiceExtension, FileFolderServiceTrait>
implements FileFolderServiceExtension {
    private VirtualStore smartStore;
    private ActualEnvironment environment;

    public VirtualFileFolderServiceExtension() {
        super(FileFolderServiceTrait.class);
    }

    public void setSmartStore(VirtualStore smartStore) {
        this.smartStore = smartStore;
    }

    public void setEnvironment(ActualEnvironment environment) {
        this.environment = environment;
    }

    public List<FileInfo> asFileInfos(List<Reference> references, VirtualStore smartStore, ActualEnvironment environment) throws VirtualizationException {
        LinkedList<FileInfo> fileInfos = new LinkedList<FileInfo>();
        for (Reference reference : references) {
            FileInfo fileInfo = this.asFileInfo(smartStore, environment, reference);
            fileInfos.add(fileInfo);
        }
        return fileInfos;
    }

    public FileInfo asFileInfo(VirtualStore smartStore, ActualEnvironment environment, Reference reference) throws VirtualizationException {
        Map<QName, Serializable> properties = smartStore.getProperties(reference);
        QName qNameType = smartStore.getType(reference);
        FileFolderServiceType type = ((FileFolderServiceTrait)this.getTrait()).getType(qNameType);
        boolean isFolder = type.equals((Object)FileFolderServiceType.FOLDER);
        NodeRef nodeRef = reference.toNodeRef();
        return ((FileFolderServiceTrait)this.getTrait()).createFileInfo(nodeRef, qNameType, isFolder, false, properties);
    }

    @Override
    public List<FileInfo> list(NodeRef contextNodeRef) {
        if (this.canVirtualize(contextNodeRef)) {
            Reference reference = this.smartStore.virtualize(contextNodeRef);
            List<Reference> virtualNodes = this.smartStore.list(reference);
            List<FileInfo> searchResult = this.asFileInfos(virtualNodes, this.smartStore, this.environment);
            if (this.mergeActualNode(reference)) {
                List<FileInfo> actualSearch = ((FileFolderServiceTrait)this.getTrait()).list(this.actualNodeFrom(reference));
                searchResult.addAll(actualSearch);
            }
            return searchResult;
        }
        return ((FileFolderServiceTrait)this.getTrait()).list(contextNodeRef);
    }

    protected boolean mergeActualNode(Reference reference) throws VirtualizationException {
        return this.smartStore.canMaterialize(reference);
    }

    protected NodeRef actualNodeFrom(Reference reference) throws VirtualizationException {
        return this.smartStore.materialize(reference);
    }

    protected boolean canVirtualize(NodeRef nodeRef) throws VirtualizationException {
        return this.smartStore.canVirtualize(nodeRef);
    }

    private Set<QName>[] buildSearchAndIgnore(boolean files, boolean folders, Set<QName> ignoreQNames) {
        Set[] searchAndIgnore = (Set[])Array.newInstance(Set.class, 3);
        Pair<Set<QName>, Set<QName>> searchTypesAndIgnoreAspects = ((FileFolderServiceTrait)this.getTrait()).buildSearchTypesAndIgnoreAspects(files, folders, ignoreQNames);
        if (searchTypesAndIgnoreAspects != null) {
            Set searchTypesQNames = (Set)searchTypesAndIgnoreAspects.getFirst();
            Set ignoreAspectsQNames = (Set)searchTypesAndIgnoreAspects.getSecond();
            HashSet<QName> ignoreTypesQNames = null;
            if ((searchTypesQNames != null || ignoreAspectsQNames != null) && ignoreQNames != null) {
                ignoreTypesQNames = new HashSet<QName>(ignoreQNames);
                if (searchTypesQNames != null) {
                    ignoreTypesQNames.removeAll(searchTypesQNames);
                }
                if (ignoreAspectsQNames != null) {
                    ignoreTypesQNames.removeAll(ignoreAspectsQNames);
                }
            }
            searchAndIgnore[0] = searchTypesQNames;
            searchAndIgnore[1] = ignoreTypesQNames;
            searchAndIgnore[2] = ignoreAspectsQNames;
        }
        return searchAndIgnore;
    }

    @Override
    public PagingResults<FileInfo> list(NodeRef contextNodeRef, final boolean files, final boolean folders, final String pattern, final Set<QName> ignoreQNames, final List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) {
        final FileFolderServiceTrait theTrait = (FileFolderServiceTrait)this.getTrait();
        if (this.canVirtualize(contextNodeRef)) {
            final Reference reference = this.smartStore.virtualize(contextNodeRef);
            Set<QName>[] searchAndIgnore = this.buildSearchAndIgnore(files, folders, ignoreQNames);
            if (this.mergeActualNode(reference)) {
                PagingResults<Reference> virtualChildren = this.smartStore.list(reference, false, true, files, folders, pattern, searchAndIgnore[1], searchAndIgnore[2], sortProps, new PagingRequest(0));
                PageCollator.PagingResultsSource<FileInfo> superSource = new PageCollator.PagingResultsSource<FileInfo>(){

                    @Override
                    public PagingResults<FileInfo> retrieve(PagingRequest pr) throws PageCollationException {
                        try {
                            PagingResults<FileInfo> result = theTrait.list(VirtualFileFolderServiceExtension.this.actualNodeFrom(reference), files, folders, pattern, ignoreQNames, sortProps, pr);
                            return result;
                        }
                        catch (VirtualizationException e) {
                            throw new PageCollationException(e);
                        }
                    }
                };
                FileInfoPropsComparator comparator = sortProps != null && !sortProps.isEmpty() ? new FileInfoPropsComparator(sortProps) : null;
                try {
                    return new PageCollator<FileInfo>().collate(this.asFileInfoResults(this.environment, virtualChildren, this.smartStore).getPage(), superSource, pagingRequest, comparator);
                }
                catch (PageCollationException error) {
                    throw new VirtualizationException(error);
                }
            }
            PagingResults<Reference> children = this.smartStore.list(reference, true, true, files, folders, pattern, searchAndIgnore[1], searchAndIgnore[2], sortProps, pagingRequest);
            return this.asFileInfoResults(this.environment, children, this.smartStore);
        }
        return theTrait.list(contextNodeRef, files, folders, pattern, ignoreQNames, sortProps, pagingRequest);
    }

    public PagingResults<FileInfo> asFileInfoResults(ActualEnvironment environment, PagingResults<Reference> results, VirtualStore store) throws ReferenceEncodingException, VirtualizationException {
        List virtualPage = results.getPage();
        final LinkedList<FileInfo> page = new LinkedList<FileInfo>();
        for (Reference ref : virtualPage) {
            FileInfo fileInfo = this.asFileInfo(store, environment, ref);
            page.add(fileInfo);
        }
        final boolean hasMoreItems = results.hasMoreItems();
        final Pair totalResultCount = results.getTotalResultCount();
        final String queryExecutionId = results.getQueryExecutionId();
        return new PagingResults<FileInfo>(){

            public List<FileInfo> getPage() {
                return page;
            }

            public String getQueryExecutionId() {
                return queryExecutionId;
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return totalResultCount;
            }

            public boolean hasMoreItems() {
                return hasMoreItems;
            }
        };
    }

    @Override
    public PagingResults<FileInfo> list(NodeRef rootNodeRef, final Set<QName> searchTypeQNames, final Set<QName> ignoreAspectQNames, final List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) {
        if (this.canVirtualize(rootNodeRef)) {
            final Reference reference = this.smartStore.virtualize(rootNodeRef);
            List<Pair<QName, Boolean>> sortingPropoerties = sortProps;
            if (sortingPropoerties == null || sortingPropoerties.isEmpty()) {
                sortingPropoerties = Arrays.asList(new Pair((Object)ContentModel.PROP_NAME, (Object)true));
            }
            if (this.mergeActualNode(reference)) {
                PagingResults<Reference> virtualChildren = this.smartStore.list(reference, false, true, searchTypeQNames, Collections.emptySet(), ignoreAspectQNames, sortProps, new PagingRequest(0));
                PageCollator.PagingResultsSource<FileInfo> superSource = new PageCollator.PagingResultsSource<FileInfo>(){

                    @Override
                    public PagingResults<FileInfo> retrieve(PagingRequest pr) throws PageCollationException {
                        try {
                            PagingResults<FileInfo> result = ((FileFolderServiceTrait)VirtualFileFolderServiceExtension.this.getTrait()).list(VirtualFileFolderServiceExtension.this.actualNodeFrom(reference), searchTypeQNames, ignoreAspectQNames, sortProps, pr);
                            return result;
                        }
                        catch (VirtualizationException e) {
                            throw new PageCollationException(e);
                        }
                    }
                };
                FileInfoPropsComparator comparator = new FileInfoPropsComparator(sortingPropoerties);
                try {
                    return new PageCollator<FileInfo>().collate(this.asFileInfoResults(this.environment, virtualChildren, this.smartStore).getPage(), superSource, pagingRequest, comparator);
                }
                catch (PageCollationException error) {
                    throw new VirtualizationException(error);
                }
            }
            PagingResults<Reference> children = this.smartStore.list(reference, true, true, searchTypeQNames, Collections.emptySet(), ignoreAspectQNames, sortingPropoerties, pagingRequest);
            return this.asFileInfoResults(this.environment, children, this.smartStore);
        }
        return ((FileFolderServiceTrait)this.getTrait()).list(rootNodeRef, searchTypeQNames, ignoreAspectQNames, sortProps, pagingRequest);
    }

    @Override
    public List<FileInfo> search(NodeRef contextNodeRef, String namePattern, boolean includeSubFolders) {
        return this.search(contextNodeRef, namePattern, true, true, false);
    }

    @Override
    public List<FileInfo> search(NodeRef contextNodeRef, String namePattern, boolean fileSearch, boolean folderSearch, boolean includeSubFolders) {
        if ((namePattern == null || namePattern.equals("*")) && this.canVirtualize(contextNodeRef)) {
            Reference reference = this.smartStore.virtualize(contextNodeRef);
            List<Reference> virtualNodes = Collections.emptyList();
            if (!includeSubFolders) {
                virtualNodes = this.smartStore.search(reference, namePattern, fileSearch, folderSearch, false);
            }
            List<FileInfo> searchResult = this.asFileInfos(virtualNodes, this.smartStore, this.environment);
            if (this.mergeActualNode(reference)) {
                List<FileInfo> actualSearch = ((FileFolderServiceTrait)this.getTrait()).search(this.actualNodeFrom(reference), namePattern, fileSearch, folderSearch, includeSubFolders);
                searchResult.addAll(actualSearch);
            }
            return searchResult;
        }
        return ((FileFolderServiceTrait)this.getTrait()).search(contextNodeRef, namePattern, fileSearch, folderSearch, includeSubFolders);
    }

    @Override
    public FileInfo rename(NodeRef sourceNodeRef, String newName) throws FileExistsException, FileNotFoundException {
        return ((FileFolderServiceTrait)this.getTrait()).rename(this.smartStore.materializeIfPossible(sourceNodeRef), newName);
    }

    @Override
    public PagingResults<FileInfo> list(NodeRef contextNodeRef, boolean files, boolean folders, Set<QName> ignoreQNames, List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) {
        return this.list(contextNodeRef, files, folders, null, ignoreQNames, sortProps, pagingRequest);
    }
}

