/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.virtual.config.NodeRefContext;
import org.alfresco.repo.virtual.config.NodeRefExpression;
import org.alfresco.repo.virtual.config.NodeRefResolver;
import org.alfresco.service.cmr.repository.NodeRef;

public class NodeRefPathExpression
implements NodeRefExpression {
    private static final String NAMESPACE_DELIMITER = ":";
    private static final String PATH_DELIMITER = "/";
    private Map<String, NodeRefContext> contexts = new HashMap<String, NodeRefContext>();
    private NodeRefResolver resolver;
    private String context = "CompanyHome";
    private String[] createNamePath;
    private String[] namePath;
    private String[] qNamePath;

    public NodeRefPathExpression(NodeRefResolver resolver, Map<String, NodeRefContext> contexts) {
        this(resolver, contexts, "CompanyHome", null);
    }

    public NodeRefPathExpression(NodeRefResolver resolver, Map<String, NodeRefContext> contexts, String context, String path) {
        this.resolver = resolver;
        this.contexts = contexts;
        this.context = context;
        this.setPath(path);
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setCreatedPathName(String createNamePath) {
        this.createNamePath = createNamePath.split(",");
    }

    public void setPath(String path) throws AlfrescoRuntimeException {
        String[] pathElements = NodeRefPathExpression.splitAndNormalizePath(path);
        if (this.isQNamePath(pathElements)) {
            this.qNamePath = pathElements;
        } else if (this.isNamePath(pathElements)) {
            this.namePath = pathElements;
        } else {
            throw new AlfrescoRuntimeException("Invalid path format : " + path);
        }
    }

    private boolean isQNamePath(String[] pathElements) {
        int i = 0;
        while (i < pathElements.length) {
            if (!pathElements[i].contains(NAMESPACE_DELIMITER)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isNamePath(String[] pathElements) {
        int i = 0;
        while (i < pathElements.length) {
            if (pathElements[i].contains(NAMESPACE_DELIMITER)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String[] splitAndNormalizePath(String path) {
        if (path == null || path.trim().length() == 0) {
            return new String[0];
        }
        String[] splitPath = path.split(PATH_DELIMITER);
        int shift = 0;
        int i = 0;
        while (i < splitPath.length) {
            if (splitPath[i] == null || splitPath[i].trim().isEmpty()) {
                ++shift;
            } else if (shift > 0) {
                splitPath[i - shift] = splitPath[i];
            }
            ++i;
        }
        if (shift > 0) {
            String[] noBlanksSplitPath = new String[splitPath.length - shift];
            if (noBlanksSplitPath.length > 0) {
                System.arraycopy(splitPath, 0, noBlanksSplitPath, 0, noBlanksSplitPath.length);
            }
            splitPath = noBlanksSplitPath;
        }
        return splitPath;
    }

    @Override
    public NodeRef resolve() {
        NodeRefContext theContext = this.contexts.get(this.context);
        if (this.namePath != null) {
            return theContext.resolveNamePath(this.namePath, this.resolver);
        }
        return theContext.resolveQNamePath(this.qNamePath, this.resolver);
    }

    @Override
    public NodeRef resolve(boolean createIfNotFound) {
        NodeRef nodeRef = this.resolve();
        if (nodeRef == null && createIfNotFound) {
            NodeRefContext theContext = this.contexts.get(this.context);
            if (this.namePath != null) {
                return theContext.createNamePath(this.namePath, this.resolver);
            }
            return theContext.createQNamePath(this.qNamePath, this.createNamePath, this.resolver);
        }
        return nodeRef;
    }

    public String toString() {
        StringBuilder pathString = new StringBuilder();
        pathString.append("<");
        pathString.append(this.context);
        pathString.append(">/");
        if (this.namePath != null) {
            pathString.append(Arrays.toString(this.namePath));
        }
        if (this.qNamePath != null) {
            pathString.append(Arrays.toString(this.qNamePath));
        }
        return "<null path expression>";
    }
}

