/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.io.Serializable;
import java.util.Set;
import java.util.UUID;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.event2.mapper.PropertyMapper;
import org.alfresco.repo.event2.mapper.ReplaceSensitivePropertyWithTextMapper;
import org.alfresco.repo.transfer.TransferModel;
import org.junit.Assert;
import org.junit.Test;

public class PropertyMapperUnitTest {
    private static final String DEFAULT_REPLACEMENT_TEXT = "SENSITIVE_DATA_REMOVED";
    private static final String USER_CONFIGURED_REPLACEMENT_TEXT = "HIDDEN_BY_SECURITY_CONFIG";
    private final PropertyMapper defaultPropertyMapper = new ReplaceSensitivePropertyWithTextMapper(null, null);
    private final PropertyMapper userConfiguredpropertyMapper = new ReplaceSensitivePropertyWithTextMapper(Set.of(ContentModel.PROP_PASSWORD, TransferModel.PROP_PASSWORD), "HIDDEN_BY_SECURITY_CONFIG");

    @Test
    public void shouldReplacePropertyValueWhenItsOneOfTheDefaultSensitivePropertiesWhenUsingDefaultConfig() {
        Assert.assertEquals((Object)DEFAULT_REPLACEMENT_TEXT, (Object)this.defaultPropertyMapper.map(ContentModel.PROP_PASSWORD, (Serializable)((Object)"test_pass")));
        Assert.assertEquals((Object)DEFAULT_REPLACEMENT_TEXT, (Object)this.defaultPropertyMapper.map(ContentModel.PROP_SALT, (Serializable)((Object)UUID.randomUUID().toString())));
        Assert.assertEquals((Object)DEFAULT_REPLACEMENT_TEXT, (Object)this.defaultPropertyMapper.map(ContentModel.PROP_PASSWORD_HASH, (Serializable)((Object)"r4nD0M_h4sH")));
        Assert.assertEquals((Object)DEFAULT_REPLACEMENT_TEXT, (Object)this.defaultPropertyMapper.map(TransferModel.PROP_PASSWORD, (Serializable)((Object)"pyramid")));
    }

    @Test
    public void shouldNotReplacePropertyValueWhenItsNotOneOfTheDefaultSensitivePropertiesWhenUsingDefaultConfig() {
        Assert.assertEquals((Object)"Bob", (Object)this.defaultPropertyMapper.map(ContentModel.PROP_USERNAME, (Serializable)((Object)"Bob")));
    }

    @Test
    public void shouldReplacePropertyValueWhenItsOneOfTheDefaultSensitivePropertiesWhenUsingUserConfig() {
        Assert.assertEquals((Object)USER_CONFIGURED_REPLACEMENT_TEXT, (Object)this.userConfiguredpropertyMapper.map(ContentModel.PROP_PASSWORD, (Serializable)((Object)"test_pass")));
        Assert.assertEquals((Object)USER_CONFIGURED_REPLACEMENT_TEXT, (Object)this.userConfiguredpropertyMapper.map(TransferModel.PROP_PASSWORD, (Serializable)((Object)"pyramid")));
    }

    @Test
    public void shouldNotReplacePropertyValueWhenItsNotOneOfTheDefaultSensitivePropertiesWhenUsingUserConfig() {
        String randomUuid = UUID.randomUUID().toString();
        Assert.assertEquals((Object)randomUuid, (Object)this.userConfiguredpropertyMapper.map(ContentModel.PROP_SALT, (Serializable)((Object)randomUuid)));
        Assert.assertEquals((Object)"r4nD0M_h4sH", (Object)this.userConfiguredpropertyMapper.map(ContentModel.PROP_PASSWORD_HASH, (Serializable)((Object)"r4nD0M_h4sH")));
    }
}

