/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.AbstractTenantRoutingContentStore;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class, LuceneTests.class, NeverRunsTests.class})
public class AbstractTenantRoutingContentStoreTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private ContentService contentService;
    private ServiceRegistry serviceRegistry;
    private AbstractTenantRoutingContentStore fileContentStore;
    private boolean isNullEntry = false;

    public void setUp() throws Exception {
        AuthenticationUtil.setRunAsUserSystem();
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.contentService = this.serviceRegistry.getContentService();
        this.fileContentStore = (AbstractTenantRoutingContentStore)ctx.getBean("fileContentStore");
    }

    public void testGetAllStores() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> txnWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Boolean execute() throws Exception {
                TestAfterRollbackTxnListener listener = new TestAfterRollbackTxnListener();
                AlfrescoTransactionSupport.bindListener((TransactionListener)listener);
                NodeRef content = AbstractTenantRoutingContentStoreTest.this.createContent(AbstractTenantRoutingContentStoreTest.this.serviceRegistry);
                ContentWriter writer = AbstractTenantRoutingContentStoreTest.this.contentService.getWriter(content, ContentModel.PROP_CONTENT, true);
                writer.setMimetype("text/plain");
                writer.putContent("The quick brown fox jumps over the lazy dog");
                throw new AlfrescoRuntimeException("Some error that causes RollBack. The transaction will be closed");
            }
        };
        try {
            this.serviceRegistry.getTransactionService().getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)txnWork, false, false);
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
        AbstractTenantRoutingContentStoreTest.assertFalse((String)"getAllStores method returned the list with null entry", (boolean)this.isNullEntry);
    }

    private void checkStores(List<ContentStore> stores) {
        AbstractTenantRoutingContentStoreTest.assertEquals((boolean)false, (boolean)stores.isEmpty());
        for (ContentStore store : stores) {
            if (store != null) continue;
            this.isNullEntry = true;
        }
    }

    private NodeRef createContent(ServiceRegistry serviceRegistry) throws Exception {
        ResultSet resultSet;
        MutableAuthenticationService authenticationService = serviceRegistry.getAuthenticationService();
        authenticationService.authenticate("admin", "admin".toCharArray());
        SearchService searchService = serviceRegistry.getSearchService();
        StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
        try {
            resultSet = searchService.query(storeRef, "lucene", "PATH:\"/app:company_home\"");
            NodeRef companyHome = resultSet.getNodeRef(0);
            serviceRegistry.getFileFolderService().create(companyHome, "Test", ContentModel.TYPE_FOLDER);
            resultSet.close();
        }
        catch (Exception exception) {}
        resultSet = searchService.query(storeRef, "lucene", "PATH:\"/app:company_home/cm:Test\"");
        NodeRef node = resultSet.getNodeRef(0);
        resultSet.close();
        String name = "TestContent(" + Thread.currentThread().getName() + " " + System.currentTimeMillis() + ")";
        HashMap<QName, String> contentProps = new HashMap<QName, String>();
        contentProps.put(ContentModel.PROP_NAME, name);
        NodeService nodeService = serviceRegistry.getNodeService();
        ChildAssociationRef association = nodeService.createNode(node, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"cm", (String)name), ContentModel.TYPE_CONTENT, contentProps);
        NodeRef content = association.getChildRef();
        HashMap<QName, String> titledProps = new HashMap<QName, String>();
        titledProps.put(ContentModel.PROP_TITLE, name);
        titledProps.put(ContentModel.PROP_DESCRIPTION, name);
        nodeService.addAspect(content, ContentModel.ASPECT_TITLED, titledProps);
        return content;
    }

    private class TestAfterRollbackTxnListener
    extends TransactionListenerAdapter {
        private TestAfterRollbackTxnListener() {
        }

        public void afterRollback() {
            AbstractTenantRoutingContentStoreTest.this.checkStores(AbstractTenantRoutingContentStoreTest.this.fileContentStore.getAllStores());
        }
    }
}

