/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation.script;

import org.alfresco.service.cmr.invitation.Invitation;
import org.alfresco.service.cmr.invitation.InvitationService;

public abstract class ScriptInvitation<T extends Invitation> {
    private T invitation;
    private InvitationService invitationService;

    public ScriptInvitation(T invitation, InvitationService invitationService) {
        this.invitation = invitation;
        this.invitationService = invitationService;
    }

    public void reject(String reason) {
        this.invitationService.reject(this.invitation.getInviteId(), reason);
    }

    public void cancel() {
        this.invitationService.cancel(this.invitation.getInviteId());
    }

    public String getInviteId() {
        return this.invitation.getInviteId();
    }

    public String getInvitationType() {
        return this.invitation.getInvitationType().toString();
    }

    public String getResourceName() {
        return this.invitation.getResourceName();
    }

    public String getResourceType() {
        return this.invitation.getResourceType().toString();
    }

    protected T getInvitation() {
        return this.invitation;
    }

    protected InvitationService getInvitationService() {
        return this.invitationService;
    }

    public String getRoleName() {
        return this.getInvitation().getRoleName();
    }

    public String getInviteeUserName() {
        return this.getInvitation().getInviteeUserName();
    }

    public abstract String getInviteeEmail();

    public abstract String getInviteeFirstName();

    public abstract String getInviteeLastName();
}

