/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remoteconnector;

import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.repo.remoteconnector.RemoteConnectorRequestImpl;
import org.alfresco.repo.remoteconnector.RemoteConnectorResponseImpl;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.service.cmr.remoteconnector.RemoteConnectorClientException;
import org.alfresco.service.cmr.remoteconnector.RemoteConnectorRequest;
import org.alfresco.service.cmr.remoteconnector.RemoteConnectorResponse;
import org.alfresco.service.cmr.remoteconnector.RemoteConnectorServerException;
import org.alfresco.service.cmr.remoteconnector.RemoteConnectorService;
import org.alfresco.util.HttpClientHelper;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class RemoteConnectorServiceImpl
implements RemoteConnectorService {
    private static Log logger = LogFactory.getLog(RemoteConnectorServiceImpl.class);
    private static final long MAX_BUFFER_RESPONSE_SIZE = 0xA00000L;
    private static ProxyHost httpProxyHost = HttpClientHelper.createProxyHost("http.proxyHost", "http.proxyPort", 80);
    private static ProxyHost httpsProxyHost;
    private static Credentials httpProxyCredentials;
    private static Credentials httpsProxyCredentials;
    private static AuthScope httpAuthScope;
    private static AuthScope httpsAuthScope;

    static {
        httpProxyCredentials = HttpClientHelper.createProxyCredentials("http.proxyUser", "http.proxyPassword");
        httpAuthScope = RemoteConnectorServiceImpl.createProxyAuthScope(httpProxyHost);
        httpsProxyHost = HttpClientHelper.createProxyHost("https.proxyHost", "https.proxyPort", 443);
        httpsProxyCredentials = HttpClientHelper.createProxyCredentials("https.proxyUser", "https.proxyPassword");
        httpsAuthScope = RemoteConnectorServiceImpl.createProxyAuthScope(httpsProxyHost);
    }

    @Override
    public RemoteConnectorRequest buildRequest(String url, String method) {
        return new RemoteConnectorRequestImpl(url, method);
    }

    public RemoteConnectorRequest buildRequest(String url, Class<? extends HttpMethodBase> method) {
        return new RemoteConnectorRequestImpl(url, method);
    }

    @Override
    public RemoteConnectorResponse executeRequest(RemoteConnectorRequest request) throws IOException, AuthenticationException, RemoteConnectorClientException, RemoteConnectorServerException {
        RemoteConnectorRequestImpl reqImpl = (RemoteConnectorRequestImpl)request;
        HttpMethodBase httpRequest = reqImpl.getMethodInstance();
        Header[] headerArray = request.getRequestHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header hdr = headerArray[n2];
            httpRequest.addRequestHeader(hdr);
            ++n2;
        }
        if (httpRequest instanceof EntityEnclosingMethod && request.getRequestBody() != null) {
            ((EntityEnclosingMethod)httpRequest).setRequestEntity(reqImpl.getRequestBody());
        }
        HttpClient httpClient = HttpClientHelper.getHttpClient();
        URL url = new URL(request.getURL());
        if (httpProxyHost != null && url.getProtocol().equals("http") && HttpClientHelper.requiresProxy(url.getHost())) {
            httpClient.getHostConfiguration().setProxyHost(httpProxyHost);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" - using HTTP proxy host for: " + url));
            }
            if (httpProxyCredentials != null) {
                httpClient.getState().setProxyCredentials(httpAuthScope, httpProxyCredentials);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(" - using HTTP proxy credentials for proxy: " + httpProxyHost.getHostName()));
                }
            }
        } else if (httpsProxyHost != null && url.getProtocol().equals("https") && HttpClientHelper.requiresProxy(url.getHost())) {
            httpClient.getHostConfiguration().setProxyHost(httpsProxyHost);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" - using HTTPS proxy host for: " + url));
            }
            if (httpsProxyCredentials != null) {
                httpClient.getState().setProxyCredentials(httpsAuthScope, httpsProxyCredentials);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(" - using HTTPS proxy credentials for proxy: " + httpsProxyHost.getHostName()));
                }
            }
        } else {
            httpClient.getHostConfiguration().setProxyHost(null);
            httpClient.getState().clearProxyCredentials();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Performing " + request.getMethod() + " request to " + request.getURL()));
            Header[] headerArray2 = request.getRequestHeaders();
            int n3 = headerArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Header hdr = headerArray2[n4];
                logger.debug((Object)("Header: " + hdr));
                ++n4;
            }
            Object requestBody = null;
            if (request != null) {
                requestBody = request.getRequestBody();
            }
            if (requestBody != null && requestBody instanceof StringRequestEntity) {
                StringRequestEntity re = (StringRequestEntity)request.getRequestBody();
                String payload = re.getContent();
                String usernameString = "\"username\"";
                String passwordString = "\"password\"";
                String hiddenString = "\"<hidden>\"";
                LinkedList<String> matches = new LinkedList<String>();
                Matcher m = Pattern.compile(String.valueOf(usernameString) + ":\"(.+)\",|" + usernameString + ":\"(.+)\"}|" + passwordString + ":\"(.+)\",|" + passwordString + ":\"(.+)\"}").matcher(payload);
                while (m.find()) {
                    matches.add(m.group());
                }
                for (String match : matches) {
                    if (match.contains(usernameString)) {
                        payload = payload.replace(match.substring(match.indexOf(usernameString) + usernameString.length() + 1, match.lastIndexOf("\"") + 1), hiddenString);
                        continue;
                    }
                    if (!match.contains(passwordString)) continue;
                    payload = payload.replace(match.substring(match.indexOf(passwordString) + passwordString.length() + 1, match.lastIndexOf("\"") + 1), hiddenString);
                }
                logger.debug((Object)("Payload (string): " + payload));
            } else if (requestBody != null && requestBody instanceof ByteArrayRequestEntity) {
                ByteArrayRequestEntity re = (ByteArrayRequestEntity)request.getRequestBody();
                logger.debug((Object)("Payload (byte array): " + re.getContent().toString()));
            } else {
                logger.debug((Object)"Payload is not of a readable type.");
            }
        }
        int status = -1;
        String statusText = null;
        RemoteConnectorResponseImpl response = null;
        try {
            String responseContentType;
            status = httpClient.executeMethod((HttpMethod)httpRequest);
            statusText = httpRequest.getStatusText();
            Header[] responseHdrs = httpRequest.getResponseHeaders();
            Header responseContentTypeH = httpRequest.getResponseHeader("Content-Type");
            String responseCharSet = httpRequest.getResponseCharSet();
            String string = responseContentType = responseContentTypeH != null ? responseContentTypeH.getValue() : null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("response url=" + request.getURL() + ", length =" + httpRequest.getResponseContentLength() + ", responceContentType " + responseContentType + ", statusText =" + statusText));
            }
            if (httpRequest.getResponseContentLength() > 0xA00000L || httpRequest.getResponseContentLength() == -1L) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("large response (or don't know length) url=" + request.getURL()));
                }
                HttpClientReleasingInputStream wrappedStream = new HttpClientReleasingInputStream(httpRequest);
                httpRequest = null;
                response = new RemoteConnectorResponseImpl(request, responseContentType, responseCharSet, status, responseHdrs, wrappedStream);
            } else {
                if (logger.isTraceEnabled()) {
                    logger.debug((Object)("small response for url=" + request.getURL()));
                }
                response = new RemoteConnectorResponseImpl(request, responseContentType, responseCharSet, status, responseHdrs, httpRequest.getResponseBody());
                httpRequest.releaseConnection();
                httpRequest = null;
            }
        }
        finally {
            if (httpRequest != null) {
                httpRequest.releaseConnection();
                httpRequest = null;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Response was " + status + " " + statusText));
        }
        if (status >= 300) {
            if (httpRequest != null) {
                httpRequest.releaseConnection();
            }
            if (status == 403 || status == 401) {
                throw new AuthenticationException(statusText);
            }
            if (status >= 500 && status <= 599) {
                logger.error((Object)("executeRequest: remote connector server exception: [" + status + "] " + statusText));
                throw new RemoteConnectorServerException(status, statusText);
            }
            if (status == 412) {
                logger.error((Object)("executeRequest: remote connector client exception: [" + status + "] " + statusText));
                throw new RemoteConnectorClientException(status, statusText, response);
            }
            if (httpRequest != null) {
                logger.error((Object)("executeRequest: remote connector client exception: [" + status + "] " + statusText));
                throw new RemoteConnectorClientException(status, statusText, response);
            }
            logger.error((Object)("executeRequest: remote connector client exception: [" + status + "] " + statusText));
            throw new RemoteConnectorClientException(status, statusText, null);
        }
        return response;
    }

    @Override
    public JSONObject executeJSONRequest(RemoteConnectorRequest request) throws ParseException, IOException, AuthenticationException {
        return RemoteConnectorServiceImpl.doExecuteJSONRequest(request, this);
    }

    public static JSONObject doExecuteJSONRequest(RemoteConnectorRequest request, RemoteConnectorService service) throws ParseException, IOException, AuthenticationException {
        request.setContentType("application/json");
        RemoteConnectorResponse response = service.executeRequest(request);
        JSONParser parser = new JSONParser();
        String jsonText = response.getResponseBodyAsString();
        Object json = parser.parse(jsonText);
        if (json instanceof JSONObject) {
            return (JSONObject)json;
        }
        throw new ParseException(0, json);
    }

    private static AuthScope createProxyAuthScope(ProxyHost proxyHost) {
        AuthScope authScope = null;
        if (proxyHost != null) {
            authScope = new AuthScope(proxyHost.getHostName(), proxyHost.getPort());
        }
        return authScope;
    }

    private static class HttpClientReleasingInputStream
    extends FilterInputStream {
        private HttpMethodBase httpRequest;

        private HttpClientReleasingInputStream(HttpMethodBase httpRequest) throws IOException {
            super(httpRequest.getResponseBodyAsStream());
            this.httpRequest = httpRequest;
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.httpRequest != null) {
                this.httpRequest.releaseConnection();
                this.httpRequest = null;
            }
        }

        protected void finalize() throws Throwable {
            if (this.httpRequest != null) {
                logger.warn((Object)"RemoteConnector response InputStream wasn't closed but must be! This can cause issues for other requests in this Thread!");
                this.httpRequest.releaseConnection();
                this.httpRequest = null;
            }
            super.finalize();
        }
    }
}

