/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.repo.transfer.AbstractNodeFilter;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

public class ContentClassFilter
extends AbstractNodeFilter {
    private Set<QName> contentClasses = new HashSet<QName>();
    private Set<QName> aspects = new HashSet<QName>();
    private Set<QName> types = new HashSet<QName>();
    private boolean initialised = false;
    private boolean exclude = false;
    private boolean directOnly = false;

    public ContentClassFilter() {
    }

    public ContentClassFilter(QName ... contentClasses) {
        this.setContentClasses(contentClasses);
    }

    @Override
    public boolean accept(NodeRef thisNode) {
        if (!this.initialised) {
            this.init();
        }
        NodeService nodeService = this.serviceRegistry.getNodeService();
        Set nodesAspects = nodeService.getAspects(thisNode);
        QName type = nodeService.getType(thisNode);
        boolean typeIsInSet = this.types.contains(type);
        boolean aspectIsInSet = false;
        for (QName aspect : nodesAspects) {
            if (!this.aspects.contains(aspect)) continue;
            aspectIsInSet = true;
            break;
        }
        return !this.exclude && (typeIsInSet || aspectIsInSet) || this.exclude && !typeIsInSet && !aspectIsInSet;
    }

    @Override
    public void init() {
        super.init();
        DictionaryService dictionaryService = this.serviceRegistry.getDictionaryService();
        this.aspects.clear();
        this.types.clear();
        for (QName contentClass : this.contentClasses) {
            ClassDefinition classDef = dictionaryService.getClass(contentClass);
            if (classDef == null) continue;
            if (classDef.isAspect()) {
                this.aspects.add(contentClass);
                if (this.directOnly) continue;
                this.aspects.addAll(dictionaryService.getSubAspects(contentClass, true));
                continue;
            }
            this.types.add(contentClass);
            if (this.directOnly) continue;
            this.types.addAll(dictionaryService.getSubTypes(contentClass, true));
        }
        this.initialised = true;
    }

    public void setContentClasses(Collection<QName> contentClasses) {
        this.contentClasses = new HashSet<QName>(contentClasses);
        this.initialised = false;
    }

    public void setContentClasses(QName ... contentClasses) {
        this.contentClasses = new HashSet<QName>(Arrays.asList(contentClasses));
        this.initialised = false;
    }

    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }

    public void setDirectOnly(boolean directOnly) {
        this.directOnly = directOnly;
        this.initialised = false;
    }
}

