/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.alfresco.repo.transfer.ContentDataPart;
import org.alfresco.repo.transfer.HttpMethodFactory;
import org.alfresco.repo.transfer.StandardHttpMethodFactoryImpl;
import org.alfresco.repo.transfer.Transfer;
import org.alfresco.repo.transfer.TransferCommons;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.repo.transfer.TransferTransmitter;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferProgress;
import org.alfresco.service.cmr.transfer.TransferTarget;
import org.alfresco.service.cmr.transfer.TransferVersion;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.HttpClientHelper;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SSLProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class HttpClientTransmitterImpl
implements TransferTransmitter {
    private static final Log log = LogFactory.getLog(HttpClientTransmitterImpl.class);
    private static final String MSG_UNSUPPORTED_PROTOCOL = "transfer_service.comms.unsupported_protocol";
    private static final String MSG_UNSUCCESSFUL_RESPONSE = "transfer_service.comms.unsuccessful_response";
    private static final String MSG_HTTP_REQUEST_FAILED = "transfer_service.comms.http_request_failed";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final String HTTP_SCHEME_NAME = "http";
    private static final String HTTPS_SCHEME_NAME = "https";
    private HttpClient httpClient = null;
    private Protocol httpProtocol = new Protocol("http", (ProtocolSocketFactory)new DefaultProtocolSocketFactory(), 80);
    private Protocol httpsProtocol = new Protocol("https", (ProtocolSocketFactory)new SSLProtocolSocketFactory(), 443);
    private Map<String, Protocol> protocolMap = new TreeMap<String, Protocol>();
    private HttpMethodFactory httpMethodFactory = null;
    private ContentService contentService;
    private NodeService nodeService;
    private boolean isAuthenticationPreemptive = false;
    private ProxyHost httpProxyHost;
    private ProxyHost httpsProxyHost;
    private Credentials httpProxyCredentials;
    private Credentials httpsProxyCredentials;
    private AuthScope httpAuthScope;
    private AuthScope httpsAuthScope;

    public HttpClientTransmitterImpl() {
        this.protocolMap.put(HTTP_SCHEME_NAME, this.httpProtocol);
        this.protocolMap.put(HTTPS_SCHEME_NAME, this.httpsProtocol);
        this.httpClient = new HttpClient();
        this.httpClient.setHttpConnectionManager((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        this.httpMethodFactory = new StandardHttpMethodFactoryImpl();
        this.httpProxyHost = HttpClientHelper.createProxyHost("http.proxyHost", "http.proxyPort", 80);
        this.httpProxyCredentials = HttpClientHelper.createProxyCredentials("http.proxyUser", "http.proxyPassword");
        this.httpAuthScope = this.createProxyAuthScope(this.httpProxyHost);
        this.httpsProxyHost = HttpClientHelper.createProxyHost("https.proxyHost", "https.proxyPort", 443);
        this.httpsProxyCredentials = HttpClientHelper.createProxyCredentials("https.proxyUser", "https.proxyPassword");
        this.httpsAuthScope = this.createProxyAuthScope(this.httpsProxyHost);
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"contentService", (Object)this.contentService);
        this.httpClient.getParams().setAuthenticationPreemptive(this.isAuthenticationPreemptive);
    }

    public void setHttpsSocketFactory(ProtocolSocketFactory socketFactory) {
        this.protocolMap.put(HTTPS_SCHEME_NAME, new Protocol(HTTPS_SCHEME_NAME, socketFactory, 443));
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setIsAuthenticationPreemptive(boolean isAuthenticationPreemptive) {
        this.isAuthenticationPreemptive = isAuthenticationPreemptive;
    }

    @Override
    public void verifyTarget(TransferTarget target) throws TransferException {
        PostMethod verifyRequest = this.getPostMethod();
        try {
            HostConfiguration hostConfig = this.getHostConfig(target);
            HttpState httpState = this.getHttpState(target);
            verifyRequest.setPath(String.valueOf(target.getEndpointPath()) + "/test");
            try {
                int response = this.httpClient.executeMethod(hostConfig, (HttpMethod)verifyRequest, httpState);
                this.checkResponseStatus("verifyTarget", response, (HttpMethod)verifyRequest);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                String error = "Failed to execute HTTP request to target";
                log.debug((Object)error, (Throwable)e);
                throw new TransferException(MSG_HTTP_REQUEST_FAILED, new Object[]{"verifyTraget", target.toString(), e.toString()}, e);
            }
        }
        finally {
            verifyRequest.releaseConnection();
        }
    }

    private void checkResponseStatus(String methodName, int response, HttpMethod method) {
        if (response != 200) {
            Throwable error = null;
            try {
                log.error((Object)("Received \"unsuccessful\" response code from target server: " + response));
                String errorPayload = method.getResponseBodyAsString();
                JSONObject errorObj = new JSONObject(errorPayload);
                error = this.rehydrateError(errorObj);
            }
            catch (Exception exception) {
                throw new TransferException(MSG_UNSUCCESSFUL_RESPONSE, new Object[]{methodName, response});
            }
            if (error != null && TransferException.class.isAssignableFrom(error.getClass())) {
                throw (TransferException)((Object)error);
            }
            throw new TransferException(MSG_UNSUCCESSFUL_RESPONSE, new Object[]{methodName, response});
        }
    }

    private HttpState getHttpState(TransferTarget target) {
        HttpState httpState = new HttpState();
        httpState.setCredentials(new AuthScope(target.getEndpointHost(), target.getEndpointPort(), AuthScope.ANY_REALM), (Credentials)new UsernamePasswordCredentials(target.getUsername(), new String(target.getPassword())));
        String requiredProtocol = target.getEndpointProtocol();
        if (requiredProtocol == null) {
            throw new TransferException(MSG_UNSUPPORTED_PROTOCOL, new Object[]{requiredProtocol});
        }
        Protocol protocol = this.protocolMap.get(requiredProtocol.toLowerCase().trim());
        if (protocol == null) {
            log.error((Object)("Unsupported protocol: " + requiredProtocol));
            throw new TransferException(MSG_UNSUPPORTED_PROTOCOL, new Object[]{requiredProtocol});
        }
        if (this.httpProxyHost != null && HTTP_SCHEME_NAME.equals(protocol.getScheme()) && HttpClientHelper.requiresProxy(target.getEndpointHost())) {
            if (this.httpProxyCredentials != null) {
                httpState.setProxyCredentials(this.httpAuthScope, this.httpProxyCredentials);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using HTTP proxy credentials for proxy: " + this.httpProxyHost.getHostName()));
                }
            }
        } else if (this.httpsProxyHost != null && HTTPS_SCHEME_NAME.equals(protocol.getScheme()) && HttpClientHelper.requiresProxy(target.getEndpointHost()) && this.httpsProxyCredentials != null) {
            httpState.setProxyCredentials(this.httpsAuthScope, this.httpsProxyCredentials);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using HTTPS proxy credentials for proxy: " + this.httpsProxyHost.getHostName()));
            }
        }
        return httpState;
    }

    private HostConfiguration getHostConfig(TransferTarget target) {
        String requiredProtocol = target.getEndpointProtocol();
        if (requiredProtocol == null) {
            throw new TransferException(MSG_UNSUPPORTED_PROTOCOL, new Object[]{requiredProtocol});
        }
        Protocol protocol = this.protocolMap.get(requiredProtocol.toLowerCase().trim());
        if (protocol == null) {
            log.error((Object)("Unsupported protocol: " + target.getEndpointProtocol()));
            throw new TransferException(MSG_UNSUPPORTED_PROTOCOL, new Object[]{requiredProtocol});
        }
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost(target.getEndpointHost(), target.getEndpointPort(), protocol);
        if (this.httpProxyHost != null && HTTP_SCHEME_NAME.equals(protocol.getScheme()) && HttpClientHelper.requiresProxy(target.getEndpointHost())) {
            hostConfig.setProxyHost(this.httpProxyHost);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using HTTP proxy host for: " + target.getEndpointHost()));
            }
        } else if (this.httpsProxyHost != null && HTTPS_SCHEME_NAME.equals(protocol.getScheme()) && HttpClientHelper.requiresProxy(target.getEndpointHost())) {
            hostConfig.setProxyHost(this.httpsProxyHost);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using HTTPS proxy host for: " + target.getEndpointHost()));
            }
        }
        return hostConfig;
    }

    private AuthScope createProxyAuthScope(ProxyHost proxyHost) {
        AuthScope authScope = null;
        if (proxyHost != null) {
            authScope = new AuthScope(proxyHost.getHostName(), proxyHost.getPort());
        }
        return authScope;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Transfer begin(TransferTarget target, String fromRepositoryId, TransferVersion fromVersion) throws TransferException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public void sendManifest(Transfer transfer, File manifest, OutputStream result) throws TransferException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void abort(Transfer transfer) throws TransferException {
        TransferTarget target = transfer.getTransferTarget();
        PostMethod abortRequest = this.getPostMethod();
        try {
            HostConfiguration hostConfig = this.getHostConfig(target);
            HttpState httpState = this.getHttpState(target);
            abortRequest.setPath(String.valueOf(target.getEndpointPath()) + "/abort");
            abortRequest.setQueryString(new NameValuePair[]{new NameValuePair("transferId", transfer.getTransferId())});
            try {
                int responseStatus = this.httpClient.executeMethod(hostConfig, (HttpMethod)abortRequest, httpState);
                this.checkResponseStatus("abort", responseStatus, (HttpMethod)abortRequest);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                String error = "Failed to execute HTTP request to target";
                log.debug((Object)error, (Throwable)e);
                throw new TransferException(MSG_HTTP_REQUEST_FAILED, new Object[]{"abort", target.toString(), e.toString()}, e);
            }
        }
        finally {
            abortRequest.releaseConnection();
        }
    }

    @Override
    public void commit(Transfer transfer) throws TransferException {
        TransferTarget target = transfer.getTransferTarget();
        PostMethod commitRequest = this.getPostMethod();
        try {
            HostConfiguration hostConfig = this.getHostConfig(target);
            HttpState httpState = this.getHttpState(target);
            commitRequest.setPath(String.valueOf(target.getEndpointPath()) + "/commit");
            commitRequest.setQueryString(new NameValuePair[]{new NameValuePair("transferId", transfer.getTransferId())});
            try {
                int responseStatus = this.httpClient.executeMethod(hostConfig, (HttpMethod)commitRequest, httpState);
                this.checkResponseStatus("commit", responseStatus, (HttpMethod)commitRequest);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                String error = "Failed to execute HTTP request to target";
                log.error((Object)error, (Throwable)e);
                throw new TransferException(MSG_HTTP_REQUEST_FAILED, new Object[]{"commit", target.toString(), e.toString()}, e);
            }
        }
        finally {
            commitRequest.releaseConnection();
        }
    }

    @Override
    public void prepare(Transfer transfer) throws TransferException {
        TransferTarget target = transfer.getTransferTarget();
        PostMethod prepareRequest = this.getPostMethod();
        try {
            HostConfiguration hostConfig = this.getHostConfig(target);
            HttpState httpState = this.getHttpState(target);
            prepareRequest.setPath(String.valueOf(target.getEndpointPath()) + "/prepare");
            prepareRequest.setQueryString(new NameValuePair[]{new NameValuePair("transferId", transfer.getTransferId())});
            try {
                int responseStatus = this.httpClient.executeMethod(hostConfig, (HttpMethod)prepareRequest, httpState);
                this.checkResponseStatus("prepare", responseStatus, (HttpMethod)prepareRequest);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                String error = "Failed to execute HTTP request to target";
                log.debug((Object)error, (Throwable)e);
                throw new TransferException(MSG_HTTP_REQUEST_FAILED, new Object[]{"prepare", target.toString(), e.toString()}, e);
            }
        }
        finally {
            prepareRequest.releaseConnection();
        }
    }

    @Override
    public void sendContent(Transfer transfer, Set<ContentData> data) throws TransferException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("send content to transfer:" + transfer));
        }
        TransferTarget target = transfer.getTransferTarget();
        PostMethod postContentRequest = this.getPostMethod();
        try {
            HostConfiguration hostConfig = this.getHostConfig(target);
            HttpState httpState = this.getHttpState(target);
            try {
                postContentRequest.setPath(String.valueOf(target.getEndpointPath()) + "/post-content");
                postContentRequest.setQueryString(new NameValuePair[]{new NameValuePair("transferId", transfer.getTransferId())});
                postContentRequest.setQueryString(new NameValuePair[]{new NameValuePair("transferId", transfer.getTransferId())});
                Part[] parts = new Part[data.size()];
                int index = 0;
                for (ContentData content : data) {
                    String contentUrl = content.getContentUrl();
                    String fileName = TransferCommons.URLToPartName(contentUrl);
                    log.debug((Object)("content partName: " + fileName));
                    parts[index++] = new ContentDataPart(this.getContentService(), fileName, content);
                }
                MultipartRequestEntity requestEntity = new MultipartRequestEntity(parts, postContentRequest.getParams());
                postContentRequest.setRequestEntity((RequestEntity)requestEntity);
                int responseStatus = this.httpClient.executeMethod(hostConfig, (HttpMethod)postContentRequest, httpState);
                this.checkResponseStatus("sendContent", responseStatus, (HttpMethod)postContentRequest);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sent content");
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                String error = "Failed to execute HTTP request to target";
                log.debug((Object)error, (Throwable)e);
                throw new TransferException(MSG_HTTP_REQUEST_FAILED, new Object[]{"sendContent", target.toString(), e.toString()}, e);
            }
        }
        finally {
            postContentRequest.releaseConnection();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public TransferProgress getStatus(Transfer transfer) throws TransferException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public void getTransferReport(Transfer transfer, OutputStream result) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void channelCopy(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(2048);
        while (src.read(buffer) != -1) {
            ((Buffer)buffer).flip();
            dest.write(buffer);
            buffer.compact();
        }
        ((Buffer)buffer).flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }

    protected PostMethod getPostMethod() {
        return this.httpMethodFactory.createPostMethod();
    }

    private Throwable rehydrateError(JSONObject errorJSON) {
        if (errorJSON == null) {
            return null;
        }
        String errorMessage = errorJSON.optString("errorMessage", "");
        String errorId = errorJSON.optString("alfrescoMessageId", null);
        Object[] errorParams = new Object[]{};
        JSONArray errorParamArray = errorJSON.optJSONArray("alfrescoMessageParams");
        if (errorParamArray != null) {
            int length = errorParamArray.length();
            errorParams = new Object[length];
            int i = 0;
            while (i < length) {
                errorParams[i] = errorParamArray.getString(i);
                ++i;
            }
        }
        return new TransferException(errorId == null ? errorMessage : errorId, errorParams);
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setHttpMethodFactory(HttpMethodFactory httpMethodFactory) {
        this.httpMethodFactory = httpMethodFactory;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    private NodeRef getFileTransferRootNodeRef(NodeRef transferNodeRef) {
        if (!TransferModel.TYPE_FILE_TRANSFER_TARGET.equals((Object)this.nodeService.getType(transferNodeRef))) {
            return null;
        }
        List assocs = this.nodeService.getTargetAssocs(transferNodeRef, (QNamePattern)TransferModel.ASSOC_ROOT_FILE_TRANSFER);
        if (assocs.size() == 0 || assocs.size() > 1) {
            return null;
        }
        return ((AssociationRef)assocs.get(0)).getTargetRef();
    }
}

