/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.version.NodeServiceImpl;
import org.alfresco.repo.version.Version2Model;
import org.alfresco.repo.version.common.VersionUtil;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;

public class Node2ServiceImpl
extends NodeServiceImpl
implements NodeService,
Version2Model {
    private static final QName rootAssocName = QName.createQName((String)"http://www.alfresco.org/model/versionstore/2.0", (String)"versionedState");

    @Override
    public QName getType(NodeRef nodeRef) throws InvalidNodeRefException {
        return this.dbNodeService.getType(VersionUtil.convertNodeRef(nodeRef));
    }

    @Override
    public Set<QName> getAspects(NodeRef nodeRef) throws InvalidNodeRefException {
        Set aspects = this.dbNodeService.getAspects(VersionUtil.convertNodeRef(nodeRef));
        aspects.remove(Version2Model.ASPECT_VERSION);
        return aspects;
    }

    @Override
    public Map<QName, Serializable> getProperties(NodeRef nodeRef) throws InvalidNodeRefException {
        Map props = this.dbNodeService.getProperties(VersionUtil.convertNodeRef(nodeRef));
        VersionUtil.convertFrozenToOriginalProps(props);
        return props;
    }

    @Override
    public Serializable getProperty(NodeRef nodeRef, QName qname) throws InvalidNodeRefException {
        Map<QName, Serializable> properties = this.getProperties(VersionUtil.convertNodeRef(nodeRef));
        return properties.get(qname);
    }

    @Override
    public List<ChildAssociationRef> getParentAssocs(NodeRef nodeRef, QNamePattern typeQNamePattern, QNamePattern qnamePattern) {
        ArrayList<ChildAssociationRef> result = new ArrayList<ChildAssociationRef>();
        if (qnamePattern.isMatch(rootAssocName)) {
            result.add(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.dbNodeService.getRootNode(new StoreRef("workspace", "version2Store")), rootAssocName, nodeRef));
        }
        return result;
    }

    @Override
    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, QNamePattern typeQNamePattern, QNamePattern qnamePattern) throws InvalidNodeRefException {
        List childAssocRefs = this.dbNodeService.getChildAssocs(VersionUtil.convertNodeRef(nodeRef), typeQNamePattern, qnamePattern);
        ArrayList<ChildAssociationRef> result = new ArrayList<ChildAssociationRef>(childAssocRefs.size());
        for (ChildAssociationRef childAssocRef : childAssocRefs) {
            NodeRef childRef;
            NodeRef referencedNode;
            if (childAssocRef.getTypeQName().equals((Object)Version2Model.CHILD_QNAME_VERSIONED_ASSOCS) || !this.dbNodeService.exists(referencedNode = (NodeRef)this.dbNodeService.getProperty(childRef = childAssocRef.getChildRef(), ContentModel.PROP_REFERENCE))) continue;
            ChildAssociationRef newChildAssocRef = new ChildAssociationRef(childAssocRef.getTypeQName(), childAssocRef.getParentRef(), childAssocRef.getQName(), referencedNode, childAssocRef.isPrimary(), childAssocRef.getNthSibling());
            result.add(newChildAssocRef);
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public ChildAssociationRef getPrimaryParent(NodeRef nodeRef) throws InvalidNodeRefException {
        return new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.dbNodeService.getRootNode(new StoreRef("workspace", "version2Store")), rootAssocName, nodeRef);
    }

    @Override
    public List<AssociationRef> getTargetAssocs(NodeRef sourceRef, QNamePattern qnamePattern) {
        List childAssocRefs = this.dbNodeService.getChildAssocs(VersionUtil.convertNodeRef(sourceRef), (QNamePattern)Version2Model.CHILD_QNAME_VERSIONED_ASSOCS, qnamePattern);
        ArrayList<AssociationRef> result = new ArrayList<AssociationRef>(childAssocRefs.size());
        for (ChildAssociationRef childAssocRef : childAssocRefs) {
            NodeRef childRef = childAssocRef.getChildRef();
            NodeRef referencedNode = (NodeRef)this.dbNodeService.getProperty(childRef, ContentModel.PROP_REFERENCE);
            if (!this.dbNodeService.exists(referencedNode)) continue;
            Long assocDbId = (Long)this.dbNodeService.getProperty(childRef, Version2Model.PROP_QNAME_ASSOC_DBID);
            AssociationRef newAssocRef = new AssociationRef(assocDbId, sourceRef, childAssocRef.getQName(), referencedNode);
            result.add(newAssocRef);
        }
        return result;
    }

    @Override
    public List<AssociationRef> getTargetAssocsByPropertyValue(NodeRef sourceRef, QNamePattern qnamePattern, QName propertyQName, Serializable propertyValue) {
        if (sourceRef.getStoreRef().getIdentifier().equals("lightWeightVersionStore")) {
            return super.getTargetAssocsByPropertyValue(sourceRef, qnamePattern, propertyQName, propertyValue);
        }
        List childAssocRefs = this.dbNodeService.getChildAssocs(VersionUtil.convertNodeRef(sourceRef), (QNamePattern)Version2Model.CHILD_QNAME_VERSIONED_ASSOCS, qnamePattern);
        ArrayList<AssociationRef> result = new ArrayList<AssociationRef>(childAssocRefs.size());
        for (ChildAssociationRef childAssocRef : childAssocRefs) {
            Serializable propertyValueRetrieved;
            NodeRef childRef = childAssocRef.getChildRef();
            NodeRef referencedNode = (NodeRef)this.dbNodeService.getProperty(childRef, ContentModel.PROP_REFERENCE);
            if (!this.dbNodeService.exists(referencedNode)) continue;
            Long assocDbId = (Long)this.dbNodeService.getProperty(childRef, Version2Model.PROP_QNAME_ASSOC_DBID);
            if (propertyQName != null && ((propertyValueRetrieved = this.dbNodeService.getProperty(referencedNode, propertyQName)) == null || !propertyValueRetrieved.equals(propertyValue))) continue;
            AssociationRef newAssocRef = new AssociationRef(assocDbId, sourceRef, childAssocRef.getQName(), referencedNode);
            result.add(newAssocRef);
        }
        return result;
    }
}

