/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.List;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.Parameter;
import org.alfresco.repo.virtual.ref.PlainEncoding;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.ReferenceEncodingException;
import org.alfresco.repo.virtual.ref.ReferenceParameter;
import org.alfresco.repo.virtual.ref.RepositoryLocation;
import org.alfresco.repo.virtual.ref.RepositoryNodeRef;
import org.alfresco.repo.virtual.ref.RepositoryPath;
import org.alfresco.repo.virtual.ref.RepositoryResource;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.ResourceParameter;
import org.alfresco.repo.virtual.ref.StringParameter;
import org.alfresco.repo.virtual.ref.Stringifier;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;

public class PlainStringifier
implements Stringifier,
PlainEncoding {
    private static final long serialVersionUID = -8169416257716384803L;

    @Override
    public String stringify(Reference reference) throws ReferenceEncodingException {
        return reference.getProtocol() + ":" + this.stringify(reference.getResource()) + this.stringify(reference.getParameters());
    }

    @Override
    public String stringify(Resource resource) throws ReferenceEncodingException {
        return resource.stringify(this);
    }

    @Override
    public String stringifyResource(Resource resource) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Invalid reference " + resource.getClass());
    }

    @Override
    public String stringifyResource(RepositoryResource resource) throws ReferenceEncodingException {
        return "repository:" + this.stringify(resource.getLocation());
    }

    @Override
    public String stringifyResource(ClasspathResource resource) {
        return "classpath:" + resource.getClasspath();
    }

    @Override
    public String stringify(RepositoryLocation repositoryLocation) throws ReferenceEncodingException {
        return repositoryLocation.stringify(this);
    }

    @Override
    public String stringifyRepositoryLocation(RepositoryLocation repositoryLocation) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Invalid location " + repositoryLocation.getClass());
    }

    @Override
    public String stringifyRepositoryLocation(RepositoryNodeRef repositoryNodeRef) throws ReferenceEncodingException {
        NodeRef nodeRef = repositoryNodeRef.getNodeRef();
        StoreRef storeRef = nodeRef.getStoreRef();
        return "node:" + storeRef.getProtocol() + ":" + storeRef.getIdentifier() + ":" + nodeRef.getId();
    }

    @Override
    public String stringifyRepositoryLocation(RepositoryPath repositoryPath) throws ReferenceEncodingException {
        return "path:" + repositoryPath.getPath();
    }

    @Override
    public String stringify(List<Parameter> parameters) throws ReferenceEncodingException {
        StringBuilder parametersBuilder = new StringBuilder();
        for (Parameter parameter : parameters) {
            parametersBuilder.append(":");
            parametersBuilder.append(this.stringify(parameter));
        }
        return parametersBuilder.toString();
    }

    @Override
    public String stringify(Parameter parameter) throws ReferenceEncodingException {
        return parameter.stringify(this);
    }

    @Override
    public String stringifyParameter(ResourceParameter resourceParameter) throws ReferenceEncodingException {
        return "r:" + this.stringify((Resource)resourceParameter.getValue());
    }

    @Override
    public String stringifyParameter(StringParameter stringParameter) throws ReferenceEncodingException {
        return "s:" + (String)stringParameter.getValue();
    }

    @Override
    public String stringifyParameter(Parameter parameter) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Invalid parameter " + parameter.getClass());
    }

    @Override
    public String stringifyParameter(ReferenceParameter parameter) throws ReferenceEncodingException {
        return "ref:" + this.stringify((Reference)parameter.getValue()) + ":" + "*";
    }
}

