/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.solr.ibatis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.registry.RegistryServiceImpl;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.solr.AclEntity;
import org.alfresco.repo.domain.solr.NodeParametersEntity;
import org.alfresco.repo.domain.solr.SOLRTrackingParameters;
import org.alfresco.repo.domain.solr.SearchDAO;
import org.alfresco.repo.solr.Acl;
import org.alfresco.repo.solr.AclChangeSet;
import org.alfresco.repo.solr.NodeParameters;
import org.alfresco.repo.solr.Transaction;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.apache.ibatis.session.RowBounds;
import org.mybatis.spring.SqlSessionTemplate;

public class SearchDAOImpl
implements SearchDAO {
    private static final String SELECT_CHANGESETS_SUMMARY = "alfresco.solr.select_ChangeSets_Summary";
    private static final String SELECT_ACLS_BY_CHANGESET_IDS = "alfresco.solr.select_AclsByChangeSetIds";
    private static final String SELECT_TRANSACTIONS = "alfresco.solr.select_Txns";
    private static final String SELECT_NODES = "alfresco.solr.select_Txn_Nodes";
    private SqlSessionTemplate template;
    private QNameDAO qnameDAO;
    private RegistryServiceImpl dictionaryService;

    public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.template = sqlSessionTemplate;
    }

    public void setQNameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"template", (Object)this.template);
        PropertyCheck.mandatory((Object)this, (String)"qnameDAO", (Object)this.qnameDAO);
    }

    @Override
    public List<AclChangeSet> getAclChangeSets(Long minAclChangeSetId, Long fromCommitTime, Long maxAclChangeSetId, Long toCommitTime, int maxResults) {
        if (maxResults <= 0 || maxResults == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum results must be a reasonable number.");
        }
        Pair<Long, QName> deletedTypeQNamePair = this.qnameDAO.getQName(ContentModel.TYPE_DELETED);
        Long deletedTypeQNameId = deletedTypeQNamePair == null ? -1L : (Long)deletedTypeQNamePair.getFirst();
        SOLRTrackingParameters params = new SOLRTrackingParameters(deletedTypeQNameId);
        params.setFromIdInclusive(minAclChangeSetId);
        params.setFromCommitTimeInclusive(fromCommitTime);
        params.setToIdExclusive(maxAclChangeSetId);
        params.setToCommitTimeExclusive(toCommitTime);
        return this.template.selectList(SELECT_CHANGESETS_SUMMARY, (Object)params, new RowBounds(0, maxResults));
    }

    @Override
    public List<Acl> getAcls(List<Long> aclChangeSetIds, Long minAclId, int maxResults) {
        if (aclChangeSetIds == null || aclChangeSetIds.size() == 0) {
            throw new IllegalArgumentException("'aclChangeSetIds' must contain IDs.");
        }
        if (aclChangeSetIds.size() > 512) {
            throw new IllegalArgumentException("'aclChangeSetIds' cannot have more than 512 entries.");
        }
        Pair<Long, QName> deletedTypeQNamePair = this.qnameDAO.getQName(ContentModel.TYPE_DELETED);
        Long deletedTypeQNameId = deletedTypeQNamePair == null ? -1L : (Long)deletedTypeQNamePair.getFirst();
        SOLRTrackingParameters params = new SOLRTrackingParameters(deletedTypeQNameId);
        params.setIds(aclChangeSetIds);
        params.setFromIdInclusive(minAclId);
        List source = maxResults <= 0 || maxResults == Integer.MAX_VALUE ? this.template.selectList(SELECT_ACLS_BY_CHANGESET_IDS, (Object)params) : this.template.selectList(SELECT_ACLS_BY_CHANGESET_IDS, (Object)params, new RowBounds(0, maxResults));
        TreeSet<AclEntity> sorted = new TreeSet<AclEntity>(source);
        HashSet<Long> found = new HashSet<Long>();
        for (Acl acl : source) {
            found.add(acl.getId());
        }
        for (Acl acl : source) {
            if (acl.getInheritedId() == null || found.contains(acl.getInheritedId())) continue;
            AclEntity shared = new AclEntity();
            shared.setId(acl.getInheritedId());
            shared.setAclChangeSetId(acl.getAclChangeSetId());
            shared.setInheritedId(acl.getInheritedId());
            sorted.add(shared);
        }
        ArrayList<Acl> answer = new ArrayList<Acl>();
        answer.addAll(sorted);
        return answer;
    }

    @Override
    public List<Transaction> getTransactions(Long minTxnId, Long fromCommitTime, Long maxTxnId, Long toCommitTime, int maxResults) {
        if (maxResults <= 0 || maxResults == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum results must be a reasonable number.");
        }
        Pair<Long, QName> deletedTypeQNamePair = this.qnameDAO.getQName(ContentModel.TYPE_DELETED);
        Long deletedTypeQNameId = deletedTypeQNamePair == null ? -1L : (Long)deletedTypeQNamePair.getFirst();
        SOLRTrackingParameters params = new SOLRTrackingParameters(deletedTypeQNameId);
        params.setFromIdInclusive(minTxnId);
        params.setFromCommitTimeInclusive(fromCommitTime);
        params.setToIdExclusive(maxTxnId);
        params.setToCommitTimeExclusive(toCommitTime);
        return this.template.selectList(SELECT_TRANSACTIONS, (Object)params, new RowBounds(0, maxResults));
    }

    @Override
    public List<Node> getNodes(NodeParameters nodeParameters, QName shardPropertyQName, QName shardPropertyTypeName) {
        NodeParametersEntity params = new NodeParametersEntity(nodeParameters, this.qnameDAO);
        if (shardPropertyQName != null && shardPropertyTypeName != null) {
            if (shardPropertyQName.equals((Object)ContentModel.PROP_CREATED)) {
                params.setShardPropertyQNameId(-1L);
            } else if (shardPropertyQName.equals((Object)ContentModel.PROP_MODIFIED)) {
                params.setShardPropertyQNameId(-2L);
            } else if (shardPropertyQName.equals((Object)ContentModel.PROP_CREATOR)) {
                params.setShardPropertyQNameId(-3L);
            } else if (shardPropertyQName.equals((Object)ContentModel.PROP_MODIFIER)) {
                params.setShardPropertyQNameId(-4L);
            } else {
                Pair<Long, QName> propertyQNamePair = this.qnameDAO.getQName(shardPropertyQName);
                if (propertyQNamePair != null) {
                    params.setShardPropertyQNameId((Long)propertyQNamePair.getFirst());
                    params.setShardPropertyType(shardPropertyTypeName.getLocalName());
                }
            }
        }
        if (nodeParameters.getMaxResults() != 0 && nodeParameters.getMaxResults() != Integer.MAX_VALUE) {
            return this.template.selectList(SELECT_NODES, (Object)params, new RowBounds(0, nodeParameters.getMaxResults()));
        }
        return this.template.selectList(SELECT_NODES, (Object)params);
    }
}

