/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.integrity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.transaction.TransactionListener;
import org.alfresco.util.transaction.TransactionListenerAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IncompleteNodeTagger
extends TransactionListenerAdapter
implements NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.OnAddAspectPolicy,
NodeServicePolicies.OnRemoveAspectPolicy,
NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.OnDeleteChildAssociationPolicy,
NodeServicePolicies.OnCreateAssociationPolicy,
NodeServicePolicies.OnDeleteAssociationPolicy {
    private static Log logger = LogFactory.getLog(IncompleteNodeTagger.class);
    private static final String KEY_NODES = "IncompleteNodeTagger.Nodes";
    private PolicyComponent policyComponent;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private List<String> storesToIgnore = new ArrayList<String>(0);
    private Set<QName> propertiesToIgnore = new HashSet<QName>();
    private BehaviourFilter behaviourFilter;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setStoresToIgnore(List<String> storesToIgnore) {
        this.storesToIgnore = storesToIgnore;
    }

    public void setPropertiesToIgnore(List<String> propertiesToIgnore) {
        this.propertiesToIgnore = new HashSet<QName>();
        for (String qnameStr : propertiesToIgnore) {
            QName qname = QName.createQName((String)qnameStr);
            this.propertiesToIgnore.add(qname);
        }
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void init() {
        PropertyCheck.mandatory((Object)"IncompleteNodeTagger", (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)"IncompleteNodeTagger", (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)"IncompleteNodeTagger", (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)"IncompleteNodeTagger", (String)"behaviourFilter", (Object)this.behaviourFilter);
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCreateNode"), this, (Behaviour)new JavaBehaviour(this, "onCreateNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), this, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onAddAspect"), this, (Behaviour)new JavaBehaviour(this, "onAddAspect"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onRemoveAspect"), this, (Behaviour)new JavaBehaviour(this, "onRemoveAspect"));
        this.policyComponent.bindAssociationBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCreateChildAssociation"), this, (Behaviour)new JavaBehaviour(this, "onCreateChildAssociation"));
        this.policyComponent.bindAssociationBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onDeleteChildAssociation"), this, (Behaviour)new JavaBehaviour(this, "onDeleteChildAssociation"));
        this.policyComponent.bindAssociationBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCreateAssociation"), this, (Behaviour)new JavaBehaviour(this, "onCreateAssociation"));
        this.policyComponent.bindAssociationBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onDeleteAssociation"), this, (Behaviour)new JavaBehaviour(this, "onDeleteAssociation"));
    }

    private Map<NodeRef, Set<QName>> getNodes() {
        return (Map)AlfrescoTransactionSupport.getResource((Object)KEY_NODES);
    }

    private Set<QName> save(NodeRef nodeRef) {
        Set<QName> assocs = null;
        AlfrescoTransactionSupport.bindListener((TransactionListener)this);
        Map<NodeRef, Set<QName>> nodes = this.getNodes();
        if (nodes == null) {
            nodes = new HashMap<NodeRef, Set<QName>>(31, 0.75f);
            AlfrescoTransactionSupport.bindResource((Object)KEY_NODES, nodes);
        }
        if (nodes.containsKey(nodeRef)) {
            assocs = nodes.get(nodeRef);
        } else {
            nodes.put(nodeRef, null);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added node reference to property set: " + nodeRef));
        }
        return assocs;
    }

    private void saveAssoc(NodeRef nodeRef, QName assocType) {
        AlfrescoTransactionSupport.bindListener((TransactionListener)this);
        Set<QName> assocs = this.save(nodeRef);
        if (assocs == null) {
            assocs = new HashSet<QName>(7, 0.75f);
            Map<NodeRef, Set<QName>> nodes = this.getNodes();
            nodes.put(nodeRef, assocs);
        }
        if (assocType != null) {
            assocs.add(assocType);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added association to node: " + nodeRef + ", " + assocType));
        }
    }

    @Override
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        if (!this.storesToIgnore.contains(childAssocRef.getChildRef().getStoreRef().toString())) {
            NodeRef nodeRef = childAssocRef.getChildRef();
            this.save(nodeRef);
            this.saveAssoc(nodeRef, null);
        }
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (!this.storesToIgnore.contains(nodeRef.getStoreRef().toString())) {
            this.save(nodeRef);
        }
    }

    @Override
    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        if (!this.storesToIgnore.contains(nodeRef.getStoreRef().toString())) {
            if (aspectTypeQName.equals((Object)ContentModel.ASPECT_INCOMPLETE) && logger.isDebugEnabled()) {
                logger.debug((Object)("Ignoring aspect addition: " + ContentModel.ASPECT_INCOMPLETE));
            }
            this.save(nodeRef);
        }
    }

    @Override
    public void onRemoveAspect(NodeRef nodeRef, QName aspectTypeQName) {
        if (!this.storesToIgnore.contains(nodeRef.getStoreRef().toString())) {
            if (aspectTypeQName.equals((Object)ContentModel.ASPECT_INCOMPLETE) && logger.isDebugEnabled()) {
                logger.debug((Object)("Ignoring aspect removal: " + ContentModel.ASPECT_INCOMPLETE));
            }
            this.save(nodeRef);
        }
    }

    @Override
    public void onCreateChildAssociation(ChildAssociationRef childAssocRef, boolean isNew) {
        if (!this.storesToIgnore.contains(childAssocRef.getChildRef().getStoreRef().toString()) && !isNew) {
            this.saveAssoc(childAssocRef.getParentRef(), childAssocRef.getTypeQName());
        }
    }

    @Override
    public void onDeleteChildAssociation(ChildAssociationRef childAssocRef) {
        if (!this.storesToIgnore.contains(childAssocRef.getChildRef().getStoreRef().toString())) {
            this.saveAssoc(childAssocRef.getParentRef(), childAssocRef.getTypeQName());
        }
    }

    @Override
    public void onCreateAssociation(AssociationRef nodeAssocRef) {
        if (!this.storesToIgnore.contains(nodeAssocRef.getSourceRef().getStoreRef().toString())) {
            this.saveAssoc(nodeAssocRef.getSourceRef(), nodeAssocRef.getTypeQName());
        }
    }

    @Override
    public void onDeleteAssociation(AssociationRef nodeAssocRef) {
        if (!this.storesToIgnore.contains(nodeAssocRef.getSourceRef().getStoreRef().toString())) {
            this.saveAssoc(nodeAssocRef.getSourceRef(), nodeAssocRef.getTypeQName());
        }
    }

    public void beforeCommit(boolean readOnly) {
        final Map<NodeRef, Set<QName>> nodes = this.getNodes();
        if (readOnly || nodes == null) {
            return;
        }
        AlfrescoTransactionSupport.unbindResource((Object)KEY_NODES);
        AuthenticationUtil.RunAsWork<Void> processNodesWork = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                for (Map.Entry entry : nodes.entrySet()) {
                    if (!IncompleteNodeTagger.this.nodeService.exists((NodeRef)entry.getKey())) continue;
                    IncompleteNodeTagger.this.processNode((NodeRef)entry.getKey(), (Set)entry.getValue());
                }
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)processNodesWork, (String)AuthenticationUtil.getSystemUserName());
    }

    private void processNode(NodeRef nodeRef, Set<QName> assocTypes) {
        Set aspectTypeQNames = this.nodeService.getAspects(nodeRef);
        boolean isTagged = aspectTypeQNames.contains(ContentModel.ASPECT_INCOMPLETE);
        Map nodeProperties = this.nodeService.getProperties(nodeRef);
        QName nodeTypeQName = this.nodeService.getType(nodeRef);
        TypeDefinition typeDef = this.dictionaryService.getType(nodeTypeQName);
        if (typeDef == null) {
            throw new AlfrescoRuntimeException("Node type is not recognised: " + nodeTypeQName);
        }
        Collection<Object> propertyDefs = typeDef.getProperties().values();
        boolean classPropertiesOK = this.checkProperties(propertyDefs, nodeProperties);
        if (!classPropertiesOK) {
            this.addOrRemoveTag(nodeRef, true, isTagged);
            return;
        }
        for (QName aspectTypeQName : aspectTypeQNames) {
            boolean aspectPropertiesOK;
            AspectDefinition aspectDef = this.dictionaryService.getAspect(aspectTypeQName);
            if (aspectDef == null || (aspectPropertiesOK = this.checkProperties(propertyDefs = aspectDef.getProperties().values(), nodeProperties))) continue;
            this.addOrRemoveTag(nodeRef, true, isTagged);
            return;
        }
        if (assocTypes != null) {
            Map assocDefs = typeDef.getAssociations();
            if (assocTypes.size() > 0) {
                for (QName assocType : assocTypes) {
                    AssociationDefinition assocDef = (AssociationDefinition)assocDefs.get(assocType);
                    if (assocDef == null || this.checkAssociation(nodeRef, assocDef)) continue;
                    this.addOrRemoveTag(nodeRef, true, isTagged);
                    return;
                }
            } else {
                for (QName assocType : assocDefs.keySet()) {
                    AssociationDefinition assocDef = (AssociationDefinition)assocDefs.get(assocType);
                    if (assocDef == null || this.checkAssociation(nodeRef, assocDef)) continue;
                    this.addOrRemoveTag(nodeRef, true, isTagged);
                    return;
                }
            }
        }
        this.addOrRemoveTag(nodeRef, false, isTagged);
    }

    private boolean checkProperties(Collection<PropertyDefinition> propertyDefs, Map<QName, Serializable> properties) {
        for (PropertyDefinition propertyDef : propertyDefs) {
            if (this.propertiesToIgnore.contains(propertyDef.getName()) || !propertyDef.isMandatory() || propertyDef.isMandatoryEnforced() || properties.get(propertyDef.getName()) != null) continue;
            return false;
        }
        return true;
    }

    private boolean checkAssociation(NodeRef nodeRef, AssociationDefinition assocDef) {
        boolean complete = true;
        if (assocDef.isTargetMandatory() && !assocDef.isTargetMandatoryEnforced()) {
            int actualSize = 0;
            if (assocDef.isChild()) {
                List childAssocRefs = this.nodeService.getChildAssocs(nodeRef, (QNamePattern)assocDef.getName(), RegexQNamePattern.MATCH_ALL);
                actualSize = childAssocRefs.size();
            } else {
                List targetAssocRefs = this.nodeService.getTargetAssocs(nodeRef, (QNamePattern)assocDef.getName());
                actualSize = targetAssocRefs.size();
            }
            if (assocDef.isTargetMandatory() && actualSize == 0) {
                complete = false;
            }
        }
        return complete;
    }

    private void addOrRemoveTag(NodeRef nodeRef, boolean addTag, boolean isTagged) {
        if (addTag && !isTagged) {
            this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
            this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
            try {
                this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_INCOMPLETE, null);
            }
            finally {
                this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
                this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Tagged node as INCOMPLETE: " + nodeRef));
            }
        } else if (!addTag && isTagged) {
            this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
            this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
            try {
                this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_INCOMPLETE);
            }
            finally {
                this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
                this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Untagged node as INCOMPLETE: " + nodeRef));
            }
        }
    }
}

