/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.jaas;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.alfresco.repo.security.authentication.AbstractAuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.springframework.extensions.surf.util.I18NUtil;

public class JAASAuthenticationComponent
extends AbstractAuthenticationComponent {
    private String jaasConfigEntryName = "Alfresco";
    private String realm = null;

    public void setJaasConfigEntryName(String jaasConfigEntryName) {
        this.jaasConfigEntryName = jaasConfigEntryName;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    @Override
    protected boolean implementationAllowsGuestLogin() {
        return false;
    }

    @Override
    protected void authenticateImpl(String userName, char[] password) throws AuthenticationException {
        LoginContext lc;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Authentication for user: " + AuthenticationUtil.maskUsername((String)userName)));
        }
        try {
            lc = new LoginContext(this.jaasConfigEntryName, new SimpleCallback(userName, this.realm, password));
        }
        catch (LoginException e) {
            throw new AuthenticationException("Login Failed", (Throwable)e);
        }
        try {
            lc.login();
            this.setCurrentUser(userName);
        }
        catch (LoginException e) {
            throw new AuthenticationException("Login Failed", (Throwable)e);
        }
    }

    private static class SimpleCallback
    implements CallbackHandler {
        String userName;
        String realm;
        char[] password;

        SimpleCallback(String userName, String realm, char[] password) {
            this.userName = userName;
            this.realm = realm;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            int i = 0;
            while (i < callbacks.length) {
                Callback cb;
                if (callbacks[i] instanceof AuthorizeCallback) {
                    cb = (AuthorizeCallback)callbacks[i];
                    ((AuthorizeCallback)cb).setAuthorized(false);
                } else if (callbacks[i] instanceof LanguageCallback) {
                    cb = (LanguageCallback)callbacks[i];
                    ((LanguageCallback)cb).setLocale(I18NUtil.getLocale());
                } else if (callbacks[i] instanceof NameCallback) {
                    cb = (NameCallback)callbacks[i];
                    ((NameCallback)cb).setName(this.userName);
                } else if (callbacks[i] instanceof PasswordCallback) {
                    cb = (PasswordCallback)callbacks[i];
                    ((PasswordCallback)cb).setPassword(this.password);
                } else if (callbacks[i] instanceof RealmCallback) {
                    cb = (RealmCallback)callbacks[i];
                    ((TextInputCallback)cb).setText(this.realm);
                } else {
                    throw new UnsupportedCallbackException(callbacks[i]);
                }
                ++i;
            }
        }
    }
}

