/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.store;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.virtual.ActualEnvironment;
import org.alfresco.repo.virtual.ref.AbstractProtocolMethod;
import org.alfresco.repo.virtual.ref.GetActualNodeRefMethod;
import org.alfresco.repo.virtual.ref.NodeProtocol;
import org.alfresco.repo.virtual.ref.ProtocolMethodException;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.VirtualProtocol;
import org.alfresco.repo.virtual.store.VirtualStore;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;

public class GetChildAssocsMethod
extends AbstractProtocolMethod<List<ChildAssociationRef>> {
    private VirtualStore smartStore;
    private ActualEnvironment environment;
    private boolean preload;
    private int maxResults;
    private QNamePattern qnamePattern;
    private QNamePattern typeQNamePattern;

    public GetChildAssocsMethod(VirtualStore smartStore, ActualEnvironment environment, boolean preload, int maxResults, QNamePattern qnamePattern, QNamePattern typeQNamePattern) {
        this.smartStore = smartStore;
        this.environment = environment;
        this.preload = preload;
        this.maxResults = maxResults;
        this.qnamePattern = qnamePattern;
        this.typeQNamePattern = typeQNamePattern;
    }

    @Override
    public List<ChildAssociationRef> execute(VirtualProtocol virtualProtocol, Reference reference) throws ProtocolMethodException {
        if (this.typeQNamePattern.isMatch(ContentModel.ASSOC_CONTAINS)) {
            LinkedList<ChildAssociationRef> childAssocs = new LinkedList<ChildAssociationRef>();
            List<Reference> children = this.smartStore.list(reference);
            NodeRef nodeRefReference = reference.toNodeRef();
            int count = 0;
            for (Reference child : children) {
                if (count >= this.maxResults) break;
                NodeRef childNodeRef = child.toNodeRef();
                Serializable childName = this.environment.getProperty(childNodeRef, ContentModel.PROP_NAME);
                QName childAssocQName = QName.createQNameWithValidLocalName((String)"http://www.alfresco.org/model/content/smartfolder/1.0", (String)childName.toString());
                if (!this.qnamePattern.isMatch(childAssocQName)) continue;
                ChildAssociationRef childAssoc = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, nodeRefReference, childAssocQName, childNodeRef, true, -1);
                childAssocs.add(childAssoc);
                ++count;
            }
            return childAssocs;
        }
        return Collections.emptyList();
    }

    @Override
    public List<ChildAssociationRef> execute(NodeProtocol protocol, Reference reference) throws ProtocolMethodException {
        NodeRef actualNodeRef = reference.execute(new GetActualNodeRefMethod(null));
        NodeRef nodeRefReference = reference.toNodeRef();
        LinkedList<ChildAssociationRef> referenceAssociations = new LinkedList<ChildAssociationRef>();
        if (!this.environment.isSubClass(this.environment.getType(nodeRefReference), ContentModel.TYPE_FOLDER)) {
            List<ChildAssociationRef> actualAssociations = this.environment.getChildAssocs(actualNodeRef, this.typeQNamePattern, this.qnamePattern, this.maxResults, this.preload);
            for (ChildAssociationRef actualAssoc : actualAssociations) {
                ChildAssociationRef referenceChildAssocRef = new ChildAssociationRef(actualAssoc.getTypeQName(), nodeRefReference, actualAssoc.getQName(), actualAssoc.getChildRef(), actualAssoc.isPrimary(), actualAssoc.getNthSibling());
                referenceAssociations.add(referenceChildAssocRef);
            }
        }
        return referenceAssociations;
    }
}

