/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.io.support.ResourcePatternResolver;

public class RuntimeSystemPropertiesSetter
implements BeanFactoryPostProcessor,
ApplicationContextAware,
PriorityOrdered {
    private static Log logger = LogFactory.getLog(RuntimeSystemPropertiesSetter.class);
    private int order = 0x7FFFFFFE;
    private ResourcePatternResolver resolver;
    private Map<String, String> jvmProperties = new HashMap<String, String>(7);

    public void setJvmProperties(Map<String, String> jvmProperties) {
        this.jvmProperties = jvmProperties;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.resolver = applicationContext;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        File path;
        block5: {
            for (Map.Entry<String, String> entry : this.jvmProperties.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                String currentValue = System.getProperty(key);
                if (currentValue != null) continue;
                System.setProperty(key, value);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Setting system property: " + key + " = " + value));
            }
            path = null;
            try {
                path = this.resolver.getResource("classpath:alfresco/alfresco-jmxrmi.password").getFile().getCanonicalFile();
            }
            catch (Exception exception) {
                if (!logger.isWarnEnabled()) break block5;
                logger.warn((Object)"Could not find alfresco-jmxrmi.password on classpath");
            }
        }
        if (path == null) {
            System.setProperty("alfresco.jmx.dir", "");
        } else {
            String alfresco_jmx_dir = path.getParent();
            System.setProperty("alfresco.jmx.dir", alfresco_jmx_dir);
        }
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }
}

