/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.history.HistoricDetail;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.history.HistoricVariableUpdate;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.activiti.AbstractActivitiComponentTest;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeverRunsTests.class})
public class ActivitiTaskComponentTest
extends AbstractActivitiComponentTest {
    private WorkflowDefinition workflowDef;

    @Test
    public void testGetStartTask() {
        try {
            this.workflowEngine.getStartTask("Foo");
            Assert.fail((String)"Should blow up if Id is wrong format!");
        }
        catch (WorkflowException workflowException) {}
        WorkflowTask result = this.workflowEngine.getStartTask("activiti$Foo");
        Assert.assertNull((String)"Should not find any result for fake (but valid) Id.", (Object)result);
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        String comment = "Start task description";
        params.put(WorkflowModel.PROP_COMMENT, comment);
        params.put(WorkflowModel.PROP_PRIORITY, 1);
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_DUE_DATE, dueDate);
        WorkflowPath path = this.workflowEngine.startWorkflow(this.workflowDef.getId(), params);
        String instanceId = path.getInstance().getId();
        WorkflowTask task = this.workflowEngine.getStartTask(instanceId);
        Assert.assertNotNull((String)"Task shoudl exist!", (Object)task);
        String localId = "start" + BPMEngineRegistry.getLocalId((String)instanceId);
        String taskId = BPMEngineRegistry.createGlobalId((String)"activiti", (String)localId);
        Assert.assertEquals((String)"Start Task Id is wrong", (Object)taskId, (Object)task.getId());
        Assert.assertEquals((String)"The start task path is wrong!", (Object)path.getId(), (Object)task.getPath().getId());
        TypeDefinition definition = task.getDefinition().getMetadata();
        Assert.assertNotNull((Object)definition);
        String name = definition.getName().toPrefixString((NamespacePrefixResolver)this.namespaceService).replace(':', '_');
        Assert.assertEquals((Object)"bpm_foo", (Object)name);
        Assert.assertEquals((Object)name, (Object)task.getName());
        Assert.assertEquals((Object)name, (Object)task.getTitle());
        Assert.assertEquals((Object)name, (Object)task.getDescription());
        Assert.assertEquals((Object)WorkflowTaskState.IN_PROGRESS, (Object)task.getState());
        Assert.assertEquals((Object)name, (Object)task.getDescription());
        Map properties = task.getProperties();
        Assert.assertEquals((Object)comment, properties.get(WorkflowModel.PROP_COMMENT));
        Assert.assertEquals((Object)1, properties.get(WorkflowModel.PROP_PRIORITY));
        Assert.assertEquals((Object)dueDate, properties.get(WorkflowModel.PROP_DUE_DATE));
        task = this.workflowEngine.endTask(task.getId(), null);
        Assert.assertEquals((String)"Start Task Id is wrong", (Object)taskId, (Object)task.getId());
        Assert.assertEquals((String)"The start task path is wrong!", (Object)path.getId(), (Object)task.getPath().getId());
        definition = task.getDefinition().getMetadata();
        Assert.assertNotNull((Object)definition);
        name = definition.getName().toPrefixString((NamespacePrefixResolver)this.namespaceService).replace(':', '_');
        Assert.assertEquals((Object)"bpm_foo", (Object)name);
        Assert.assertEquals((Object)name, (Object)task.getName());
        Assert.assertEquals((Object)name, (Object)task.getTitle());
        Assert.assertEquals((Object)name, (Object)task.getDescription());
        Assert.assertEquals((Object)WorkflowTaskState.COMPLETED, (Object)task.getState());
        Assert.assertEquals((Object)name, (Object)task.getDescription());
        properties = task.getProperties();
        Assert.assertEquals((Object)comment, properties.get(WorkflowModel.PROP_COMMENT));
        Assert.assertEquals((Object)1, properties.get(WorkflowModel.PROP_PRIORITY));
        Assert.assertEquals((Object)dueDate, properties.get(WorkflowModel.PROP_DUE_DATE));
        this.workflowEngine.cancelWorkflow(instanceId);
        task = this.workflowEngine.getStartTask(instanceId);
        Assert.assertNull((Object)task);
    }

    @Test
    public void testGetTaskById() throws Exception {
        try {
            this.workflowEngine.getTaskById("Foo");
            Assert.fail((String)"Should blow up if Id is wrong format!");
        }
        catch (WorkflowException workflowException) {}
        WorkflowTask result = this.workflowEngine.getTaskById("activiti$Foo");
        Assert.assertNull((String)"Should not find any result for fake (but valid) Id.", (Object)result);
        WorkflowPath path = this.workflowEngine.startWorkflow(this.workflowDef.getId(), new HashMap());
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().executionId(BPMEngineRegistry.getLocalId((String)path.getId()))).singleResult();
        Assert.assertNotNull((String)"Task shoudl exist!", (Object)task);
        String taskId = BPMEngineRegistry.createGlobalId((String)"activiti", (String)task.getId());
        WorkflowTask wfTask = this.workflowEngine.getTaskById(taskId);
        Assert.assertNotNull((Object)wfTask);
    }

    @Test
    public void testGetStartTaskById() throws Exception {
        WorkflowTask result = this.workflowEngine.getTaskById("activiti$Foo");
        Assert.assertNull((String)"Should not find any result for fake (but valid) Id.", (Object)result);
        WorkflowPath path = this.workflowEngine.startWorkflow(this.workflowDef.getId(), new HashMap());
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().executionId(BPMEngineRegistry.getLocalId((String)path.getId()))).singleResult();
        String startTaskId = "start" + task.getProcessInstanceId();
        String taskId = this.createGlobalId(startTaskId);
        WorkflowTask wfTask = this.workflowEngine.getTaskById(taskId);
        Assert.assertNotNull((Object)wfTask);
        Assert.assertEquals((Object)this.createGlobalId(task.getProcessInstanceId()), (Object)wfTask.getPath().getId());
    }

    @Test
    public void testGetFinishedTaskById() throws Exception {
        WorkflowPath path = this.workflowEngine.startWorkflow(this.workflowDef.getId(), new HashMap());
        WorkflowTask startTask = this.workflowEngine.getStartTask(path.getInstance().getId());
        this.workflowEngine.endTask(startTask.getId(), null);
        List tasks = this.workflowEngine.getTasksForWorkflowPath(path.getId());
        String finishedTaskId = ((WorkflowTask)tasks.get(0)).getId();
        HashMap<QName, Object> props = new HashMap<QName, Object>();
        props.put(WorkflowModel.PROP_DESCRIPTION, "Task description");
        props.put(WorkflowModel.PROP_PRIORITY, 1234);
        props.put(QName.createQName((String)"myprop1"), "Property value");
        props.put(QName.createQName((String)"myprop2"), Boolean.TRUE);
        props.put(QName.createQName((String)"myprop3"), 12345);
        props.put(QName.createQName((String)"myprop4"), 45678L);
        this.workflowEngine.updateTask(finishedTaskId, props, null, null);
        this.workflowEngine.endTask(finishedTaskId, null);
        WorkflowTask finishedTask = this.workflowEngine.getTaskById(finishedTaskId);
        Assert.assertNotNull((Object)finishedTask);
        Assert.assertEquals((Object)"Task description", (Object)finishedTask.getDescription());
        Assert.assertEquals((Object)finishedTaskId, (Object)finishedTask.getId());
        Assert.assertEquals((Object)"bpm_foo_task", (Object)finishedTask.getName());
        Assert.assertEquals((Object)"Task", (Object)finishedTask.getTitle());
        Assert.assertEquals((Object)WorkflowTaskState.COMPLETED, (Object)finishedTask.getState());
        Assert.assertEquals((String)"task name", (Object)finishedTask.getDefinition().getId(), (Object)"bpm_foo_task");
        Assert.assertEquals((Object)path.getId(), (Object)finishedTask.getPath().getId());
        Assert.assertEquals((Object)path.getInstance().getId(), (Object)finishedTask.getPath().getInstance().getId());
        Assert.assertEquals((Object)"Property value", finishedTask.getProperties().get(QName.createQName((String)"myprop1")));
        Assert.assertEquals((Object)Boolean.TRUE, finishedTask.getProperties().get(QName.createQName((String)"myprop2")));
        Assert.assertEquals((Object)12345, finishedTask.getProperties().get(QName.createQName((String)"myprop3")));
        Assert.assertEquals((Object)45678L, finishedTask.getProperties().get(QName.createQName((String)"myprop4")));
        List pooledActors = (List)finishedTask.getProperties().get(WorkflowModel.ASSOC_POOLED_ACTORS);
        Assert.assertNotNull((Object)pooledActors);
        Assert.assertEquals((long)2L, (long)pooledActors.size());
        Assert.assertTrue((boolean)pooledActors.contains(AbstractActivitiComponentTest.testGroupNode));
        Assert.assertTrue((boolean)pooledActors.contains(AbstractActivitiComponentTest.testUserNode));
    }

    @Test
    public void testEndTask() throws Exception {
        WorkflowPath path = this.workflowEngine.startWorkflow(this.workflowDef.getId(), new HashMap());
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().executionId(BPMEngineRegistry.getLocalId((String)path.getId()))).singleResult();
        Assert.assertNotNull((String)"Task should exist!", (Object)task);
        String globalTaskId = this.createGlobalId(task.getId());
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(QName.createQName((String)"http://test", (String)"myVar"), "test123");
        this.workflowEngine.updateTask(globalTaskId, props, null, null);
        this.workflowEngine.endTask(globalTaskId, null);
        List updates = this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(task.getProcessInstanceId()).list();
        boolean found = false;
        for (HistoricDetail detail : updates) {
            HistoricVariableUpdate update = (HistoricVariableUpdate)detail;
            if (!update.getVariableName().equals("test_myVar")) continue;
            Assert.assertEquals((Object)"test123", (Object)update.getValue());
            found = true;
        }
        Assert.assertTrue((String)"Task variables are not flushed to process-instance", (boolean)found);
        HistoricTaskInstance hti = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId())).singleResult();
        Assert.assertNotNull((Object)hti);
        Assert.assertEquals((Object)"admin", (Object)hti.getAssignee());
    }

    @Test
    public void testGetAssignedTasks() throws Exception {
        this.performGetAssignedTasks(false);
    }

    @Test
    public void testGetAssignedTasksLazyInitialization() throws Exception {
        this.performGetAssignedTasks(true);
    }

    protected void performGetAssignedTasks(boolean lazyInitialization) throws Exception {
        HashMap<QName, Date> props = new HashMap<QName, Date>();
        props.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, new Date());
        WorkflowPath path = this.workflowEngine.startWorkflow(this.workflowDef.getId(), props);
        WorkflowTask startTask = this.workflowEngine.getStartTask(path.getInstance().getId());
        Assert.assertNotNull((Object)startTask);
        this.workflowEngine.endTask(startTask.getId(), null);
        Assert.assertEquals((long)0L, (long)this.workflowEngine.getAssignedTasks("testUser", WorkflowTaskState.IN_PROGRESS, lazyInitialization).size());
        List tasks = this.workflowEngine.getTasksForWorkflowPath(path.getId());
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.workflowEngine.updateTask(((WorkflowTask)tasks.get(0)).getId(), Collections.singletonMap(ContentModel.PROP_OWNER, "testUser"), null, null);
        tasks = this.workflowEngine.getAssignedTasks("testUser", WorkflowTaskState.IN_PROGRESS, lazyInitialization);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        WorkflowTask task = (WorkflowTask)tasks.get(0);
        Assert.assertEquals((Object)"Task", (Object)task.getDescription());
        Assert.assertEquals((Object)"Task", (Object)task.getTitle());
        Assert.assertEquals((Object)WorkflowTaskState.IN_PROGRESS, (Object)task.getState());
        Assert.assertEquals((Object)"testUser", task.getProperties().get(ContentModel.PROP_OWNER));
        Assert.assertEquals(props.get(WorkflowModel.PROP_DUE_DATE), task.getProperties().get(WorkflowModel.PROP_DUE_DATE));
        Assert.assertNotNull(task.getProperties().get(WorkflowModel.PROP_START_DATE));
        AuthenticationUtil.setFullyAuthenticatedUser((String)"testUser");
        this.workflowEngine.endTask(task.getId(), "Next");
        tasks = this.workflowEngine.getAssignedTasks("testUser", WorkflowTaskState.IN_PROGRESS, lazyInitialization);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        tasks = this.workflowEngine.getAssignedTasks("testUser", WorkflowTaskState.COMPLETED, lazyInitialization);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        task = (WorkflowTask)tasks.get(0);
        Assert.assertEquals((Object)"Task", (Object)task.getDescription());
        Assert.assertEquals((Object)"Task", (Object)task.getTitle());
        Assert.assertEquals((Object)WorkflowTaskState.COMPLETED, (Object)task.getState());
        Assert.assertEquals((Object)"testUser", task.getProperties().get(ContentModel.PROP_OWNER));
        Assert.assertEquals(props.get(WorkflowModel.PROP_DUE_DATE), task.getProperties().get(WorkflowModel.PROP_DUE_DATE));
        Assert.assertNotNull(task.getProperties().get(WorkflowModel.PROP_START_DATE));
    }

    @Test
    public void testGetPooledTasks() throws Exception {
        this.performGetPooledTasksTest(false);
    }

    @Test
    public void testGetPooledTasksLazyInitialization() throws Exception {
        this.performGetPooledTasksTest(true);
    }

    protected void performGetPooledTasksTest(boolean lazy) {
        WorkflowPath path = this.workflowEngine.startWorkflow(this.workflowDef.getId(), new HashMap());
        WorkflowTask startTask = this.workflowEngine.getStartTask(path.getInstance().getId());
        Assert.assertNotNull((Object)startTask);
        this.workflowEngine.endTask(startTask.getId(), null);
        List tasks = this.workflowEngine.getTasksForWorkflowPath(path.getId());
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        WorkflowTask theTask = (WorkflowTask)tasks.get(0);
        Serializable pooledActors = (Serializable)theTask.getProperties().get(WorkflowModel.ASSOC_POOLED_ACTORS);
        Assert.assertNotNull((Object)pooledActors);
        List pooledActorNodes = (List)((Object)pooledActors);
        Assert.assertEquals((long)2L, (long)pooledActorNodes.size());
        Assert.assertTrue((boolean)pooledActorNodes.contains(AbstractActivitiComponentTest.testUserNode));
        Assert.assertTrue((boolean)pooledActorNodes.contains(AbstractActivitiComponentTest.testGroupNode));
        List pooledUserTasks = this.workflowEngine.getPooledTasks(Arrays.asList("testUser"), lazy);
        Assert.assertNotNull((Object)pooledUserTasks);
        Assert.assertEquals((long)1L, (long)pooledUserTasks.size());
        Assert.assertEquals((Object)theTask.getId(), (Object)((WorkflowTask)pooledUserTasks.get(0)).getId());
        List pooledGroupTasks = this.workflowEngine.getPooledTasks(Arrays.asList("GROUP_testGroup"), lazy);
        Assert.assertNotNull((Object)pooledGroupTasks);
        Assert.assertEquals((long)1L, (long)pooledGroupTasks.size());
        Assert.assertEquals((Object)theTask.getId(), (Object)((WorkflowTask)pooledGroupTasks.get(0)).getId());
        List pooledTasks = this.workflowEngine.getPooledTasks(Arrays.asList("testUser", "GROUP_testGroup"), lazy);
        Assert.assertNotNull((Object)pooledTasks);
        Assert.assertEquals((long)1L, (long)pooledTasks.size());
        Assert.assertEquals((Object)theTask.getId(), (Object)((WorkflowTask)pooledTasks.get(0)).getId());
        List unexistingPooledTasks = this.workflowEngine.getPooledTasks(Arrays.asList("unexisting"), lazy);
        Assert.assertNotNull((Object)unexistingPooledTasks);
        Assert.assertEquals((long)0L, (long)unexistingPooledTasks.size());
        pooledGroupTasks = this.workflowEngine.getPooledTasks(Arrays.asList("unexistinggroup", "GROUP_testGroup"), lazy);
        Assert.assertNotNull((Object)pooledGroupTasks);
        Assert.assertEquals((long)1L, (long)pooledGroupTasks.size());
        Assert.assertEquals((Object)theTask.getId(), (Object)((WorkflowTask)pooledGroupTasks.get(0)).getId());
    }

    @Test
    public void testQueryTasksInProgress() throws Exception {
        WorkflowPath path = this.workflowEngine.startWorkflow(this.workflowDef.getId(), new HashMap());
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().executionId(BPMEngineRegistry.getLocalId((String)path.getId()))).singleResult();
        Assert.assertNotNull((String)"Task should exist!", (Object)task);
        String globalTaskId = this.createGlobalId(task.getId());
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        taskQuery.setTaskId(globalTaskId);
        List tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)globalTaskId, (Object)((WorkflowTask)tasks.get(0)).getId());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        taskQuery.setTaskId(this.createGlobalId("nonexistentTask"));
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        taskQuery.setProcessId(this.createGlobalId(task.getProcessInstanceId()));
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)globalTaskId, (Object)((WorkflowTask)tasks.get(0)).getId());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        taskQuery.setProcessId(this.createGlobalId("nonexistentProcess"));
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        taskQuery.setActorId("testUser");
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        this.taskService.setAssignee(task.getId(), "testUser");
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        taskQuery.setActorId("testUser");
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)globalTaskId, (Object)((WorkflowTask)tasks.get(0)).getId());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        taskQuery.setActorId("nonexistentUser");
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        taskQuery.setWorkflowDefinitionName("testTask");
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskQuery.setWorkflowDefinitionName("unexistingTaskName");
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        taskQuery.setTaskName(QName.createQName((String)"bpm_foo_task"));
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskQuery.setTaskName(QName.createQName((String)"unexisting_task_name"));
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 928374L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "stringValue");
        variables.put("booleanVar", true);
        Date date = Calendar.getInstance().getTime();
        variables.put("dateVar", date);
        variables.put("nullVar", null);
        ActivitiScriptNode scriptNode = new ActivitiScriptNode(AbstractActivitiComponentTest.testGroupNode, this.serviceRegistry);
        variables.put("scriptNodeVar", scriptNode);
        this.taskService.setVariablesLocal(task.getId(), variables);
        this.checkTaskVariableTaskPresent(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"longVar"), 928374L, globalTaskId);
        this.checkTaskVariableNoMatch(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"longVar"), 444444L);
        this.checkTaskVariableTaskPresent(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"shortVar"), (short)123, globalTaskId);
        this.checkTaskVariableNoMatch(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"shortVar"), (short)456);
        this.checkTaskVariableTaskPresent(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"integerVar"), 1234, globalTaskId);
        this.checkTaskVariableNoMatch(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"integerVar"), 5678);
        this.checkTaskVariableTaskPresent(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"stringVar"), "stringValue", globalTaskId);
        this.checkTaskVariableNoMatch(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"stringVar"), "noMatchString");
        this.checkTaskVariableTaskPresent(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"booleanVar"), true, globalTaskId);
        this.checkTaskVariableNoMatch(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"booleanVar"), false);
        this.checkTaskVariableTaskPresent(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"dateVar"), date, globalTaskId);
        Calendar otherDate = Calendar.getInstance();
        otherDate.add(1, 1);
        this.checkTaskVariableNoMatch(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"dateVar"), otherDate.getTime());
        this.checkTaskVariableTaskPresent(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"nullVar"), null, globalTaskId);
        this.checkTaskVariableNoMatch(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"nullVar"), "notNull");
        this.checkTaskVariableTaskPresent(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"scriptNodeVar"), scriptNode, globalTaskId);
        ActivitiScriptNode otherNode = new ActivitiScriptNode(AbstractActivitiComponentTest.testUserNode, this.serviceRegistry);
        this.checkTaskVariableNoMatch(WorkflowTaskState.IN_PROGRESS, QName.createQName((String)"scriptNodeVar"), otherNode);
        this.runtime.setVariable(task.getExecutionId(), "processVar", (Object)"testing");
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(QName.createQName((String)"processVar"), "testing");
        taskQuery.setProcessCustomProps(props);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        props.put(QName.createQName((String)"processVar"), "notmatching");
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testQueryTasksCompleted() throws Exception {
        WorkflowPath path = this.workflowEngine.startWorkflow(this.workflowDef.getId(), new HashMap());
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().executionId(BPMEngineRegistry.getLocalId((String)path.getId()))).singleResult();
        this.taskService.setVariableLocal(task.getId(), "taskVar", (Object)"theValue");
        Assert.assertNotNull((String)"Task should exist!", (Object)task);
        String globalTaskId = this.createGlobalId(task.getId());
        this.taskService.setAssignee(task.getId(), "testUser");
        this.runtime.setVariable(task.getExecutionId(), "processVar", (Object)"testing");
        AuthenticationUtil.setFullyAuthenticatedUser((String)"testUser");
        this.workflowEngine.endTask(globalTaskId, null);
        AuthenticationUtil.setFullyAuthenticatedUser((String)"admin");
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        taskQuery.setActive(Boolean.FALSE);
        taskQuery.setTaskId(globalTaskId);
        List tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)globalTaskId, (Object)((WorkflowTask)tasks.get(0)).getId());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        taskQuery.setTaskId(this.createGlobalId("nonexistantTask"));
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        taskQuery.setProcessId(this.createGlobalId(task.getProcessInstanceId()));
        taskQuery.setActive(Boolean.FALSE);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)2L, (long)tasks.size());
        boolean taskFound = false;
        boolean startTaskFound = false;
        for (WorkflowTask wfTask : tasks) {
            if (wfTask.getId().equals(globalTaskId)) {
                taskFound = true;
            }
            if (!wfTask.getId().contains("start")) continue;
            startTaskFound = true;
        }
        Assert.assertTrue((String)"Task should have been returned", (boolean)taskFound);
        Assert.assertTrue((String)"Start-task should have been returned", (boolean)startTaskFound);
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        taskQuery.setProcessId(this.createGlobalId("nonexistantProcess"));
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        taskQuery.setActorId("testUser");
        taskQuery.setActive(Boolean.FALSE);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        taskQuery.setActorId("unexistingUser");
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        taskQuery.setWorkflowDefinitionName("testTask");
        taskQuery.setActive(Boolean.FALSE);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskQuery.setWorkflowDefinitionName("unexistingTaskName");
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(QName.createQName((String)"taskVar"), "theValue");
        taskQuery.setActive(Boolean.valueOf(false));
        taskQuery.setTaskCustomProps(props);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        props.put(QName.createQName((String)"processVar"), "notmatching");
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        props = new HashMap();
        props.put(QName.createQName((String)"processVar"), "testing");
        taskQuery.setActive(Boolean.valueOf(false));
        taskQuery.setProcessCustomProps(props);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        props.put(QName.createQName((String)"processVar"), "notmatching");
        tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testQueryUsingNodeRef() {
        NodeRef nodeRef = new NodeRef("workspace:///someRef");
        QName nodeRefPropQname = QName.createQName((String)"testProp");
        HashMap<QName, NodeRef> props = new HashMap<QName, NodeRef>();
        props.put(nodeRefPropQname, nodeRef);
        this.workflowEngine.startWorkflow(this.workflowDef.getId(), props);
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        HashMap<QName, NodeRef> queryParams = new HashMap<QName, NodeRef>();
        queryParams.put(nodeRefPropQname, nodeRef);
        taskQuery.setProcessCustomProps(queryParams);
        List tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void testUpdateTask() {
        NodeRef nodeRef = new NodeRef("workspace:///someRef");
        NodeRef anotherRef = new NodeRef("workspace:///anotherRef");
        QName propQname = QName.createQName((String)"testProp");
        QName nodeRefPropQname = QName.createQName((String)"testAssoc");
        QName singleNodeRefPropQname = QName.createQName((String)"testAssocSingleValue");
        HashMap<QName, String> props = new HashMap<QName, String>();
        WorkflowPath path = this.workflowEngine.startWorkflow(this.workflowDef.getId(), props);
        WorkflowTask startTask = this.workflowEngine.getStartTask(path.getInstance().getId());
        this.workflowEngine.endTask(startTask.getId(), null);
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.IN_PROGRESS);
        taskQuery.setProcessId(path.getInstance().getId());
        List tasks = this.workflowEngine.queryTasks(taskQuery);
        WorkflowTask task = (WorkflowTask)tasks.get(0);
        props = new HashMap();
        props.put(propQname, "54321");
        props.put(singleNodeRefPropQname, (String)nodeRef);
        this.workflowEngine.updateTask(task.getId(), props, null, null);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        task = (WorkflowTask)tasks.get(0);
        Assert.assertEquals((Object)"54321", task.getProperties().get(propQname));
        HashMap<QName, List<NodeRef>> toAdd = new HashMap<QName, List<NodeRef>>();
        toAdd.put(nodeRefPropQname, Arrays.asList(anotherRef, nodeRef));
        this.workflowEngine.updateTask(task.getId(), null, toAdd, null);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        task = (WorkflowTask)tasks.get(0);
        Assert.assertEquals((long)2L, (long)((List)task.getProperties().get(nodeRefPropQname)).size());
        HashMap<QName, List<NodeRef>> toRemove = new HashMap<QName, List<NodeRef>>();
        toRemove.put(nodeRefPropQname, Arrays.asList(nodeRef));
        this.workflowEngine.updateTask(task.getId(), null, null, toRemove);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        task = (WorkflowTask)tasks.get(0);
        Assert.assertEquals((long)1L, (long)((List)task.getProperties().get(nodeRefPropQname)).size());
        Assert.assertEquals((Object)anotherRef, ((List)task.getProperties().get(nodeRefPropQname)).get(0));
        toAdd = new HashMap();
        toRemove = new HashMap();
        toRemove.put(singleNodeRefPropQname, Arrays.asList(nodeRef));
        toAdd.put(singleNodeRefPropQname, Arrays.asList(anotherRef));
        this.workflowEngine.updateTask(task.getId(), null, toAdd, toRemove);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        task = (WorkflowTask)tasks.get(0);
        Assert.assertEquals((Object)anotherRef, task.getProperties().get(singleNodeRefPropQname));
        toRemove = new HashMap();
        toRemove.put(singleNodeRefPropQname, Arrays.asList(anotherRef));
        this.workflowEngine.updateTask(task.getId(), null, null, toRemove);
        tasks = this.workflowEngine.queryTasks(taskQuery);
        task = (WorkflowTask)tasks.get(0);
        Assert.assertNull(task.getProperties().get(singleNodeRefPropQname));
    }

    private void checkTaskVariableTaskPresent(WorkflowTaskState state, QName varName, Object varValue, String expectedTask) {
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(state);
        HashMap<QName, Object> customProperties = new HashMap<QName, Object>();
        customProperties.put(varName, varValue);
        taskQuery.setTaskCustomProps(customProperties);
        this.assertTaskPresent(taskQuery, expectedTask);
    }

    private void checkTaskVariableNoMatch(WorkflowTaskState state, QName varName, Object varValue) {
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(state);
        HashMap<QName, Object> customProperties = new HashMap<QName, Object>();
        customProperties.put(varName, varValue);
        taskQuery.setTaskCustomProps(customProperties);
        this.assertNoTaskPresent(taskQuery);
    }

    private WorkflowTaskQuery createWorkflowTaskQuery(WorkflowTaskState state) {
        WorkflowTaskQuery taskQuery = new WorkflowTaskQuery();
        taskQuery.setTaskState(state);
        return taskQuery;
    }

    private void assertTaskPresent(WorkflowTaskQuery taskQuery, String taskId) {
        List tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)taskId, (Object)((WorkflowTask)tasks.get(0)).getId());
    }

    private void assertNoTaskPresent(WorkflowTaskQuery taskQuery) {
        List tasks = this.workflowEngine.queryTasks(taskQuery);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    private String createGlobalId(String id) {
        return BPMEngineRegistry.createGlobalId((String)"activiti", (String)id);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.workflowDef = this.deployTestTaskDefinition();
    }
}

