/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryption;

import org.alfresco.encryption.KeyStoreChecker;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.transaction.TransactionService;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class EncryptionChecker
extends AbstractLifecycleBean {
    private TransactionService transactionService;
    private KeyStoreChecker keyStoreChecker;

    public void setKeyStoreChecker(KeyStoreChecker keyStoreChecker) {
        this.keyStoreChecker = keyStoreChecker;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    protected void onBootstrap(ApplicationEvent event) {
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        txnHelper.setForceWritable(true);
        txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                try {
                    EncryptionChecker.this.keyStoreChecker.validateKeyStores();
                }
                catch (Throwable e) {
                    throw new AlfrescoRuntimeException("Keystores are invalid", e);
                }
                return null;
            }
        });
    }

    protected void onShutdown(ApplicationEvent event) {
    }
}

